/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.hardware;

import eu.qimpress.samm.core.NamedEntity;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Processor Core</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The ProcessorCore entity represents a single core within a processor package. Each core has a numeric identifier within the scope of the processor package and a collection of caches the core utilizes when executing code.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.ProcessorCore#getCoreID <em>Core ID</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.ProcessorCore#getCaches <em>Caches</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.ProcessorCore#getDescriptor <em>Descriptor</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getProcessorCore()
 * @model
 * @generated
 */
public interface ProcessorCore extends NamedEntity {
	/**
	 * Returns the value of the '<em><b>Core ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Identifier an execution core within a processor.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Core ID</em>' attribute.
	 * @see #isSetCoreID()
	 * @see #unsetCoreID()
	 * @see #setCoreID(int)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getProcessorCore_CoreID()
	 * @model unsettable="true" required="true" transient="true" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	int getCoreID();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.ProcessorCore#getCoreID <em>Core ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Core ID</em>' attribute.
	 * @see #isSetCoreID()
	 * @see #unsetCoreID()
	 * @see #getCoreID()
	 * @generated
	 */
	void setCoreID(int value);

	/**
	 * Unsets the value of the '{@link eu.qimpress.samm.deployment.hardware.ProcessorCore#getCoreID <em>Core ID</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetCoreID()
	 * @see #getCoreID()
	 * @see #setCoreID(int)
	 * @generated
	 */
	void unsetCoreID();

	/**
	 * Returns whether the value of the '{@link eu.qimpress.samm.deployment.hardware.ProcessorCore#getCoreID <em>Core ID</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Core ID</em>' attribute is set.
	 * @see #unsetCoreID()
	 * @see #getCoreID()
	 * @see #setCoreID(int)
	 * @generated
	 */
	boolean isSetCoreID();

	/**
	 * Returns the value of the '<em><b>Caches</b></em>' reference list.
	 * The list contents are of type {@link eu.qimpress.samm.deployment.hardware.Cache}.
	 * It is bidirectional and its opposite is '{@link eu.qimpress.samm.deployment.hardware.Cache#getCores <em>Cores</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Lists memory caches representing a cache hierarchy for a particular core.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Caches</em>' reference list.
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getProcessorCore_Caches()
	 * @see eu.qimpress.samm.deployment.hardware.Cache#getCores
	 * @model opposite="cores" ordered="false"
	 * @generated
	 */
	EList<Cache> getCaches();

	/**
	 * Returns the value of the '<em><b>Descriptor</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link eu.qimpress.samm.deployment.hardware.ProcessorDescriptor#getCores <em>Cores</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Associates a processor core with a particular processor.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Descriptor</em>' container reference.
	 * @see #setDescriptor(ProcessorDescriptor)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getProcessorCore_Descriptor()
	 * @see eu.qimpress.samm.deployment.hardware.ProcessorDescriptor#getCores
	 * @model opposite="cores" required="true" transient="false" ordered="false"
	 * @generated
	 */
	ProcessorDescriptor getDescriptor();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.ProcessorCore#getDescriptor <em>Descriptor</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Descriptor</em>' container reference.
	 * @see #getDescriptor()
	 * @generated
	 */
	void setDescriptor(ProcessorDescriptor value);

} // ProcessorCore
