/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.hardware;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Network Interface Descriptor</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The NetworkInterfaceDescriptor entity captures the essential properties of different types of network interfaces.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.NetworkInterfaceDescriptor#getLinkLatency <em>Link Latency</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.NetworkInterfaceDescriptor#getLinkSpeed <em>Link Speed</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getNetworkInterfaceDescriptor()
 * @model
 * @generated
 */
public interface NetworkInterfaceDescriptor extends HardwareDescriptor {
	/**
	 * Returns the value of the '<em><b>Link Latency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Latency of the network, in seconds. The latency is primarily determined by the properties of the physical layer and modulation speed.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Link Latency</em>' attribute.
	 * @see #setLinkLatency(double)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getNetworkInterfaceDescriptor_LinkLatency()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	double getLinkLatency();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.NetworkInterfaceDescriptor#getLinkLatency <em>Link Latency</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Link Latency</em>' attribute.
	 * @see #getLinkLatency()
	 * @generated
	 */
	void setLinkLatency(double value);

	/**
	 * Returns the value of the '<em><b>Link Speed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Link speed of the network interface, in bits per second. Determines the maximum theoretical bandwidth.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Link Speed</em>' attribute.
	 * @see #setLinkSpeed(int)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getNetworkInterfaceDescriptor_LinkSpeed()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getLinkSpeed();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.NetworkInterfaceDescriptor#getLinkSpeed <em>Link Speed</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Link Speed</em>' attribute.
	 * @see #getLinkSpeed()
	 * @generated
	 */
	void setLinkSpeed(int value);

} // NetworkInterfaceDescriptor
