/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.hardware;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Network Element Descriptor</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The NetworkElementDescriptor entity captures the common properties of an active network element such as router or switch, such as aggregate bandwidth the device provides and forwarding latency between individual ports, be it routed or switched traffic.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.NetworkElementDescriptor#getAggregateBandwidth <em>Aggregate Bandwidth</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.NetworkElementDescriptor#getForwardingLatency <em>Forwarding Latency</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getNetworkElementDescriptor()
 * @model
 * @generated
 */
public interface NetworkElementDescriptor extends HardwareDescriptor {
	/**
	 * Returns the value of the '<em><b>Aggregate Bandwidth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Bandwidth of the interconnect in bits per second.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Aggregate Bandwidth</em>' attribute.
	 * @see #setAggregateBandwidth(int)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getNetworkElementDescriptor_AggregateBandwidth()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getAggregateBandwidth();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.NetworkElementDescriptor#getAggregateBandwidth <em>Aggregate Bandwidth</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Aggregate Bandwidth</em>' attribute.
	 * @see #getAggregateBandwidth()
	 * @generated
	 */
	void setAggregateBandwidth(int value);

	/**
	 * Returns the value of the '<em><b>Forwarding Latency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Average latency of the interconnect, in seconds.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Forwarding Latency</em>' attribute.
	 * @see #setForwardingLatency(double)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getNetworkElementDescriptor_ForwardingLatency()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	double getForwardingLatency();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.NetworkElementDescriptor#getForwardingLatency <em>Forwarding Latency</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Forwarding Latency</em>' attribute.
	 * @see #getForwardingLatency()
	 * @generated
	 */
	void setForwardingLatency(double value);

} // NetworkElementDescriptor
