/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.hardware;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Memory Descriptor</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The MemoryDescriptor entity captures the essential properties of different types of memory, such as DRAM or SRAM.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.MemoryDescriptor#getBandwidth <em>Bandwidth</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.MemoryDescriptor#getFsbFrequency <em>Fsb Frequency</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.MemoryDescriptor#getAccessLatency <em>Access Latency</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.MemoryDescriptor#getBurstLength <em>Burst Length</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getMemoryDescriptor()
 * @model
 * @generated
 */
public interface MemoryDescriptor extends HardwareDescriptor {
	/**
	 * Returns the value of the '<em><b>Bandwidth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Memory bandwidth, in bytes per second.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Bandwidth</em>' attribute.
	 * @see #setBandwidth(int)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getMemoryDescriptor_Bandwidth()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getBandwidth();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.MemoryDescriptor#getBandwidth <em>Bandwidth</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Bandwidth</em>' attribute.
	 * @see #getBandwidth()
	 * @generated
	 */
	void setBandwidth(int value);

	/**
	 * Returns the value of the '<em><b>Fsb Frequency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Frequency of the Front Side Bus, in Hertz.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Fsb Frequency</em>' attribute.
	 * @see #setFsbFrequency(int)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getMemoryDescriptor_FsbFrequency()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getFsbFrequency();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.MemoryDescriptor#getFsbFrequency <em>Fsb Frequency</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Fsb Frequency</em>' attribute.
	 * @see #getFsbFrequency()
	 * @generated
	 */
	void setFsbFrequency(int value);

	/**
	 * Returns the value of the '<em><b>Access Latency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Access latency expressed in number of (Front Side Bus) clocks. The memory access latency basically represents the miss penalty for the last level of caches. 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Access Latency</em>' attribute.
	 * @see #setAccessLatency(int)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getMemoryDescriptor_AccessLatency()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getAccessLatency();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.MemoryDescriptor#getAccessLatency <em>Access Latency</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Access Latency</em>' attribute.
	 * @see #getAccessLatency()
	 * @generated
	 */
	void setAccessLatency(int value);

	/**
	 * Returns the value of the '<em><b>Burst Length</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The maximum amount of data that can be transferred during a single memory transaction, in bytes.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Burst Length</em>' attribute.
	 * @see #setBurstLength(int)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getMemoryDescriptor_BurstLength()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getBurstLength();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.MemoryDescriptor#getBurstLength <em>Burst Length</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Burst Length</em>' attribute.
	 * @see #getBurstLength()
	 * @generated
	 */
	void setBurstLength(int value);

} // MemoryDescriptor
