/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.hardware;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import eu.qimpress.samm.core.CorePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * The Hardware package focuses on modelling properties of physical hardware that are common to multiple instances of hardware devices in computational nodes.
 * <!-- end-model-doc -->
 * @see eu.qimpress.samm.deployment.hardware.HardwareFactory
 * @model kind="package"
 * @generated
 */
public interface HardwarePackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "hardware";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://q-impress.eu/samm/deployment/hardware";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "hardware";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	HardwarePackage eINSTANCE = eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl.init();

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.hardware.impl.HardwareDescriptorImpl <em>Descriptor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.hardware.impl.HardwareDescriptorImpl
	 * @see eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl#getHardwareDescriptor()
	 * @generated
	 */
	int HARDWARE_DESCRIPTOR = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HARDWARE_DESCRIPTOR__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HARDWARE_DESCRIPTOR__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HARDWARE_DESCRIPTOR__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The number of structural features of the '<em>Descriptor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HARDWARE_DESCRIPTOR_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.hardware.impl.NetworkElementDescriptorImpl <em>Network Element Descriptor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.hardware.impl.NetworkElementDescriptorImpl
	 * @see eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl#getNetworkElementDescriptor()
	 * @generated
	 */
	int NETWORK_ELEMENT_DESCRIPTOR = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_ELEMENT_DESCRIPTOR__ID = HARDWARE_DESCRIPTOR__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_ELEMENT_DESCRIPTOR__DOCUMENTATION = HARDWARE_DESCRIPTOR__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_ELEMENT_DESCRIPTOR__NAME = HARDWARE_DESCRIPTOR__NAME;

	/**
	 * The feature id for the '<em><b>Aggregate Bandwidth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_ELEMENT_DESCRIPTOR__AGGREGATE_BANDWIDTH = HARDWARE_DESCRIPTOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Forwarding Latency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_ELEMENT_DESCRIPTOR__FORWARDING_LATENCY = HARDWARE_DESCRIPTOR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Network Element Descriptor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_ELEMENT_DESCRIPTOR_FEATURE_COUNT = HARDWARE_DESCRIPTOR_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.hardware.impl.TLBImpl <em>TLB</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.hardware.impl.TLBImpl
	 * @see eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl#getTLB()
	 * @generated
	 */
	int TLB = 2;

	/**
	 * The feature id for the '<em><b>Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TLB__KIND = 0;

	/**
	 * The feature id for the '<em><b>Entry Page Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TLB__ENTRY_PAGE_SIZE = 1;

	/**
	 * The feature id for the '<em><b>Associativity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TLB__ASSOCIATIVITY = 2;

	/**
	 * The feature id for the '<em><b>Entries Count</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TLB__ENTRIES_COUNT = 3;

	/**
	 * The number of structural features of the '<em>TLB</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TLB_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.hardware.impl.ProcessorCoreImpl <em>Processor Core</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.hardware.impl.ProcessorCoreImpl
	 * @see eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl#getProcessorCore()
	 * @generated
	 */
	int PROCESSOR_CORE = 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_CORE__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_CORE__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_CORE__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Core ID</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_CORE__CORE_ID = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Caches</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_CORE__CACHES = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Descriptor</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_CORE__DESCRIPTOR = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Processor Core</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_CORE_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.hardware.impl.CacheImpl <em>Cache</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.hardware.impl.CacheImpl
	 * @see eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl#getCache()
	 * @generated
	 */
	int CACHE = 4;

	/**
	 * The feature id for the '<em><b>Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__LEVEL = 0;

	/**
	 * The feature id for the '<em><b>Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__KIND = 1;

	/**
	 * The feature id for the '<em><b>Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__SIZE = 2;

	/**
	 * The feature id for the '<em><b>Associativity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__ASSOCIATIVITY = 3;

	/**
	 * The feature id for the '<em><b>Cache Line Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__CACHE_LINE_SIZE = 4;

	/**
	 * The feature id for the '<em><b>Access Latency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__ACCESS_LATENCY = 5;

	/**
	 * The feature id for the '<em><b>Cores</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE__CORES = 6;

	/**
	 * The number of structural features of the '<em>Cache</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CACHE_FEATURE_COUNT = 7;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.hardware.impl.ProcessorDescriptorImpl <em>Processor Descriptor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.hardware.impl.ProcessorDescriptorImpl
	 * @see eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl#getProcessorDescriptor()
	 * @generated
	 */
	int PROCESSOR_DESCRIPTOR = 5;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DESCRIPTOR__ID = HARDWARE_DESCRIPTOR__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DESCRIPTOR__DOCUMENTATION = HARDWARE_DESCRIPTOR__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DESCRIPTOR__NAME = HARDWARE_DESCRIPTOR__NAME;

	/**
	 * The feature id for the '<em><b>Caches</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DESCRIPTOR__CACHES = HARDWARE_DESCRIPTOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Tlbs</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DESCRIPTOR__TLBS = HARDWARE_DESCRIPTOR_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Cores</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DESCRIPTOR__CORES = HARDWARE_DESCRIPTOR_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Processor Descriptor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROCESSOR_DESCRIPTOR_FEATURE_COUNT = HARDWARE_DESCRIPTOR_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.hardware.impl.StorageDeviceDescriptorImpl <em>Storage Device Descriptor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.hardware.impl.StorageDeviceDescriptorImpl
	 * @see eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl#getStorageDeviceDescriptor()
	 * @generated
	 */
	int STORAGE_DEVICE_DESCRIPTOR = 6;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STORAGE_DEVICE_DESCRIPTOR__ID = HARDWARE_DESCRIPTOR__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STORAGE_DEVICE_DESCRIPTOR__DOCUMENTATION = HARDWARE_DESCRIPTOR__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STORAGE_DEVICE_DESCRIPTOR__NAME = HARDWARE_DESCRIPTOR__NAME;

	/**
	 * The feature id for the '<em><b>Write Speed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STORAGE_DEVICE_DESCRIPTOR__WRITE_SPEED = HARDWARE_DESCRIPTOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Read Speed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STORAGE_DEVICE_DESCRIPTOR__READ_SPEED = HARDWARE_DESCRIPTOR_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Request Latency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STORAGE_DEVICE_DESCRIPTOR__REQUEST_LATENCY = HARDWARE_DESCRIPTOR_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Cache Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STORAGE_DEVICE_DESCRIPTOR__CACHE_SIZE = HARDWARE_DESCRIPTOR_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Storage Device Descriptor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STORAGE_DEVICE_DESCRIPTOR_FEATURE_COUNT = HARDWARE_DESCRIPTOR_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.hardware.impl.MemoryDescriptorImpl <em>Memory Descriptor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.hardware.impl.MemoryDescriptorImpl
	 * @see eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl#getMemoryDescriptor()
	 * @generated
	 */
	int MEMORY_DESCRIPTOR = 7;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DESCRIPTOR__ID = HARDWARE_DESCRIPTOR__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DESCRIPTOR__DOCUMENTATION = HARDWARE_DESCRIPTOR__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DESCRIPTOR__NAME = HARDWARE_DESCRIPTOR__NAME;

	/**
	 * The feature id for the '<em><b>Bandwidth</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DESCRIPTOR__BANDWIDTH = HARDWARE_DESCRIPTOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Fsb Frequency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DESCRIPTOR__FSB_FREQUENCY = HARDWARE_DESCRIPTOR_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Access Latency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DESCRIPTOR__ACCESS_LATENCY = HARDWARE_DESCRIPTOR_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Burst Length</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DESCRIPTOR__BURST_LENGTH = HARDWARE_DESCRIPTOR_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Memory Descriptor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMORY_DESCRIPTOR_FEATURE_COUNT = HARDWARE_DESCRIPTOR_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.hardware.impl.HardwareDescriptorRepositoryImpl <em>Descriptor Repository</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.hardware.impl.HardwareDescriptorRepositoryImpl
	 * @see eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl#getHardwareDescriptorRepository()
	 * @generated
	 */
	int HARDWARE_DESCRIPTOR_REPOSITORY = 8;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HARDWARE_DESCRIPTOR_REPOSITORY__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HARDWARE_DESCRIPTOR_REPOSITORY__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HARDWARE_DESCRIPTOR_REPOSITORY__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Descriptors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HARDWARE_DESCRIPTOR_REPOSITORY__DESCRIPTORS = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Descriptor Repository</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HARDWARE_DESCRIPTOR_REPOSITORY_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.hardware.impl.NetworkInterfaceDescriptorImpl <em>Network Interface Descriptor</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.hardware.impl.NetworkInterfaceDescriptorImpl
	 * @see eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl#getNetworkInterfaceDescriptor()
	 * @generated
	 */
	int NETWORK_INTERFACE_DESCRIPTOR = 9;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_INTERFACE_DESCRIPTOR__ID = HARDWARE_DESCRIPTOR__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_INTERFACE_DESCRIPTOR__DOCUMENTATION = HARDWARE_DESCRIPTOR__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_INTERFACE_DESCRIPTOR__NAME = HARDWARE_DESCRIPTOR__NAME;

	/**
	 * The feature id for the '<em><b>Link Latency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_INTERFACE_DESCRIPTOR__LINK_LATENCY = HARDWARE_DESCRIPTOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Link Speed</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_INTERFACE_DESCRIPTOR__LINK_SPEED = HARDWARE_DESCRIPTOR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Network Interface Descriptor</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int NETWORK_INTERFACE_DESCRIPTOR_FEATURE_COUNT = HARDWARE_DESCRIPTOR_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.deployment.hardware.CacheKind <em>Cache Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.deployment.hardware.CacheKind
	 * @see eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl#getCacheKind()
	 * @generated
	 */
	int CACHE_KIND = 10;


	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.hardware.NetworkElementDescriptor <em>Network Element Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Network Element Descriptor</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.NetworkElementDescriptor
	 * @generated
	 */
	EClass getNetworkElementDescriptor();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.NetworkElementDescriptor#getAggregateBandwidth <em>Aggregate Bandwidth</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Aggregate Bandwidth</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.NetworkElementDescriptor#getAggregateBandwidth()
	 * @see #getNetworkElementDescriptor()
	 * @generated
	 */
	EAttribute getNetworkElementDescriptor_AggregateBandwidth();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.NetworkElementDescriptor#getForwardingLatency <em>Forwarding Latency</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Forwarding Latency</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.NetworkElementDescriptor#getForwardingLatency()
	 * @see #getNetworkElementDescriptor()
	 * @generated
	 */
	EAttribute getNetworkElementDescriptor_ForwardingLatency();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.hardware.HardwareDescriptor <em>Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Descriptor</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.HardwareDescriptor
	 * @generated
	 */
	EClass getHardwareDescriptor();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.hardware.TLB <em>TLB</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TLB</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.TLB
	 * @generated
	 */
	EClass getTLB();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.TLB#getKind <em>Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Kind</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.TLB#getKind()
	 * @see #getTLB()
	 * @generated
	 */
	EAttribute getTLB_Kind();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.TLB#getEntryPageSize <em>Entry Page Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Entry Page Size</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.TLB#getEntryPageSize()
	 * @see #getTLB()
	 * @generated
	 */
	EAttribute getTLB_EntryPageSize();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.TLB#getAssociativity <em>Associativity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Associativity</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.TLB#getAssociativity()
	 * @see #getTLB()
	 * @generated
	 */
	EAttribute getTLB_Associativity();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.TLB#getEntriesCount <em>Entries Count</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Entries Count</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.TLB#getEntriesCount()
	 * @see #getTLB()
	 * @generated
	 */
	EAttribute getTLB_EntriesCount();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.hardware.ProcessorCore <em>Processor Core</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Processor Core</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.ProcessorCore
	 * @generated
	 */
	EClass getProcessorCore();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.ProcessorCore#getCoreID <em>Core ID</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Core ID</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.ProcessorCore#getCoreID()
	 * @see #getProcessorCore()
	 * @generated
	 */
	EAttribute getProcessorCore_CoreID();

	/**
	 * Returns the meta object for the reference list '{@link eu.qimpress.samm.deployment.hardware.ProcessorCore#getCaches <em>Caches</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Caches</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.ProcessorCore#getCaches()
	 * @see #getProcessorCore()
	 * @generated
	 */
	EReference getProcessorCore_Caches();

	/**
	 * Returns the meta object for the container reference '{@link eu.qimpress.samm.deployment.hardware.ProcessorCore#getDescriptor <em>Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Descriptor</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.ProcessorCore#getDescriptor()
	 * @see #getProcessorCore()
	 * @generated
	 */
	EReference getProcessorCore_Descriptor();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.hardware.Cache <em>Cache</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Cache</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.Cache
	 * @generated
	 */
	EClass getCache();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.Cache#getLevel <em>Level</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Level</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.Cache#getLevel()
	 * @see #getCache()
	 * @generated
	 */
	EAttribute getCache_Level();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.Cache#getKind <em>Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Kind</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.Cache#getKind()
	 * @see #getCache()
	 * @generated
	 */
	EAttribute getCache_Kind();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.Cache#getSize <em>Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Size</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.Cache#getSize()
	 * @see #getCache()
	 * @generated
	 */
	EAttribute getCache_Size();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.Cache#getAssociativity <em>Associativity</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Associativity</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.Cache#getAssociativity()
	 * @see #getCache()
	 * @generated
	 */
	EAttribute getCache_Associativity();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.Cache#getCacheLineSize <em>Cache Line Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cache Line Size</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.Cache#getCacheLineSize()
	 * @see #getCache()
	 * @generated
	 */
	EAttribute getCache_CacheLineSize();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.Cache#getAccessLatency <em>Access Latency</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Access Latency</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.Cache#getAccessLatency()
	 * @see #getCache()
	 * @generated
	 */
	EAttribute getCache_AccessLatency();

	/**
	 * Returns the meta object for the reference list '{@link eu.qimpress.samm.deployment.hardware.Cache#getCores <em>Cores</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Cores</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.Cache#getCores()
	 * @see #getCache()
	 * @generated
	 */
	EReference getCache_Cores();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.hardware.ProcessorDescriptor <em>Processor Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Processor Descriptor</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.ProcessorDescriptor
	 * @generated
	 */
	EClass getProcessorDescriptor();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.deployment.hardware.ProcessorDescriptor#getCaches <em>Caches</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Caches</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.ProcessorDescriptor#getCaches()
	 * @see #getProcessorDescriptor()
	 * @generated
	 */
	EReference getProcessorDescriptor_Caches();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.deployment.hardware.ProcessorDescriptor#getTlbs <em>Tlbs</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Tlbs</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.ProcessorDescriptor#getTlbs()
	 * @see #getProcessorDescriptor()
	 * @generated
	 */
	EReference getProcessorDescriptor_Tlbs();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.deployment.hardware.ProcessorDescriptor#getCores <em>Cores</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Cores</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.ProcessorDescriptor#getCores()
	 * @see #getProcessorDescriptor()
	 * @generated
	 */
	EReference getProcessorDescriptor_Cores();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor <em>Storage Device Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Storage Device Descriptor</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor
	 * @generated
	 */
	EClass getStorageDeviceDescriptor();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor#getWriteSpeed <em>Write Speed</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Write Speed</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor#getWriteSpeed()
	 * @see #getStorageDeviceDescriptor()
	 * @generated
	 */
	EAttribute getStorageDeviceDescriptor_WriteSpeed();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor#getReadSpeed <em>Read Speed</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Read Speed</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor#getReadSpeed()
	 * @see #getStorageDeviceDescriptor()
	 * @generated
	 */
	EAttribute getStorageDeviceDescriptor_ReadSpeed();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor#getRequestLatency <em>Request Latency</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Request Latency</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor#getRequestLatency()
	 * @see #getStorageDeviceDescriptor()
	 * @generated
	 */
	EAttribute getStorageDeviceDescriptor_RequestLatency();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor#getCacheSize <em>Cache Size</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Cache Size</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor#getCacheSize()
	 * @see #getStorageDeviceDescriptor()
	 * @generated
	 */
	EAttribute getStorageDeviceDescriptor_CacheSize();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.hardware.MemoryDescriptor <em>Memory Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Memory Descriptor</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.MemoryDescriptor
	 * @generated
	 */
	EClass getMemoryDescriptor();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.MemoryDescriptor#getBandwidth <em>Bandwidth</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Bandwidth</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.MemoryDescriptor#getBandwidth()
	 * @see #getMemoryDescriptor()
	 * @generated
	 */
	EAttribute getMemoryDescriptor_Bandwidth();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.MemoryDescriptor#getFsbFrequency <em>Fsb Frequency</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Fsb Frequency</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.MemoryDescriptor#getFsbFrequency()
	 * @see #getMemoryDescriptor()
	 * @generated
	 */
	EAttribute getMemoryDescriptor_FsbFrequency();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.MemoryDescriptor#getAccessLatency <em>Access Latency</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Access Latency</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.MemoryDescriptor#getAccessLatency()
	 * @see #getMemoryDescriptor()
	 * @generated
	 */
	EAttribute getMemoryDescriptor_AccessLatency();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.MemoryDescriptor#getBurstLength <em>Burst Length</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Burst Length</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.MemoryDescriptor#getBurstLength()
	 * @see #getMemoryDescriptor()
	 * @generated
	 */
	EAttribute getMemoryDescriptor_BurstLength();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.hardware.HardwareDescriptorRepository <em>Descriptor Repository</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Descriptor Repository</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.HardwareDescriptorRepository
	 * @generated
	 */
	EClass getHardwareDescriptorRepository();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.samm.deployment.hardware.HardwareDescriptorRepository#getDescriptors <em>Descriptors</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Descriptors</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.HardwareDescriptorRepository#getDescriptors()
	 * @see #getHardwareDescriptorRepository()
	 * @generated
	 */
	EReference getHardwareDescriptorRepository_Descriptors();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.deployment.hardware.NetworkInterfaceDescriptor <em>Network Interface Descriptor</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Network Interface Descriptor</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.NetworkInterfaceDescriptor
	 * @generated
	 */
	EClass getNetworkInterfaceDescriptor();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.NetworkInterfaceDescriptor#getLinkLatency <em>Link Latency</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Link Latency</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.NetworkInterfaceDescriptor#getLinkLatency()
	 * @see #getNetworkInterfaceDescriptor()
	 * @generated
	 */
	EAttribute getNetworkInterfaceDescriptor_LinkLatency();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.samm.deployment.hardware.NetworkInterfaceDescriptor#getLinkSpeed <em>Link Speed</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Link Speed</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.NetworkInterfaceDescriptor#getLinkSpeed()
	 * @see #getNetworkInterfaceDescriptor()
	 * @generated
	 */
	EAttribute getNetworkInterfaceDescriptor_LinkSpeed();

	/**
	 * Returns the meta object for enum '{@link eu.qimpress.samm.deployment.hardware.CacheKind <em>Cache Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Cache Kind</em>'.
	 * @see eu.qimpress.samm.deployment.hardware.CacheKind
	 * @generated
	 */
	EEnum getCacheKind();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	HardwareFactory getHardwareFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.hardware.impl.NetworkElementDescriptorImpl <em>Network Element Descriptor</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.hardware.impl.NetworkElementDescriptorImpl
		 * @see eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl#getNetworkElementDescriptor()
		 * @generated
		 */
		EClass NETWORK_ELEMENT_DESCRIPTOR = eINSTANCE.getNetworkElementDescriptor();

		/**
		 * The meta object literal for the '<em><b>Aggregate Bandwidth</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NETWORK_ELEMENT_DESCRIPTOR__AGGREGATE_BANDWIDTH = eINSTANCE.getNetworkElementDescriptor_AggregateBandwidth();

		/**
		 * The meta object literal for the '<em><b>Forwarding Latency</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NETWORK_ELEMENT_DESCRIPTOR__FORWARDING_LATENCY = eINSTANCE.getNetworkElementDescriptor_ForwardingLatency();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.hardware.impl.HardwareDescriptorImpl <em>Descriptor</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.hardware.impl.HardwareDescriptorImpl
		 * @see eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl#getHardwareDescriptor()
		 * @generated
		 */
		EClass HARDWARE_DESCRIPTOR = eINSTANCE.getHardwareDescriptor();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.hardware.impl.TLBImpl <em>TLB</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.hardware.impl.TLBImpl
		 * @see eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl#getTLB()
		 * @generated
		 */
		EClass TLB = eINSTANCE.getTLB();

		/**
		 * The meta object literal for the '<em><b>Kind</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TLB__KIND = eINSTANCE.getTLB_Kind();

		/**
		 * The meta object literal for the '<em><b>Entry Page Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TLB__ENTRY_PAGE_SIZE = eINSTANCE.getTLB_EntryPageSize();

		/**
		 * The meta object literal for the '<em><b>Associativity</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TLB__ASSOCIATIVITY = eINSTANCE.getTLB_Associativity();

		/**
		 * The meta object literal for the '<em><b>Entries Count</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TLB__ENTRIES_COUNT = eINSTANCE.getTLB_EntriesCount();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.hardware.impl.ProcessorCoreImpl <em>Processor Core</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.hardware.impl.ProcessorCoreImpl
		 * @see eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl#getProcessorCore()
		 * @generated
		 */
		EClass PROCESSOR_CORE = eINSTANCE.getProcessorCore();

		/**
		 * The meta object literal for the '<em><b>Core ID</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute PROCESSOR_CORE__CORE_ID = eINSTANCE.getProcessorCore_CoreID();

		/**
		 * The meta object literal for the '<em><b>Caches</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROCESSOR_CORE__CACHES = eINSTANCE.getProcessorCore_Caches();

		/**
		 * The meta object literal for the '<em><b>Descriptor</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROCESSOR_CORE__DESCRIPTOR = eINSTANCE.getProcessorCore_Descriptor();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.hardware.impl.CacheImpl <em>Cache</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.hardware.impl.CacheImpl
		 * @see eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl#getCache()
		 * @generated
		 */
		EClass CACHE = eINSTANCE.getCache();

		/**
		 * The meta object literal for the '<em><b>Level</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CACHE__LEVEL = eINSTANCE.getCache_Level();

		/**
		 * The meta object literal for the '<em><b>Kind</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CACHE__KIND = eINSTANCE.getCache_Kind();

		/**
		 * The meta object literal for the '<em><b>Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CACHE__SIZE = eINSTANCE.getCache_Size();

		/**
		 * The meta object literal for the '<em><b>Associativity</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CACHE__ASSOCIATIVITY = eINSTANCE.getCache_Associativity();

		/**
		 * The meta object literal for the '<em><b>Cache Line Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CACHE__CACHE_LINE_SIZE = eINSTANCE.getCache_CacheLineSize();

		/**
		 * The meta object literal for the '<em><b>Access Latency</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute CACHE__ACCESS_LATENCY = eINSTANCE.getCache_AccessLatency();

		/**
		 * The meta object literal for the '<em><b>Cores</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CACHE__CORES = eINSTANCE.getCache_Cores();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.hardware.impl.ProcessorDescriptorImpl <em>Processor Descriptor</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.hardware.impl.ProcessorDescriptorImpl
		 * @see eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl#getProcessorDescriptor()
		 * @generated
		 */
		EClass PROCESSOR_DESCRIPTOR = eINSTANCE.getProcessorDescriptor();

		/**
		 * The meta object literal for the '<em><b>Caches</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROCESSOR_DESCRIPTOR__CACHES = eINSTANCE.getProcessorDescriptor_Caches();

		/**
		 * The meta object literal for the '<em><b>Tlbs</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROCESSOR_DESCRIPTOR__TLBS = eINSTANCE.getProcessorDescriptor_Tlbs();

		/**
		 * The meta object literal for the '<em><b>Cores</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PROCESSOR_DESCRIPTOR__CORES = eINSTANCE.getProcessorDescriptor_Cores();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.hardware.impl.StorageDeviceDescriptorImpl <em>Storage Device Descriptor</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.hardware.impl.StorageDeviceDescriptorImpl
		 * @see eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl#getStorageDeviceDescriptor()
		 * @generated
		 */
		EClass STORAGE_DEVICE_DESCRIPTOR = eINSTANCE.getStorageDeviceDescriptor();

		/**
		 * The meta object literal for the '<em><b>Write Speed</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STORAGE_DEVICE_DESCRIPTOR__WRITE_SPEED = eINSTANCE.getStorageDeviceDescriptor_WriteSpeed();

		/**
		 * The meta object literal for the '<em><b>Read Speed</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STORAGE_DEVICE_DESCRIPTOR__READ_SPEED = eINSTANCE.getStorageDeviceDescriptor_ReadSpeed();

		/**
		 * The meta object literal for the '<em><b>Request Latency</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STORAGE_DEVICE_DESCRIPTOR__REQUEST_LATENCY = eINSTANCE.getStorageDeviceDescriptor_RequestLatency();

		/**
		 * The meta object literal for the '<em><b>Cache Size</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STORAGE_DEVICE_DESCRIPTOR__CACHE_SIZE = eINSTANCE.getStorageDeviceDescriptor_CacheSize();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.hardware.impl.MemoryDescriptorImpl <em>Memory Descriptor</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.hardware.impl.MemoryDescriptorImpl
		 * @see eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl#getMemoryDescriptor()
		 * @generated
		 */
		EClass MEMORY_DESCRIPTOR = eINSTANCE.getMemoryDescriptor();

		/**
		 * The meta object literal for the '<em><b>Bandwidth</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MEMORY_DESCRIPTOR__BANDWIDTH = eINSTANCE.getMemoryDescriptor_Bandwidth();

		/**
		 * The meta object literal for the '<em><b>Fsb Frequency</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MEMORY_DESCRIPTOR__FSB_FREQUENCY = eINSTANCE.getMemoryDescriptor_FsbFrequency();

		/**
		 * The meta object literal for the '<em><b>Access Latency</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MEMORY_DESCRIPTOR__ACCESS_LATENCY = eINSTANCE.getMemoryDescriptor_AccessLatency();

		/**
		 * The meta object literal for the '<em><b>Burst Length</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MEMORY_DESCRIPTOR__BURST_LENGTH = eINSTANCE.getMemoryDescriptor_BurstLength();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.hardware.impl.HardwareDescriptorRepositoryImpl <em>Descriptor Repository</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.hardware.impl.HardwareDescriptorRepositoryImpl
		 * @see eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl#getHardwareDescriptorRepository()
		 * @generated
		 */
		EClass HARDWARE_DESCRIPTOR_REPOSITORY = eINSTANCE.getHardwareDescriptorRepository();

		/**
		 * The meta object literal for the '<em><b>Descriptors</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HARDWARE_DESCRIPTOR_REPOSITORY__DESCRIPTORS = eINSTANCE.getHardwareDescriptorRepository_Descriptors();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.hardware.impl.NetworkInterfaceDescriptorImpl <em>Network Interface Descriptor</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.hardware.impl.NetworkInterfaceDescriptorImpl
		 * @see eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl#getNetworkInterfaceDescriptor()
		 * @generated
		 */
		EClass NETWORK_INTERFACE_DESCRIPTOR = eINSTANCE.getNetworkInterfaceDescriptor();

		/**
		 * The meta object literal for the '<em><b>Link Latency</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NETWORK_INTERFACE_DESCRIPTOR__LINK_LATENCY = eINSTANCE.getNetworkInterfaceDescriptor_LinkLatency();

		/**
		 * The meta object literal for the '<em><b>Link Speed</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute NETWORK_INTERFACE_DESCRIPTOR__LINK_SPEED = eINSTANCE.getNetworkInterfaceDescriptor_LinkSpeed();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.deployment.hardware.CacheKind <em>Cache Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.deployment.hardware.CacheKind
		 * @see eu.qimpress.samm.deployment.hardware.impl.HardwarePackageImpl#getCacheKind()
		 * @generated
		 */
		EEnum CACHE_KIND = eINSTANCE.getCacheKind();

	}

} //HardwarePackage
