/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.hardware;

import eu.qimpress.samm.core.NamedEntity;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Descriptor Repository</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The HardwareDescriptorRepository entity represents a container for all kinds of hardware descriptors.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.HardwareDescriptorRepository#getDescriptors <em>Descriptors</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getHardwareDescriptorRepository()
 * @model
 * @generated
 */
public interface HardwareDescriptorRepository extends NamedEntity {
	/**
	 * Returns the value of the '<em><b>Descriptors</b></em>' containment reference list.
	 * The list contents are of type {@link eu.qimpress.samm.deployment.hardware.HardwareDescriptor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Hardware descriptors contained within the repository.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Descriptors</em>' containment reference list.
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getHardwareDescriptorRepository_Descriptors()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<HardwareDescriptor> getDescriptors();

} // HardwareDescriptorRepository
