/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.hardware;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Cache</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The Cache entity represents a processor cache. It captures the level on which the cache operates in cache hierarchy, its size and associativity, size of the cache line and access latency. Each cache can be available to one or more ProcessorCores. The Cache entity allows describing typical caches, such as instruction or data (or unified) caches, but is unsuitable for capturing caches such as the Pentium 4 trace cache.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.Cache#getLevel <em>Level</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.Cache#getKind <em>Kind</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.Cache#getSize <em>Size</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.Cache#getAssociativity <em>Associativity</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.Cache#getCacheLineSize <em>Cache Line Size</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.Cache#getAccessLatency <em>Access Latency</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.hardware.Cache#getCores <em>Cores</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getCache()
 * @model
 * @generated
 */
public interface Cache extends EObject {
	/**
	 * Returns the value of the '<em><b>Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The level at which the cache operates in the cache hierarchy.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Level</em>' attribute.
	 * @see #setLevel(int)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getCache_Level()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getLevel();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.Cache#getLevel <em>Level</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Level</em>' attribute.
	 * @see #getLevel()
	 * @generated
	 */
	void setLevel(int value);

	/**
	 * Returns the value of the '<em><b>Kind</b></em>' attribute.
	 * The literals are from the enumeration {@link eu.qimpress.samm.deployment.hardware.CacheKind}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The kind of contents stored by this cache.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Kind</em>' attribute.
	 * @see eu.qimpress.samm.deployment.hardware.CacheKind
	 * @see #setKind(CacheKind)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getCache_Kind()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	CacheKind getKind();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.Cache#getKind <em>Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Kind</em>' attribute.
	 * @see eu.qimpress.samm.deployment.hardware.CacheKind
	 * @see #getKind()
	 * @generated
	 */
	void setKind(CacheKind value);

	/**
	 * Returns the value of the '<em><b>Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Size of the cache, in bytes.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Size</em>' attribute.
	 * @see #setSize(int)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getCache_Size()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getSize();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.Cache#getSize <em>Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Size</em>' attribute.
	 * @see #getSize()
	 * @generated
	 */
	void setSize(int value);

	/**
	 * Returns the value of the '<em><b>Associativity</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Degree of cache associativity, possibly in powers of 2. Value of 1 indicates a direct-mapped cache, value of (cacheSize / cacheLineSize) indicates a fully associative cache. Values between those extremes indicate the degree of associativity. Other values are considered invalid.
	 * 
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Associativity</em>' attribute.
	 * @see #setAssociativity(int)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getCache_Associativity()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getAssociativity();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.Cache#getAssociativity <em>Associativity</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Associativity</em>' attribute.
	 * @see #getAssociativity()
	 * @generated
	 */
	void setAssociativity(int value);

	/**
	 * Returns the value of the '<em><b>Cache Line Size</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Size of the cache line, in bytes.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Cache Line Size</em>' attribute.
	 * @see #setCacheLineSize(int)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getCache_CacheLineSize()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getCacheLineSize();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.Cache#getCacheLineSize <em>Cache Line Size</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Cache Line Size</em>' attribute.
	 * @see #getCacheLineSize()
	 * @generated
	 */
	void setCacheLineSize(int value);

	/**
	 * Returns the value of the '<em><b>Access Latency</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Cache access latency expressed in number of clocks of the processor. The access latency of higher-level caches represents the miss penalty for lower-level (closer to processor) caches. The memory access latency represents the miss penalty for the highest-level cache.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Access Latency</em>' attribute.
	 * @see #setAccessLatency(int)
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getCache_AccessLatency()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getAccessLatency();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.hardware.Cache#getAccessLatency <em>Access Latency</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Access Latency</em>' attribute.
	 * @see #getAccessLatency()
	 * @generated
	 */
	void setAccessLatency(int value);

	/**
	 * Returns the value of the '<em><b>Cores</b></em>' reference list.
	 * The list contents are of type {@link eu.qimpress.samm.deployment.hardware.ProcessorCore}.
	 * It is bidirectional and its opposite is '{@link eu.qimpress.samm.deployment.hardware.ProcessorCore#getCaches <em>Caches</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * Collection of processor cores sharing a particular cache.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Cores</em>' reference list.
	 * @see eu.qimpress.samm.deployment.hardware.HardwarePackage#getCache_Cores()
	 * @see eu.qimpress.samm.deployment.hardware.ProcessorCore#getCaches
	 * @model opposite="caches" required="true" ordered="false"
	 * @generated
	 */
	EList<ProcessorCore> getCores();

} // Cache
