/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.allocation.impl;

import java.util.Map;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.OCL;

import eu.qimpress.samm.core.impl.NamedEntityImpl;
import eu.qimpress.samm.deployment.allocation.AllocationPackage;
import eu.qimpress.samm.deployment.allocation.Service;
import eu.qimpress.samm.deployment.allocation.util.AllocationValidator;
import eu.qimpress.samm.deployment.targetenvironment.Container;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Service</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.allocation.impl.ServiceImpl#isBlackBox <em>Is Black Box</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.allocation.impl.ServiceImpl#getContainer <em>Container</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.allocation.impl.ServiceImpl#getSubcomponentInstance <em>Subcomponent Instance</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ServiceImpl extends NamedEntityImpl implements Service {
	/**
	 * The default value of the '{@link #isBlackBox() <em>Is Black Box</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isBlackBox()
	 * @generated
	 * @ordered
	 */
	protected static final boolean IS_BLACK_BOX_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isBlackBox() <em>Is Black Box</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isBlackBox()
	 * @generated
	 * @ordered
	 */
	protected boolean isBlackBox = IS_BLACK_BOX_EDEFAULT;

	/**
	 * The cached value of the '{@link #getContainer() <em>Container</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getContainer()
	 * @generated
	 * @ordered
	 */
	protected Container container;

	/**
	 * The cached value of the '{@link #getSubcomponentInstance() <em>Subcomponent Instance</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSubcomponentInstance()
	 * @generated
	 * @ordered
	 */
	protected SubcomponentInstance subcomponentInstance;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ServiceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return AllocationPackage.Literals.SERVICE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isBlackBox() {
		return isBlackBox;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIsBlackBox(boolean newIsBlackBox) {
		boolean oldIsBlackBox = isBlackBox;
		isBlackBox = newIsBlackBox;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AllocationPackage.SERVICE__IS_BLACK_BOX, oldIsBlackBox, isBlackBox));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Container getContainer() {
		if (container != null && container.eIsProxy()) {
			InternalEObject oldContainer = (InternalEObject)container;
			container = (Container)eResolveProxy(oldContainer);
			if (container != oldContainer) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, AllocationPackage.SERVICE__CONTAINER, oldContainer, container));
			}
		}
		return container;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Container basicGetContainer() {
		return container;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setContainer(Container newContainer) {
		Container oldContainer = container;
		container = newContainer;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AllocationPackage.SERVICE__CONTAINER, oldContainer, container));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SubcomponentInstance getSubcomponentInstance() {
		if (subcomponentInstance != null && subcomponentInstance.eIsProxy()) {
			InternalEObject oldSubcomponentInstance = (InternalEObject)subcomponentInstance;
			subcomponentInstance = (SubcomponentInstance)eResolveProxy(oldSubcomponentInstance);
			if (subcomponentInstance != oldSubcomponentInstance) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, AllocationPackage.SERVICE__SUBCOMPONENT_INSTANCE, oldSubcomponentInstance, subcomponentInstance));
			}
		}
		return subcomponentInstance;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SubcomponentInstance basicGetSubcomponentInstance() {
		return subcomponentInstance;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSubcomponentInstance(SubcomponentInstance newSubcomponentInstance) {
		SubcomponentInstance oldSubcomponentInstance = subcomponentInstance;
		subcomponentInstance = newSubcomponentInstance;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, AllocationPackage.SERVICE__SUBCOMPONENT_INSTANCE, oldSubcomponentInstance, subcomponentInstance));
	}

	/**
	 * The cached OCL expression body for the '{@link #WhiteBoxServicesNeedAContainer(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>White Box Services Need AContainer</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #WhiteBoxServicesNeedAContainer(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static final String WHITE_BOX_SERVICES_NEED_ACONTAINER__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP = "if not self.isBlackBox then not self.container.oclIsUndefined() else true endif";

	/**
	 * The cached OCL invariant for the '{@link #WhiteBoxServicesNeedAContainer(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map) <em>White Box Services Need AContainer</em>}' invariant operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #WhiteBoxServicesNeedAContainer(org.eclipse.emf.common.util.DiagnosticChain, java.util.Map)
	 * @generated
	 * @ordered
	 */
	protected static Constraint WHITE_BOX_SERVICES_NEED_ACONTAINER__DIAGNOSTIC_CHAIN_MAP__EOCL_INV;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean WhiteBoxServicesNeedAContainer(DiagnosticChain diagnostics, Map<Object, Object> context) {
		if (WHITE_BOX_SERVICES_NEED_ACONTAINER__DIAGNOSTIC_CHAIN_MAP__EOCL_INV == null) {
			OCL.Helper helper = EOCL_ENV.createOCLHelper();
			helper.setContext(AllocationPackage.Literals.SERVICE);
			try {
				WHITE_BOX_SERVICES_NEED_ACONTAINER__DIAGNOSTIC_CHAIN_MAP__EOCL_INV = helper.createInvariant(WHITE_BOX_SERVICES_NEED_ACONTAINER__DIAGNOSTIC_CHAIN_MAP__EOCL_EXP);
			}
			catch (ParserException pe) {
				throw new UnsupportedOperationException(pe.getLocalizedMessage());
			}
		}
		if (!EOCL_ENV.createQuery(WHITE_BOX_SERVICES_NEED_ACONTAINER__DIAGNOSTIC_CHAIN_MAP__EOCL_INV).check(this)) {
			if (diagnostics != null) {
				diagnostics.add
					(new BasicDiagnostic
						(Diagnostic.ERROR,
						 AllocationValidator.DIAGNOSTIC_SOURCE,
						 AllocationValidator.SERVICE__WHITE_BOX_SERVICES_NEED_ACONTAINER,
						 EcorePlugin.INSTANCE.getString("_UI_GenericInvariant_diagnostic", new Object[] { "WhiteBoxServicesNeedAContainer", EObjectValidator.getObjectLabel(this, context) }),
						 new Object [] { this }));
			}
			return false;
		}
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case AllocationPackage.SERVICE__IS_BLACK_BOX:
				return isBlackBox();
			case AllocationPackage.SERVICE__CONTAINER:
				if (resolve) return getContainer();
				return basicGetContainer();
			case AllocationPackage.SERVICE__SUBCOMPONENT_INSTANCE:
				if (resolve) return getSubcomponentInstance();
				return basicGetSubcomponentInstance();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case AllocationPackage.SERVICE__IS_BLACK_BOX:
				setIsBlackBox((Boolean)newValue);
				return;
			case AllocationPackage.SERVICE__CONTAINER:
				setContainer((Container)newValue);
				return;
			case AllocationPackage.SERVICE__SUBCOMPONENT_INSTANCE:
				setSubcomponentInstance((SubcomponentInstance)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case AllocationPackage.SERVICE__IS_BLACK_BOX:
				setIsBlackBox(IS_BLACK_BOX_EDEFAULT);
				return;
			case AllocationPackage.SERVICE__CONTAINER:
				setContainer((Container)null);
				return;
			case AllocationPackage.SERVICE__SUBCOMPONENT_INSTANCE:
				setSubcomponentInstance((SubcomponentInstance)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case AllocationPackage.SERVICE__IS_BLACK_BOX:
				return isBlackBox != IS_BLACK_BOX_EDEFAULT;
			case AllocationPackage.SERVICE__CONTAINER:
				return container != null;
			case AllocationPackage.SERVICE__SUBCOMPONENT_INSTANCE:
				return subcomponentInstance != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (isBlackBox: ");
		result.append(isBlackBox);
		result.append(')');
		return result.toString();
	}

	/**
	 * The cached environment for evaluating OCL expressions.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected static final OCL EOCL_ENV = OCL.newInstance();

} //ServiceImpl
