/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.allocation;

import eu.qimpress.samm.core.NamedEntity;
import org.eclipse.emf.ecore.EObject;

import eu.qimpress.samm.deployment.targetenvironment.Container;
import eu.qimpress.samm.staticstructure.SubcomponentInstance;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Service</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The service entity represents a basic building unit of the service-oriented architecture. A service is a composite structure realized by a deployed component providing resp. requiring functionality through its provided ports to resp. from other services.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.samm.deployment.allocation.Service#isBlackBox <em>Is Black Box</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.allocation.Service#getContainer <em>Container</em>}</li>
 *   <li>{@link eu.qimpress.samm.deployment.allocation.Service#getSubcomponentInstance <em>Subcomponent Instance</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.samm.deployment.allocation.AllocationPackage#getService()
 * @model
 * @generated
 */
public interface Service extends NamedEntity {
	/**
	 * Returns the value of the '<em><b>Is Black Box</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This derived attribute specifies whether the internal structure of the Service is visible. For those Services which have the isBlackBox property set to true, no information on the internal structure is available.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Is Black Box</em>' attribute.
	 * @see #setIsBlackBox(boolean)
	 * @see eu.qimpress.samm.deployment.allocation.AllocationPackage#getService_IsBlackBox()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	boolean isBlackBox();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.allocation.Service#isBlackBox <em>Is Black Box</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Is Black Box</em>' attribute.
	 * @see #isBlackBox()
	 * @generated
	 */
	void setIsBlackBox(boolean value);

	/**
	 * Returns the value of the '<em><b>Container</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property determines the container on which the Service is allocated and executed. The component exploits the resources (e.g., CPU, disk, or memory) of the container.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Container</em>' reference.
	 * @see #setContainer(Container)
	 * @see eu.qimpress.samm.deployment.allocation.AllocationPackage#getService_Container()
	 * @model ordered="false"
	 * @generated
	 */
	Container getContainer();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.allocation.Service#getContainer <em>Container</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Container</em>' reference.
	 * @see #getContainer()
	 * @generated
	 */
	void setContainer(Container value);

	/**
	 * Returns the value of the '<em><b>Subcomponent Instance</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * The component property identifies the ComponentType, whose instance actually realizes (implements) the Service.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Subcomponent Instance</em>' reference.
	 * @see #setSubcomponentInstance(SubcomponentInstance)
	 * @see eu.qimpress.samm.deployment.allocation.AllocationPackage#getService_SubcomponentInstance()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	SubcomponentInstance getSubcomponentInstance();

	/**
	 * Sets the value of the '{@link eu.qimpress.samm.deployment.allocation.Service#getSubcomponentInstance <em>Subcomponent Instance</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Subcomponent Instance</em>' reference.
	 * @see #getSubcomponentInstance()
	 * @generated
	 */
	void setSubcomponentInstance(SubcomponentInstance value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * if not self.isBlackBox then not self.container.oclIsUndefined() else true endif
	 * @param diagnostics The chain of diagnostics to which problems are to be appended.
	 * @param context The cache of context-specific information.
	 * <!-- end-model-doc -->
	 * @model annotation="http://www.eclipse.org/uml2/1.1.0/GenModel body='if not self.isBlackBox then not self.container.oclIsUndefined() else true endif'"
	 * @generated
	 */
	boolean WhiteBoxServicesNeedAContainer(DiagnosticChain diagnostics, Map<Object, Object> context);

} // Service
