/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.behaviour.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import eu.qimpress.identifier.Identifier;
import eu.qimpress.samm.behaviour.*;
import eu.qimpress.samm.core.Entity;
import eu.qimpress.samm.core.NamedEntity;
import eu.qimpress.samm.behaviour.Behaviour;
import eu.qimpress.samm.behaviour.BehaviourPackage;
import eu.qimpress.samm.behaviour.ComponentTypeBehaviour;
import eu.qimpress.samm.behaviour.GastBehaviourStub;
import eu.qimpress.samm.behaviour.OperationBehaviour;
import eu.qimpress.samm.behaviour.SeffBehaviourStub;
import eu.qimpress.samm.behaviour.TBPBehaviourStub;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see eu.qimpress.samm.behaviour.BehaviourPackage
 * @generated
 */
public class BehaviourSwitch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static BehaviourPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BehaviourSwitch() {
		if (modelPackage == null) {
			modelPackage = BehaviourPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public T doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List<EClass> eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case BehaviourPackage.COMPONENT_TYPE_BEHAVIOUR: {
				ComponentTypeBehaviour componentTypeBehaviour = (ComponentTypeBehaviour)theEObject;
				T result = caseComponentTypeBehaviour(componentTypeBehaviour);
				if (result == null) result = caseBehaviour(componentTypeBehaviour);
				if (result == null) result = caseNamedEntity(componentTypeBehaviour);
				if (result == null) result = caseEntity(componentTypeBehaviour);
				if (result == null) result = caseIdentifier(componentTypeBehaviour);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case BehaviourPackage.BEHAVIOUR: {
				Behaviour behaviour = (Behaviour)theEObject;
				T result = caseBehaviour(behaviour);
				if (result == null) result = caseNamedEntity(behaviour);
				if (result == null) result = caseEntity(behaviour);
				if (result == null) result = caseIdentifier(behaviour);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case BehaviourPackage.SEFF_BEHAVIOUR_STUB: {
				SeffBehaviourStub seffBehaviourStub = (SeffBehaviourStub)theEObject;
				T result = caseSeffBehaviourStub(seffBehaviourStub);
				if (result == null) result = caseOperationBehaviour(seffBehaviourStub);
				if (result == null) result = caseBehaviour(seffBehaviourStub);
				if (result == null) result = caseNamedEntity(seffBehaviourStub);
				if (result == null) result = caseEntity(seffBehaviourStub);
				if (result == null) result = caseIdentifier(seffBehaviourStub);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case BehaviourPackage.GAST_BEHAVIOUR_STUB: {
				GastBehaviourStub gastBehaviourStub = (GastBehaviourStub)theEObject;
				T result = caseGastBehaviourStub(gastBehaviourStub);
				if (result == null) result = caseOperationBehaviour(gastBehaviourStub);
				if (result == null) result = caseBehaviour(gastBehaviourStub);
				if (result == null) result = caseNamedEntity(gastBehaviourStub);
				if (result == null) result = caseEntity(gastBehaviourStub);
				if (result == null) result = caseIdentifier(gastBehaviourStub);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case BehaviourPackage.TBP_BEHAVIOUR_STUB: {
				TBPBehaviourStub tbpBehaviourStub = (TBPBehaviourStub)theEObject;
				T result = caseTBPBehaviourStub(tbpBehaviourStub);
				if (result == null) result = caseComponentTypeBehaviour(tbpBehaviourStub);
				if (result == null) result = caseBehaviour(tbpBehaviourStub);
				if (result == null) result = caseNamedEntity(tbpBehaviourStub);
				if (result == null) result = caseEntity(tbpBehaviourStub);
				if (result == null) result = caseIdentifier(tbpBehaviourStub);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case BehaviourPackage.OPERATION_BEHAVIOUR: {
				OperationBehaviour operationBehaviour = (OperationBehaviour)theEObject;
				T result = caseOperationBehaviour(operationBehaviour);
				if (result == null) result = caseBehaviour(operationBehaviour);
				if (result == null) result = caseNamedEntity(operationBehaviour);
				if (result == null) result = caseEntity(operationBehaviour);
				if (result == null) result = caseIdentifier(operationBehaviour);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Component Type Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Component Type Behaviour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseComponentTypeBehaviour(ComponentTypeBehaviour object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Behaviour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseBehaviour(Behaviour object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Seff Behaviour Stub</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Seff Behaviour Stub</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSeffBehaviourStub(SeffBehaviourStub object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Gast Behaviour Stub</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Gast Behaviour Stub</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGastBehaviourStub(GastBehaviourStub object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>TBP Behaviour Stub</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>TBP Behaviour Stub</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTBPBehaviourStub(TBPBehaviourStub object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Operation Behaviour</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Operation Behaviour</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseOperationBehaviour(OperationBehaviour object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Identifier</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Identifier</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIdentifier(Identifier object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Entity</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Entity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEntity(Entity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Named Entity</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Named Entity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNamedEntity(NamedEntity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(EObject object) {
		return null;
	}

} //BehaviourSwitch
