/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.behaviour;

import eu.qimpress.samm.core.CorePackage;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import eu.qimpress.identifier.IdentifierPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * The behaviour package specifies a behaviour meta-model for services. Since the aim is to support many different behaviour models to allow reasoning about various behavioural aspects, a general behaviour meta-model is defined that has to be specialized by particular behavioural meta-models via inheritance.
 * 
 * <!-- end-model-doc -->
 * @see eu.qimpress.samm.behaviour.BehaviourFactory
 * @model kind="package"
 * @generated
 */
public interface BehaviourPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "behaviour";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://q-impress.eu/samm/behaviour";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "behaviour";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	BehaviourPackage eINSTANCE = eu.qimpress.samm.behaviour.impl.BehaviourPackageImpl.init();

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.behaviour.impl.BehaviourImpl <em>Behaviour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.behaviour.impl.BehaviourImpl
	 * @see eu.qimpress.samm.behaviour.impl.BehaviourPackageImpl#getBehaviour()
	 * @generated
	 */
	int BEHAVIOUR = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The number of structural features of the '<em>Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BEHAVIOUR_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.behaviour.impl.ComponentTypeBehaviourImpl <em>Component Type Behaviour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.behaviour.impl.ComponentTypeBehaviourImpl
	 * @see eu.qimpress.samm.behaviour.impl.BehaviourPackageImpl#getComponentTypeBehaviour()
	 * @generated
	 */
	int COMPONENT_TYPE_BEHAVIOUR = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE_BEHAVIOUR__ID = BEHAVIOUR__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE_BEHAVIOUR__DOCUMENTATION = BEHAVIOUR__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE_BEHAVIOUR__NAME = BEHAVIOUR__NAME;

	/**
	 * The number of structural features of the '<em>Component Type Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int COMPONENT_TYPE_BEHAVIOUR_FEATURE_COUNT = BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.behaviour.impl.OperationBehaviourImpl <em>Operation Behaviour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.behaviour.impl.OperationBehaviourImpl
	 * @see eu.qimpress.samm.behaviour.impl.BehaviourPackageImpl#getOperationBehaviour()
	 * @generated
	 */
	int OPERATION_BEHAVIOUR = 5;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_BEHAVIOUR__ID = BEHAVIOUR__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_BEHAVIOUR__DOCUMENTATION = BEHAVIOUR__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_BEHAVIOUR__NAME = BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_BEHAVIOUR__OPERATION = BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Operation Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OPERATION_BEHAVIOUR_FEATURE_COUNT = BEHAVIOUR_FEATURE_COUNT + 1;


	/**
	 * The meta object id for the '{@link eu.qimpress.samm.behaviour.impl.SeffBehaviourStubImpl <em>Seff Behaviour Stub</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.behaviour.impl.SeffBehaviourStubImpl
	 * @see eu.qimpress.samm.behaviour.impl.BehaviourPackageImpl#getSeffBehaviourStub()
	 * @generated
	 */
	int SEFF_BEHAVIOUR_STUB = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEFF_BEHAVIOUR_STUB__ID = OPERATION_BEHAVIOUR__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEFF_BEHAVIOUR_STUB__DOCUMENTATION = OPERATION_BEHAVIOUR__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEFF_BEHAVIOUR_STUB__NAME = OPERATION_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEFF_BEHAVIOUR_STUB__OPERATION = OPERATION_BEHAVIOUR__OPERATION;

	/**
	 * The number of structural features of the '<em>Seff Behaviour Stub</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SEFF_BEHAVIOUR_STUB_FEATURE_COUNT = OPERATION_BEHAVIOUR_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link eu.qimpress.samm.behaviour.impl.GastBehaviourStubImpl <em>Gast Behaviour Stub</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.behaviour.impl.GastBehaviourStubImpl
	 * @see eu.qimpress.samm.behaviour.impl.BehaviourPackageImpl#getGastBehaviourStub()
	 * @generated
	 */
	int GAST_BEHAVIOUR_STUB = 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_BEHAVIOUR_STUB__ID = OPERATION_BEHAVIOUR__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_BEHAVIOUR_STUB__DOCUMENTATION = OPERATION_BEHAVIOUR__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_BEHAVIOUR_STUB__NAME = OPERATION_BEHAVIOUR__NAME;

	/**
	 * The feature id for the '<em><b>Operation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_BEHAVIOUR_STUB__OPERATION = OPERATION_BEHAVIOUR__OPERATION;

	/**
	 * The number of structural features of the '<em>Gast Behaviour Stub</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_BEHAVIOUR_STUB_FEATURE_COUNT = OPERATION_BEHAVIOUR_FEATURE_COUNT + 0;


	/**
	 * The meta object id for the '{@link eu.qimpress.samm.behaviour.impl.TBPBehaviourStubImpl <em>TBP Behaviour Stub</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.samm.behaviour.impl.TBPBehaviourStubImpl
	 * @see eu.qimpress.samm.behaviour.impl.BehaviourPackageImpl#getTBPBehaviourStub()
	 * @generated
	 */
	int TBP_BEHAVIOUR_STUB = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TBP_BEHAVIOUR_STUB__ID = COMPONENT_TYPE_BEHAVIOUR__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TBP_BEHAVIOUR_STUB__DOCUMENTATION = COMPONENT_TYPE_BEHAVIOUR__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TBP_BEHAVIOUR_STUB__NAME = COMPONENT_TYPE_BEHAVIOUR__NAME;

	/**
	 * The number of structural features of the '<em>TBP Behaviour Stub</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TBP_BEHAVIOUR_STUB_FEATURE_COUNT = COMPONENT_TYPE_BEHAVIOUR_FEATURE_COUNT + 0;


	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.behaviour.ComponentTypeBehaviour <em>Component Type Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Component Type Behaviour</em>'.
	 * @see eu.qimpress.samm.behaviour.ComponentTypeBehaviour
	 * @generated
	 */
	EClass getComponentTypeBehaviour();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.behaviour.Behaviour <em>Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Behaviour</em>'.
	 * @see eu.qimpress.samm.behaviour.Behaviour
	 * @generated
	 */
	EClass getBehaviour();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.behaviour.SeffBehaviourStub <em>Seff Behaviour Stub</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Seff Behaviour Stub</em>'.
	 * @see eu.qimpress.samm.behaviour.SeffBehaviourStub
	 * @generated
	 */
	EClass getSeffBehaviourStub();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.behaviour.GastBehaviourStub <em>Gast Behaviour Stub</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Gast Behaviour Stub</em>'.
	 * @see eu.qimpress.samm.behaviour.GastBehaviourStub
	 * @generated
	 */
	EClass getGastBehaviourStub();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.behaviour.TBPBehaviourStub <em>TBP Behaviour Stub</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>TBP Behaviour Stub</em>'.
	 * @see eu.qimpress.samm.behaviour.TBPBehaviourStub
	 * @generated
	 */
	EClass getTBPBehaviourStub();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.samm.behaviour.OperationBehaviour <em>Operation Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Operation Behaviour</em>'.
	 * @see eu.qimpress.samm.behaviour.OperationBehaviour
	 * @generated
	 */
	EClass getOperationBehaviour();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.samm.behaviour.OperationBehaviour#getOperation <em>Operation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Operation</em>'.
	 * @see eu.qimpress.samm.behaviour.OperationBehaviour#getOperation()
	 * @see #getOperationBehaviour()
	 * @generated
	 */
	EReference getOperationBehaviour_Operation();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	BehaviourFactory getBehaviourFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.behaviour.impl.ComponentTypeBehaviourImpl <em>Component Type Behaviour</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.behaviour.impl.ComponentTypeBehaviourImpl
		 * @see eu.qimpress.samm.behaviour.impl.BehaviourPackageImpl#getComponentTypeBehaviour()
		 * @generated
		 */
		EClass COMPONENT_TYPE_BEHAVIOUR = eINSTANCE.getComponentTypeBehaviour();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.behaviour.impl.BehaviourImpl <em>Behaviour</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.behaviour.impl.BehaviourImpl
		 * @see eu.qimpress.samm.behaviour.impl.BehaviourPackageImpl#getBehaviour()
		 * @generated
		 */
		EClass BEHAVIOUR = eINSTANCE.getBehaviour();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.behaviour.impl.SeffBehaviourStubImpl <em>Seff Behaviour Stub</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.behaviour.impl.SeffBehaviourStubImpl
		 * @see eu.qimpress.samm.behaviour.impl.BehaviourPackageImpl#getSeffBehaviourStub()
		 * @generated
		 */
		EClass SEFF_BEHAVIOUR_STUB = eINSTANCE.getSeffBehaviourStub();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.behaviour.impl.GastBehaviourStubImpl <em>Gast Behaviour Stub</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.behaviour.impl.GastBehaviourStubImpl
		 * @see eu.qimpress.samm.behaviour.impl.BehaviourPackageImpl#getGastBehaviourStub()
		 * @generated
		 */
		EClass GAST_BEHAVIOUR_STUB = eINSTANCE.getGastBehaviourStub();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.behaviour.impl.TBPBehaviourStubImpl <em>TBP Behaviour Stub</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.behaviour.impl.TBPBehaviourStubImpl
		 * @see eu.qimpress.samm.behaviour.impl.BehaviourPackageImpl#getTBPBehaviourStub()
		 * @generated
		 */
		EClass TBP_BEHAVIOUR_STUB = eINSTANCE.getTBPBehaviourStub();

		/**
		 * The meta object literal for the '{@link eu.qimpress.samm.behaviour.impl.OperationBehaviourImpl <em>Operation Behaviour</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.samm.behaviour.impl.OperationBehaviourImpl
		 * @see eu.qimpress.samm.behaviour.impl.BehaviourPackageImpl#getOperationBehaviour()
		 * @generated
		 */
		EClass OPERATION_BEHAVIOUR = eINSTANCE.getOperationBehaviour();

		/**
		 * The meta object literal for the '<em><b>Operation</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference OPERATION_BEHAVIOUR__OPERATION = eINSTANCE.getOperationBehaviour_Operation();

	}

} //BehaviourPackage
