/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.staticstructure.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import eu.qimpress.samm.staticstructure.util.StaticstructureAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class StaticstructureItemProviderAdapterFactory extends StaticstructureAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public StaticstructureItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.staticstructure.PassiveResource} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PassiveResourceItemProvider passiveResourceItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.staticstructure.PassiveResource}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPassiveResourceAdapter() {
		if (passiveResourceItemProvider == null) {
			passiveResourceItemProvider = new PassiveResourceItemProvider(this);
		}

		return passiveResourceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.staticstructure.ServiceArchitectureModel} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ServiceArchitectureModelItemProvider serviceArchitectureModelItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.staticstructure.ServiceArchitectureModel}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createServiceArchitectureModelAdapter() {
		if (serviceArchitectureModelItemProvider == null) {
			serviceArchitectureModelItemProvider = new ServiceArchitectureModelItemProvider(this);
		}

		return serviceArchitectureModelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.staticstructure.SubcomponentInstance} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SubcomponentInstanceItemProvider subcomponentInstanceItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.staticstructure.SubcomponentInstance}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSubcomponentInstanceAdapter() {
		if (subcomponentInstanceItemProvider == null) {
			subcomponentInstanceItemProvider = new SubcomponentInstanceItemProvider(this);
		}

		return subcomponentInstanceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.staticstructure.InterfacePort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InterfacePortItemProvider interfacePortItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.staticstructure.InterfacePort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInterfacePortAdapter() {
		if (interfacePortItemProvider == null) {
			interfacePortItemProvider = new InterfacePortItemProvider(this);
		}

		return interfacePortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.staticstructure.Interface} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InterfaceItemProvider interfaceItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.staticstructure.Interface}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInterfaceAdapter() {
		if (interfaceItemProvider == null) {
			interfaceItemProvider = new InterfaceItemProvider(this);
		}

		return interfaceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.staticstructure.Operation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OperationItemProvider operationItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.staticstructure.Operation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOperationAdapter() {
		if (operationItemProvider == null) {
			operationItemProvider = new OperationItemProvider(this);
		}

		return operationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.staticstructure.MessageType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MessageTypeItemProvider messageTypeItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.staticstructure.MessageType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMessageTypeAdapter() {
		if (messageTypeItemProvider == null) {
			messageTypeItemProvider = new MessageTypeItemProvider(this);
		}

		return messageTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.staticstructure.Parameter} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ParameterItemProvider parameterItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.staticstructure.Parameter}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createParameterAdapter() {
		if (parameterItemProvider == null) {
			parameterItemProvider = new ParameterItemProvider(this);
		}

		return parameterItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.staticstructure.OperationException} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected OperationExceptionItemProvider operationExceptionItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.staticstructure.OperationException}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createOperationExceptionAdapter() {
		if (operationExceptionItemProvider == null) {
			operationExceptionItemProvider = new OperationExceptionItemProvider(this);
		}

		return operationExceptionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.staticstructure.EventPort} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EventPortItemProvider eventPortItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.staticstructure.EventPort}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEventPortAdapter() {
		if (eventPortItemProvider == null) {
			eventPortItemProvider = new EventPortItemProvider(this);
		}

		return eventPortItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.staticstructure.Connector} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ConnectorItemProvider connectorItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.staticstructure.Connector}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createConnectorAdapter() {
		if (connectorItemProvider == null) {
			connectorItemProvider = new ConnectorItemProvider(this);
		}

		return connectorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.staticstructure.SubcomponentEndpoint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SubcomponentEndpointItemProvider subcomponentEndpointItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.staticstructure.SubcomponentEndpoint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSubcomponentEndpointAdapter() {
		if (subcomponentEndpointItemProvider == null) {
			subcomponentEndpointItemProvider = new SubcomponentEndpointItemProvider(this);
		}

		return subcomponentEndpointItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.staticstructure.Repository} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RepositoryItemProvider repositoryItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.staticstructure.Repository}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRepositoryAdapter() {
		if (repositoryItemProvider == null) {
			repositoryItemProvider = new RepositoryItemProvider(this);
		}

		return repositoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.staticstructure.ComponentEndpoint} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComponentEndpointItemProvider componentEndpointItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.staticstructure.ComponentEndpoint}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createComponentEndpointAdapter() {
		if (componentEndpointItemProvider == null) {
			componentEndpointItemProvider = new ComponentEndpointItemProvider(this);
		}

		return componentEndpointItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.staticstructure.CompositeComponent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CompositeComponentItemProvider compositeComponentItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.staticstructure.CompositeComponent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCompositeComponentAdapter() {
		if (compositeComponentItemProvider == null) {
			compositeComponentItemProvider = new CompositeComponentItemProvider(this);
		}

		return compositeComponentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.staticstructure.PrimitiveComponent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PrimitiveComponentItemProvider primitiveComponentItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.staticstructure.PrimitiveComponent}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPrimitiveComponentAdapter() {
		if (primitiveComponentItemProvider == null) {
			primitiveComponentItemProvider = new PrimitiveComponentItemProvider(this);
		}

		return primitiveComponentItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (passiveResourceItemProvider != null) passiveResourceItemProvider.dispose();
		if (serviceArchitectureModelItemProvider != null) serviceArchitectureModelItemProvider.dispose();
		if (subcomponentInstanceItemProvider != null) subcomponentInstanceItemProvider.dispose();
		if (interfacePortItemProvider != null) interfacePortItemProvider.dispose();
		if (interfaceItemProvider != null) interfaceItemProvider.dispose();
		if (operationItemProvider != null) operationItemProvider.dispose();
		if (messageTypeItemProvider != null) messageTypeItemProvider.dispose();
		if (parameterItemProvider != null) parameterItemProvider.dispose();
		if (operationExceptionItemProvider != null) operationExceptionItemProvider.dispose();
		if (eventPortItemProvider != null) eventPortItemProvider.dispose();
		if (connectorItemProvider != null) connectorItemProvider.dispose();
		if (subcomponentEndpointItemProvider != null) subcomponentEndpointItemProvider.dispose();
		if (repositoryItemProvider != null) repositoryItemProvider.dispose();
		if (componentEndpointItemProvider != null) componentEndpointItemProvider.dispose();
		if (compositeComponentItemProvider != null) compositeComponentItemProvider.dispose();
		if (primitiveComponentItemProvider != null) primitiveComponentItemProvider.dispose();
	}

}
