/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import eu.qimpress.samm.deployment.targetenvironment.util.TargetenvironmentAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class TargetenvironmentItemProviderAdapterFactory extends TargetenvironmentAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TargetenvironmentItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.targetenvironment.NetworkElement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NetworkElementItemProvider networkElementItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.targetenvironment.NetworkElement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNetworkElementAdapter() {
		if (networkElementItemProvider == null) {
			networkElementItemProvider = new NetworkElementItemProvider(this);
		}

		return networkElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.targetenvironment.NetworkInterface} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NetworkInterfaceItemProvider networkInterfaceItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.targetenvironment.NetworkInterface}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNetworkInterfaceAdapter() {
		if (networkInterfaceItemProvider == null) {
			networkInterfaceItemProvider = new NetworkInterfaceItemProvider(this);
		}

		return networkInterfaceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.targetenvironment.Node} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NodeItemProvider nodeItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.targetenvironment.Node}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNodeAdapter() {
		if (nodeItemProvider == null) {
			nodeItemProvider = new NodeItemProvider(this);
		}

		return nodeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.targetenvironment.Container} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ContainerItemProvider containerItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.targetenvironment.Container}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createContainerAdapter() {
		if (containerItemProvider == null) {
			containerItemProvider = new ContainerItemProvider(this);
		}

		return containerItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.targetenvironment.StorageResource} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StorageResourceItemProvider storageResourceItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.targetenvironment.StorageResource}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStorageResourceAdapter() {
		if (storageResourceItemProvider == null) {
			storageResourceItemProvider = new StorageResourceItemProvider(this);
		}

		return storageResourceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.targetenvironment.StorageDevice} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StorageDeviceItemProvider storageDeviceItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.targetenvironment.StorageDevice}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStorageDeviceAdapter() {
		if (storageDeviceItemProvider == null) {
			storageDeviceItemProvider = new StorageDeviceItemProvider(this);
		}

		return storageDeviceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.targetenvironment.MemoryResource} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MemoryResourceItemProvider memoryResourceItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.targetenvironment.MemoryResource}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMemoryResourceAdapter() {
		if (memoryResourceItemProvider == null) {
			memoryResourceItemProvider = new MemoryResourceItemProvider(this);
		}

		return memoryResourceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.targetenvironment.Memory} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MemoryItemProvider memoryItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.targetenvironment.Memory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMemoryAdapter() {
		if (memoryItemProvider == null) {
			memoryItemProvider = new MemoryItemProvider(this);
		}

		return memoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.targetenvironment.ExecutionResource} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExecutionResourceItemProvider executionResourceItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.targetenvironment.ExecutionResource}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createExecutionResourceAdapter() {
		if (executionResourceItemProvider == null) {
			executionResourceItemProvider = new ExecutionResourceItemProvider(this);
		}

		return executionResourceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.targetenvironment.Processor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessorItemProvider processorItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.targetenvironment.Processor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessorAdapter() {
		if (processorItemProvider == null) {
			processorItemProvider = new ProcessorItemProvider(this);
		}

		return processorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.targetenvironment.NetworkResource} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NetworkResourceItemProvider networkResourceItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.targetenvironment.NetworkResource}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNetworkResourceAdapter() {
		if (networkResourceItemProvider == null) {
			networkResourceItemProvider = new NetworkResourceItemProvider(this);
		}

		return networkResourceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.targetenvironment.TargetEnvironment} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TargetEnvironmentItemProvider targetEnvironmentItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.targetenvironment.TargetEnvironment}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTargetEnvironmentAdapter() {
		if (targetEnvironmentItemProvider == null) {
			targetEnvironmentItemProvider = new TargetEnvironmentItemProvider(this);
		}

		return targetEnvironmentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected SoftwarePerformanceProfileItemProvider softwarePerformanceProfileItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSoftwarePerformanceProfileAdapter() {
		if (softwarePerformanceProfileItemProvider == null) {
			softwarePerformanceProfileItemProvider = new SoftwarePerformanceProfileItemProvider(this);
		}

		return softwarePerformanceProfileItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.targetenvironment.FileSystemPerformanceProfile} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FileSystemPerformanceProfileItemProvider fileSystemPerformanceProfileItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.targetenvironment.FileSystemPerformanceProfile}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFileSystemPerformanceProfileAdapter() {
		if (fileSystemPerformanceProfileItemProvider == null) {
			fileSystemPerformanceProfileItemProvider = new FileSystemPerformanceProfileItemProvider(this);
		}

		return fileSystemPerformanceProfileItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (networkElementItemProvider != null) networkElementItemProvider.dispose();
		if (networkInterfaceItemProvider != null) networkInterfaceItemProvider.dispose();
		if (nodeItemProvider != null) nodeItemProvider.dispose();
		if (containerItemProvider != null) containerItemProvider.dispose();
		if (storageResourceItemProvider != null) storageResourceItemProvider.dispose();
		if (storageDeviceItemProvider != null) storageDeviceItemProvider.dispose();
		if (memoryResourceItemProvider != null) memoryResourceItemProvider.dispose();
		if (memoryItemProvider != null) memoryItemProvider.dispose();
		if (executionResourceItemProvider != null) executionResourceItemProvider.dispose();
		if (processorItemProvider != null) processorItemProvider.dispose();
		if (networkResourceItemProvider != null) networkResourceItemProvider.dispose();
		if (targetEnvironmentItemProvider != null) targetEnvironmentItemProvider.dispose();
		if (softwarePerformanceProfileItemProvider != null) softwarePerformanceProfileItemProvider.dispose();
		if (fileSystemPerformanceProfileItemProvider != null) fileSystemPerformanceProfileItemProvider.dispose();
	}

}
