/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.targetenvironment.provider;


import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

import eu.qimpress.samm.annotation.provider.AnnotationItemProvider;
import eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile;
import eu.qimpress.samm.deployment.targetenvironment.TargetenvironmentPackage;
import eu.qimpress.samm.staticstructure.provider.SammEditPlugin;

/**
 * This is the item provider adapter for a {@link eu.qimpress.samm.deployment.targetenvironment.SoftwarePerformanceProfile} object.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class SoftwarePerformanceProfileItemProvider
	extends AnnotationItemProvider
	implements
		IEditingDomainItemProvider,
		IStructuredItemContentProvider,
		ITreeItemContentProvider,
		IItemLabelProvider,
		IItemPropertySource {
	/**
	 * This constructs an instance from a factory and a notifier.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SoftwarePerformanceProfileItemProvider(AdapterFactory adapterFactory) {
		super(adapterFactory);
	}

	/**
	 * This returns the property descriptors for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
		if (itemPropertyDescriptors == null) {
			super.getPropertyDescriptors(object);

			addSoftwareKindPropertyDescriptor(object);
			addClocksPerInstructionAveragePropertyDescriptor(object);
			addClocksPerInstructionDistributionPropertyDescriptor(object);
			addTlbMissProbabilityPropertyDescriptor(object);
			addProcessorPropertyDescriptor(object);
		}
		return itemPropertyDescriptors;
	}

	/**
	 * This adds a property descriptor for the Software Kind feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addSoftwareKindPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_SoftwarePerformanceProfile_softwareKind_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_SoftwarePerformanceProfile_softwareKind_feature", "_UI_SoftwarePerformanceProfile_type"),
				 TargetenvironmentPackage.Literals.SOFTWARE_PERFORMANCE_PROFILE__SOFTWARE_KIND,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Clocks Per Instruction Average feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addClocksPerInstructionAveragePropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_SoftwarePerformanceProfile_clocksPerInstructionAverage_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_SoftwarePerformanceProfile_clocksPerInstructionAverage_feature", "_UI_SoftwarePerformanceProfile_type"),
				 TargetenvironmentPackage.Literals.SOFTWARE_PERFORMANCE_PROFILE__CLOCKS_PER_INSTRUCTION_AVERAGE,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.REAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Clocks Per Instruction Distribution feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addClocksPerInstructionDistributionPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_SoftwarePerformanceProfile_clocksPerInstructionDistribution_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_SoftwarePerformanceProfile_clocksPerInstructionDistribution_feature", "_UI_SoftwarePerformanceProfile_type"),
				 TargetenvironmentPackage.Literals.SOFTWARE_PERFORMANCE_PROFILE__CLOCKS_PER_INSTRUCTION_DISTRIBUTION,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.GENERIC_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Tlb Miss Probability feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addTlbMissProbabilityPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_SoftwarePerformanceProfile_tlbMissProbability_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_SoftwarePerformanceProfile_tlbMissProbability_feature", "_UI_SoftwarePerformanceProfile_type"),
				 TargetenvironmentPackage.Literals.SOFTWARE_PERFORMANCE_PROFILE__TLB_MISS_PROBABILITY,
				 true,
				 false,
				 false,
				 ItemPropertyDescriptor.REAL_VALUE_IMAGE,
				 null,
				 null));
	}

	/**
	 * This adds a property descriptor for the Processor feature.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected void addProcessorPropertyDescriptor(Object object) {
		itemPropertyDescriptors.add
			(createItemPropertyDescriptor
				(((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory(),
				 getResourceLocator(),
				 getString("_UI_SoftwarePerformanceProfile_processor_feature"),
				 getString("_UI_PropertyDescriptor_description", "_UI_SoftwarePerformanceProfile_processor_feature", "_UI_SoftwarePerformanceProfile_type"),
				 TargetenvironmentPackage.Literals.SOFTWARE_PERFORMANCE_PROFILE__PROCESSOR,
				 true,
				 false,
				 true,
				 null,
				 null,
				 null));
	}

	/**
	 * This returns SoftwarePerformanceProfile.gif.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object getImage(Object object) {
		return overlayImage(object, getResourceLocator().getImage("full/obj16/SoftwarePerformanceProfile"));
	}

	/**
	 * This returns the label text for the adapted class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getText(Object object) {
		String label = ((SoftwarePerformanceProfile)object).getSoftwareKind();
		return label == null || label.length() == 0 ?
			getString("_UI_SoftwarePerformanceProfile_type") :
			getString("_UI_SoftwarePerformanceProfile_type") + " " + label;
	}

	/**
	 * This handles model notifications by calling {@link #updateChildren} to update any cached
	 * children and by creating a viewer notification, which it passes to {@link #fireNotifyChanged}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void notifyChanged(Notification notification) {
		updateChildren(notification);

		switch (notification.getFeatureID(SoftwarePerformanceProfile.class)) {
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__SOFTWARE_KIND:
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__CLOCKS_PER_INSTRUCTION_AVERAGE:
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__CLOCKS_PER_INSTRUCTION_DISTRIBUTION:
			case TargetenvironmentPackage.SOFTWARE_PERFORMANCE_PROFILE__TLB_MISS_PROBABILITY:
				fireNotifyChanged(new ViewerNotification(notification, notification.getNotifier(), false, true));
				return;
		}
		super.notifyChanged(notification);
	}

	/**
	 * This adds {@link org.eclipse.emf.edit.command.CommandParameter}s describing the children
	 * that can be created under this object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
		super.collectNewChildDescriptors(newChildDescriptors, object);
	}

	/**
	 * Return the resource locator for this item provider's resources.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		return SammEditPlugin.INSTANCE;
	}

}
