/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.samm.deployment.hardware.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import eu.qimpress.samm.deployment.hardware.util.HardwareAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class HardwareItemProviderAdapterFactory extends HardwareAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public HardwareItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.hardware.NetworkElementDescriptor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NetworkElementDescriptorItemProvider networkElementDescriptorItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.hardware.NetworkElementDescriptor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNetworkElementDescriptorAdapter() {
		if (networkElementDescriptorItemProvider == null) {
			networkElementDescriptorItemProvider = new NetworkElementDescriptorItemProvider(this);
		}

		return networkElementDescriptorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.hardware.TLB} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TLBItemProvider tlbItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.hardware.TLB}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTLBAdapter() {
		if (tlbItemProvider == null) {
			tlbItemProvider = new TLBItemProvider(this);
		}

		return tlbItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.hardware.ProcessorCore} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessorCoreItemProvider processorCoreItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.hardware.ProcessorCore}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessorCoreAdapter() {
		if (processorCoreItemProvider == null) {
			processorCoreItemProvider = new ProcessorCoreItemProvider(this);
		}

		return processorCoreItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.hardware.Cache} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CacheItemProvider cacheItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.hardware.Cache}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCacheAdapter() {
		if (cacheItemProvider == null) {
			cacheItemProvider = new CacheItemProvider(this);
		}

		return cacheItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.hardware.ProcessorDescriptor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ProcessorDescriptorItemProvider processorDescriptorItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.hardware.ProcessorDescriptor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createProcessorDescriptorAdapter() {
		if (processorDescriptorItemProvider == null) {
			processorDescriptorItemProvider = new ProcessorDescriptorItemProvider(this);
		}

		return processorDescriptorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StorageDeviceDescriptorItemProvider storageDeviceDescriptorItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.hardware.StorageDeviceDescriptor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStorageDeviceDescriptorAdapter() {
		if (storageDeviceDescriptorItemProvider == null) {
			storageDeviceDescriptorItemProvider = new StorageDeviceDescriptorItemProvider(this);
		}

		return storageDeviceDescriptorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.hardware.MemoryDescriptor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MemoryDescriptorItemProvider memoryDescriptorItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.hardware.MemoryDescriptor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMemoryDescriptorAdapter() {
		if (memoryDescriptorItemProvider == null) {
			memoryDescriptorItemProvider = new MemoryDescriptorItemProvider(this);
		}

		return memoryDescriptorItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.hardware.HardwareDescriptorRepository} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HardwareDescriptorRepositoryItemProvider hardwareDescriptorRepositoryItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.hardware.HardwareDescriptorRepository}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHardwareDescriptorRepositoryAdapter() {
		if (hardwareDescriptorRepositoryItemProvider == null) {
			hardwareDescriptorRepositoryItemProvider = new HardwareDescriptorRepositoryItemProvider(this);
		}

		return hardwareDescriptorRepositoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.samm.deployment.hardware.NetworkInterfaceDescriptor} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected NetworkInterfaceDescriptorItemProvider networkInterfaceDescriptorItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.samm.deployment.hardware.NetworkInterfaceDescriptor}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createNetworkInterfaceDescriptorAdapter() {
		if (networkInterfaceDescriptorItemProvider == null) {
			networkInterfaceDescriptorItemProvider = new NetworkInterfaceDescriptorItemProvider(this);
		}

		return networkInterfaceDescriptorItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (networkElementDescriptorItemProvider != null) networkElementDescriptorItemProvider.dispose();
		if (tlbItemProvider != null) tlbItemProvider.dispose();
		if (processorCoreItemProvider != null) processorCoreItemProvider.dispose();
		if (cacheItemProvider != null) cacheItemProvider.dispose();
		if (processorDescriptorItemProvider != null) processorDescriptorItemProvider.dispose();
		if (storageDeviceDescriptorItemProvider != null) storageDeviceDescriptorItemProvider.dispose();
		if (memoryDescriptorItemProvider != null) memoryDescriptorItemProvider.dispose();
		if (hardwareDescriptorRepositoryItemProvider != null) hardwareDescriptorRepositoryItemProvider.dispose();
		if (networkInterfaceDescriptorItemProvider != null) networkInterfaceDescriptorItemProvider.dispose();
	}

}
