/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.resultmodel.util;

import eu.qimpress.identifier.Identifier;

import eu.qimpress.resultmodel.*;

import eu.qimpress.samm.core.Entity;
import eu.qimpress.samm.core.NamedEntity;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see eu.qimpress.resultmodel.ResultModelPackage
 * @generated
 */
public class ResultModelSwitch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static ResultModelPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResultModelSwitch() {
		if (modelPackage == null) {
			modelPackage = ResultModelPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public T doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List<EClass> eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case ResultModelPackage.RESULT_REPOSITORY: {
				ResultRepository resultRepository = (ResultRepository)theEObject;
				T result = caseResultRepository(resultRepository);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ResultModelPackage.ALTERNATIVE_EVALUATION: {
				AlternativeEvaluation alternativeEvaluation = (AlternativeEvaluation)theEObject;
				T result = caseAlternativeEvaluation(alternativeEvaluation);
				if (result == null) result = caseNamedEntity(alternativeEvaluation);
				if (result == null) result = caseEntity(alternativeEvaluation);
				if (result == null) result = caseIdentifier(alternativeEvaluation);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ResultModelPackage.ANALYSIS_RESULT: {
				AnalysisResult analysisResult = (AnalysisResult)theEObject;
				T result = caseAnalysisResult(analysisResult);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ResultModelPackage.PERFORMANCE_PREDICTION_RESULT: {
				PerformancePredictionResult performancePredictionResult = (PerformancePredictionResult)theEObject;
				T result = casePerformancePredictionResult(performancePredictionResult);
				if (result == null) result = caseAnalysisResult(performancePredictionResult);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ResultModelPackage.RESPONSE_TIME: {
				ResponseTime responseTime = (ResponseTime)theEObject;
				T result = caseResponseTime(responseTime);
				if (result == null) result = caseResultObject(responseTime);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ResultModelPackage.RESULT_OBJECT: {
				ResultObject resultObject = (ResultObject)theEObject;
				T result = caseResultObject(resultObject);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ResultModelPackage.RESULT_DISTRIBUTION: {
				ResultDistribution resultDistribution = (ResultDistribution)theEObject;
				T result = caseResultDistribution(resultDistribution);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ResultModelPackage.CPU_RESOURCE_UTILIZATION: {
				CpuResourceUtilization cpuResourceUtilization = (CpuResourceUtilization)theEObject;
				T result = caseCpuResourceUtilization(cpuResourceUtilization);
				if (result == null) result = caseResultObject(cpuResourceUtilization);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ResultModelPackage.HDD_RESOURCE_UTILIZATION: {
				HddResourceUtilization hddResourceUtilization = (HddResourceUtilization)theEObject;
				T result = caseHddResourceUtilization(hddResourceUtilization);
				if (result == null) result = caseResultObject(hddResourceUtilization);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ResultModelPackage.THROUGHPUT: {
				Throughput throughput = (Throughput)theEObject;
				T result = caseThroughput(throughput);
				if (result == null) result = caseResultObject(throughput);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ResultModelPackage.RELIABILITY_PREDICTION_RESULT: {
				ReliabilityPredictionResult reliabilityPredictionResult = (ReliabilityPredictionResult)theEObject;
				T result = caseReliabilityPredictionResult(reliabilityPredictionResult);
				if (result == null) result = caseAnalysisResult(reliabilityPredictionResult);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ResultModelPackage.RELIABILITY: {
				Reliability reliability = (Reliability)theEObject;
				T result = caseReliability(reliability);
				if (result == null) result = caseResultObject(reliability);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case ResultModelPackage.MAINTAINABILITY_PREDICTION_RESULT: {
				MaintainabilityPredictionResult maintainabilityPredictionResult = (MaintainabilityPredictionResult)theEObject;
				T result = caseMaintainabilityPredictionResult(maintainabilityPredictionResult);
				if (result == null) result = caseAnalysisResult(maintainabilityPredictionResult);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Result Repository</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Result Repository</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseResultRepository(ResultRepository object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Alternative Evaluation</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Alternative Evaluation</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAlternativeEvaluation(AlternativeEvaluation object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Analysis Result</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Analysis Result</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseAnalysisResult(AnalysisResult object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Performance Prediction Result</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Performance Prediction Result</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T casePerformancePredictionResult(PerformancePredictionResult object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Response Time</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Response Time</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseResponseTime(ResponseTime object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Result Object</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Result Object</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseResultObject(ResultObject object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Result Distribution</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Result Distribution</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseResultDistribution(ResultDistribution object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Cpu Resource Utilization</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Cpu Resource Utilization</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseCpuResourceUtilization(CpuResourceUtilization object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Hdd Resource Utilization</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Hdd Resource Utilization</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseHddResourceUtilization(HddResourceUtilization object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Throughput</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Throughput</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseThroughput(Throughput object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Reliability Prediction Result</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Reliability Prediction Result</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReliabilityPredictionResult(ReliabilityPredictionResult object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Reliability</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Reliability</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReliability(Reliability object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Maintainability Prediction Result</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Maintainability Prediction Result</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMaintainabilityPredictionResult(MaintainabilityPredictionResult object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Identifier</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Identifier</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIdentifier(Identifier object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Entity</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Entity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseEntity(Entity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Named Entity</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Named Entity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNamedEntity(NamedEntity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(EObject object) {
		return null;
	}

} //ResultModelSwitch
