/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.resultmodel.util;

import eu.qimpress.identifier.Identifier;

import eu.qimpress.resultmodel.*;

import eu.qimpress.samm.core.Entity;
import eu.qimpress.samm.core.NamedEntity;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see eu.qimpress.resultmodel.ResultModelPackage
 * @generated
 */
public class ResultModelAdapterFactory extends AdapterFactoryImpl {
	/**
	 * The cached model package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static ResultModelPackage modelPackage;

	/**
	 * Creates an instance of the adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResultModelAdapterFactory() {
		if (modelPackage == null) {
			modelPackage = ResultModelPackage.eINSTANCE;
		}
	}

	/**
	 * Returns whether this factory is applicable for the type of the object.
	 * <!-- begin-user-doc -->
	 * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
	 * <!-- end-user-doc -->
	 * @return whether this factory is applicable for the type of the object.
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object object) {
		if (object == modelPackage) {
			return true;
		}
		if (object instanceof EObject) {
			return ((EObject)object).eClass().getEPackage() == modelPackage;
		}
		return false;
	}

	/**
	 * The switch that delegates to the <code>createXXX</code> methods.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResultModelSwitch<Adapter> modelSwitch =
		new ResultModelSwitch<Adapter>() {
			@Override
			public Adapter caseResultRepository(ResultRepository object) {
				return createResultRepositoryAdapter();
			}
			@Override
			public Adapter caseAlternativeEvaluation(AlternativeEvaluation object) {
				return createAlternativeEvaluationAdapter();
			}
			@Override
			public Adapter caseAnalysisResult(AnalysisResult object) {
				return createAnalysisResultAdapter();
			}
			@Override
			public Adapter casePerformancePredictionResult(PerformancePredictionResult object) {
				return createPerformancePredictionResultAdapter();
			}
			@Override
			public Adapter caseResponseTime(ResponseTime object) {
				return createResponseTimeAdapter();
			}
			@Override
			public Adapter caseResultObject(ResultObject object) {
				return createResultObjectAdapter();
			}
			@Override
			public Adapter caseResultDistribution(ResultDistribution object) {
				return createResultDistributionAdapter();
			}
			@Override
			public Adapter caseCpuResourceUtilization(CpuResourceUtilization object) {
				return createCpuResourceUtilizationAdapter();
			}
			@Override
			public Adapter caseHddResourceUtilization(HddResourceUtilization object) {
				return createHddResourceUtilizationAdapter();
			}
			@Override
			public Adapter caseThroughput(Throughput object) {
				return createThroughputAdapter();
			}
			@Override
			public Adapter caseReliabilityPredictionResult(ReliabilityPredictionResult object) {
				return createReliabilityPredictionResultAdapter();
			}
			@Override
			public Adapter caseReliability(Reliability object) {
				return createReliabilityAdapter();
			}
			@Override
			public Adapter caseMaintainabilityPredictionResult(MaintainabilityPredictionResult object) {
				return createMaintainabilityPredictionResultAdapter();
			}
			@Override
			public Adapter caseIdentifier(Identifier object) {
				return createIdentifierAdapter();
			}
			@Override
			public Adapter caseEntity(Entity object) {
				return createEntityAdapter();
			}
			@Override
			public Adapter caseNamedEntity(NamedEntity object) {
				return createNamedEntityAdapter();
			}
			@Override
			public Adapter defaultCase(EObject object) {
				return createEObjectAdapter();
			}
		};

	/**
	 * Creates an adapter for the <code>target</code>.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param target the object to adapt.
	 * @return the adapter for the <code>target</code>.
	 * @generated
	 */
	@Override
	public Adapter createAdapter(Notifier target) {
		return modelSwitch.doSwitch((EObject)target);
	}


	/**
	 * Creates a new adapter for an object of class '{@link eu.qimpress.resultmodel.ResultRepository <em>Result Repository</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see eu.qimpress.resultmodel.ResultRepository
	 * @generated
	 */
	public Adapter createResultRepositoryAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link eu.qimpress.resultmodel.AlternativeEvaluation <em>Alternative Evaluation</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see eu.qimpress.resultmodel.AlternativeEvaluation
	 * @generated
	 */
	public Adapter createAlternativeEvaluationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link eu.qimpress.resultmodel.AnalysisResult <em>Analysis Result</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see eu.qimpress.resultmodel.AnalysisResult
	 * @generated
	 */
	public Adapter createAnalysisResultAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link eu.qimpress.resultmodel.PerformancePredictionResult <em>Performance Prediction Result</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see eu.qimpress.resultmodel.PerformancePredictionResult
	 * @generated
	 */
	public Adapter createPerformancePredictionResultAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link eu.qimpress.resultmodel.ResponseTime <em>Response Time</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see eu.qimpress.resultmodel.ResponseTime
	 * @generated
	 */
	public Adapter createResponseTimeAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link eu.qimpress.resultmodel.ResultObject <em>Result Object</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see eu.qimpress.resultmodel.ResultObject
	 * @generated
	 */
	public Adapter createResultObjectAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link eu.qimpress.resultmodel.ResultDistribution <em>Result Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see eu.qimpress.resultmodel.ResultDistribution
	 * @generated
	 */
	public Adapter createResultDistributionAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link eu.qimpress.resultmodel.CpuResourceUtilization <em>Cpu Resource Utilization</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see eu.qimpress.resultmodel.CpuResourceUtilization
	 * @generated
	 */
	public Adapter createCpuResourceUtilizationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link eu.qimpress.resultmodel.HddResourceUtilization <em>Hdd Resource Utilization</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see eu.qimpress.resultmodel.HddResourceUtilization
	 * @generated
	 */
	public Adapter createHddResourceUtilizationAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link eu.qimpress.resultmodel.Throughput <em>Throughput</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see eu.qimpress.resultmodel.Throughput
	 * @generated
	 */
	public Adapter createThroughputAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link eu.qimpress.resultmodel.ReliabilityPredictionResult <em>Reliability Prediction Result</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see eu.qimpress.resultmodel.ReliabilityPredictionResult
	 * @generated
	 */
	public Adapter createReliabilityPredictionResultAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link eu.qimpress.resultmodel.Reliability <em>Reliability</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see eu.qimpress.resultmodel.Reliability
	 * @generated
	 */
	public Adapter createReliabilityAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link eu.qimpress.resultmodel.MaintainabilityPredictionResult <em>Maintainability Prediction Result</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see eu.qimpress.resultmodel.MaintainabilityPredictionResult
	 * @generated
	 */
	public Adapter createMaintainabilityPredictionResultAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link eu.qimpress.identifier.Identifier <em>Identifier</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see eu.qimpress.identifier.Identifier
	 * @generated
	 */
	public Adapter createIdentifierAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link eu.qimpress.samm.core.Entity <em>Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see eu.qimpress.samm.core.Entity
	 * @generated
	 */
	public Adapter createEntityAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for an object of class '{@link eu.qimpress.samm.core.NamedEntity <em>Named Entity</em>}'.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null so that we can easily ignore cases;
	 * it's useful to ignore a case when inheritance will catch all the cases anyway.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @see eu.qimpress.samm.core.NamedEntity
	 * @generated
	 */
	public Adapter createNamedEntityAdapter() {
		return null;
	}

	/**
	 * Creates a new adapter for the default case.
	 * <!-- begin-user-doc -->
	 * This default implementation returns null.
	 * <!-- end-user-doc -->
	 * @return the new adapter.
	 * @generated
	 */
	public Adapter createEObjectAdapter() {
		return null;
	}

} //ResultModelAdapterFactory
