/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.resultmodel.impl;

import de.fzi.maintainabilitymodel.main.EffortAnalysisInstance;
import de.fzi.maintainabilitymodel.workplan.Task;

import eu.qimpress.resultmodel.MaintainabilityPredictionResult;
import eu.qimpress.resultmodel.ResultModelPackage;

import java.util.Collection;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;

import org.eclipse.emf.ecore.util.EObjectResolvingEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Maintainability Prediction Result</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link eu.qimpress.resultmodel.impl.MaintainabilityPredictionResultImpl#getAggregatedTimeEffort <em>Aggregated Time Effort</em>}</li>
 *   <li>{@link eu.qimpress.resultmodel.impl.MaintainabilityPredictionResultImpl#getEffortanalysisinstances <em>Effortanalysisinstances</em>}</li>
 *   <li>{@link eu.qimpress.resultmodel.impl.MaintainabilityPredictionResultImpl#getAggregatedCosts <em>Aggregated Costs</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class MaintainabilityPredictionResultImpl extends AnalysisResultImpl implements MaintainabilityPredictionResult {
	/**
	 * The default value of the '{@link #getAggregatedTimeEffort() <em>Aggregated Time Effort</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAggregatedTimeEffort()
	 * @generated
	 * @ordered
	 */
	protected static final double AGGREGATED_TIME_EFFORT_EDEFAULT = 0.0;

	/**
	 * The cached value of the '{@link #getEffortanalysisinstances() <em>Effortanalysisinstances</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getEffortanalysisinstances()
	 * @generated
	 * @ordered
	 */
	protected EList<EffortAnalysisInstance> effortanalysisinstances;

	/**
	 * The default value of the '{@link #getAggregatedCosts() <em>Aggregated Costs</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAggregatedCosts()
	 * @generated
	 * @ordered
	 */
	protected static final double AGGREGATED_COSTS_EDEFAULT = 0.0;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MaintainabilityPredictionResultImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ResultModelPackage.Literals.MAINTAINABILITY_PREDICTION_RESULT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public double getAggregatedTimeEffort() {
		double aggregatedTimeEffort = 0;
		
		for (EffortAnalysisInstance instance : this.getEffortanalysisinstances()) {
			if (instance.getWorkplan() != null)
			for (Task task : instance.getWorkplan().getTasks()) {
				aggregatedTimeEffort += task.getAggregatedTimeEstimate();
			}
		}
		
		return aggregatedTimeEffort;	
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setAggregatedTimeEffort(double newAggregatedTimeEffort) {
		// TODO: implement this method to set the 'Aggregated Time Effort' attribute
		// Ensure that you remove @generated or mark it @generated NOT
		//throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<EffortAnalysisInstance> getEffortanalysisinstances() {
		if (effortanalysisinstances == null) {
			effortanalysisinstances = new EObjectResolvingEList<EffortAnalysisInstance>(EffortAnalysisInstance.class, this, ResultModelPackage.MAINTAINABILITY_PREDICTION_RESULT__EFFORTANALYSISINSTANCES);
		}
		return effortanalysisinstances;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public double getAggregatedCosts() {
		double aggregatedCost = 0;
		
		for (EffortAnalysisInstance instance : this.getEffortanalysisinstances()) {
			if (instance.getWorkplan() != null)
			for (Task task : instance.getWorkplan().getTasks()) {
				aggregatedCost += task.getAggregatedCostEstimate();
			}
		    
		}
		
		return aggregatedCost;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setAggregatedCosts(double newAggregatedCosts) {
		//throw new UnsupportedOperationException();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ResultModelPackage.MAINTAINABILITY_PREDICTION_RESULT__AGGREGATED_TIME_EFFORT:
				return getAggregatedTimeEffort();
			case ResultModelPackage.MAINTAINABILITY_PREDICTION_RESULT__EFFORTANALYSISINSTANCES:
				return getEffortanalysisinstances();
			case ResultModelPackage.MAINTAINABILITY_PREDICTION_RESULT__AGGREGATED_COSTS:
				return getAggregatedCosts();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ResultModelPackage.MAINTAINABILITY_PREDICTION_RESULT__AGGREGATED_TIME_EFFORT:
				setAggregatedTimeEffort((Double)newValue);
				return;
			case ResultModelPackage.MAINTAINABILITY_PREDICTION_RESULT__EFFORTANALYSISINSTANCES:
				getEffortanalysisinstances().clear();
				getEffortanalysisinstances().addAll((Collection<? extends EffortAnalysisInstance>)newValue);
				return;
			case ResultModelPackage.MAINTAINABILITY_PREDICTION_RESULT__AGGREGATED_COSTS:
				setAggregatedCosts((Double)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ResultModelPackage.MAINTAINABILITY_PREDICTION_RESULT__AGGREGATED_TIME_EFFORT:
				setAggregatedTimeEffort(AGGREGATED_TIME_EFFORT_EDEFAULT);
				return;
			case ResultModelPackage.MAINTAINABILITY_PREDICTION_RESULT__EFFORTANALYSISINSTANCES:
				getEffortanalysisinstances().clear();
				return;
			case ResultModelPackage.MAINTAINABILITY_PREDICTION_RESULT__AGGREGATED_COSTS:
				setAggregatedCosts(AGGREGATED_COSTS_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ResultModelPackage.MAINTAINABILITY_PREDICTION_RESULT__AGGREGATED_TIME_EFFORT:
				return getAggregatedTimeEffort() != AGGREGATED_TIME_EFFORT_EDEFAULT;
			case ResultModelPackage.MAINTAINABILITY_PREDICTION_RESULT__EFFORTANALYSISINSTANCES:
				return effortanalysisinstances != null && !effortanalysisinstances.isEmpty();
			case ResultModelPackage.MAINTAINABILITY_PREDICTION_RESULT__AGGREGATED_COSTS:
				return getAggregatedCosts() != AGGREGATED_COSTS_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

} //MaintainabilityPredictionResultImpl
