/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.resultmodel.impl;

import eu.qimpress.resultmodel.AlternativeEvaluation;
import eu.qimpress.resultmodel.AnalysisResult;
import eu.qimpress.resultmodel.ResultModelPackage;

import eu.qimpress.samm.core.impl.NamedEntityImpl;

import eu.qimpress.samm.staticstructure.ServiceArchitectureModel;

import eu.qimpress.samm.usagemodel.UsageModel;

import java.util.Collection;
import java.util.Date;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Alternative Evaluation</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link eu.qimpress.resultmodel.impl.AlternativeEvaluationImpl#getRunDate <em>Run Date</em>}</li>
 *   <li>{@link eu.qimpress.resultmodel.impl.AlternativeEvaluationImpl#getAlternativeId <em>Alternative Id</em>}</li>
 *   <li>{@link eu.qimpress.resultmodel.impl.AlternativeEvaluationImpl#getServiceArchitectureModel <em>Service Architecture Model</em>}</li>
 *   <li>{@link eu.qimpress.resultmodel.impl.AlternativeEvaluationImpl#getAnalysisResults <em>Analysis Results</em>}</li>
 *   <li>{@link eu.qimpress.resultmodel.impl.AlternativeEvaluationImpl#getUsageModel <em>Usage Model</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class AlternativeEvaluationImpl extends NamedEntityImpl implements AlternativeEvaluation {
	/**
	 * The default value of the '{@link #getRunDate() <em>Run Date</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRunDate()
	 * @generated
	 * @ordered
	 */
	protected static final Date RUN_DATE_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getRunDate() <em>Run Date</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRunDate()
	 * @generated
	 * @ordered
	 */
	protected Date runDate = RUN_DATE_EDEFAULT;

	/**
	 * The default value of the '{@link #getAlternativeId() <em>Alternative Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAlternativeId()
	 * @generated
	 * @ordered
	 */
	protected static final String ALTERNATIVE_ID_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getAlternativeId() <em>Alternative Id</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAlternativeId()
	 * @generated
	 * @ordered
	 */
	protected String alternativeId = ALTERNATIVE_ID_EDEFAULT;

	/**
	 * The cached value of the '{@link #getServiceArchitectureModel() <em>Service Architecture Model</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getServiceArchitectureModel()
	 * @generated
	 * @ordered
	 */
	protected ServiceArchitectureModel serviceArchitectureModel;

	/**
	 * The cached value of the '{@link #getAnalysisResults() <em>Analysis Results</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAnalysisResults()
	 * @generated
	 * @ordered
	 */
	protected EList<AnalysisResult> analysisResults;

	/**
	 * The cached value of the '{@link #getUsageModel() <em>Usage Model</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getUsageModel()
	 * @generated
	 * @ordered
	 */
	protected UsageModel usageModel;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AlternativeEvaluationImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return ResultModelPackage.Literals.ALTERNATIVE_EVALUATION;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Date getRunDate() {
		return runDate;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setRunDate(Date newRunDate) {
		Date oldRunDate = runDate;
		runDate = newRunDate;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ResultModelPackage.ALTERNATIVE_EVALUATION__RUN_DATE, oldRunDate, runDate));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getAlternativeId() {
		return alternativeId;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAlternativeId(String newAlternativeId) {
		String oldAlternativeId = alternativeId;
		alternativeId = newAlternativeId;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ResultModelPackage.ALTERNATIVE_EVALUATION__ALTERNATIVE_ID, oldAlternativeId, alternativeId));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ServiceArchitectureModel getServiceArchitectureModel() {
		if (serviceArchitectureModel != null && serviceArchitectureModel.eIsProxy()) {
			InternalEObject oldServiceArchitectureModel = (InternalEObject)serviceArchitectureModel;
			serviceArchitectureModel = (ServiceArchitectureModel)eResolveProxy(oldServiceArchitectureModel);
			if (serviceArchitectureModel != oldServiceArchitectureModel) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ResultModelPackage.ALTERNATIVE_EVALUATION__SERVICE_ARCHITECTURE_MODEL, oldServiceArchitectureModel, serviceArchitectureModel));
			}
		}
		return serviceArchitectureModel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ServiceArchitectureModel basicGetServiceArchitectureModel() {
		return serviceArchitectureModel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setServiceArchitectureModel(ServiceArchitectureModel newServiceArchitectureModel) {
		ServiceArchitectureModel oldServiceArchitectureModel = serviceArchitectureModel;
		serviceArchitectureModel = newServiceArchitectureModel;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ResultModelPackage.ALTERNATIVE_EVALUATION__SERVICE_ARCHITECTURE_MODEL, oldServiceArchitectureModel, serviceArchitectureModel));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<AnalysisResult> getAnalysisResults() {
		if (analysisResults == null) {
			analysisResults = new EObjectContainmentEList<AnalysisResult>(AnalysisResult.class, this, ResultModelPackage.ALTERNATIVE_EVALUATION__ANALYSIS_RESULTS);
		}
		return analysisResults;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UsageModel getUsageModel() {
		if (usageModel != null && usageModel.eIsProxy()) {
			InternalEObject oldUsageModel = (InternalEObject)usageModel;
			usageModel = (UsageModel)eResolveProxy(oldUsageModel);
			if (usageModel != oldUsageModel) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, ResultModelPackage.ALTERNATIVE_EVALUATION__USAGE_MODEL, oldUsageModel, usageModel));
			}
		}
		return usageModel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public UsageModel basicGetUsageModel() {
		return usageModel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setUsageModel(UsageModel newUsageModel) {
		UsageModel oldUsageModel = usageModel;
		usageModel = newUsageModel;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, ResultModelPackage.ALTERNATIVE_EVALUATION__USAGE_MODEL, oldUsageModel, usageModel));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case ResultModelPackage.ALTERNATIVE_EVALUATION__ANALYSIS_RESULTS:
				return ((InternalEList<?>)getAnalysisResults()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case ResultModelPackage.ALTERNATIVE_EVALUATION__RUN_DATE:
				return getRunDate();
			case ResultModelPackage.ALTERNATIVE_EVALUATION__ALTERNATIVE_ID:
				return getAlternativeId();
			case ResultModelPackage.ALTERNATIVE_EVALUATION__SERVICE_ARCHITECTURE_MODEL:
				if (resolve) return getServiceArchitectureModel();
				return basicGetServiceArchitectureModel();
			case ResultModelPackage.ALTERNATIVE_EVALUATION__ANALYSIS_RESULTS:
				return getAnalysisResults();
			case ResultModelPackage.ALTERNATIVE_EVALUATION__USAGE_MODEL:
				if (resolve) return getUsageModel();
				return basicGetUsageModel();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case ResultModelPackage.ALTERNATIVE_EVALUATION__RUN_DATE:
				setRunDate((Date)newValue);
				return;
			case ResultModelPackage.ALTERNATIVE_EVALUATION__ALTERNATIVE_ID:
				setAlternativeId((String)newValue);
				return;
			case ResultModelPackage.ALTERNATIVE_EVALUATION__SERVICE_ARCHITECTURE_MODEL:
				setServiceArchitectureModel((ServiceArchitectureModel)newValue);
				return;
			case ResultModelPackage.ALTERNATIVE_EVALUATION__ANALYSIS_RESULTS:
				getAnalysisResults().clear();
				getAnalysisResults().addAll((Collection<? extends AnalysisResult>)newValue);
				return;
			case ResultModelPackage.ALTERNATIVE_EVALUATION__USAGE_MODEL:
				setUsageModel((UsageModel)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case ResultModelPackage.ALTERNATIVE_EVALUATION__RUN_DATE:
				setRunDate(RUN_DATE_EDEFAULT);
				return;
			case ResultModelPackage.ALTERNATIVE_EVALUATION__ALTERNATIVE_ID:
				setAlternativeId(ALTERNATIVE_ID_EDEFAULT);
				return;
			case ResultModelPackage.ALTERNATIVE_EVALUATION__SERVICE_ARCHITECTURE_MODEL:
				setServiceArchitectureModel((ServiceArchitectureModel)null);
				return;
			case ResultModelPackage.ALTERNATIVE_EVALUATION__ANALYSIS_RESULTS:
				getAnalysisResults().clear();
				return;
			case ResultModelPackage.ALTERNATIVE_EVALUATION__USAGE_MODEL:
				setUsageModel((UsageModel)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case ResultModelPackage.ALTERNATIVE_EVALUATION__RUN_DATE:
				return RUN_DATE_EDEFAULT == null ? runDate != null : !RUN_DATE_EDEFAULT.equals(runDate);
			case ResultModelPackage.ALTERNATIVE_EVALUATION__ALTERNATIVE_ID:
				return ALTERNATIVE_ID_EDEFAULT == null ? alternativeId != null : !ALTERNATIVE_ID_EDEFAULT.equals(alternativeId);
			case ResultModelPackage.ALTERNATIVE_EVALUATION__SERVICE_ARCHITECTURE_MODEL:
				return serviceArchitectureModel != null;
			case ResultModelPackage.ALTERNATIVE_EVALUATION__ANALYSIS_RESULTS:
				return analysisResults != null && !analysisResults.isEmpty();
			case ResultModelPackage.ALTERNATIVE_EVALUATION__USAGE_MODEL:
				return usageModel != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (runDate: ");
		result.append(runDate);
		result.append(", alternativeId: ");
		result.append(alternativeId);
		result.append(')');
		return result.toString();
	}

} //AlternativeEvaluationImpl
