/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.resultmodel;

import eu.qimpress.samm.core.CorePackage;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see eu.qimpress.resultmodel.ResultModelFactory
 * @model kind="package"
 * @generated
 */
public interface ResultModelPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "resultmodel";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://q-impress.eu/resultmodel";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "resultmodel";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ResultModelPackage eINSTANCE = eu.qimpress.resultmodel.impl.ResultModelPackageImpl.init();

	/**
	 * The meta object id for the '{@link eu.qimpress.resultmodel.impl.ResultRepositoryImpl <em>Result Repository</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.resultmodel.impl.ResultRepositoryImpl
	 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getResultRepository()
	 * @generated
	 */
	int RESULT_REPOSITORY = 0;

	/**
	 * The feature id for the '<em><b>Analysis Runs</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_REPOSITORY__ANALYSIS_RUNS = 0;

	/**
	 * The number of structural features of the '<em>Result Repository</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_REPOSITORY_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link eu.qimpress.resultmodel.impl.AlternativeEvaluationImpl <em>Alternative Evaluation</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.resultmodel.impl.AlternativeEvaluationImpl
	 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getAlternativeEvaluation()
	 * @generated
	 */
	int ALTERNATIVE_EVALUATION = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALTERNATIVE_EVALUATION__ID = CorePackage.NAMED_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Documentation</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALTERNATIVE_EVALUATION__DOCUMENTATION = CorePackage.NAMED_ENTITY__DOCUMENTATION;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALTERNATIVE_EVALUATION__NAME = CorePackage.NAMED_ENTITY__NAME;

	/**
	 * The feature id for the '<em><b>Run Date</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALTERNATIVE_EVALUATION__RUN_DATE = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Alternative Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALTERNATIVE_EVALUATION__ALTERNATIVE_ID = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Service Architecture Model</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALTERNATIVE_EVALUATION__SERVICE_ARCHITECTURE_MODEL = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Analysis Results</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALTERNATIVE_EVALUATION__ANALYSIS_RESULTS = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Usage Model</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALTERNATIVE_EVALUATION__USAGE_MODEL = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Alternative Evaluation</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ALTERNATIVE_EVALUATION_FEATURE_COUNT = CorePackage.NAMED_ENTITY_FEATURE_COUNT + 5;

	/**
	 * The meta object id for the '{@link eu.qimpress.resultmodel.impl.AnalysisResultImpl <em>Analysis Result</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.resultmodel.impl.AnalysisResultImpl
	 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getAnalysisResult()
	 * @generated
	 */
	int ANALYSIS_RESULT = 2;

	/**
	 * The number of structural features of the '<em>Analysis Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int ANALYSIS_RESULT_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link eu.qimpress.resultmodel.impl.PerformancePredictionResultImpl <em>Performance Prediction Result</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.resultmodel.impl.PerformancePredictionResultImpl
	 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getPerformancePredictionResult()
	 * @generated
	 */
	int PERFORMANCE_PREDICTION_RESULT = 3;

	/**
	 * The feature id for the '<em><b>Response Times</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERFORMANCE_PREDICTION_RESULT__RESPONSE_TIMES = ANALYSIS_RESULT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Resource Utilizations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERFORMANCE_PREDICTION_RESULT__RESOURCE_UTILIZATIONS = ANALYSIS_RESULT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Hdd Resource Utilizations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERFORMANCE_PREDICTION_RESULT__HDD_RESOURCE_UTILIZATIONS = ANALYSIS_RESULT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Throughputs</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERFORMANCE_PREDICTION_RESULT__THROUGHPUTS = ANALYSIS_RESULT_FEATURE_COUNT + 3;

	/**
	 * The number of structural features of the '<em>Performance Prediction Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PERFORMANCE_PREDICTION_RESULT_FEATURE_COUNT = ANALYSIS_RESULT_FEATURE_COUNT + 4;

	/**
	 * The meta object id for the '{@link eu.qimpress.resultmodel.impl.ResultObjectImpl <em>Result Object</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.resultmodel.impl.ResultObjectImpl
	 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getResultObject()
	 * @generated
	 */
	int RESULT_OBJECT = 5;

	/**
	 * The feature id for the '<em><b>Result Distribution</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_OBJECT__RESULT_DISTRIBUTION = 0;

	/**
	 * The number of structural features of the '<em>Result Object</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_OBJECT_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link eu.qimpress.resultmodel.impl.ResponseTimeImpl <em>Response Time</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.resultmodel.impl.ResponseTimeImpl
	 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getResponseTime()
	 * @generated
	 */
	int RESPONSE_TIME = 4;

	/**
	 * The feature id for the '<em><b>Result Distribution</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESPONSE_TIME__RESULT_DISTRIBUTION = RESULT_OBJECT__RESULT_DISTRIBUTION;

	/**
	 * The feature id for the '<em><b>Usage Scenario</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESPONSE_TIME__USAGE_SCENARIO = RESULT_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Response Time</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESPONSE_TIME_FEATURE_COUNT = RESULT_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link eu.qimpress.resultmodel.impl.ResultDistributionImpl <em>Result Distribution</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.resultmodel.impl.ResultDistributionImpl
	 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getResultDistribution()
	 * @generated
	 */
	int RESULT_DISTRIBUTION = 6;

	/**
	 * The feature id for the '<em><b>10 Percent Quantile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_DISTRIBUTION__10_PERCENT_QUANTILE = 0;

	/**
	 * The feature id for the '<em><b>90 Percent Quantile</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_DISTRIBUTION__90_PERCENT_QUANTILE = 1;

	/**
	 * The feature id for the '<em><b>Arithmetic Mean</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_DISTRIBUTION__ARITHMETIC_MEAN = 2;

	/**
	 * The feature id for the '<em><b>Median</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_DISTRIBUTION__MEDIAN = 3;

	/**
	 * The number of structural features of the '<em>Result Distribution</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RESULT_DISTRIBUTION_FEATURE_COUNT = 4;

	/**
	 * The meta object id for the '{@link eu.qimpress.resultmodel.impl.CpuResourceUtilizationImpl <em>Cpu Resource Utilization</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.resultmodel.impl.CpuResourceUtilizationImpl
	 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getCpuResourceUtilization()
	 * @generated
	 */
	int CPU_RESOURCE_UTILIZATION = 7;

	/**
	 * The feature id for the '<em><b>Result Distribution</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU_RESOURCE_UTILIZATION__RESULT_DISTRIBUTION = RESULT_OBJECT__RESULT_DISTRIBUTION;

	/**
	 * The feature id for the '<em><b>Execution Resource</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU_RESOURCE_UTILIZATION__EXECUTION_RESOURCE = RESULT_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Cpu Resource Utilization</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CPU_RESOURCE_UTILIZATION_FEATURE_COUNT = RESULT_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link eu.qimpress.resultmodel.impl.HddResourceUtilizationImpl <em>Hdd Resource Utilization</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.resultmodel.impl.HddResourceUtilizationImpl
	 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getHddResourceUtilization()
	 * @generated
	 */
	int HDD_RESOURCE_UTILIZATION = 8;

	/**
	 * The feature id for the '<em><b>Result Distribution</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HDD_RESOURCE_UTILIZATION__RESULT_DISTRIBUTION = RESULT_OBJECT__RESULT_DISTRIBUTION;

	/**
	 * The feature id for the '<em><b>Storage Resource</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HDD_RESOURCE_UTILIZATION__STORAGE_RESOURCE = RESULT_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Hdd Resource Utilization</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int HDD_RESOURCE_UTILIZATION_FEATURE_COUNT = RESULT_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link eu.qimpress.resultmodel.impl.ThroughputImpl <em>Throughput</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.resultmodel.impl.ThroughputImpl
	 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getThroughput()
	 * @generated
	 */
	int THROUGHPUT = 9;

	/**
	 * The feature id for the '<em><b>Result Distribution</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROUGHPUT__RESULT_DISTRIBUTION = RESULT_OBJECT__RESULT_DISTRIBUTION;

	/**
	 * The feature id for the '<em><b>Usage Scenario</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROUGHPUT__USAGE_SCENARIO = RESULT_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Throughput</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int THROUGHPUT_FEATURE_COUNT = RESULT_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link eu.qimpress.resultmodel.impl.ReliabilityPredictionResultImpl <em>Reliability Prediction Result</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.resultmodel.impl.ReliabilityPredictionResultImpl
	 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getReliabilityPredictionResult()
	 * @generated
	 */
	int RELIABILITY_PREDICTION_RESULT = 10;

	/**
	 * The feature id for the '<em><b>Reliabilities</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELIABILITY_PREDICTION_RESULT__RELIABILITIES = ANALYSIS_RESULT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Reliability Prediction Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELIABILITY_PREDICTION_RESULT_FEATURE_COUNT = ANALYSIS_RESULT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link eu.qimpress.resultmodel.impl.ReliabilityImpl <em>Reliability</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.resultmodel.impl.ReliabilityImpl
	 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getReliability()
	 * @generated
	 */
	int RELIABILITY = 11;

	/**
	 * The feature id for the '<em><b>Result Distribution</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELIABILITY__RESULT_DISTRIBUTION = RESULT_OBJECT__RESULT_DISTRIBUTION;

	/**
	 * The feature id for the '<em><b>System Call</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELIABILITY__SYSTEM_CALL = RESULT_OBJECT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Reliability</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int RELIABILITY_FEATURE_COUNT = RESULT_OBJECT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link eu.qimpress.resultmodel.impl.MaintainabilityPredictionResultImpl <em>Maintainability Prediction Result</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see eu.qimpress.resultmodel.impl.MaintainabilityPredictionResultImpl
	 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getMaintainabilityPredictionResult()
	 * @generated
	 */
	int MAINTAINABILITY_PREDICTION_RESULT = 12;

	/**
	 * The feature id for the '<em><b>Aggregated Time Effort</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAINTAINABILITY_PREDICTION_RESULT__AGGREGATED_TIME_EFFORT = ANALYSIS_RESULT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Effortanalysisinstances</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAINTAINABILITY_PREDICTION_RESULT__EFFORTANALYSISINSTANCES = ANALYSIS_RESULT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Aggregated Costs</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAINTAINABILITY_PREDICTION_RESULT__AGGREGATED_COSTS = ANALYSIS_RESULT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Maintainability Prediction Result</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MAINTAINABILITY_PREDICTION_RESULT_FEATURE_COUNT = ANALYSIS_RESULT_FEATURE_COUNT + 3;


	/**
	 * Returns the meta object for class '{@link eu.qimpress.resultmodel.ResultRepository <em>Result Repository</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Result Repository</em>'.
	 * @see eu.qimpress.resultmodel.ResultRepository
	 * @generated
	 */
	EClass getResultRepository();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.resultmodel.ResultRepository#getAnalysisRuns <em>Analysis Runs</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Analysis Runs</em>'.
	 * @see eu.qimpress.resultmodel.ResultRepository#getAnalysisRuns()
	 * @see #getResultRepository()
	 * @generated
	 */
	EReference getResultRepository_AnalysisRuns();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.resultmodel.AlternativeEvaluation <em>Alternative Evaluation</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Alternative Evaluation</em>'.
	 * @see eu.qimpress.resultmodel.AlternativeEvaluation
	 * @generated
	 */
	EClass getAlternativeEvaluation();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.resultmodel.AlternativeEvaluation#getRunDate <em>Run Date</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Run Date</em>'.
	 * @see eu.qimpress.resultmodel.AlternativeEvaluation#getRunDate()
	 * @see #getAlternativeEvaluation()
	 * @generated
	 */
	EAttribute getAlternativeEvaluation_RunDate();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.resultmodel.AlternativeEvaluation#getAlternativeId <em>Alternative Id</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Alternative Id</em>'.
	 * @see eu.qimpress.resultmodel.AlternativeEvaluation#getAlternativeId()
	 * @see #getAlternativeEvaluation()
	 * @generated
	 */
	EAttribute getAlternativeEvaluation_AlternativeId();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.resultmodel.AlternativeEvaluation#getServiceArchitectureModel <em>Service Architecture Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Service Architecture Model</em>'.
	 * @see eu.qimpress.resultmodel.AlternativeEvaluation#getServiceArchitectureModel()
	 * @see #getAlternativeEvaluation()
	 * @generated
	 */
	EReference getAlternativeEvaluation_ServiceArchitectureModel();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.resultmodel.AlternativeEvaluation#getAnalysisResults <em>Analysis Results</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Analysis Results</em>'.
	 * @see eu.qimpress.resultmodel.AlternativeEvaluation#getAnalysisResults()
	 * @see #getAlternativeEvaluation()
	 * @generated
	 */
	EReference getAlternativeEvaluation_AnalysisResults();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.resultmodel.AlternativeEvaluation#getUsageModel <em>Usage Model</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Usage Model</em>'.
	 * @see eu.qimpress.resultmodel.AlternativeEvaluation#getUsageModel()
	 * @see #getAlternativeEvaluation()
	 * @generated
	 */
	EReference getAlternativeEvaluation_UsageModel();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.resultmodel.AnalysisResult <em>Analysis Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Analysis Result</em>'.
	 * @see eu.qimpress.resultmodel.AnalysisResult
	 * @generated
	 */
	EClass getAnalysisResult();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.resultmodel.PerformancePredictionResult <em>Performance Prediction Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Performance Prediction Result</em>'.
	 * @see eu.qimpress.resultmodel.PerformancePredictionResult
	 * @generated
	 */
	EClass getPerformancePredictionResult();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.resultmodel.PerformancePredictionResult#getResponseTimes <em>Response Times</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Response Times</em>'.
	 * @see eu.qimpress.resultmodel.PerformancePredictionResult#getResponseTimes()
	 * @see #getPerformancePredictionResult()
	 * @generated
	 */
	EReference getPerformancePredictionResult_ResponseTimes();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.resultmodel.PerformancePredictionResult#getResourceUtilizations <em>Resource Utilizations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Resource Utilizations</em>'.
	 * @see eu.qimpress.resultmodel.PerformancePredictionResult#getResourceUtilizations()
	 * @see #getPerformancePredictionResult()
	 * @generated
	 */
	EReference getPerformancePredictionResult_ResourceUtilizations();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.resultmodel.PerformancePredictionResult#getHddResourceUtilizations <em>Hdd Resource Utilizations</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Hdd Resource Utilizations</em>'.
	 * @see eu.qimpress.resultmodel.PerformancePredictionResult#getHddResourceUtilizations()
	 * @see #getPerformancePredictionResult()
	 * @generated
	 */
	EReference getPerformancePredictionResult_HddResourceUtilizations();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.resultmodel.PerformancePredictionResult#getThroughputs <em>Throughputs</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Throughputs</em>'.
	 * @see eu.qimpress.resultmodel.PerformancePredictionResult#getThroughputs()
	 * @see #getPerformancePredictionResult()
	 * @generated
	 */
	EReference getPerformancePredictionResult_Throughputs();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.resultmodel.ResponseTime <em>Response Time</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Response Time</em>'.
	 * @see eu.qimpress.resultmodel.ResponseTime
	 * @generated
	 */
	EClass getResponseTime();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.resultmodel.ResponseTime#getUsageScenario <em>Usage Scenario</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Usage Scenario</em>'.
	 * @see eu.qimpress.resultmodel.ResponseTime#getUsageScenario()
	 * @see #getResponseTime()
	 * @generated
	 */
	EReference getResponseTime_UsageScenario();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.resultmodel.ResultObject <em>Result Object</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Result Object</em>'.
	 * @see eu.qimpress.resultmodel.ResultObject
	 * @generated
	 */
	EClass getResultObject();

	/**
	 * Returns the meta object for the containment reference '{@link eu.qimpress.resultmodel.ResultObject#getResultDistribution <em>Result Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Result Distribution</em>'.
	 * @see eu.qimpress.resultmodel.ResultObject#getResultDistribution()
	 * @see #getResultObject()
	 * @generated
	 */
	EReference getResultObject_ResultDistribution();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.resultmodel.ResultDistribution <em>Result Distribution</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Result Distribution</em>'.
	 * @see eu.qimpress.resultmodel.ResultDistribution
	 * @generated
	 */
	EClass getResultDistribution();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.resultmodel.ResultDistribution#get_10PercentQuantile <em>10 Percent Quantile</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>10 Percent Quantile</em>'.
	 * @see eu.qimpress.resultmodel.ResultDistribution#get_10PercentQuantile()
	 * @see #getResultDistribution()
	 * @generated
	 */
	EAttribute getResultDistribution__10PercentQuantile();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.resultmodel.ResultDistribution#get_90PercentQuantile <em>90 Percent Quantile</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>90 Percent Quantile</em>'.
	 * @see eu.qimpress.resultmodel.ResultDistribution#get_90PercentQuantile()
	 * @see #getResultDistribution()
	 * @generated
	 */
	EAttribute getResultDistribution__90PercentQuantile();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.resultmodel.ResultDistribution#getArithmeticMean <em>Arithmetic Mean</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Arithmetic Mean</em>'.
	 * @see eu.qimpress.resultmodel.ResultDistribution#getArithmeticMean()
	 * @see #getResultDistribution()
	 * @generated
	 */
	EAttribute getResultDistribution_ArithmeticMean();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.resultmodel.ResultDistribution#getMedian <em>Median</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Median</em>'.
	 * @see eu.qimpress.resultmodel.ResultDistribution#getMedian()
	 * @see #getResultDistribution()
	 * @generated
	 */
	EAttribute getResultDistribution_Median();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.resultmodel.CpuResourceUtilization <em>Cpu Resource Utilization</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Cpu Resource Utilization</em>'.
	 * @see eu.qimpress.resultmodel.CpuResourceUtilization
	 * @generated
	 */
	EClass getCpuResourceUtilization();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.resultmodel.CpuResourceUtilization#getExecutionResource <em>Execution Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Execution Resource</em>'.
	 * @see eu.qimpress.resultmodel.CpuResourceUtilization#getExecutionResource()
	 * @see #getCpuResourceUtilization()
	 * @generated
	 */
	EReference getCpuResourceUtilization_ExecutionResource();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.resultmodel.HddResourceUtilization <em>Hdd Resource Utilization</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Hdd Resource Utilization</em>'.
	 * @see eu.qimpress.resultmodel.HddResourceUtilization
	 * @generated
	 */
	EClass getHddResourceUtilization();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.resultmodel.HddResourceUtilization#getStorageResource <em>Storage Resource</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Storage Resource</em>'.
	 * @see eu.qimpress.resultmodel.HddResourceUtilization#getStorageResource()
	 * @see #getHddResourceUtilization()
	 * @generated
	 */
	EReference getHddResourceUtilization_StorageResource();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.resultmodel.Throughput <em>Throughput</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Throughput</em>'.
	 * @see eu.qimpress.resultmodel.Throughput
	 * @generated
	 */
	EClass getThroughput();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.resultmodel.Throughput#getUsageScenario <em>Usage Scenario</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Usage Scenario</em>'.
	 * @see eu.qimpress.resultmodel.Throughput#getUsageScenario()
	 * @see #getThroughput()
	 * @generated
	 */
	EReference getThroughput_UsageScenario();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.resultmodel.ReliabilityPredictionResult <em>Reliability Prediction Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Reliability Prediction Result</em>'.
	 * @see eu.qimpress.resultmodel.ReliabilityPredictionResult
	 * @generated
	 */
	EClass getReliabilityPredictionResult();

	/**
	 * Returns the meta object for the containment reference list '{@link eu.qimpress.resultmodel.ReliabilityPredictionResult#getReliabilities <em>Reliabilities</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Reliabilities</em>'.
	 * @see eu.qimpress.resultmodel.ReliabilityPredictionResult#getReliabilities()
	 * @see #getReliabilityPredictionResult()
	 * @generated
	 */
	EReference getReliabilityPredictionResult_Reliabilities();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.resultmodel.Reliability <em>Reliability</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Reliability</em>'.
	 * @see eu.qimpress.resultmodel.Reliability
	 * @generated
	 */
	EClass getReliability();

	/**
	 * Returns the meta object for the reference '{@link eu.qimpress.resultmodel.Reliability#getSystemCall <em>System Call</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>System Call</em>'.
	 * @see eu.qimpress.resultmodel.Reliability#getSystemCall()
	 * @see #getReliability()
	 * @generated
	 */
	EReference getReliability_SystemCall();

	/**
	 * Returns the meta object for class '{@link eu.qimpress.resultmodel.MaintainabilityPredictionResult <em>Maintainability Prediction Result</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Maintainability Prediction Result</em>'.
	 * @see eu.qimpress.resultmodel.MaintainabilityPredictionResult
	 * @generated
	 */
	EClass getMaintainabilityPredictionResult();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.resultmodel.MaintainabilityPredictionResult#getAggregatedTimeEffort <em>Aggregated Time Effort</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Aggregated Time Effort</em>'.
	 * @see eu.qimpress.resultmodel.MaintainabilityPredictionResult#getAggregatedTimeEffort()
	 * @see #getMaintainabilityPredictionResult()
	 * @generated
	 */
	EAttribute getMaintainabilityPredictionResult_AggregatedTimeEffort();

	/**
	 * Returns the meta object for the reference list '{@link eu.qimpress.resultmodel.MaintainabilityPredictionResult#getEffortanalysisinstances <em>Effortanalysisinstances</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Effortanalysisinstances</em>'.
	 * @see eu.qimpress.resultmodel.MaintainabilityPredictionResult#getEffortanalysisinstances()
	 * @see #getMaintainabilityPredictionResult()
	 * @generated
	 */
	EReference getMaintainabilityPredictionResult_Effortanalysisinstances();

	/**
	 * Returns the meta object for the attribute '{@link eu.qimpress.resultmodel.MaintainabilityPredictionResult#getAggregatedCosts <em>Aggregated Costs</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Aggregated Costs</em>'.
	 * @see eu.qimpress.resultmodel.MaintainabilityPredictionResult#getAggregatedCosts()
	 * @see #getMaintainabilityPredictionResult()
	 * @generated
	 */
	EAttribute getMaintainabilityPredictionResult_AggregatedCosts();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ResultModelFactory getResultModelFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link eu.qimpress.resultmodel.impl.ResultRepositoryImpl <em>Result Repository</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.resultmodel.impl.ResultRepositoryImpl
		 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getResultRepository()
		 * @generated
		 */
		EClass RESULT_REPOSITORY = eINSTANCE.getResultRepository();

		/**
		 * The meta object literal for the '<em><b>Analysis Runs</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RESULT_REPOSITORY__ANALYSIS_RUNS = eINSTANCE.getResultRepository_AnalysisRuns();

		/**
		 * The meta object literal for the '{@link eu.qimpress.resultmodel.impl.AlternativeEvaluationImpl <em>Alternative Evaluation</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.resultmodel.impl.AlternativeEvaluationImpl
		 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getAlternativeEvaluation()
		 * @generated
		 */
		EClass ALTERNATIVE_EVALUATION = eINSTANCE.getAlternativeEvaluation();

		/**
		 * The meta object literal for the '<em><b>Run Date</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ALTERNATIVE_EVALUATION__RUN_DATE = eINSTANCE.getAlternativeEvaluation_RunDate();

		/**
		 * The meta object literal for the '<em><b>Alternative Id</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute ALTERNATIVE_EVALUATION__ALTERNATIVE_ID = eINSTANCE.getAlternativeEvaluation_AlternativeId();

		/**
		 * The meta object literal for the '<em><b>Service Architecture Model</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ALTERNATIVE_EVALUATION__SERVICE_ARCHITECTURE_MODEL = eINSTANCE.getAlternativeEvaluation_ServiceArchitectureModel();

		/**
		 * The meta object literal for the '<em><b>Analysis Results</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ALTERNATIVE_EVALUATION__ANALYSIS_RESULTS = eINSTANCE.getAlternativeEvaluation_AnalysisResults();

		/**
		 * The meta object literal for the '<em><b>Usage Model</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference ALTERNATIVE_EVALUATION__USAGE_MODEL = eINSTANCE.getAlternativeEvaluation_UsageModel();

		/**
		 * The meta object literal for the '{@link eu.qimpress.resultmodel.impl.AnalysisResultImpl <em>Analysis Result</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.resultmodel.impl.AnalysisResultImpl
		 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getAnalysisResult()
		 * @generated
		 */
		EClass ANALYSIS_RESULT = eINSTANCE.getAnalysisResult();

		/**
		 * The meta object literal for the '{@link eu.qimpress.resultmodel.impl.PerformancePredictionResultImpl <em>Performance Prediction Result</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.resultmodel.impl.PerformancePredictionResultImpl
		 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getPerformancePredictionResult()
		 * @generated
		 */
		EClass PERFORMANCE_PREDICTION_RESULT = eINSTANCE.getPerformancePredictionResult();

		/**
		 * The meta object literal for the '<em><b>Response Times</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PERFORMANCE_PREDICTION_RESULT__RESPONSE_TIMES = eINSTANCE.getPerformancePredictionResult_ResponseTimes();

		/**
		 * The meta object literal for the '<em><b>Resource Utilizations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PERFORMANCE_PREDICTION_RESULT__RESOURCE_UTILIZATIONS = eINSTANCE.getPerformancePredictionResult_ResourceUtilizations();

		/**
		 * The meta object literal for the '<em><b>Hdd Resource Utilizations</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PERFORMANCE_PREDICTION_RESULT__HDD_RESOURCE_UTILIZATIONS = eINSTANCE.getPerformancePredictionResult_HddResourceUtilizations();

		/**
		 * The meta object literal for the '<em><b>Throughputs</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference PERFORMANCE_PREDICTION_RESULT__THROUGHPUTS = eINSTANCE.getPerformancePredictionResult_Throughputs();

		/**
		 * The meta object literal for the '{@link eu.qimpress.resultmodel.impl.ResponseTimeImpl <em>Response Time</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.resultmodel.impl.ResponseTimeImpl
		 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getResponseTime()
		 * @generated
		 */
		EClass RESPONSE_TIME = eINSTANCE.getResponseTime();

		/**
		 * The meta object literal for the '<em><b>Usage Scenario</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RESPONSE_TIME__USAGE_SCENARIO = eINSTANCE.getResponseTime_UsageScenario();

		/**
		 * The meta object literal for the '{@link eu.qimpress.resultmodel.impl.ResultObjectImpl <em>Result Object</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.resultmodel.impl.ResultObjectImpl
		 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getResultObject()
		 * @generated
		 */
		EClass RESULT_OBJECT = eINSTANCE.getResultObject();

		/**
		 * The meta object literal for the '<em><b>Result Distribution</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RESULT_OBJECT__RESULT_DISTRIBUTION = eINSTANCE.getResultObject_ResultDistribution();

		/**
		 * The meta object literal for the '{@link eu.qimpress.resultmodel.impl.ResultDistributionImpl <em>Result Distribution</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.resultmodel.impl.ResultDistributionImpl
		 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getResultDistribution()
		 * @generated
		 */
		EClass RESULT_DISTRIBUTION = eINSTANCE.getResultDistribution();

		/**
		 * The meta object literal for the '<em><b>10 Percent Quantile</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RESULT_DISTRIBUTION__10_PERCENT_QUANTILE = eINSTANCE.getResultDistribution__10PercentQuantile();

		/**
		 * The meta object literal for the '<em><b>90 Percent Quantile</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RESULT_DISTRIBUTION__90_PERCENT_QUANTILE = eINSTANCE.getResultDistribution__90PercentQuantile();

		/**
		 * The meta object literal for the '<em><b>Arithmetic Mean</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RESULT_DISTRIBUTION__ARITHMETIC_MEAN = eINSTANCE.getResultDistribution_ArithmeticMean();

		/**
		 * The meta object literal for the '<em><b>Median</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute RESULT_DISTRIBUTION__MEDIAN = eINSTANCE.getResultDistribution_Median();

		/**
		 * The meta object literal for the '{@link eu.qimpress.resultmodel.impl.CpuResourceUtilizationImpl <em>Cpu Resource Utilization</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.resultmodel.impl.CpuResourceUtilizationImpl
		 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getCpuResourceUtilization()
		 * @generated
		 */
		EClass CPU_RESOURCE_UTILIZATION = eINSTANCE.getCpuResourceUtilization();

		/**
		 * The meta object literal for the '<em><b>Execution Resource</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CPU_RESOURCE_UTILIZATION__EXECUTION_RESOURCE = eINSTANCE.getCpuResourceUtilization_ExecutionResource();

		/**
		 * The meta object literal for the '{@link eu.qimpress.resultmodel.impl.HddResourceUtilizationImpl <em>Hdd Resource Utilization</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.resultmodel.impl.HddResourceUtilizationImpl
		 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getHddResourceUtilization()
		 * @generated
		 */
		EClass HDD_RESOURCE_UTILIZATION = eINSTANCE.getHddResourceUtilization();

		/**
		 * The meta object literal for the '<em><b>Storage Resource</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference HDD_RESOURCE_UTILIZATION__STORAGE_RESOURCE = eINSTANCE.getHddResourceUtilization_StorageResource();

		/**
		 * The meta object literal for the '{@link eu.qimpress.resultmodel.impl.ThroughputImpl <em>Throughput</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.resultmodel.impl.ThroughputImpl
		 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getThroughput()
		 * @generated
		 */
		EClass THROUGHPUT = eINSTANCE.getThroughput();

		/**
		 * The meta object literal for the '<em><b>Usage Scenario</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference THROUGHPUT__USAGE_SCENARIO = eINSTANCE.getThroughput_UsageScenario();

		/**
		 * The meta object literal for the '{@link eu.qimpress.resultmodel.impl.ReliabilityPredictionResultImpl <em>Reliability Prediction Result</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.resultmodel.impl.ReliabilityPredictionResultImpl
		 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getReliabilityPredictionResult()
		 * @generated
		 */
		EClass RELIABILITY_PREDICTION_RESULT = eINSTANCE.getReliabilityPredictionResult();

		/**
		 * The meta object literal for the '<em><b>Reliabilities</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RELIABILITY_PREDICTION_RESULT__RELIABILITIES = eINSTANCE.getReliabilityPredictionResult_Reliabilities();

		/**
		 * The meta object literal for the '{@link eu.qimpress.resultmodel.impl.ReliabilityImpl <em>Reliability</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.resultmodel.impl.ReliabilityImpl
		 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getReliability()
		 * @generated
		 */
		EClass RELIABILITY = eINSTANCE.getReliability();

		/**
		 * The meta object literal for the '<em><b>System Call</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference RELIABILITY__SYSTEM_CALL = eINSTANCE.getReliability_SystemCall();

		/**
		 * The meta object literal for the '{@link eu.qimpress.resultmodel.impl.MaintainabilityPredictionResultImpl <em>Maintainability Prediction Result</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see eu.qimpress.resultmodel.impl.MaintainabilityPredictionResultImpl
		 * @see eu.qimpress.resultmodel.impl.ResultModelPackageImpl#getMaintainabilityPredictionResult()
		 * @generated
		 */
		EClass MAINTAINABILITY_PREDICTION_RESULT = eINSTANCE.getMaintainabilityPredictionResult();

		/**
		 * The meta object literal for the '<em><b>Aggregated Time Effort</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MAINTAINABILITY_PREDICTION_RESULT__AGGREGATED_TIME_EFFORT = eINSTANCE.getMaintainabilityPredictionResult_AggregatedTimeEffort();

		/**
		 * The meta object literal for the '<em><b>Effortanalysisinstances</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MAINTAINABILITY_PREDICTION_RESULT__EFFORTANALYSISINSTANCES = eINSTANCE.getMaintainabilityPredictionResult_Effortanalysisinstances();

		/**
		 * The meta object literal for the '<em><b>Aggregated Costs</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MAINTAINABILITY_PREDICTION_RESULT__AGGREGATED_COSTS = eINSTANCE.getMaintainabilityPredictionResult_AggregatedCosts();

	}

} //ResultModelPackage
