/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.resultmodel.provider;

import eu.qimpress.resultmodel.util.ResultModelAdapterFactory;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class ResultModelItemProviderAdapterFactory extends ResultModelAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResultModelItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.resultmodel.ResultRepository} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResultRepositoryItemProvider resultRepositoryItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.resultmodel.ResultRepository}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createResultRepositoryAdapter() {
		if (resultRepositoryItemProvider == null) {
			resultRepositoryItemProvider = new ResultRepositoryItemProvider(this);
		}

		return resultRepositoryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.resultmodel.AlternativeEvaluation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AlternativeEvaluationItemProvider alternativeEvaluationItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.resultmodel.AlternativeEvaluation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAlternativeEvaluationAdapter() {
		if (alternativeEvaluationItemProvider == null) {
			alternativeEvaluationItemProvider = new AlternativeEvaluationItemProvider(this);
		}

		return alternativeEvaluationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.resultmodel.PerformancePredictionResult} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected PerformancePredictionResultItemProvider performancePredictionResultItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.resultmodel.PerformancePredictionResult}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createPerformancePredictionResultAdapter() {
		if (performancePredictionResultItemProvider == null) {
			performancePredictionResultItemProvider = new PerformancePredictionResultItemProvider(this);
		}

		return performancePredictionResultItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.resultmodel.ResponseTime} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResponseTimeItemProvider responseTimeItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.resultmodel.ResponseTime}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createResponseTimeAdapter() {
		if (responseTimeItemProvider == null) {
			responseTimeItemProvider = new ResponseTimeItemProvider(this);
		}

		return responseTimeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.resultmodel.ResultDistribution} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ResultDistributionItemProvider resultDistributionItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.resultmodel.ResultDistribution}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createResultDistributionAdapter() {
		if (resultDistributionItemProvider == null) {
			resultDistributionItemProvider = new ResultDistributionItemProvider(this);
		}

		return resultDistributionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.resultmodel.CpuResourceUtilization} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected CpuResourceUtilizationItemProvider cpuResourceUtilizationItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.resultmodel.CpuResourceUtilization}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createCpuResourceUtilizationAdapter() {
		if (cpuResourceUtilizationItemProvider == null) {
			cpuResourceUtilizationItemProvider = new CpuResourceUtilizationItemProvider(this);
		}

		return cpuResourceUtilizationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.resultmodel.HddResourceUtilization} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected HddResourceUtilizationItemProvider hddResourceUtilizationItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.resultmodel.HddResourceUtilization}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createHddResourceUtilizationAdapter() {
		if (hddResourceUtilizationItemProvider == null) {
			hddResourceUtilizationItemProvider = new HddResourceUtilizationItemProvider(this);
		}

		return hddResourceUtilizationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.resultmodel.Throughput} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ThroughputItemProvider throughputItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.resultmodel.Throughput}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createThroughputAdapter() {
		if (throughputItemProvider == null) {
			throughputItemProvider = new ThroughputItemProvider(this);
		}

		return throughputItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.resultmodel.ReliabilityPredictionResult} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReliabilityPredictionResultItemProvider reliabilityPredictionResultItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.resultmodel.ReliabilityPredictionResult}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReliabilityPredictionResultAdapter() {
		if (reliabilityPredictionResultItemProvider == null) {
			reliabilityPredictionResultItemProvider = new ReliabilityPredictionResultItemProvider(this);
		}

		return reliabilityPredictionResultItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.resultmodel.Reliability} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ReliabilityItemProvider reliabilityItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.resultmodel.Reliability}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createReliabilityAdapter() {
		if (reliabilityItemProvider == null) {
			reliabilityItemProvider = new ReliabilityItemProvider(this);
		}

		return reliabilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link eu.qimpress.resultmodel.MaintainabilityPredictionResult} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MaintainabilityPredictionResultItemProvider maintainabilityPredictionResultItemProvider;

	/**
	 * This creates an adapter for a {@link eu.qimpress.resultmodel.MaintainabilityPredictionResult}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createMaintainabilityPredictionResultAdapter() {
		if (maintainabilityPredictionResultItemProvider == null) {
			maintainabilityPredictionResultItemProvider = new MaintainabilityPredictionResultItemProvider(this);
		}

		return maintainabilityPredictionResultItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (resultRepositoryItemProvider != null) resultRepositoryItemProvider.dispose();
		if (alternativeEvaluationItemProvider != null) alternativeEvaluationItemProvider.dispose();
		if (performancePredictionResultItemProvider != null) performancePredictionResultItemProvider.dispose();
		if (responseTimeItemProvider != null) responseTimeItemProvider.dispose();
		if (resultDistributionItemProvider != null) resultDistributionItemProvider.dispose();
		if (cpuResourceUtilizationItemProvider != null) cpuResourceUtilizationItemProvider.dispose();
		if (hddResourceUtilizationItemProvider != null) hddResourceUtilizationItemProvider.dispose();
		if (throughputItemProvider != null) throughputItemProvider.dispose();
		if (reliabilityPredictionResultItemProvider != null) reliabilityPredictionResultItemProvider.dispose();
		if (reliabilityItemProvider != null) reliabilityItemProvider.dispose();
		if (maintainabilityPredictionResultItemProvider != null) maintainabilityPredictionResultItemProvider.dispose();
	}

}
