/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.qualityannotationdecorator.seffdecorator.util;

import eu.qimpress.identifier.util.IdentifierValidator;

import eu.qimpress.qualityannotationdecorator.seffdecorator.*;

import java.util.Map;

import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.EObjectValidator;

/**
 * <!-- begin-user-doc -->
 * The <b>Validator</b> for the model.
 * <!-- end-user-doc -->
 * @see eu.qimpress.qualityannotationdecorator.seffdecorator.SeffdecoratorPackage
 * @generated
 */
public class SeffdecoratorValidator extends EObjectValidator {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final SeffdecoratorValidator INSTANCE = new SeffdecoratorValidator();

	/**
	 * A constant for the {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes} from this package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.common.util.Diagnostic#getSource()
	 * @see org.eclipse.emf.common.util.Diagnostic#getCode()
	 * @generated
	 */
	public static final String DIAGNOSTIC_SOURCE = "eu.qimpress.qualityannotationdecorator.seffdecorator";

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'Branch Probabilities For One Branch Action Must Contain Constant Numbers Only Or Parametric Formulas Only' of 'Branch Probability'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int BRANCH_PROBABILITY__BRANCH_PROBABILITIES_FOR_ONE_BRANCH_ACTION_MUST_CONTAIN_CONSTANT_NUMBERS_ONLY_OR_PARAMETRIC_FORMULAS_ONLY = 1;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 1;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants in a derived class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final int DIAGNOSTIC_CODE_COUNT = GENERATED_DIAGNOSTIC_CODE_COUNT;

	/**
	 * The cached base package validator.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IdentifierValidator identifierValidator;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SeffdecoratorValidator() {
		super();
		identifierValidator = IdentifierValidator.INSTANCE;
	}

	/**
	 * Returns the package of this validator switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EPackage getEPackage() {
	  return SeffdecoratorPackage.eINSTANCE;
	}

	/**
	 * Calls <code>validateXXX</code> for the corresponding classifier of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
		switch (classifierID) {
			case SeffdecoratorPackage.BRANCH_PROBABILITY:
				return validateBranchProbability((BranchProbability)value, diagnostics, context);
			case SeffdecoratorPackage.LOOP_COUNT:
				return validateLoopCount((LoopCount)value, diagnostics, context);
			case SeffdecoratorPackage.RESOURCE_DEMAND:
				return validateResourceDemand((ResourceDemand)value, diagnostics, context);
			case SeffdecoratorPackage.CPU_RESOURCE_DEMAND:
				return validateCpuResourceDemand((CpuResourceDemand)value, diagnostics, context);
			case SeffdecoratorPackage.HDD_RESOURCE_DEMAND:
				return validateHddResourceDemand((HddResourceDemand)value, diagnostics, context);
			case SeffdecoratorPackage.ACTIVITY_FAILURE_PROBABILITY:
				return validateActivityFailureProbability((ActivityFailureProbability)value, diagnostics, context);
			case SeffdecoratorPackage.PASSIVE_RESOURCE_DEMAND:
				return validatePassiveResourceDemand((PassiveResourceDemand)value, diagnostics, context);
			default:
				return true;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateBranchProbability(BranchProbability branchProbability, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(branchProbability, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(branchProbability, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(branchProbability, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(branchProbability, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(branchProbability, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(branchProbability, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(branchProbability, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(branchProbability, diagnostics, context);
		if (result || diagnostics != null) result &= validateBranchProbability_BranchProbabilitiesForOneBranchActionMustContainConstantNumbersOnlyOrParametricFormulasOnly(branchProbability, diagnostics, context);
		return result;
	}

	/**
	 * Validates the BranchProbabilitiesForOneBranchActionMustContainConstantNumbersOnlyOrParametricFormulasOnly constraint of '<em>Branch Probability</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateBranchProbability_BranchProbabilitiesForOneBranchActionMustContainConstantNumbersOnlyOrParametricFormulasOnly(BranchProbability branchProbability, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return branchProbability.BranchProbabilitiesForOneBranchActionMustContainConstantNumbersOnlyOrParametricFormulasOnly(diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateLoopCount(LoopCount loopCount, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(loopCount, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(loopCount, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(loopCount, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(loopCount, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(loopCount, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(loopCount, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(loopCount, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(loopCount, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateResourceDemand(ResourceDemand resourceDemand, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(resourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(resourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(resourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(resourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(resourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(resourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(resourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(resourceDemand, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateCpuResourceDemand(CpuResourceDemand cpuResourceDemand, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(cpuResourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(cpuResourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(cpuResourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(cpuResourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(cpuResourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(cpuResourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(cpuResourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(cpuResourceDemand, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateHddResourceDemand(HddResourceDemand hddResourceDemand, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(hddResourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(hddResourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(hddResourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(hddResourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(hddResourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(hddResourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(hddResourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(hddResourceDemand, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateActivityFailureProbability(ActivityFailureProbability activityFailureProbability, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(activityFailureProbability, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(activityFailureProbability, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(activityFailureProbability, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(activityFailureProbability, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(activityFailureProbability, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(activityFailureProbability, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(activityFailureProbability, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(activityFailureProbability, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validatePassiveResourceDemand(PassiveResourceDemand passiveResourceDemand, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(passiveResourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(passiveResourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(passiveResourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(passiveResourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(passiveResourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(passiveResourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(passiveResourceDemand, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(passiveResourceDemand, diagnostics, context);
		return result;
	}

	/**
	 * Returns the resource locator that will be used to fetch messages for this validator's diagnostics.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		// TODO
		// Specialize this to return a resource locator for messages specific to this validator.
		// Ensure that you remove @generated or mark it @generated NOT
		return super.getResourceLocator();
	}

} //SeffdecoratorValidator
