/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.qualityannotationdecorator.sammdecorator.util;

import eu.qimpress.identifier.util.IdentifierValidator;
import eu.qimpress.qualityannotationdecorator.sammdecorator.*;

import java.util.Map;

import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.util.EObjectValidator;

/**
 * <!-- begin-user-doc -->
 * The <b>Validator</b> for the model.
 * <!-- end-user-doc -->
 * @see eu.qimpress.qualityannotationdecorator.sammdecorator.SammdecoratorPackage
 * @generated
 */
public class SammdecoratorValidator extends EObjectValidator {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final SammdecoratorValidator INSTANCE = new SammdecoratorValidator();

	/**
	 * A constant for the {@link org.eclipse.emf.common.util.Diagnostic#getSource() source} of diagnostic {@link org.eclipse.emf.common.util.Diagnostic#getCode() codes} from this package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.emf.common.util.Diagnostic#getSource()
	 * @see org.eclipse.emf.common.util.Diagnostic#getCode()
	 * @generated
	 */
	public static final String DIAGNOSTIC_SOURCE = "eu.qimpress.qualityannotationdecorator.sammdecorator";

	/**
	 * The {@link org.eclipse.emf.common.util.Diagnostic#getCode() code} for constraint 'Operation Has To Be Provided By The Service' of 'Black Box Service Annotation'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final int BLACK_BOX_SERVICE_ANNOTATION__OPERATION_HAS_TO_BE_PROVIDED_BY_THE_SERVICE = 1;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 1;

	/**
	 * A constant with a fixed name that can be used as the base value for additional hand written constants in a derived class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static final int DIAGNOSTIC_CODE_COUNT = GENERATED_DIAGNOSTIC_CODE_COUNT;

	/**
	 * The cached base package validator.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IdentifierValidator identifierValidator;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public SammdecoratorValidator() {
		super();
		identifierValidator = IdentifierValidator.INSTANCE;
	}

	/**
	 * Returns the package of this validator switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EPackage getEPackage() {
	  return SammdecoratorPackage.eINSTANCE;
	}

	/**
	 * Calls <code>validateXXX</code> for the corresponding classifier of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
		switch (classifierID) {
			case SammdecoratorPackage.BLACK_BOX_SERVICE_RESPONSE_TIME:
				return validateBlackBoxServiceResponseTime((BlackBoxServiceResponseTime)value, diagnostics, context);
			case SammdecoratorPackage.BLACK_BOX_SERVICE_ANNOTATION:
				return validateBlackBoxServiceAnnotation((BlackBoxServiceAnnotation)value, diagnostics, context);
			case SammdecoratorPackage.BLACK_BOX_SERVICE_FAILURE_PROBABILITY:
				return validateBlackBoxServiceFailureProbability((BlackBoxServiceFailureProbability)value, diagnostics, context);
			default:
				return true;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateBlackBoxServiceResponseTime(BlackBoxServiceResponseTime blackBoxServiceResponseTime, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(blackBoxServiceResponseTime, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(blackBoxServiceResponseTime, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(blackBoxServiceResponseTime, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(blackBoxServiceResponseTime, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(blackBoxServiceResponseTime, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(blackBoxServiceResponseTime, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(blackBoxServiceResponseTime, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(blackBoxServiceResponseTime, diagnostics, context);
		if (result || diagnostics != null) result &= validateBlackBoxServiceAnnotation_OperationHasToBeProvidedByTheService(blackBoxServiceResponseTime, diagnostics, context);
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateBlackBoxServiceAnnotation(BlackBoxServiceAnnotation blackBoxServiceAnnotation, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(blackBoxServiceAnnotation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(blackBoxServiceAnnotation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(blackBoxServiceAnnotation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(blackBoxServiceAnnotation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(blackBoxServiceAnnotation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(blackBoxServiceAnnotation, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(blackBoxServiceAnnotation, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(blackBoxServiceAnnotation, diagnostics, context);
		if (result || diagnostics != null) result &= validateBlackBoxServiceAnnotation_OperationHasToBeProvidedByTheService(blackBoxServiceAnnotation, diagnostics, context);
		return result;
	}

	/**
	 * Validates the OperationHasToBeProvidedByTheService constraint of '<em>Black Box Service Annotation</em>'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateBlackBoxServiceAnnotation_OperationHasToBeProvidedByTheService(BlackBoxServiceAnnotation blackBoxServiceAnnotation, DiagnosticChain diagnostics, Map<Object, Object> context) {
		return blackBoxServiceAnnotation.OperationHasToBeProvidedByTheService(diagnostics, context);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean validateBlackBoxServiceFailureProbability(BlackBoxServiceFailureProbability blackBoxServiceFailureProbability, DiagnosticChain diagnostics, Map<Object, Object> context) {
		boolean result = validate_EveryMultiplicityConforms(blackBoxServiceFailureProbability, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryDataValueConforms(blackBoxServiceFailureProbability, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryReferenceIsContained(blackBoxServiceFailureProbability, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryProxyResolves(blackBoxServiceFailureProbability, diagnostics, context);
		if (result || diagnostics != null) result &= validate_UniqueID(blackBoxServiceFailureProbability, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryKeyUnique(blackBoxServiceFailureProbability, diagnostics, context);
		if (result || diagnostics != null) result &= validate_EveryMapEntryUnique(blackBoxServiceFailureProbability, diagnostics, context);
		if (result || diagnostics != null) result &= identifierValidator.validateIdentifier_idHasToBeUnique(blackBoxServiceFailureProbability, diagnostics, context);
		if (result || diagnostics != null) result &= validateBlackBoxServiceAnnotation_OperationHasToBeProvidedByTheService(blackBoxServiceFailureProbability, diagnostics, context);
		return result;
	}

	/**
	 * Returns the resource locator that will be used to fetch messages for this validator's diagnostics.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ResourceLocator getResourceLocator() {
		// TODO
		// Specialize this to return a resource locator for messages specific to this validator.
		// Ensure that you remove @generated or mark it @generated NOT
		return super.getResourceLocator();
	}

} //SammdecoratorValidator
