/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package eu.qimpress.qualityannotationdecorator.sammdecorator;

import eu.qimpress.samm.deployment.allocation.Service;

import eu.qimpress.samm.qosannotation.Annotation;

import eu.qimpress.samm.staticstructure.Operation;

import java.util.Map;

import org.eclipse.emf.common.util.DiagnosticChain;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Black Box Service Annotation</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * The BlackBoxServiceAnnotation allows software architects to specify the quality attributes of a service (signature + role) of a component.
 * 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link eu.qimpress.qualityannotationdecorator.sammdecorator.BlackBoxServiceAnnotation#getOperation <em>Operation</em>}</li>
 *   <li>{@link eu.qimpress.qualityannotationdecorator.sammdecorator.BlackBoxServiceAnnotation#getService <em>Service</em>}</li>
 * </ul>
 * </p>
 *
 * @see eu.qimpress.qualityannotationdecorator.sammdecorator.SammdecoratorPackage#getBlackBoxServiceAnnotation()
 * @model abstract="true"
 * @generated
 */
public interface BlackBoxServiceAnnotation extends Annotation {
	/**
	 * Returns the value of the '<em><b>Operation</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Operation</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Operation</em>' reference.
	 * @see #setOperation(Operation)
	 * @see eu.qimpress.qualityannotationdecorator.sammdecorator.SammdecoratorPackage#getBlackBoxServiceAnnotation_Operation()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	Operation getOperation();

	/**
	 * Sets the value of the '{@link eu.qimpress.qualityannotationdecorator.sammdecorator.BlackBoxServiceAnnotation#getOperation <em>Operation</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Operation</em>' reference.
	 * @see #getOperation()
	 * @generated
	 */
	void setOperation(Operation value);

	/**
	 * Returns the value of the '<em><b>Service</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Service</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Service</em>' reference.
	 * @see #setService(Service)
	 * @see eu.qimpress.qualityannotationdecorator.sammdecorator.SammdecoratorPackage#getBlackBoxServiceAnnotation_Service()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	Service getService();

	/**
	 * Sets the value of the '{@link eu.qimpress.qualityannotationdecorator.sammdecorator.BlackBoxServiceAnnotation#getService <em>Service</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Service</em>' reference.
	 * @see #getService()
	 * @generated
	 */
	void setService(Service value);

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * if 
	 * 	self.service.isBlackBox 
	 * then 
	 * 	self.service.subcomponentInstance.realizedBy.provided
	 * 	->exists(ip|ip.interfaceType.signatures->includes(self.operation)) 
	 * else 
	 * 	false
	 * endif
	 * @param diagnostics The chain of diagnostics to which problems are to be appended.
	 * @param context The cache of context-specific information.
	 * <!-- end-model-doc -->
	 * @model annotation="http://www.eclipse.org/uml2/1.1.0/GenModel body='if \r\n\tself.service.isBlackBox \r\nthen \r\n\tself.service.subcomponentInstance.realizedBy.provided\r\n\t->exists(ip|ip.interfaceType.signatures->includes(self.operation)) \r\nelse \r\n\tfalse\r\nendif'"
	 * @generated
	 */
	boolean OperationHasToBeProvidedByTheService(DiagnosticChain diagnostics, Map<Object, Object> context);

} // BlackBoxServiceAnnotation
