/**
 * <copyright>
 * </copyright>
 *
 * $Id: FormalParameterImpl.java,v 1.5 2008/12/05 15:44:36 stammel Exp $
 */
package de.fzi.gast.variables.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

import de.fzi.gast.functions.Function;
import de.fzi.gast.functions.functionsPackage;
import de.fzi.gast.variables.FormalParameter;
import de.fzi.gast.variables.variablesPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Formal Parameter</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.variables.impl.FormalParameterImpl#isPassedByReference <em>Passed By Reference</em>}</li>
 *   <li>{@link de.fzi.gast.variables.impl.FormalParameterImpl#getSurroundingFunction <em>Surrounding Function</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class FormalParameterImpl extends VariableImpl implements FormalParameter {
	/**
	 * The default value of the '{@link #isPassedByReference() <em>Passed By Reference</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isPassedByReference()
	 * @generated
	 * @ordered
	 */
	protected static final boolean PASSED_BY_REFERENCE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isPassedByReference() <em>Passed By Reference</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isPassedByReference()
	 * @generated
	 * @ordered
	 */
	protected boolean passedByReference = PASSED_BY_REFERENCE_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FormalParameterImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return variablesPackage.Literals.FORMAL_PARAMETER;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isPassedByReference() {
		return passedByReference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPassedByReference(boolean newPassedByReference) {
		boolean oldPassedByReference = passedByReference;
		passedByReference = newPassedByReference;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, variablesPackage.FORMAL_PARAMETER__PASSED_BY_REFERENCE, oldPassedByReference, passedByReference));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Function getSurroundingFunction() {
		if (eContainerFeatureID() != variablesPackage.FORMAL_PARAMETER__SURROUNDING_FUNCTION) return null;
		return (Function)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSurroundingFunction(Function newSurroundingFunction, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newSurroundingFunction, variablesPackage.FORMAL_PARAMETER__SURROUNDING_FUNCTION, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSurroundingFunction(Function newSurroundingFunction) {
		if (newSurroundingFunction != eInternalContainer() || (eContainerFeatureID() != variablesPackage.FORMAL_PARAMETER__SURROUNDING_FUNCTION && newSurroundingFunction != null)) {
			if (EcoreUtil.isAncestor(this, newSurroundingFunction))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newSurroundingFunction != null)
				msgs = ((InternalEObject)newSurroundingFunction).eInverseAdd(this, functionsPackage.FUNCTION__FORMAL_PARAMETERS, Function.class, msgs);
			msgs = basicSetSurroundingFunction(newSurroundingFunction, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, variablesPackage.FORMAL_PARAMETER__SURROUNDING_FUNCTION, newSurroundingFunction, newSurroundingFunction));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case variablesPackage.FORMAL_PARAMETER__SURROUNDING_FUNCTION:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetSurroundingFunction((Function)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case variablesPackage.FORMAL_PARAMETER__SURROUNDING_FUNCTION:
				return basicSetSurroundingFunction(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case variablesPackage.FORMAL_PARAMETER__SURROUNDING_FUNCTION:
				return eInternalContainer().eInverseRemove(this, functionsPackage.FUNCTION__FORMAL_PARAMETERS, Function.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case variablesPackage.FORMAL_PARAMETER__PASSED_BY_REFERENCE:
				return isPassedByReference();
			case variablesPackage.FORMAL_PARAMETER__SURROUNDING_FUNCTION:
				return getSurroundingFunction();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case variablesPackage.FORMAL_PARAMETER__PASSED_BY_REFERENCE:
				setPassedByReference((Boolean)newValue);
				return;
			case variablesPackage.FORMAL_PARAMETER__SURROUNDING_FUNCTION:
				setSurroundingFunction((Function)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case variablesPackage.FORMAL_PARAMETER__PASSED_BY_REFERENCE:
				setPassedByReference(PASSED_BY_REFERENCE_EDEFAULT);
				return;
			case variablesPackage.FORMAL_PARAMETER__SURROUNDING_FUNCTION:
				setSurroundingFunction((Function)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case variablesPackage.FORMAL_PARAMETER__PASSED_BY_REFERENCE:
				return passedByReference != PASSED_BY_REFERENCE_EDEFAULT;
			case variablesPackage.FORMAL_PARAMETER__SURROUNDING_FUNCTION:
				return getSurroundingFunction() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (passedByReference: ");
		result.append(passedByReference);
		result.append(')');
		return result.toString();
	}

} //FormalParameterImpl
