/**
 * <copyright>
 * </copyright>
 *
 * $Id: FieldImpl.java,v 1.6 2009/01/20 10:51:19 stammel Exp $
 */
package de.fzi.gast.variables.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

import de.fzi.gast.accesses.DeclarationTypeAccess;
import de.fzi.gast.accesses.accessesPackage;
import de.fzi.gast.core.NamedModelElement;
import de.fzi.gast.core.corePackage;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.GASTType;
import de.fzi.gast.types.typesPackage;
import de.fzi.gast.types.impl.MemberImpl;
import de.fzi.gast.variables.Field;
import de.fzi.gast.variables.Variable;
import de.fzi.gast.variables.variablesPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Field</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.variables.impl.FieldImpl#getSimpleName <em>Simple Name</em>}</li>
 *   <li>{@link de.fzi.gast.variables.impl.FieldImpl#getType <em>Type</em>}</li>
 *   <li>{@link de.fzi.gast.variables.impl.FieldImpl#isConst <em>Const</em>}</li>
 *   <li>{@link de.fzi.gast.variables.impl.FieldImpl#getTypeDeclaration <em>Type Declaration</em>}</li>
 *   <li>{@link de.fzi.gast.variables.impl.FieldImpl#isPropertyField <em>Property Field</em>}</li>
 *   <li>{@link de.fzi.gast.variables.impl.FieldImpl#getSurroundingClass <em>Surrounding Class</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class FieldImpl extends MemberImpl implements Field {
	/**
	 * The default value of the '{@link #getSimpleName() <em>Simple Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSimpleName()
	 * @generated
	 * @ordered
	 */
	protected static final String SIMPLE_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSimpleName() <em>Simple Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSimpleName()
	 * @generated
	 * @ordered
	 */
	protected String simpleName = SIMPLE_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #isConst() <em>Const</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isConst()
	 * @generated
	 * @ordered
	 */
	protected static final boolean CONST_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isConst() <em>Const</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isConst()
	 * @generated
	 * @ordered
	 */
	protected boolean const_ = CONST_EDEFAULT;

	/**
	 * This is true if the Const attribute has been set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	protected boolean constESet;

	/**
	 * The cached value of the '{@link #getTypeDeclaration() <em>Type Declaration</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getTypeDeclaration()
	 * @generated
	 * @ordered
	 */
	protected DeclarationTypeAccess typeDeclaration;

	/**
	 * The default value of the '{@link #isPropertyField() <em>Property Field</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isPropertyField()
	 * @generated
	 * @ordered
	 */
	protected static final boolean PROPERTY_FIELD_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isPropertyField() <em>Property Field</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isPropertyField()
	 * @generated
	 * @ordered
	 */
	protected boolean propertyField = PROPERTY_FIELD_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FieldImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return variablesPackage.Literals.FIELD;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getSimpleName() {
		return simpleName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSimpleName(String newSimpleName) {
		String oldSimpleName = simpleName;
		simpleName = newSimpleName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, variablesPackage.FIELD__SIMPLE_NAME, oldSimpleName, simpleName));
	}


	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTType getType() {
		GASTType type = basicGetType();
		return type != null && type.eIsProxy() ? (GASTType)eResolveProxy((InternalEObject)type) : type;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public GASTType basicGetType() {
		if (this.getTypeDeclaration() != null)
			return this.getTypeDeclaration().getTargetType();
		else 
			return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isConst() {
		return this.isFinal();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setConst(boolean newConst) {
		boolean oldConst = const_;
		const_ = newConst;
		boolean oldConstESet = constESet;
		constESet = true;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, variablesPackage.FIELD__CONST, oldConst, const_, !oldConstESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void unsetConst() {
		boolean oldConst = const_;
		boolean oldConstESet = constESet;
		const_ = CONST_EDEFAULT;
		constESet = false;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.UNSET, variablesPackage.FIELD__CONST, oldConst, CONST_EDEFAULT, oldConstESet));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isSetConst() {
		return constESet;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeclarationTypeAccess getTypeDeclaration() {
		return typeDeclaration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetTypeDeclaration(DeclarationTypeAccess newTypeDeclaration, NotificationChain msgs) {
		DeclarationTypeAccess oldTypeDeclaration = typeDeclaration;
		typeDeclaration = newTypeDeclaration;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, variablesPackage.FIELD__TYPE_DECLARATION, oldTypeDeclaration, newTypeDeclaration);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setTypeDeclaration(DeclarationTypeAccess newTypeDeclaration) {
		if (newTypeDeclaration != typeDeclaration) {
			NotificationChain msgs = null;
			if (typeDeclaration != null)
				msgs = ((InternalEObject)typeDeclaration).eInverseRemove(this, accessesPackage.DECLARATION_TYPE_ACCESS__SURROUNDING_VARIABLE, DeclarationTypeAccess.class, msgs);
			if (newTypeDeclaration != null)
				msgs = ((InternalEObject)newTypeDeclaration).eInverseAdd(this, accessesPackage.DECLARATION_TYPE_ACCESS__SURROUNDING_VARIABLE, DeclarationTypeAccess.class, msgs);
			msgs = basicSetTypeDeclaration(newTypeDeclaration, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, variablesPackage.FIELD__TYPE_DECLARATION, newTypeDeclaration, newTypeDeclaration));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isPropertyField() {
		return propertyField;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPropertyField(boolean newPropertyField) {
		boolean oldPropertyField = propertyField;
		propertyField = newPropertyField;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, variablesPackage.FIELD__PROPERTY_FIELD, oldPropertyField, propertyField));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTClass getSurroundingClass() {
		if (eContainerFeatureID() != variablesPackage.FIELD__SURROUNDING_CLASS) return null;
		return (GASTClass)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSurroundingClass(GASTClass newSurroundingClass, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newSurroundingClass, variablesPackage.FIELD__SURROUNDING_CLASS, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSurroundingClass(GASTClass newSurroundingClass) {
		if (newSurroundingClass != eInternalContainer() || (eContainerFeatureID() != variablesPackage.FIELD__SURROUNDING_CLASS && newSurroundingClass != null)) {
			if (EcoreUtil.isAncestor(this, newSurroundingClass))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newSurroundingClass != null)
				msgs = ((InternalEObject)newSurroundingClass).eInverseAdd(this, typesPackage.GAST_CLASS__FIELDS, GASTClass.class, msgs);
			msgs = basicSetSurroundingClass(newSurroundingClass, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, variablesPackage.FIELD__SURROUNDING_CLASS, newSurroundingClass, newSurroundingClass));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case variablesPackage.FIELD__TYPE_DECLARATION:
				if (typeDeclaration != null)
					msgs = ((InternalEObject)typeDeclaration).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - variablesPackage.FIELD__TYPE_DECLARATION, null, msgs);
				return basicSetTypeDeclaration((DeclarationTypeAccess)otherEnd, msgs);
			case variablesPackage.FIELD__SURROUNDING_CLASS:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetSurroundingClass((GASTClass)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case variablesPackage.FIELD__TYPE_DECLARATION:
				return basicSetTypeDeclaration(null, msgs);
			case variablesPackage.FIELD__SURROUNDING_CLASS:
				return basicSetSurroundingClass(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case variablesPackage.FIELD__SURROUNDING_CLASS:
				return eInternalContainer().eInverseRemove(this, typesPackage.GAST_CLASS__FIELDS, GASTClass.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case variablesPackage.FIELD__SIMPLE_NAME:
				return getSimpleName();
			case variablesPackage.FIELD__TYPE:
				if (resolve) return getType();
				return basicGetType();
			case variablesPackage.FIELD__CONST:
				return isConst();
			case variablesPackage.FIELD__TYPE_DECLARATION:
				return getTypeDeclaration();
			case variablesPackage.FIELD__PROPERTY_FIELD:
				return isPropertyField();
			case variablesPackage.FIELD__SURROUNDING_CLASS:
				return getSurroundingClass();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case variablesPackage.FIELD__SIMPLE_NAME:
				setSimpleName((String)newValue);
				return;
			case variablesPackage.FIELD__CONST:
				setConst((Boolean)newValue);
				return;
			case variablesPackage.FIELD__TYPE_DECLARATION:
				setTypeDeclaration((DeclarationTypeAccess)newValue);
				return;
			case variablesPackage.FIELD__PROPERTY_FIELD:
				setPropertyField((Boolean)newValue);
				return;
			case variablesPackage.FIELD__SURROUNDING_CLASS:
				setSurroundingClass((GASTClass)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case variablesPackage.FIELD__SIMPLE_NAME:
				setSimpleName(SIMPLE_NAME_EDEFAULT);
				return;
			case variablesPackage.FIELD__CONST:
				unsetConst();
				return;
			case variablesPackage.FIELD__TYPE_DECLARATION:
				setTypeDeclaration((DeclarationTypeAccess)null);
				return;
			case variablesPackage.FIELD__PROPERTY_FIELD:
				setPropertyField(PROPERTY_FIELD_EDEFAULT);
				return;
			case variablesPackage.FIELD__SURROUNDING_CLASS:
				setSurroundingClass((GASTClass)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case variablesPackage.FIELD__SIMPLE_NAME:
				return SIMPLE_NAME_EDEFAULT == null ? simpleName != null : !SIMPLE_NAME_EDEFAULT.equals(simpleName);
			case variablesPackage.FIELD__TYPE:
				return basicGetType() != null;
			case variablesPackage.FIELD__CONST:
				return isSetConst();
			case variablesPackage.FIELD__TYPE_DECLARATION:
				return typeDeclaration != null;
			case variablesPackage.FIELD__PROPERTY_FIELD:
				return propertyField != PROPERTY_FIELD_EDEFAULT;
			case variablesPackage.FIELD__SURROUNDING_CLASS:
				return getSurroundingClass() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == NamedModelElement.class) {
			switch (derivedFeatureID) {
				case variablesPackage.FIELD__SIMPLE_NAME: return corePackage.NAMED_MODEL_ELEMENT__SIMPLE_NAME;
				default: return -1;
			}
		}
		if (baseClass == Variable.class) {
			switch (derivedFeatureID) {
				case variablesPackage.FIELD__TYPE: return variablesPackage.VARIABLE__TYPE;
				case variablesPackage.FIELD__CONST: return variablesPackage.VARIABLE__CONST;
				case variablesPackage.FIELD__TYPE_DECLARATION: return variablesPackage.VARIABLE__TYPE_DECLARATION;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == NamedModelElement.class) {
			switch (baseFeatureID) {
				case corePackage.NAMED_MODEL_ELEMENT__SIMPLE_NAME: return variablesPackage.FIELD__SIMPLE_NAME;
				default: return -1;
			}
		}
		if (baseClass == Variable.class) {
			switch (baseFeatureID) {
				case variablesPackage.VARIABLE__TYPE: return variablesPackage.FIELD__TYPE;
				case variablesPackage.VARIABLE__CONST: return variablesPackage.FIELD__CONST;
				case variablesPackage.VARIABLE__TYPE_DECLARATION: return variablesPackage.FIELD__TYPE_DECLARATION;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (simpleName: ");
		result.append(simpleName);
		result.append(", const: ");
		if (constESet) result.append(const_); else result.append("<unset>");
		result.append(", propertyField: ");
		result.append(propertyField);
		result.append(')');
		return result.toString();
	}

} //FieldImpl
