/**
 * <copyright>
 * </copyright>
 *
 * $Id: Variable.java,v 1.6 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.variables;

import de.fzi.gast.accesses.DeclarationTypeAccess;
import de.fzi.gast.core.NamedModelElement;
import de.fzi.gast.core.SourceEntity;
import de.fzi.gast.types.GASTType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Variable</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class is the root of the variable hierarchy. 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.variables.Variable#getType <em>Type</em>}</li>
 *   <li>{@link de.fzi.gast.variables.Variable#isConst <em>Const</em>}</li>
 *   <li>{@link de.fzi.gast.variables.Variable#getTypeDeclaration <em>Type Declaration</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.variables.variablesPackage#getVariable()
 * @model abstract="true"
 * @generated
 */
public interface Variable extends NamedModelElement, SourceEntity {
	/**
	 * Returns the value of the '<em><b>Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the declared type of this variable. It is derived from typeDeclaration.getType().
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Type</em>' reference.
	 * @see de.fzi.gast.variables.variablesPackage#getVariable_Type()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	GASTType getType();

	/**
	 * Returns the value of the '<em><b>Const</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is true if this variable is declared as constant.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Const</em>' attribute.
	 * @see #isSetConst()
	 * @see #unsetConst()
	 * @see #setConst(boolean)
	 * @see de.fzi.gast.variables.variablesPackage#getVariable_Const()
	 * @model unsettable="true" required="true" ordered="false"
	 * @generated
	 */
	boolean isConst();

	/**
	 * Sets the value of the '{@link de.fzi.gast.variables.Variable#isConst <em>Const</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Const</em>' attribute.
	 * @see #isSetConst()
	 * @see #unsetConst()
	 * @see #isConst()
	 * @generated
	 */
	void setConst(boolean value);

	/**
	 * Unsets the value of the '{@link de.fzi.gast.variables.Variable#isConst <em>Const</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isSetConst()
	 * @see #isConst()
	 * @see #setConst(boolean)
	 * @generated
	 */
	void unsetConst();

	/**
	 * Returns whether the value of the '{@link de.fzi.gast.variables.Variable#isConst <em>Const</em>}' attribute is set.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return whether the value of the '<em>Const</em>' attribute is set.
	 * @see #unsetConst()
	 * @see #isConst()
	 * @see #setConst(boolean)
	 * @generated
	 */
	boolean isSetConst();

	/**
	 * Returns the value of the '<em><b>Type Declaration</b></em>' containment reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.accesses.DeclarationTypeAccess#getSurroundingVariable <em>Surrounding Variable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to a type access which points to the declared type of this variable.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Type Declaration</em>' containment reference.
	 * @see #setTypeDeclaration(DeclarationTypeAccess)
	 * @see de.fzi.gast.variables.variablesPackage#getVariable_TypeDeclaration()
	 * @see de.fzi.gast.accesses.DeclarationTypeAccess#getSurroundingVariable
	 * @model opposite="surroundingVariable" containment="true" ordered="false"
	 * @generated
	 */
	DeclarationTypeAccess getTypeDeclaration();

	/**
	 * Sets the value of the '{@link de.fzi.gast.variables.Variable#getTypeDeclaration <em>Type Declaration</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type Declaration</em>' containment reference.
	 * @see #getTypeDeclaration()
	 * @generated
	 */
	void setTypeDeclaration(DeclarationTypeAccess value);

} // Variable
