/**
 * <copyright>
 * </copyright>
 *
 * $Id: LocalVariable.java,v 1.5 2008/12/05 15:44:34 stammel Exp $
 */
package de.fzi.gast.variables;

import de.fzi.gast.functions.Function;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Local Variable</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents a local variable. Local variables are declared variables within a function body. 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.variables.LocalVariable#getSurroundingFunction <em>Surrounding Function</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.variables.variablesPackage#getLocalVariable()
 * @model
 * @generated
 */
public interface LocalVariable extends Variable {
	/**
	 * Returns the value of the '<em><b>Surrounding Function</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.functions.Function#getLocalVariables <em>Local Variables</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the function in which the local variable is declared.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Function</em>' container reference.
	 * @see #setSurroundingFunction(Function)
	 * @see de.fzi.gast.variables.variablesPackage#getLocalVariable_SurroundingFunction()
	 * @see de.fzi.gast.functions.Function#getLocalVariables
	 * @model opposite="localVariables" required="true" transient="false" ordered="false"
	 * @generated
	 */
	Function getSurroundingFunction();

	/**
	 * Sets the value of the '{@link de.fzi.gast.variables.LocalVariable#getSurroundingFunction <em>Surrounding Function</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Surrounding Function</em>' container reference.
	 * @see #getSurroundingFunction()
	 * @generated
	 */
	void setSurroundingFunction(Function value);

} // LocalVariable
