/**
 * <copyright>
 * </copyright>
 *
 * $Id: GlobalVariable.java,v 1.5 2008/12/05 15:44:34 stammel Exp $
 */
package de.fzi.gast.variables;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Global Variable</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents a global variable. Since global variables are not declared within the context of another model element, they are primarily accessible via the root object of the model.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.variables.GlobalVariable#getSurroundingPackage <em>Surrounding Package</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.variables.variablesPackage#getGlobalVariable()
 * @model
 * @generated
 */
public interface GlobalVariable extends Variable {
	/**
	 * Returns the value of the '<em><b>Surrounding Package</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.core.Package#getGlobalVariables <em>Global Variables</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the package which contains the declaration of this global variable.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Package</em>' container reference.
	 * @see #setSurroundingPackage(de.fzi.gast.core.Package)
	 * @see de.fzi.gast.variables.variablesPackage#getGlobalVariable_SurroundingPackage()
	 * @see de.fzi.gast.core.Package#getGlobalVariables
	 * @model opposite="globalVariables" required="true" transient="false" ordered="false"
	 * @generated
	 */
	de.fzi.gast.core.Package getSurroundingPackage();

	/**
	 * Sets the value of the '{@link de.fzi.gast.variables.GlobalVariable#getSurroundingPackage <em>Surrounding Package</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Surrounding Package</em>' container reference.
	 * @see #getSurroundingPackage()
	 * @generated
	 */
	void setSurroundingPackage(de.fzi.gast.core.Package value);

} // GlobalVariable
