/**
 * <copyright>
 * </copyright>
 *
 * $Id: FormalParameter.java,v 1.5 2008/12/05 15:44:34 stammel Exp $
 */
package de.fzi.gast.variables;

import de.fzi.gast.functions.Function;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Formal Parameter</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents a formal parameter of a function.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.variables.FormalParameter#isPassedByReference <em>Passed By Reference</em>}</li>
 *   <li>{@link de.fzi.gast.variables.FormalParameter#getSurroundingFunction <em>Surrounding Function</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.variables.variablesPackage#getFormalParameter()
 * @model
 * @generated
 */
public interface FormalParameter extends Variable {
	/**
	 * Returns the value of the '<em><b>Passed By Reference</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is true if this parameter is passed by reference, it is false if it is passed by value.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Passed By Reference</em>' attribute.
	 * @see #setPassedByReference(boolean)
	 * @see de.fzi.gast.variables.variablesPackage#getFormalParameter_PassedByReference()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	boolean isPassedByReference();

	/**
	 * Sets the value of the '{@link de.fzi.gast.variables.FormalParameter#isPassedByReference <em>Passed By Reference</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Passed By Reference</em>' attribute.
	 * @see #isPassedByReference()
	 * @generated
	 */
	void setPassedByReference(boolean value);

	/**
	 * Returns the value of the '<em><b>Surrounding Function</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.functions.Function#getFormalParameters <em>Formal Parameters</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the function this formal parameter belongs to.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Function</em>' container reference.
	 * @see #setSurroundingFunction(Function)
	 * @see de.fzi.gast.variables.variablesPackage#getFormalParameter_SurroundingFunction()
	 * @see de.fzi.gast.functions.Function#getFormalParameters
	 * @model opposite="formalParameters" required="true" transient="false" ordered="false"
	 * @generated
	 */
	Function getSurroundingFunction();

	/**
	 * Sets the value of the '{@link de.fzi.gast.variables.FormalParameter#getSurroundingFunction <em>Surrounding Function</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Surrounding Function</em>' container reference.
	 * @see #getSurroundingFunction()
	 * @generated
	 */
	void setSurroundingFunction(Function value);

} // FormalParameter
