/**
 * <copyright>
 * </copyright>
 *
 * $Id: Field.java,v 1.5 2008/12/05 15:44:34 stammel Exp $
 */
package de.fzi.gast.variables;

import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.Member;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Field</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents fields. They are class members.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.variables.Field#isPropertyField <em>Property Field</em>}</li>
 *   <li>{@link de.fzi.gast.variables.Field#getSurroundingClass <em>Surrounding Class</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.variables.variablesPackage#getField()
 * @model
 * @generated
 */
public interface Field extends Member, Variable {
	/**
	 * Returns the value of the '<em><b>Property Field</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is true if it is a property field.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Property Field</em>' attribute.
	 * @see #setPropertyField(boolean)
	 * @see de.fzi.gast.variables.variablesPackage#getField_PropertyField()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	boolean isPropertyField();

	/**
	 * Sets the value of the '{@link de.fzi.gast.variables.Field#isPropertyField <em>Property Field</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Property Field</em>' attribute.
	 * @see #isPropertyField()
	 * @generated
	 */
	void setPropertyField(boolean value);

	/**
	 * Returns the value of the '<em><b>Surrounding Class</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.types.GASTClass#getFields <em>Fields</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the class the field belongs to.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Class</em>' container reference.
	 * @see #setSurroundingClass(GASTClass)
	 * @see de.fzi.gast.variables.variablesPackage#getField_SurroundingClass()
	 * @see de.fzi.gast.types.GASTClass#getFields
	 * @model opposite="fields" transient="false" ordered="false"
	 * @generated
	 */
	GASTClass getSurroundingClass();

	/**
	 * Sets the value of the '{@link de.fzi.gast.variables.Field#getSurroundingClass <em>Surrounding Class</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Surrounding Class</em>' container reference.
	 * @see #getSurroundingClass()
	 * @generated
	 */
	void setSurroundingClass(GASTClass value);

} // Field
