/**
 * <copyright>
 * </copyright>
 *
 * $Id: CatchParameter.java,v 1.5 2008/12/05 15:44:34 stammel Exp $
 */
package de.fzi.gast.variables;

import de.fzi.gast.functions.Function;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Catch Parameter</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class models a parameter of a catch expression.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.variables.CatchParameter#isRethrown <em>Rethrown</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.variables.variablesPackage#getCatchParameter()
 * @model
 * @generated
 */
public interface CatchParameter extends Variable {
	/**
	 * Returns the value of the '<em><b>Rethrown</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is true if the exception, which is handled by this catch parameter is rethrown to the caller.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Rethrown</em>' attribute.
	 * @see #setRethrown(boolean)
	 * @see de.fzi.gast.variables.variablesPackage#getCatchParameter_Rethrown()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	boolean isRethrown();

	/**
	 * Sets the value of the '{@link de.fzi.gast.variables.CatchParameter#isRethrown <em>Rethrown</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Rethrown</em>' attribute.
	 * @see #isRethrown()
	 * @generated
	 */
	void setRethrown(boolean value);

} // CatchParameter
