/**
 * <copyright>
 * </copyright>
 *
 * $Id: typesSwitch.java,v 1.5 2008/12/05 15:44:35 stammel Exp $
 */
package de.fzi.gast.types.util;

import java.util.List;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import de.fzi.gast.core.GenericEntity;
import de.fzi.gast.core.Identifier;
import de.fzi.gast.core.ModelElement;
import de.fzi.gast.core.NamedModelElement;
import de.fzi.gast.core.SourceEntity;
import de.fzi.gast.types.*;
import de.fzi.gast.types.GASTArray;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.GASTType;
import de.fzi.gast.types.GenericClass;
import de.fzi.gast.types.Member;
import de.fzi.gast.types.Reference;
import de.fzi.gast.types.TypeAlias;
import de.fzi.gast.types.TypeDecorator;
import de.fzi.gast.types.TypeParameterClass;
import de.fzi.gast.types.typesPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Switch</b> for the model's inheritance hierarchy.
 * It supports the call {@link #doSwitch(EObject) doSwitch(object)}
 * to invoke the <code>caseXXX</code> method for each class of the model,
 * starting with the actual class of the object
 * and proceeding up the inheritance hierarchy
 * until a non-null result is returned,
 * which is the result of the switch.
 * <!-- end-user-doc -->
 * @see de.fzi.gast.types.typesPackage
 * @generated
 */
public class typesSwitch<T> {
	/**
	 * The cached model package
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected static typesPackage modelPackage;

	/**
	 * Creates an instance of the switch.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public typesSwitch() {
		if (modelPackage == null) {
			modelPackage = typesPackage.eINSTANCE;
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	public T doSwitch(EObject theEObject) {
		return doSwitch(theEObject.eClass(), theEObject);
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(EClass theEClass, EObject theEObject) {
		if (theEClass.eContainer() == modelPackage) {
			return doSwitch(theEClass.getClassifierID(), theEObject);
		}
		else {
			List<EClass> eSuperTypes = theEClass.getESuperTypes();
			return
				eSuperTypes.isEmpty() ?
					defaultCase(theEObject) :
					doSwitch(eSuperTypes.get(0), theEObject);
		}
	}

	/**
	 * Calls <code>caseXXX</code> for each class of the model until one returns a non null result; it yields that result.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the first non-null result returned by a <code>caseXXX</code> call.
	 * @generated
	 */
	protected T doSwitch(int classifierID, EObject theEObject) {
		switch (classifierID) {
			case typesPackage.REFERENCE: {
				Reference reference = (Reference)theEObject;
				T result = caseReference(reference);
				if (result == null) result = caseTypeDecorator(reference);
				if (result == null) result = caseGASTType(reference);
				if (result == null) result = caseNamedModelElement(reference);
				if (result == null) result = caseModelElement(reference);
				if (result == null) result = caseIdentifier(reference);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case typesPackage.TYPE_DECORATOR: {
				TypeDecorator typeDecorator = (TypeDecorator)theEObject;
				T result = caseTypeDecorator(typeDecorator);
				if (result == null) result = caseGASTType(typeDecorator);
				if (result == null) result = caseNamedModelElement(typeDecorator);
				if (result == null) result = caseModelElement(typeDecorator);
				if (result == null) result = caseIdentifier(typeDecorator);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case typesPackage.GAST_TYPE: {
				GASTType gastType = (GASTType)theEObject;
				T result = caseGASTType(gastType);
				if (result == null) result = caseNamedModelElement(gastType);
				if (result == null) result = caseModelElement(gastType);
				if (result == null) result = caseIdentifier(gastType);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case typesPackage.GAST_ARRAY: {
				GASTArray gastArray = (GASTArray)theEObject;
				T result = caseGASTArray(gastArray);
				if (result == null) result = caseTypeDecorator(gastArray);
				if (result == null) result = caseGASTType(gastArray);
				if (result == null) result = caseNamedModelElement(gastArray);
				if (result == null) result = caseModelElement(gastArray);
				if (result == null) result = caseIdentifier(gastArray);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case typesPackage.TYPE_ALIAS: {
				TypeAlias typeAlias = (TypeAlias)theEObject;
				T result = caseTypeAlias(typeAlias);
				if (result == null) result = caseMember(typeAlias);
				if (result == null) result = caseTypeDecorator(typeAlias);
				if (result == null) result = caseSourceEntity(typeAlias);
				if (result == null) result = caseGASTType(typeAlias);
				if (result == null) result = caseNamedModelElement(typeAlias);
				if (result == null) result = caseModelElement(typeAlias);
				if (result == null) result = caseIdentifier(typeAlias);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case typesPackage.MEMBER: {
				Member member = (Member)theEObject;
				T result = caseMember(member);
				if (result == null) result = caseSourceEntity(member);
				if (result == null) result = caseModelElement(member);
				if (result == null) result = caseIdentifier(member);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case typesPackage.TYPE_PARAMETER_CLASS: {
				TypeParameterClass typeParameterClass = (TypeParameterClass)theEObject;
				T result = caseTypeParameterClass(typeParameterClass);
				if (result == null) result = caseGASTClass(typeParameterClass);
				if (result == null) result = caseMember(typeParameterClass);
				if (result == null) result = caseGASTType(typeParameterClass);
				if (result == null) result = caseSourceEntity(typeParameterClass);
				if (result == null) result = caseNamedModelElement(typeParameterClass);
				if (result == null) result = caseModelElement(typeParameterClass);
				if (result == null) result = caseIdentifier(typeParameterClass);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case typesPackage.GENERIC_CLASS: {
				GenericClass genericClass = (GenericClass)theEObject;
				T result = caseGenericClass(genericClass);
				if (result == null) result = caseGASTClass(genericClass);
				if (result == null) result = caseGenericEntity(genericClass);
				if (result == null) result = caseMember(genericClass);
				if (result == null) result = caseGASTType(genericClass);
				if (result == null) result = caseSourceEntity(genericClass);
				if (result == null) result = caseNamedModelElement(genericClass);
				if (result == null) result = caseModelElement(genericClass);
				if (result == null) result = caseIdentifier(genericClass);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case typesPackage.GAST_ENUMERATION: {
				GASTEnumeration gastEnumeration = (GASTEnumeration)theEObject;
				T result = caseGASTEnumeration(gastEnumeration);
				if (result == null) result = caseGASTClass(gastEnumeration);
				if (result == null) result = caseMember(gastEnumeration);
				if (result == null) result = caseGASTType(gastEnumeration);
				if (result == null) result = caseSourceEntity(gastEnumeration);
				if (result == null) result = caseNamedModelElement(gastEnumeration);
				if (result == null) result = caseModelElement(gastEnumeration);
				if (result == null) result = caseIdentifier(gastEnumeration);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case typesPackage.GAST_STRUCT: {
				GASTStruct gastStruct = (GASTStruct)theEObject;
				T result = caseGASTStruct(gastStruct);
				if (result == null) result = caseGASTClass(gastStruct);
				if (result == null) result = caseMember(gastStruct);
				if (result == null) result = caseGASTType(gastStruct);
				if (result == null) result = caseSourceEntity(gastStruct);
				if (result == null) result = caseNamedModelElement(gastStruct);
				if (result == null) result = caseModelElement(gastStruct);
				if (result == null) result = caseIdentifier(gastStruct);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case typesPackage.GAST_UNION: {
				GASTUnion gastUnion = (GASTUnion)theEObject;
				T result = caseGASTUnion(gastUnion);
				if (result == null) result = caseGASTClass(gastUnion);
				if (result == null) result = caseMember(gastUnion);
				if (result == null) result = caseGASTType(gastUnion);
				if (result == null) result = caseSourceEntity(gastUnion);
				if (result == null) result = caseNamedModelElement(gastUnion);
				if (result == null) result = caseModelElement(gastUnion);
				if (result == null) result = caseIdentifier(gastUnion);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			case typesPackage.GAST_CLASS: {
				GASTClass gastClass = (GASTClass)theEObject;
				T result = caseGASTClass(gastClass);
				if (result == null) result = caseMember(gastClass);
				if (result == null) result = caseGASTType(gastClass);
				if (result == null) result = caseSourceEntity(gastClass);
				if (result == null) result = caseNamedModelElement(gastClass);
				if (result == null) result = caseModelElement(gastClass);
				if (result == null) result = caseIdentifier(gastClass);
				if (result == null) result = defaultCase(theEObject);
				return result;
			}
			default: return defaultCase(theEObject);
		}
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Reference</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Reference</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseReference(Reference object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Type Decorator</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Type Decorator</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTypeDecorator(TypeDecorator object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>GAST Type</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>GAST Type</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGASTType(GASTType object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>GAST Array</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>GAST Array</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGASTArray(GASTArray object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Type Alias</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Type Alias</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTypeAlias(TypeAlias object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Member</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Member</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseMember(Member object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Type Parameter Class</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Type Parameter Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseTypeParameterClass(TypeParameterClass object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Generic Class</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Generic Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGenericClass(GenericClass object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>GAST Enumeration</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>GAST Enumeration</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGASTEnumeration(GASTEnumeration object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>GAST Struct</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>GAST Struct</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGASTStruct(GASTStruct object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>GAST Union</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>GAST Union</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGASTUnion(GASTUnion object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>GAST Class</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>GAST Class</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGASTClass(GASTClass object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Identifier</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Identifier</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseIdentifier(Identifier object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Model Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Model Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseModelElement(ModelElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Named Model Element</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Named Model Element</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseNamedModelElement(NamedModelElement object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Source Entity</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Source Entity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseSourceEntity(SourceEntity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>Generic Entity</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>Generic Entity</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject) doSwitch(EObject)
	 * @generated
	 */
	public T caseGenericEntity(GenericEntity object) {
		return null;
	}

	/**
	 * Returns the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * <!-- begin-user-doc -->
	 * This implementation returns null;
	 * returning a non-null result will terminate the switch, but this is the last case anyway.
	 * <!-- end-user-doc -->
	 * @param object the target of the switch.
	 * @return the result of interpreting the object as an instance of '<em>EObject</em>'.
	 * @see #doSwitch(org.eclipse.emf.ecore.EObject)
	 * @generated
	 */
	public T defaultCase(EObject object) {
		return null;
	}

} //typesSwitch
