/**
 * <copyright>
 * </copyright>
 *
 * $Id: typesPackage.java,v 1.6 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.types;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import de.fzi.gast.core.corePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * This package contains all classes and interfaces which belong to the type hierarchy.
 * <!-- end-model-doc -->
 * @see de.fzi.gast.types.typesFactory
 * @model kind="package"
 * @generated
 */
public interface typesPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "types";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.fzi.de/gast/types";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "types";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	typesPackage eINSTANCE = de.fzi.gast.types.impl.typesPackageImpl.init();

	/**
	 * The meta object id for the '{@link de.fzi.gast.types.impl.GASTTypeImpl <em>GAST Type</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.types.impl.GASTTypeImpl
	 * @see de.fzi.gast.types.impl.typesPackageImpl#getGASTType()
	 * @generated
	 */
	int GAST_TYPE = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_TYPE__ID = corePackage.NAMED_MODEL_ELEMENT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_TYPE__ANNOTATIONS = corePackage.NAMED_MODEL_ELEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_TYPE__STATUS = corePackage.NAMED_MODEL_ELEMENT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_TYPE__SISSY_ID = corePackage.NAMED_MODEL_ELEMENT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_TYPE__SIMPLE_NAME = corePackage.NAMED_MODEL_ELEMENT__SIMPLE_NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_TYPE__QUALIFIED_NAME = corePackage.NAMED_MODEL_ELEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Reference Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_TYPE__REFERENCE_TYPE = corePackage.NAMED_MODEL_ELEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>GAST Type</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_TYPE_FEATURE_COUNT = corePackage.NAMED_MODEL_ELEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.fzi.gast.types.impl.TypeDecoratorImpl <em>Type Decorator</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.types.impl.TypeDecoratorImpl
	 * @see de.fzi.gast.types.impl.typesPackageImpl#getTypeDecorator()
	 * @generated
	 */
	int TYPE_DECORATOR = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DECORATOR__ID = GAST_TYPE__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DECORATOR__ANNOTATIONS = GAST_TYPE__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DECORATOR__STATUS = GAST_TYPE__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DECORATOR__SISSY_ID = GAST_TYPE__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DECORATOR__SIMPLE_NAME = GAST_TYPE__SIMPLE_NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DECORATOR__QUALIFIED_NAME = GAST_TYPE__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Reference Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DECORATOR__REFERENCE_TYPE = GAST_TYPE__REFERENCE_TYPE;

	/**
	 * The feature id for the '<em><b>Decorated Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DECORATOR__DECORATED_TYPE = GAST_TYPE_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Undecorated Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DECORATOR__UNDECORATED_TYPE = GAST_TYPE_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Type Decorator</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_DECORATOR_FEATURE_COUNT = GAST_TYPE_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.fzi.gast.types.impl.ReferenceImpl <em>Reference</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.types.impl.ReferenceImpl
	 * @see de.fzi.gast.types.impl.typesPackageImpl#getReference()
	 * @generated
	 */
	int REFERENCE = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE__ID = TYPE_DECORATOR__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE__ANNOTATIONS = TYPE_DECORATOR__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE__STATUS = TYPE_DECORATOR__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE__SISSY_ID = TYPE_DECORATOR__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE__SIMPLE_NAME = TYPE_DECORATOR__SIMPLE_NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE__QUALIFIED_NAME = TYPE_DECORATOR__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Reference Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE__REFERENCE_TYPE = TYPE_DECORATOR__REFERENCE_TYPE;

	/**
	 * The feature id for the '<em><b>Decorated Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE__DECORATED_TYPE = TYPE_DECORATOR__DECORATED_TYPE;

	/**
	 * The feature id for the '<em><b>Undecorated Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE__UNDECORATED_TYPE = TYPE_DECORATOR__UNDECORATED_TYPE;

	/**
	 * The feature id for the '<em><b>Referenced Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE__REFERENCED_TYPE = TYPE_DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Explicit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE__EXPLICIT = TYPE_DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Reference</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int REFERENCE_FEATURE_COUNT = TYPE_DECORATOR_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.fzi.gast.types.impl.GASTArrayImpl <em>GAST Array</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.types.impl.GASTArrayImpl
	 * @see de.fzi.gast.types.impl.typesPackageImpl#getGASTArray()
	 * @generated
	 */
	int GAST_ARRAY = 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ARRAY__ID = TYPE_DECORATOR__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ARRAY__ANNOTATIONS = TYPE_DECORATOR__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ARRAY__STATUS = TYPE_DECORATOR__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ARRAY__SISSY_ID = TYPE_DECORATOR__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ARRAY__SIMPLE_NAME = TYPE_DECORATOR__SIMPLE_NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ARRAY__QUALIFIED_NAME = TYPE_DECORATOR__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Reference Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ARRAY__REFERENCE_TYPE = TYPE_DECORATOR__REFERENCE_TYPE;

	/**
	 * The feature id for the '<em><b>Decorated Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ARRAY__DECORATED_TYPE = TYPE_DECORATOR__DECORATED_TYPE;

	/**
	 * The feature id for the '<em><b>Undecorated Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ARRAY__UNDECORATED_TYPE = TYPE_DECORATOR__UNDECORATED_TYPE;

	/**
	 * The feature id for the '<em><b>Base Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ARRAY__BASE_TYPE = TYPE_DECORATOR_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Dimensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ARRAY__DIMENSIONS = TYPE_DECORATOR_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>GAST Array</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ARRAY_FEATURE_COUNT = TYPE_DECORATOR_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.fzi.gast.types.impl.MemberImpl <em>Member</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.types.impl.MemberImpl
	 * @see de.fzi.gast.types.impl.typesPackageImpl#getMember()
	 * @generated
	 */
	int MEMBER = 5;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__ID = corePackage.SOURCE_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__ANNOTATIONS = corePackage.SOURCE_ENTITY__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__STATUS = corePackage.SOURCE_ENTITY__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__SISSY_ID = corePackage.SOURCE_ENTITY__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__POSITION = corePackage.SOURCE_ENTITY__POSITION;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__VISIBILITY = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Overridden Member</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__OVERRIDDEN_MEMBER = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Abstract</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__ABSTRACT = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Extern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__EXTERN = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Final</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__FINAL = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Internal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__INTERNAL = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Introspectable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__INTROSPECTABLE = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Override</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__OVERRIDE = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Static</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__STATIC = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Type Parameter Class Member</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__TYPE_PARAMETER_CLASS_MEMBER = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER__VIRTUAL = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 10;

	/**
	 * The number of structural features of the '<em>Member</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int MEMBER_FEATURE_COUNT = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 11;

	/**
	 * The meta object id for the '{@link de.fzi.gast.types.impl.TypeAliasImpl <em>Type Alias</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.types.impl.TypeAliasImpl
	 * @see de.fzi.gast.types.impl.typesPackageImpl#getTypeAlias()
	 * @generated
	 */
	int TYPE_ALIAS = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__ID = MEMBER__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__ANNOTATIONS = MEMBER__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__STATUS = MEMBER__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__SISSY_ID = MEMBER__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__POSITION = MEMBER__POSITION;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__VISIBILITY = MEMBER__VISIBILITY;

	/**
	 * The feature id for the '<em><b>Overridden Member</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__OVERRIDDEN_MEMBER = MEMBER__OVERRIDDEN_MEMBER;

	/**
	 * The feature id for the '<em><b>Abstract</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__ABSTRACT = MEMBER__ABSTRACT;

	/**
	 * The feature id for the '<em><b>Extern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__EXTERN = MEMBER__EXTERN;

	/**
	 * The feature id for the '<em><b>Final</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__FINAL = MEMBER__FINAL;

	/**
	 * The feature id for the '<em><b>Internal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__INTERNAL = MEMBER__INTERNAL;

	/**
	 * The feature id for the '<em><b>Introspectable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__INTROSPECTABLE = MEMBER__INTROSPECTABLE;

	/**
	 * The feature id for the '<em><b>Override</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__OVERRIDE = MEMBER__OVERRIDE;

	/**
	 * The feature id for the '<em><b>Static</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__STATIC = MEMBER__STATIC;

	/**
	 * The feature id for the '<em><b>Type Parameter Class Member</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__TYPE_PARAMETER_CLASS_MEMBER = MEMBER__TYPE_PARAMETER_CLASS_MEMBER;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__VIRTUAL = MEMBER__VIRTUAL;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__SIMPLE_NAME = MEMBER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__QUALIFIED_NAME = MEMBER_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Reference Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__REFERENCE_TYPE = MEMBER_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Decorated Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__DECORATED_TYPE = MEMBER_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Undecorated Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__UNDECORATED_TYPE = MEMBER_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Aliased Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__ALIASED_TYPE = MEMBER_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Inner Type Alias</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__INNER_TYPE_ALIAS = MEMBER_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__SURROUNDING_CLASS = MEMBER_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Surrounding Package</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS__SURROUNDING_PACKAGE = MEMBER_FEATURE_COUNT + 8;

	/**
	 * The number of structural features of the '<em>Type Alias</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_ALIAS_FEATURE_COUNT = MEMBER_FEATURE_COUNT + 9;

	/**
	 * The meta object id for the '{@link de.fzi.gast.types.impl.GASTClassImpl <em>GAST Class</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.types.impl.GASTClassImpl
	 * @see de.fzi.gast.types.impl.typesPackageImpl#getGASTClass()
	 * @generated
	 */
	int GAST_CLASS = 11;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__ID = MEMBER__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__ANNOTATIONS = MEMBER__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__STATUS = MEMBER__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__SISSY_ID = MEMBER__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__POSITION = MEMBER__POSITION;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__VISIBILITY = MEMBER__VISIBILITY;

	/**
	 * The feature id for the '<em><b>Overridden Member</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__OVERRIDDEN_MEMBER = MEMBER__OVERRIDDEN_MEMBER;

	/**
	 * The feature id for the '<em><b>Abstract</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__ABSTRACT = MEMBER__ABSTRACT;

	/**
	 * The feature id for the '<em><b>Extern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__EXTERN = MEMBER__EXTERN;

	/**
	 * The feature id for the '<em><b>Final</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__FINAL = MEMBER__FINAL;

	/**
	 * The feature id for the '<em><b>Internal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__INTERNAL = MEMBER__INTERNAL;

	/**
	 * The feature id for the '<em><b>Introspectable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__INTROSPECTABLE = MEMBER__INTROSPECTABLE;

	/**
	 * The feature id for the '<em><b>Override</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__OVERRIDE = MEMBER__OVERRIDE;

	/**
	 * The feature id for the '<em><b>Static</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__STATIC = MEMBER__STATIC;

	/**
	 * The feature id for the '<em><b>Type Parameter Class Member</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__TYPE_PARAMETER_CLASS_MEMBER = MEMBER__TYPE_PARAMETER_CLASS_MEMBER;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__VIRTUAL = MEMBER__VIRTUAL;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__SIMPLE_NAME = MEMBER_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__QUALIFIED_NAME = MEMBER_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Reference Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__REFERENCE_TYPE = MEMBER_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Inner Type Aliases</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__INNER_TYPE_ALIASES = MEMBER_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Inner Delegates</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__INNER_DELEGATES = MEMBER_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Constructors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__CONSTRUCTORS = MEMBER_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Destructors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__DESTRUCTORS = MEMBER_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Fields</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__FIELDS = MEMBER_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Methods</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__METHODS = MEMBER_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__SURROUNDING_FUNCTION = MEMBER_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Surrounding Package</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__SURROUNDING_PACKAGE = MEMBER_FEATURE_COUNT + 10;

	/**
	 * The feature id for the '<em><b>Super Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__SUPER_TYPES = MEMBER_FEATURE_COUNT + 11;

	/**
	 * The feature id for the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__LINES_OF_COMMENTS = MEMBER_FEATURE_COUNT + 12;

	/**
	 * The feature id for the '<em><b>Local</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__LOCAL = MEMBER_FEATURE_COUNT + 13;

	/**
	 * The feature id for the '<em><b>Primitive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__PRIMITIVE = MEMBER_FEATURE_COUNT + 14;

	/**
	 * The feature id for the '<em><b>Interface</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__INTERFACE = MEMBER_FEATURE_COUNT + 15;

	/**
	 * The feature id for the '<em><b>Anonymous</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__ANONYMOUS = MEMBER_FEATURE_COUNT + 16;

	/**
	 * The feature id for the '<em><b>Inner Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__INNER_CLASSES = MEMBER_FEATURE_COUNT + 17;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__SURROUNDING_CLASS = MEMBER_FEATURE_COUNT + 18;

	/**
	 * The feature id for the '<em><b>Inheritance Type Accesses</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__INHERITANCE_TYPE_ACCESSES = MEMBER_FEATURE_COUNT + 19;

	/**
	 * The feature id for the '<em><b>Self</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__SELF = MEMBER_FEATURE_COUNT + 20;

	/**
	 * The feature id for the '<em><b>Friend Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__FRIEND_CLASSES = MEMBER_FEATURE_COUNT + 21;

	/**
	 * The feature id for the '<em><b>Friend Functions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__FRIEND_FUNCTIONS = MEMBER_FEATURE_COUNT + 22;

	/**
	 * The feature id for the '<em><b>Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__PROPERTY = MEMBER_FEATURE_COUNT + 23;

	/**
	 * The feature id for the '<em><b>All Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__ALL_ACCESSES = MEMBER_FEATURE_COUNT + 24;

	/**
	 * The feature id for the '<em><b>All Accessed Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__ALL_ACCESSED_CLASSES = MEMBER_FEATURE_COUNT + 25;

	/**
	 * The feature id for the '<em><b>Inner</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS__INNER = MEMBER_FEATURE_COUNT + 26;

	/**
	 * The number of structural features of the '<em>GAST Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_CLASS_FEATURE_COUNT = MEMBER_FEATURE_COUNT + 27;

	/**
	 * The meta object id for the '{@link de.fzi.gast.types.impl.TypeParameterClassImpl <em>Type Parameter Class</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.types.impl.TypeParameterClassImpl
	 * @see de.fzi.gast.types.impl.typesPackageImpl#getTypeParameterClass()
	 * @generated
	 */
	int TYPE_PARAMETER_CLASS = 6;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__ID = GAST_CLASS__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__ANNOTATIONS = GAST_CLASS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__STATUS = GAST_CLASS__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__SISSY_ID = GAST_CLASS__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__POSITION = GAST_CLASS__POSITION;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__VISIBILITY = GAST_CLASS__VISIBILITY;

	/**
	 * The feature id for the '<em><b>Overridden Member</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__OVERRIDDEN_MEMBER = GAST_CLASS__OVERRIDDEN_MEMBER;

	/**
	 * The feature id for the '<em><b>Abstract</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__ABSTRACT = GAST_CLASS__ABSTRACT;

	/**
	 * The feature id for the '<em><b>Extern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__EXTERN = GAST_CLASS__EXTERN;

	/**
	 * The feature id for the '<em><b>Final</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__FINAL = GAST_CLASS__FINAL;

	/**
	 * The feature id for the '<em><b>Internal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__INTERNAL = GAST_CLASS__INTERNAL;

	/**
	 * The feature id for the '<em><b>Introspectable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__INTROSPECTABLE = GAST_CLASS__INTROSPECTABLE;

	/**
	 * The feature id for the '<em><b>Override</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__OVERRIDE = GAST_CLASS__OVERRIDE;

	/**
	 * The feature id for the '<em><b>Static</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__STATIC = GAST_CLASS__STATIC;

	/**
	 * The feature id for the '<em><b>Type Parameter Class Member</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__TYPE_PARAMETER_CLASS_MEMBER = GAST_CLASS__TYPE_PARAMETER_CLASS_MEMBER;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__VIRTUAL = GAST_CLASS__VIRTUAL;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__SIMPLE_NAME = GAST_CLASS__SIMPLE_NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__QUALIFIED_NAME = GAST_CLASS__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Reference Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__REFERENCE_TYPE = GAST_CLASS__REFERENCE_TYPE;

	/**
	 * The feature id for the '<em><b>Inner Type Aliases</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__INNER_TYPE_ALIASES = GAST_CLASS__INNER_TYPE_ALIASES;

	/**
	 * The feature id for the '<em><b>Inner Delegates</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__INNER_DELEGATES = GAST_CLASS__INNER_DELEGATES;

	/**
	 * The feature id for the '<em><b>Constructors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__CONSTRUCTORS = GAST_CLASS__CONSTRUCTORS;

	/**
	 * The feature id for the '<em><b>Destructors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__DESTRUCTORS = GAST_CLASS__DESTRUCTORS;

	/**
	 * The feature id for the '<em><b>Fields</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__FIELDS = GAST_CLASS__FIELDS;

	/**
	 * The feature id for the '<em><b>Methods</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__METHODS = GAST_CLASS__METHODS;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__SURROUNDING_FUNCTION = GAST_CLASS__SURROUNDING_FUNCTION;

	/**
	 * The feature id for the '<em><b>Surrounding Package</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__SURROUNDING_PACKAGE = GAST_CLASS__SURROUNDING_PACKAGE;

	/**
	 * The feature id for the '<em><b>Super Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__SUPER_TYPES = GAST_CLASS__SUPER_TYPES;

	/**
	 * The feature id for the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__LINES_OF_COMMENTS = GAST_CLASS__LINES_OF_COMMENTS;

	/**
	 * The feature id for the '<em><b>Local</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__LOCAL = GAST_CLASS__LOCAL;

	/**
	 * The feature id for the '<em><b>Primitive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__PRIMITIVE = GAST_CLASS__PRIMITIVE;

	/**
	 * The feature id for the '<em><b>Interface</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__INTERFACE = GAST_CLASS__INTERFACE;

	/**
	 * The feature id for the '<em><b>Anonymous</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__ANONYMOUS = GAST_CLASS__ANONYMOUS;

	/**
	 * The feature id for the '<em><b>Inner Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__INNER_CLASSES = GAST_CLASS__INNER_CLASSES;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__SURROUNDING_CLASS = GAST_CLASS__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Inheritance Type Accesses</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__INHERITANCE_TYPE_ACCESSES = GAST_CLASS__INHERITANCE_TYPE_ACCESSES;

	/**
	 * The feature id for the '<em><b>Self</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__SELF = GAST_CLASS__SELF;

	/**
	 * The feature id for the '<em><b>Friend Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__FRIEND_CLASSES = GAST_CLASS__FRIEND_CLASSES;

	/**
	 * The feature id for the '<em><b>Friend Functions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__FRIEND_FUNCTIONS = GAST_CLASS__FRIEND_FUNCTIONS;

	/**
	 * The feature id for the '<em><b>Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__PROPERTY = GAST_CLASS__PROPERTY;

	/**
	 * The feature id for the '<em><b>All Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__ALL_ACCESSES = GAST_CLASS__ALL_ACCESSES;

	/**
	 * The feature id for the '<em><b>All Accessed Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__ALL_ACCESSED_CLASSES = GAST_CLASS__ALL_ACCESSED_CLASSES;

	/**
	 * The feature id for the '<em><b>Inner</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__INNER = GAST_CLASS__INNER;

	/**
	 * The feature id for the '<em><b>Type Bounds</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS__TYPE_BOUNDS = GAST_CLASS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Type Parameter Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TYPE_PARAMETER_CLASS_FEATURE_COUNT = GAST_CLASS_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.types.impl.GenericClassImpl <em>Generic Class</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.types.impl.GenericClassImpl
	 * @see de.fzi.gast.types.impl.typesPackageImpl#getGenericClass()
	 * @generated
	 */
	int GENERIC_CLASS = 7;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__ID = GAST_CLASS__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__ANNOTATIONS = GAST_CLASS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__STATUS = GAST_CLASS__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__SISSY_ID = GAST_CLASS__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__POSITION = GAST_CLASS__POSITION;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__VISIBILITY = GAST_CLASS__VISIBILITY;

	/**
	 * The feature id for the '<em><b>Overridden Member</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__OVERRIDDEN_MEMBER = GAST_CLASS__OVERRIDDEN_MEMBER;

	/**
	 * The feature id for the '<em><b>Abstract</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__ABSTRACT = GAST_CLASS__ABSTRACT;

	/**
	 * The feature id for the '<em><b>Extern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__EXTERN = GAST_CLASS__EXTERN;

	/**
	 * The feature id for the '<em><b>Final</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__FINAL = GAST_CLASS__FINAL;

	/**
	 * The feature id for the '<em><b>Internal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__INTERNAL = GAST_CLASS__INTERNAL;

	/**
	 * The feature id for the '<em><b>Introspectable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__INTROSPECTABLE = GAST_CLASS__INTROSPECTABLE;

	/**
	 * The feature id for the '<em><b>Override</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__OVERRIDE = GAST_CLASS__OVERRIDE;

	/**
	 * The feature id for the '<em><b>Static</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__STATIC = GAST_CLASS__STATIC;

	/**
	 * The feature id for the '<em><b>Type Parameter Class Member</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__TYPE_PARAMETER_CLASS_MEMBER = GAST_CLASS__TYPE_PARAMETER_CLASS_MEMBER;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__VIRTUAL = GAST_CLASS__VIRTUAL;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__SIMPLE_NAME = GAST_CLASS__SIMPLE_NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__QUALIFIED_NAME = GAST_CLASS__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Reference Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__REFERENCE_TYPE = GAST_CLASS__REFERENCE_TYPE;

	/**
	 * The feature id for the '<em><b>Inner Type Aliases</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__INNER_TYPE_ALIASES = GAST_CLASS__INNER_TYPE_ALIASES;

	/**
	 * The feature id for the '<em><b>Inner Delegates</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__INNER_DELEGATES = GAST_CLASS__INNER_DELEGATES;

	/**
	 * The feature id for the '<em><b>Constructors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__CONSTRUCTORS = GAST_CLASS__CONSTRUCTORS;

	/**
	 * The feature id for the '<em><b>Destructors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__DESTRUCTORS = GAST_CLASS__DESTRUCTORS;

	/**
	 * The feature id for the '<em><b>Fields</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__FIELDS = GAST_CLASS__FIELDS;

	/**
	 * The feature id for the '<em><b>Methods</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__METHODS = GAST_CLASS__METHODS;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__SURROUNDING_FUNCTION = GAST_CLASS__SURROUNDING_FUNCTION;

	/**
	 * The feature id for the '<em><b>Surrounding Package</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__SURROUNDING_PACKAGE = GAST_CLASS__SURROUNDING_PACKAGE;

	/**
	 * The feature id for the '<em><b>Super Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__SUPER_TYPES = GAST_CLASS__SUPER_TYPES;

	/**
	 * The feature id for the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__LINES_OF_COMMENTS = GAST_CLASS__LINES_OF_COMMENTS;

	/**
	 * The feature id for the '<em><b>Local</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__LOCAL = GAST_CLASS__LOCAL;

	/**
	 * The feature id for the '<em><b>Primitive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__PRIMITIVE = GAST_CLASS__PRIMITIVE;

	/**
	 * The feature id for the '<em><b>Interface</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__INTERFACE = GAST_CLASS__INTERFACE;

	/**
	 * The feature id for the '<em><b>Anonymous</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__ANONYMOUS = GAST_CLASS__ANONYMOUS;

	/**
	 * The feature id for the '<em><b>Inner Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__INNER_CLASSES = GAST_CLASS__INNER_CLASSES;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__SURROUNDING_CLASS = GAST_CLASS__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Inheritance Type Accesses</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__INHERITANCE_TYPE_ACCESSES = GAST_CLASS__INHERITANCE_TYPE_ACCESSES;

	/**
	 * The feature id for the '<em><b>Self</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__SELF = GAST_CLASS__SELF;

	/**
	 * The feature id for the '<em><b>Friend Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__FRIEND_CLASSES = GAST_CLASS__FRIEND_CLASSES;

	/**
	 * The feature id for the '<em><b>Friend Functions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__FRIEND_FUNCTIONS = GAST_CLASS__FRIEND_FUNCTIONS;

	/**
	 * The feature id for the '<em><b>Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__PROPERTY = GAST_CLASS__PROPERTY;

	/**
	 * The feature id for the '<em><b>All Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__ALL_ACCESSES = GAST_CLASS__ALL_ACCESSES;

	/**
	 * The feature id for the '<em><b>All Accessed Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__ALL_ACCESSED_CLASSES = GAST_CLASS__ALL_ACCESSED_CLASSES;

	/**
	 * The feature id for the '<em><b>Inner</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__INNER = GAST_CLASS__INNER;

	/**
	 * The feature id for the '<em><b>Type Parameters</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS__TYPE_PARAMETERS = GAST_CLASS_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Generic Class</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GENERIC_CLASS_FEATURE_COUNT = GAST_CLASS_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.types.impl.GASTEnumerationImpl <em>GAST Enumeration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.types.impl.GASTEnumerationImpl
	 * @see de.fzi.gast.types.impl.typesPackageImpl#getGASTEnumeration()
	 * @generated
	 */
	int GAST_ENUMERATION = 8;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__ID = GAST_CLASS__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__ANNOTATIONS = GAST_CLASS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__STATUS = GAST_CLASS__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__SISSY_ID = GAST_CLASS__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__POSITION = GAST_CLASS__POSITION;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__VISIBILITY = GAST_CLASS__VISIBILITY;

	/**
	 * The feature id for the '<em><b>Overridden Member</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__OVERRIDDEN_MEMBER = GAST_CLASS__OVERRIDDEN_MEMBER;

	/**
	 * The feature id for the '<em><b>Abstract</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__ABSTRACT = GAST_CLASS__ABSTRACT;

	/**
	 * The feature id for the '<em><b>Extern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__EXTERN = GAST_CLASS__EXTERN;

	/**
	 * The feature id for the '<em><b>Final</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__FINAL = GAST_CLASS__FINAL;

	/**
	 * The feature id for the '<em><b>Internal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__INTERNAL = GAST_CLASS__INTERNAL;

	/**
	 * The feature id for the '<em><b>Introspectable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__INTROSPECTABLE = GAST_CLASS__INTROSPECTABLE;

	/**
	 * The feature id for the '<em><b>Override</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__OVERRIDE = GAST_CLASS__OVERRIDE;

	/**
	 * The feature id for the '<em><b>Static</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__STATIC = GAST_CLASS__STATIC;

	/**
	 * The feature id for the '<em><b>Type Parameter Class Member</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__TYPE_PARAMETER_CLASS_MEMBER = GAST_CLASS__TYPE_PARAMETER_CLASS_MEMBER;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__VIRTUAL = GAST_CLASS__VIRTUAL;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__SIMPLE_NAME = GAST_CLASS__SIMPLE_NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__QUALIFIED_NAME = GAST_CLASS__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Reference Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__REFERENCE_TYPE = GAST_CLASS__REFERENCE_TYPE;

	/**
	 * The feature id for the '<em><b>Inner Type Aliases</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__INNER_TYPE_ALIASES = GAST_CLASS__INNER_TYPE_ALIASES;

	/**
	 * The feature id for the '<em><b>Inner Delegates</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__INNER_DELEGATES = GAST_CLASS__INNER_DELEGATES;

	/**
	 * The feature id for the '<em><b>Constructors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__CONSTRUCTORS = GAST_CLASS__CONSTRUCTORS;

	/**
	 * The feature id for the '<em><b>Destructors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__DESTRUCTORS = GAST_CLASS__DESTRUCTORS;

	/**
	 * The feature id for the '<em><b>Fields</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__FIELDS = GAST_CLASS__FIELDS;

	/**
	 * The feature id for the '<em><b>Methods</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__METHODS = GAST_CLASS__METHODS;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__SURROUNDING_FUNCTION = GAST_CLASS__SURROUNDING_FUNCTION;

	/**
	 * The feature id for the '<em><b>Surrounding Package</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__SURROUNDING_PACKAGE = GAST_CLASS__SURROUNDING_PACKAGE;

	/**
	 * The feature id for the '<em><b>Super Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__SUPER_TYPES = GAST_CLASS__SUPER_TYPES;

	/**
	 * The feature id for the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__LINES_OF_COMMENTS = GAST_CLASS__LINES_OF_COMMENTS;

	/**
	 * The feature id for the '<em><b>Local</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__LOCAL = GAST_CLASS__LOCAL;

	/**
	 * The feature id for the '<em><b>Primitive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__PRIMITIVE = GAST_CLASS__PRIMITIVE;

	/**
	 * The feature id for the '<em><b>Interface</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__INTERFACE = GAST_CLASS__INTERFACE;

	/**
	 * The feature id for the '<em><b>Anonymous</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__ANONYMOUS = GAST_CLASS__ANONYMOUS;

	/**
	 * The feature id for the '<em><b>Inner Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__INNER_CLASSES = GAST_CLASS__INNER_CLASSES;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__SURROUNDING_CLASS = GAST_CLASS__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Inheritance Type Accesses</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__INHERITANCE_TYPE_ACCESSES = GAST_CLASS__INHERITANCE_TYPE_ACCESSES;

	/**
	 * The feature id for the '<em><b>Self</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__SELF = GAST_CLASS__SELF;

	/**
	 * The feature id for the '<em><b>Friend Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__FRIEND_CLASSES = GAST_CLASS__FRIEND_CLASSES;

	/**
	 * The feature id for the '<em><b>Friend Functions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__FRIEND_FUNCTIONS = GAST_CLASS__FRIEND_FUNCTIONS;

	/**
	 * The feature id for the '<em><b>Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__PROPERTY = GAST_CLASS__PROPERTY;

	/**
	 * The feature id for the '<em><b>All Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__ALL_ACCESSES = GAST_CLASS__ALL_ACCESSES;

	/**
	 * The feature id for the '<em><b>All Accessed Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__ALL_ACCESSED_CLASSES = GAST_CLASS__ALL_ACCESSED_CLASSES;

	/**
	 * The feature id for the '<em><b>Inner</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION__INNER = GAST_CLASS__INNER;

	/**
	 * The number of structural features of the '<em>GAST Enumeration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_ENUMERATION_FEATURE_COUNT = GAST_CLASS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.fzi.gast.types.impl.GASTStructImpl <em>GAST Struct</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.types.impl.GASTStructImpl
	 * @see de.fzi.gast.types.impl.typesPackageImpl#getGASTStruct()
	 * @generated
	 */
	int GAST_STRUCT = 9;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__ID = GAST_CLASS__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__ANNOTATIONS = GAST_CLASS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__STATUS = GAST_CLASS__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__SISSY_ID = GAST_CLASS__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__POSITION = GAST_CLASS__POSITION;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__VISIBILITY = GAST_CLASS__VISIBILITY;

	/**
	 * The feature id for the '<em><b>Overridden Member</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__OVERRIDDEN_MEMBER = GAST_CLASS__OVERRIDDEN_MEMBER;

	/**
	 * The feature id for the '<em><b>Abstract</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__ABSTRACT = GAST_CLASS__ABSTRACT;

	/**
	 * The feature id for the '<em><b>Extern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__EXTERN = GAST_CLASS__EXTERN;

	/**
	 * The feature id for the '<em><b>Final</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__FINAL = GAST_CLASS__FINAL;

	/**
	 * The feature id for the '<em><b>Internal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__INTERNAL = GAST_CLASS__INTERNAL;

	/**
	 * The feature id for the '<em><b>Introspectable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__INTROSPECTABLE = GAST_CLASS__INTROSPECTABLE;

	/**
	 * The feature id for the '<em><b>Override</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__OVERRIDE = GAST_CLASS__OVERRIDE;

	/**
	 * The feature id for the '<em><b>Static</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__STATIC = GAST_CLASS__STATIC;

	/**
	 * The feature id for the '<em><b>Type Parameter Class Member</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__TYPE_PARAMETER_CLASS_MEMBER = GAST_CLASS__TYPE_PARAMETER_CLASS_MEMBER;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__VIRTUAL = GAST_CLASS__VIRTUAL;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__SIMPLE_NAME = GAST_CLASS__SIMPLE_NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__QUALIFIED_NAME = GAST_CLASS__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Reference Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__REFERENCE_TYPE = GAST_CLASS__REFERENCE_TYPE;

	/**
	 * The feature id for the '<em><b>Inner Type Aliases</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__INNER_TYPE_ALIASES = GAST_CLASS__INNER_TYPE_ALIASES;

	/**
	 * The feature id for the '<em><b>Inner Delegates</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__INNER_DELEGATES = GAST_CLASS__INNER_DELEGATES;

	/**
	 * The feature id for the '<em><b>Constructors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__CONSTRUCTORS = GAST_CLASS__CONSTRUCTORS;

	/**
	 * The feature id for the '<em><b>Destructors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__DESTRUCTORS = GAST_CLASS__DESTRUCTORS;

	/**
	 * The feature id for the '<em><b>Fields</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__FIELDS = GAST_CLASS__FIELDS;

	/**
	 * The feature id for the '<em><b>Methods</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__METHODS = GAST_CLASS__METHODS;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__SURROUNDING_FUNCTION = GAST_CLASS__SURROUNDING_FUNCTION;

	/**
	 * The feature id for the '<em><b>Surrounding Package</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__SURROUNDING_PACKAGE = GAST_CLASS__SURROUNDING_PACKAGE;

	/**
	 * The feature id for the '<em><b>Super Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__SUPER_TYPES = GAST_CLASS__SUPER_TYPES;

	/**
	 * The feature id for the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__LINES_OF_COMMENTS = GAST_CLASS__LINES_OF_COMMENTS;

	/**
	 * The feature id for the '<em><b>Local</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__LOCAL = GAST_CLASS__LOCAL;

	/**
	 * The feature id for the '<em><b>Primitive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__PRIMITIVE = GAST_CLASS__PRIMITIVE;

	/**
	 * The feature id for the '<em><b>Interface</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__INTERFACE = GAST_CLASS__INTERFACE;

	/**
	 * The feature id for the '<em><b>Anonymous</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__ANONYMOUS = GAST_CLASS__ANONYMOUS;

	/**
	 * The feature id for the '<em><b>Inner Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__INNER_CLASSES = GAST_CLASS__INNER_CLASSES;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__SURROUNDING_CLASS = GAST_CLASS__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Inheritance Type Accesses</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__INHERITANCE_TYPE_ACCESSES = GAST_CLASS__INHERITANCE_TYPE_ACCESSES;

	/**
	 * The feature id for the '<em><b>Self</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__SELF = GAST_CLASS__SELF;

	/**
	 * The feature id for the '<em><b>Friend Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__FRIEND_CLASSES = GAST_CLASS__FRIEND_CLASSES;

	/**
	 * The feature id for the '<em><b>Friend Functions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__FRIEND_FUNCTIONS = GAST_CLASS__FRIEND_FUNCTIONS;

	/**
	 * The feature id for the '<em><b>Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__PROPERTY = GAST_CLASS__PROPERTY;

	/**
	 * The feature id for the '<em><b>All Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__ALL_ACCESSES = GAST_CLASS__ALL_ACCESSES;

	/**
	 * The feature id for the '<em><b>All Accessed Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__ALL_ACCESSED_CLASSES = GAST_CLASS__ALL_ACCESSED_CLASSES;

	/**
	 * The feature id for the '<em><b>Inner</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT__INNER = GAST_CLASS__INNER;

	/**
	 * The number of structural features of the '<em>GAST Struct</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_STRUCT_FEATURE_COUNT = GAST_CLASS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.fzi.gast.types.impl.GASTUnionImpl <em>GAST Union</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.types.impl.GASTUnionImpl
	 * @see de.fzi.gast.types.impl.typesPackageImpl#getGASTUnion()
	 * @generated
	 */
	int GAST_UNION = 10;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__ID = GAST_CLASS__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__ANNOTATIONS = GAST_CLASS__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__STATUS = GAST_CLASS__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__SISSY_ID = GAST_CLASS__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__POSITION = GAST_CLASS__POSITION;

	/**
	 * The feature id for the '<em><b>Visibility</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__VISIBILITY = GAST_CLASS__VISIBILITY;

	/**
	 * The feature id for the '<em><b>Overridden Member</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__OVERRIDDEN_MEMBER = GAST_CLASS__OVERRIDDEN_MEMBER;

	/**
	 * The feature id for the '<em><b>Abstract</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__ABSTRACT = GAST_CLASS__ABSTRACT;

	/**
	 * The feature id for the '<em><b>Extern</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__EXTERN = GAST_CLASS__EXTERN;

	/**
	 * The feature id for the '<em><b>Final</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__FINAL = GAST_CLASS__FINAL;

	/**
	 * The feature id for the '<em><b>Internal</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__INTERNAL = GAST_CLASS__INTERNAL;

	/**
	 * The feature id for the '<em><b>Introspectable</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__INTROSPECTABLE = GAST_CLASS__INTROSPECTABLE;

	/**
	 * The feature id for the '<em><b>Override</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__OVERRIDE = GAST_CLASS__OVERRIDE;

	/**
	 * The feature id for the '<em><b>Static</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__STATIC = GAST_CLASS__STATIC;

	/**
	 * The feature id for the '<em><b>Type Parameter Class Member</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__TYPE_PARAMETER_CLASS_MEMBER = GAST_CLASS__TYPE_PARAMETER_CLASS_MEMBER;

	/**
	 * The feature id for the '<em><b>Virtual</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__VIRTUAL = GAST_CLASS__VIRTUAL;

	/**
	 * The feature id for the '<em><b>Simple Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__SIMPLE_NAME = GAST_CLASS__SIMPLE_NAME;

	/**
	 * The feature id for the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__QUALIFIED_NAME = GAST_CLASS__QUALIFIED_NAME;

	/**
	 * The feature id for the '<em><b>Reference Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__REFERENCE_TYPE = GAST_CLASS__REFERENCE_TYPE;

	/**
	 * The feature id for the '<em><b>Inner Type Aliases</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__INNER_TYPE_ALIASES = GAST_CLASS__INNER_TYPE_ALIASES;

	/**
	 * The feature id for the '<em><b>Inner Delegates</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__INNER_DELEGATES = GAST_CLASS__INNER_DELEGATES;

	/**
	 * The feature id for the '<em><b>Constructors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__CONSTRUCTORS = GAST_CLASS__CONSTRUCTORS;

	/**
	 * The feature id for the '<em><b>Destructors</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__DESTRUCTORS = GAST_CLASS__DESTRUCTORS;

	/**
	 * The feature id for the '<em><b>Fields</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__FIELDS = GAST_CLASS__FIELDS;

	/**
	 * The feature id for the '<em><b>Methods</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__METHODS = GAST_CLASS__METHODS;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__SURROUNDING_FUNCTION = GAST_CLASS__SURROUNDING_FUNCTION;

	/**
	 * The feature id for the '<em><b>Surrounding Package</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__SURROUNDING_PACKAGE = GAST_CLASS__SURROUNDING_PACKAGE;

	/**
	 * The feature id for the '<em><b>Super Types</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__SUPER_TYPES = GAST_CLASS__SUPER_TYPES;

	/**
	 * The feature id for the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__LINES_OF_COMMENTS = GAST_CLASS__LINES_OF_COMMENTS;

	/**
	 * The feature id for the '<em><b>Local</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__LOCAL = GAST_CLASS__LOCAL;

	/**
	 * The feature id for the '<em><b>Primitive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__PRIMITIVE = GAST_CLASS__PRIMITIVE;

	/**
	 * The feature id for the '<em><b>Interface</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__INTERFACE = GAST_CLASS__INTERFACE;

	/**
	 * The feature id for the '<em><b>Anonymous</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__ANONYMOUS = GAST_CLASS__ANONYMOUS;

	/**
	 * The feature id for the '<em><b>Inner Classes</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__INNER_CLASSES = GAST_CLASS__INNER_CLASSES;

	/**
	 * The feature id for the '<em><b>Surrounding Class</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__SURROUNDING_CLASS = GAST_CLASS__SURROUNDING_CLASS;

	/**
	 * The feature id for the '<em><b>Inheritance Type Accesses</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__INHERITANCE_TYPE_ACCESSES = GAST_CLASS__INHERITANCE_TYPE_ACCESSES;

	/**
	 * The feature id for the '<em><b>Self</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__SELF = GAST_CLASS__SELF;

	/**
	 * The feature id for the '<em><b>Friend Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__FRIEND_CLASSES = GAST_CLASS__FRIEND_CLASSES;

	/**
	 * The feature id for the '<em><b>Friend Functions</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__FRIEND_FUNCTIONS = GAST_CLASS__FRIEND_FUNCTIONS;

	/**
	 * The feature id for the '<em><b>Property</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__PROPERTY = GAST_CLASS__PROPERTY;

	/**
	 * The feature id for the '<em><b>All Accesses</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__ALL_ACCESSES = GAST_CLASS__ALL_ACCESSES;

	/**
	 * The feature id for the '<em><b>All Accessed Classes</b></em>' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__ALL_ACCESSED_CLASSES = GAST_CLASS__ALL_ACCESSED_CLASSES;

	/**
	 * The feature id for the '<em><b>Inner</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION__INNER = GAST_CLASS__INNER;

	/**
	 * The number of structural features of the '<em>GAST Union</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_UNION_FEATURE_COUNT = GAST_CLASS_FEATURE_COUNT + 0;

	/**
	 * The meta object id for the '{@link de.fzi.gast.types.Visibilities <em>Visibilities</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.types.Visibilities
	 * @see de.fzi.gast.types.impl.typesPackageImpl#getVisibilities()
	 * @generated
	 */
	int VISIBILITIES = 12;


	/**
	 * Returns the meta object for class '{@link de.fzi.gast.types.Reference <em>Reference</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Reference</em>'.
	 * @see de.fzi.gast.types.Reference
	 * @generated
	 */
	EClass getReference();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.types.Reference#getReferencedType <em>Referenced Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Referenced Type</em>'.
	 * @see de.fzi.gast.types.Reference#getReferencedType()
	 * @see #getReference()
	 * @generated
	 */
	EReference getReference_ReferencedType();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.types.Reference#isExplicit <em>Explicit</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Explicit</em>'.
	 * @see de.fzi.gast.types.Reference#isExplicit()
	 * @see #getReference()
	 * @generated
	 */
	EAttribute getReference_Explicit();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.types.TypeDecorator <em>Type Decorator</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type Decorator</em>'.
	 * @see de.fzi.gast.types.TypeDecorator
	 * @generated
	 */
	EClass getTypeDecorator();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.types.TypeDecorator#getDecoratedType <em>Decorated Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Decorated Type</em>'.
	 * @see de.fzi.gast.types.TypeDecorator#getDecoratedType()
	 * @see #getTypeDecorator()
	 * @generated
	 */
	EReference getTypeDecorator_DecoratedType();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.types.TypeDecorator#getUndecoratedType <em>Undecorated Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Undecorated Type</em>'.
	 * @see de.fzi.gast.types.TypeDecorator#getUndecoratedType()
	 * @see #getTypeDecorator()
	 * @generated
	 */
	EReference getTypeDecorator_UndecoratedType();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.types.GASTType <em>GAST Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>GAST Type</em>'.
	 * @see de.fzi.gast.types.GASTType
	 * @generated
	 */
	EClass getGASTType();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.types.GASTType#getQualifiedName <em>Qualified Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Qualified Name</em>'.
	 * @see de.fzi.gast.types.GASTType#getQualifiedName()
	 * @see #getGASTType()
	 * @generated
	 */
	EAttribute getGASTType_QualifiedName();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.types.GASTType#isReferenceType <em>Reference Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Reference Type</em>'.
	 * @see de.fzi.gast.types.GASTType#isReferenceType()
	 * @see #getGASTType()
	 * @generated
	 */
	EAttribute getGASTType_ReferenceType();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.types.GASTArray <em>GAST Array</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>GAST Array</em>'.
	 * @see de.fzi.gast.types.GASTArray
	 * @generated
	 */
	EClass getGASTArray();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.types.GASTArray#getBaseType <em>Base Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Base Type</em>'.
	 * @see de.fzi.gast.types.GASTArray#getBaseType()
	 * @see #getGASTArray()
	 * @generated
	 */
	EReference getGASTArray_BaseType();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.types.GASTArray#getDimensions <em>Dimensions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Dimensions</em>'.
	 * @see de.fzi.gast.types.GASTArray#getDimensions()
	 * @see #getGASTArray()
	 * @generated
	 */
	EAttribute getGASTArray_Dimensions();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.types.TypeAlias <em>Type Alias</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type Alias</em>'.
	 * @see de.fzi.gast.types.TypeAlias
	 * @generated
	 */
	EClass getTypeAlias();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.types.TypeAlias#getAliasedType <em>Aliased Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Aliased Type</em>'.
	 * @see de.fzi.gast.types.TypeAlias#getAliasedType()
	 * @see #getTypeAlias()
	 * @generated
	 */
	EReference getTypeAlias_AliasedType();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.types.TypeAlias#isInnerTypeAlias <em>Inner Type Alias</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Inner Type Alias</em>'.
	 * @see de.fzi.gast.types.TypeAlias#isInnerTypeAlias()
	 * @see #getTypeAlias()
	 * @generated
	 */
	EAttribute getTypeAlias_InnerTypeAlias();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.types.TypeAlias#getSurroundingClass <em>Surrounding Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Surrounding Class</em>'.
	 * @see de.fzi.gast.types.TypeAlias#getSurroundingClass()
	 * @see #getTypeAlias()
	 * @generated
	 */
	EReference getTypeAlias_SurroundingClass();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.types.TypeAlias#getSurroundingPackage <em>Surrounding Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Surrounding Package</em>'.
	 * @see de.fzi.gast.types.TypeAlias#getSurroundingPackage()
	 * @see #getTypeAlias()
	 * @generated
	 */
	EReference getTypeAlias_SurroundingPackage();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.types.Member <em>Member</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Member</em>'.
	 * @see de.fzi.gast.types.Member
	 * @generated
	 */
	EClass getMember();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.types.Member#getVisibility <em>Visibility</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Visibility</em>'.
	 * @see de.fzi.gast.types.Member#getVisibility()
	 * @see #getMember()
	 * @generated
	 */
	EAttribute getMember_Visibility();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.types.Member#getOverriddenMember <em>Overridden Member</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Overridden Member</em>'.
	 * @see de.fzi.gast.types.Member#getOverriddenMember()
	 * @see #getMember()
	 * @generated
	 */
	EReference getMember_OverriddenMember();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.types.Member#isAbstract <em>Abstract</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Abstract</em>'.
	 * @see de.fzi.gast.types.Member#isAbstract()
	 * @see #getMember()
	 * @generated
	 */
	EAttribute getMember_Abstract();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.types.Member#isExtern <em>Extern</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Extern</em>'.
	 * @see de.fzi.gast.types.Member#isExtern()
	 * @see #getMember()
	 * @generated
	 */
	EAttribute getMember_Extern();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.types.Member#isFinal <em>Final</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Final</em>'.
	 * @see de.fzi.gast.types.Member#isFinal()
	 * @see #getMember()
	 * @generated
	 */
	EAttribute getMember_Final();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.types.Member#isInternal <em>Internal</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Internal</em>'.
	 * @see de.fzi.gast.types.Member#isInternal()
	 * @see #getMember()
	 * @generated
	 */
	EAttribute getMember_Internal();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.types.Member#isIntrospectable <em>Introspectable</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Introspectable</em>'.
	 * @see de.fzi.gast.types.Member#isIntrospectable()
	 * @see #getMember()
	 * @generated
	 */
	EAttribute getMember_Introspectable();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.types.Member#isOverride <em>Override</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Override</em>'.
	 * @see de.fzi.gast.types.Member#isOverride()
	 * @see #getMember()
	 * @generated
	 */
	EAttribute getMember_Override();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.types.Member#isStatic <em>Static</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Static</em>'.
	 * @see de.fzi.gast.types.Member#isStatic()
	 * @see #getMember()
	 * @generated
	 */
	EAttribute getMember_Static();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.types.Member#isTypeParameterClassMember <em>Type Parameter Class Member</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type Parameter Class Member</em>'.
	 * @see de.fzi.gast.types.Member#isTypeParameterClassMember()
	 * @see #getMember()
	 * @generated
	 */
	EAttribute getMember_TypeParameterClassMember();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.types.Member#isVirtual <em>Virtual</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Virtual</em>'.
	 * @see de.fzi.gast.types.Member#isVirtual()
	 * @see #getMember()
	 * @generated
	 */
	EAttribute getMember_Virtual();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.types.TypeParameterClass <em>Type Parameter Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Type Parameter Class</em>'.
	 * @see de.fzi.gast.types.TypeParameterClass
	 * @generated
	 */
	EClass getTypeParameterClass();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.types.TypeParameterClass#getTypeBounds <em>Type Bounds</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Type Bounds</em>'.
	 * @see de.fzi.gast.types.TypeParameterClass#getTypeBounds()
	 * @see #getTypeParameterClass()
	 * @generated
	 */
	EReference getTypeParameterClass_TypeBounds();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.types.GenericClass <em>Generic Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Generic Class</em>'.
	 * @see de.fzi.gast.types.GenericClass
	 * @generated
	 */
	EClass getGenericClass();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.types.GASTEnumeration <em>GAST Enumeration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>GAST Enumeration</em>'.
	 * @see de.fzi.gast.types.GASTEnumeration
	 * @generated
	 */
	EClass getGASTEnumeration();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.types.GASTStruct <em>GAST Struct</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>GAST Struct</em>'.
	 * @see de.fzi.gast.types.GASTStruct
	 * @generated
	 */
	EClass getGASTStruct();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.types.GASTUnion <em>GAST Union</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>GAST Union</em>'.
	 * @see de.fzi.gast.types.GASTUnion
	 * @generated
	 */
	EClass getGASTUnion();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.types.GASTClass <em>GAST Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>GAST Class</em>'.
	 * @see de.fzi.gast.types.GASTClass
	 * @generated
	 */
	EClass getGASTClass();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.types.GASTClass#getInnerTypeAliases <em>Inner Type Aliases</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Inner Type Aliases</em>'.
	 * @see de.fzi.gast.types.GASTClass#getInnerTypeAliases()
	 * @see #getGASTClass()
	 * @generated
	 */
	EReference getGASTClass_InnerTypeAliases();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.types.GASTClass#getFields <em>Fields</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Fields</em>'.
	 * @see de.fzi.gast.types.GASTClass#getFields()
	 * @see #getGASTClass()
	 * @generated
	 */
	EReference getGASTClass_Fields();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.types.GASTClass#getMethods <em>Methods</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Methods</em>'.
	 * @see de.fzi.gast.types.GASTClass#getMethods()
	 * @see #getGASTClass()
	 * @generated
	 */
	EReference getGASTClass_Methods();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.types.GASTClass#getConstructors <em>Constructors</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Constructors</em>'.
	 * @see de.fzi.gast.types.GASTClass#getConstructors()
	 * @see #getGASTClass()
	 * @generated
	 */
	EReference getGASTClass_Constructors();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.types.GASTClass#getDestructors <em>Destructors</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Destructors</em>'.
	 * @see de.fzi.gast.types.GASTClass#getDestructors()
	 * @see #getGASTClass()
	 * @generated
	 */
	EReference getGASTClass_Destructors();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.types.GASTClass#getInnerDelegates <em>Inner Delegates</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Inner Delegates</em>'.
	 * @see de.fzi.gast.types.GASTClass#getInnerDelegates()
	 * @see #getGASTClass()
	 * @generated
	 */
	EReference getGASTClass_InnerDelegates();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.types.GASTClass#getSurroundingPackage <em>Surrounding Package</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Surrounding Package</em>'.
	 * @see de.fzi.gast.types.GASTClass#getSurroundingPackage()
	 * @see #getGASTClass()
	 * @generated
	 */
	EReference getGASTClass_SurroundingPackage();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.types.GASTClass#getSuperTypes <em>Super Types</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Super Types</em>'.
	 * @see de.fzi.gast.types.GASTClass#getSuperTypes()
	 * @see #getGASTClass()
	 * @generated
	 */
	EReference getGASTClass_SuperTypes();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.types.GASTClass#getLinesOfComments <em>Lines Of Comments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lines Of Comments</em>'.
	 * @see de.fzi.gast.types.GASTClass#getLinesOfComments()
	 * @see #getGASTClass()
	 * @generated
	 */
	EAttribute getGASTClass_LinesOfComments();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.types.GASTClass#isLocal <em>Local</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Local</em>'.
	 * @see de.fzi.gast.types.GASTClass#isLocal()
	 * @see #getGASTClass()
	 * @generated
	 */
	EAttribute getGASTClass_Local();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.types.GASTClass#isPrimitive <em>Primitive</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Primitive</em>'.
	 * @see de.fzi.gast.types.GASTClass#isPrimitive()
	 * @see #getGASTClass()
	 * @generated
	 */
	EAttribute getGASTClass_Primitive();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.types.GASTClass#getSurroundingFunction <em>Surrounding Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Surrounding Function</em>'.
	 * @see de.fzi.gast.types.GASTClass#getSurroundingFunction()
	 * @see #getGASTClass()
	 * @generated
	 */
	EReference getGASTClass_SurroundingFunction();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.types.GASTClass#isInterface <em>Interface</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Interface</em>'.
	 * @see de.fzi.gast.types.GASTClass#isInterface()
	 * @see #getGASTClass()
	 * @generated
	 */
	EAttribute getGASTClass_Interface();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.types.GASTClass#isAnonymous <em>Anonymous</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Anonymous</em>'.
	 * @see de.fzi.gast.types.GASTClass#isAnonymous()
	 * @see #getGASTClass()
	 * @generated
	 */
	EAttribute getGASTClass_Anonymous();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.types.GASTClass#getInnerClasses <em>Inner Classes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Inner Classes</em>'.
	 * @see de.fzi.gast.types.GASTClass#getInnerClasses()
	 * @see #getGASTClass()
	 * @generated
	 */
	EReference getGASTClass_InnerClasses();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.types.GASTClass#getSurroundingClass <em>Surrounding Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Surrounding Class</em>'.
	 * @see de.fzi.gast.types.GASTClass#getSurroundingClass()
	 * @see #getGASTClass()
	 * @generated
	 */
	EReference getGASTClass_SurroundingClass();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.types.GASTClass#getInheritanceTypeAccesses <em>Inheritance Type Accesses</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Inheritance Type Accesses</em>'.
	 * @see de.fzi.gast.types.GASTClass#getInheritanceTypeAccesses()
	 * @see #getGASTClass()
	 * @generated
	 */
	EReference getGASTClass_InheritanceTypeAccesses();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.types.GASTClass#getSelf <em>Self</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Self</em>'.
	 * @see de.fzi.gast.types.GASTClass#getSelf()
	 * @see #getGASTClass()
	 * @generated
	 */
	EReference getGASTClass_Self();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.types.GASTClass#getFriendClasses <em>Friend Classes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>Friend Classes</em>'.
	 * @see de.fzi.gast.types.GASTClass#getFriendClasses()
	 * @see #getGASTClass()
	 * @generated
	 */
	EReference getGASTClass_FriendClasses();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.types.GASTClass#getFriendFunctions <em>Friend Functions</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Friend Functions</em>'.
	 * @see de.fzi.gast.types.GASTClass#getFriendFunctions()
	 * @see #getGASTClass()
	 * @generated
	 */
	EReference getGASTClass_FriendFunctions();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.types.GASTClass#getProperty <em>Property</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Property</em>'.
	 * @see de.fzi.gast.types.GASTClass#getProperty()
	 * @see #getGASTClass()
	 * @generated
	 */
	EReference getGASTClass_Property();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.types.GASTClass#getAllAccesses <em>All Accesses</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>All Accesses</em>'.
	 * @see de.fzi.gast.types.GASTClass#getAllAccesses()
	 * @see #getGASTClass()
	 * @generated
	 */
	EReference getGASTClass_AllAccesses();

	/**
	 * Returns the meta object for the reference list '{@link de.fzi.gast.types.GASTClass#getAllAccessedClasses <em>All Accessed Classes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference list '<em>All Accessed Classes</em>'.
	 * @see de.fzi.gast.types.GASTClass#getAllAccessedClasses()
	 * @see #getGASTClass()
	 * @generated
	 */
	EReference getGASTClass_AllAccessedClasses();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.types.GASTClass#isInner <em>Inner</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Inner</em>'.
	 * @see de.fzi.gast.types.GASTClass#isInner()
	 * @see #getGASTClass()
	 * @generated
	 */
	EAttribute getGASTClass_Inner();

	/**
	 * Returns the meta object for enum '{@link de.fzi.gast.types.Visibilities <em>Visibilities</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Visibilities</em>'.
	 * @see de.fzi.gast.types.Visibilities
	 * @generated
	 */
	EEnum getVisibilities();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	typesFactory gettypesFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link de.fzi.gast.types.impl.ReferenceImpl <em>Reference</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.types.impl.ReferenceImpl
		 * @see de.fzi.gast.types.impl.typesPackageImpl#getReference()
		 * @generated
		 */
		EClass REFERENCE = eINSTANCE.getReference();

		/**
		 * The meta object literal for the '<em><b>Referenced Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference REFERENCE__REFERENCED_TYPE = eINSTANCE.getReference_ReferencedType();

		/**
		 * The meta object literal for the '<em><b>Explicit</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute REFERENCE__EXPLICIT = eINSTANCE.getReference_Explicit();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.types.impl.TypeDecoratorImpl <em>Type Decorator</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.types.impl.TypeDecoratorImpl
		 * @see de.fzi.gast.types.impl.typesPackageImpl#getTypeDecorator()
		 * @generated
		 */
		EClass TYPE_DECORATOR = eINSTANCE.getTypeDecorator();

		/**
		 * The meta object literal for the '<em><b>Decorated Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TYPE_DECORATOR__DECORATED_TYPE = eINSTANCE.getTypeDecorator_DecoratedType();

		/**
		 * The meta object literal for the '<em><b>Undecorated Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TYPE_DECORATOR__UNDECORATED_TYPE = eINSTANCE.getTypeDecorator_UndecoratedType();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.types.impl.GASTTypeImpl <em>GAST Type</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.types.impl.GASTTypeImpl
		 * @see de.fzi.gast.types.impl.typesPackageImpl#getGASTType()
		 * @generated
		 */
		EClass GAST_TYPE = eINSTANCE.getGASTType();

		/**
		 * The meta object literal for the '<em><b>Qualified Name</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GAST_TYPE__QUALIFIED_NAME = eINSTANCE.getGASTType_QualifiedName();

		/**
		 * The meta object literal for the '<em><b>Reference Type</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GAST_TYPE__REFERENCE_TYPE = eINSTANCE.getGASTType_ReferenceType();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.types.impl.GASTArrayImpl <em>GAST Array</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.types.impl.GASTArrayImpl
		 * @see de.fzi.gast.types.impl.typesPackageImpl#getGASTArray()
		 * @generated
		 */
		EClass GAST_ARRAY = eINSTANCE.getGASTArray();

		/**
		 * The meta object literal for the '<em><b>Base Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GAST_ARRAY__BASE_TYPE = eINSTANCE.getGASTArray_BaseType();

		/**
		 * The meta object literal for the '<em><b>Dimensions</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GAST_ARRAY__DIMENSIONS = eINSTANCE.getGASTArray_Dimensions();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.types.impl.TypeAliasImpl <em>Type Alias</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.types.impl.TypeAliasImpl
		 * @see de.fzi.gast.types.impl.typesPackageImpl#getTypeAlias()
		 * @generated
		 */
		EClass TYPE_ALIAS = eINSTANCE.getTypeAlias();

		/**
		 * The meta object literal for the '<em><b>Aliased Type</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TYPE_ALIAS__ALIASED_TYPE = eINSTANCE.getTypeAlias_AliasedType();

		/**
		 * The meta object literal for the '<em><b>Inner Type Alias</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute TYPE_ALIAS__INNER_TYPE_ALIAS = eINSTANCE.getTypeAlias_InnerTypeAlias();

		/**
		 * The meta object literal for the '<em><b>Surrounding Class</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TYPE_ALIAS__SURROUNDING_CLASS = eINSTANCE.getTypeAlias_SurroundingClass();

		/**
		 * The meta object literal for the '<em><b>Surrounding Package</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TYPE_ALIAS__SURROUNDING_PACKAGE = eINSTANCE.getTypeAlias_SurroundingPackage();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.types.impl.MemberImpl <em>Member</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.types.impl.MemberImpl
		 * @see de.fzi.gast.types.impl.typesPackageImpl#getMember()
		 * @generated
		 */
		EClass MEMBER = eINSTANCE.getMember();

		/**
		 * The meta object literal for the '<em><b>Visibility</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MEMBER__VISIBILITY = eINSTANCE.getMember_Visibility();

		/**
		 * The meta object literal for the '<em><b>Overridden Member</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference MEMBER__OVERRIDDEN_MEMBER = eINSTANCE.getMember_OverriddenMember();

		/**
		 * The meta object literal for the '<em><b>Abstract</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MEMBER__ABSTRACT = eINSTANCE.getMember_Abstract();

		/**
		 * The meta object literal for the '<em><b>Extern</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MEMBER__EXTERN = eINSTANCE.getMember_Extern();

		/**
		 * The meta object literal for the '<em><b>Final</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MEMBER__FINAL = eINSTANCE.getMember_Final();

		/**
		 * The meta object literal for the '<em><b>Internal</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MEMBER__INTERNAL = eINSTANCE.getMember_Internal();

		/**
		 * The meta object literal for the '<em><b>Introspectable</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MEMBER__INTROSPECTABLE = eINSTANCE.getMember_Introspectable();

		/**
		 * The meta object literal for the '<em><b>Override</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MEMBER__OVERRIDE = eINSTANCE.getMember_Override();

		/**
		 * The meta object literal for the '<em><b>Static</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MEMBER__STATIC = eINSTANCE.getMember_Static();

		/**
		 * The meta object literal for the '<em><b>Type Parameter Class Member</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MEMBER__TYPE_PARAMETER_CLASS_MEMBER = eINSTANCE.getMember_TypeParameterClassMember();

		/**
		 * The meta object literal for the '<em><b>Virtual</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute MEMBER__VIRTUAL = eINSTANCE.getMember_Virtual();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.types.impl.TypeParameterClassImpl <em>Type Parameter Class</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.types.impl.TypeParameterClassImpl
		 * @see de.fzi.gast.types.impl.typesPackageImpl#getTypeParameterClass()
		 * @generated
		 */
		EClass TYPE_PARAMETER_CLASS = eINSTANCE.getTypeParameterClass();

		/**
		 * The meta object literal for the '<em><b>Type Bounds</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference TYPE_PARAMETER_CLASS__TYPE_BOUNDS = eINSTANCE.getTypeParameterClass_TypeBounds();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.types.impl.GenericClassImpl <em>Generic Class</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.types.impl.GenericClassImpl
		 * @see de.fzi.gast.types.impl.typesPackageImpl#getGenericClass()
		 * @generated
		 */
		EClass GENERIC_CLASS = eINSTANCE.getGenericClass();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.types.impl.GASTEnumerationImpl <em>GAST Enumeration</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.types.impl.GASTEnumerationImpl
		 * @see de.fzi.gast.types.impl.typesPackageImpl#getGASTEnumeration()
		 * @generated
		 */
		EClass GAST_ENUMERATION = eINSTANCE.getGASTEnumeration();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.types.impl.GASTStructImpl <em>GAST Struct</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.types.impl.GASTStructImpl
		 * @see de.fzi.gast.types.impl.typesPackageImpl#getGASTStruct()
		 * @generated
		 */
		EClass GAST_STRUCT = eINSTANCE.getGASTStruct();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.types.impl.GASTUnionImpl <em>GAST Union</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.types.impl.GASTUnionImpl
		 * @see de.fzi.gast.types.impl.typesPackageImpl#getGASTUnion()
		 * @generated
		 */
		EClass GAST_UNION = eINSTANCE.getGASTUnion();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.types.impl.GASTClassImpl <em>GAST Class</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.types.impl.GASTClassImpl
		 * @see de.fzi.gast.types.impl.typesPackageImpl#getGASTClass()
		 * @generated
		 */
		EClass GAST_CLASS = eINSTANCE.getGASTClass();

		/**
		 * The meta object literal for the '<em><b>Inner Type Aliases</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GAST_CLASS__INNER_TYPE_ALIASES = eINSTANCE.getGASTClass_InnerTypeAliases();

		/**
		 * The meta object literal for the '<em><b>Fields</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GAST_CLASS__FIELDS = eINSTANCE.getGASTClass_Fields();

		/**
		 * The meta object literal for the '<em><b>Methods</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GAST_CLASS__METHODS = eINSTANCE.getGASTClass_Methods();

		/**
		 * The meta object literal for the '<em><b>Constructors</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GAST_CLASS__CONSTRUCTORS = eINSTANCE.getGASTClass_Constructors();

		/**
		 * The meta object literal for the '<em><b>Destructors</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GAST_CLASS__DESTRUCTORS = eINSTANCE.getGASTClass_Destructors();

		/**
		 * The meta object literal for the '<em><b>Inner Delegates</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GAST_CLASS__INNER_DELEGATES = eINSTANCE.getGASTClass_InnerDelegates();

		/**
		 * The meta object literal for the '<em><b>Surrounding Package</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GAST_CLASS__SURROUNDING_PACKAGE = eINSTANCE.getGASTClass_SurroundingPackage();

		/**
		 * The meta object literal for the '<em><b>Super Types</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GAST_CLASS__SUPER_TYPES = eINSTANCE.getGASTClass_SuperTypes();

		/**
		 * The meta object literal for the '<em><b>Lines Of Comments</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GAST_CLASS__LINES_OF_COMMENTS = eINSTANCE.getGASTClass_LinesOfComments();

		/**
		 * The meta object literal for the '<em><b>Local</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GAST_CLASS__LOCAL = eINSTANCE.getGASTClass_Local();

		/**
		 * The meta object literal for the '<em><b>Primitive</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GAST_CLASS__PRIMITIVE = eINSTANCE.getGASTClass_Primitive();

		/**
		 * The meta object literal for the '<em><b>Surrounding Function</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GAST_CLASS__SURROUNDING_FUNCTION = eINSTANCE.getGASTClass_SurroundingFunction();

		/**
		 * The meta object literal for the '<em><b>Interface</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GAST_CLASS__INTERFACE = eINSTANCE.getGASTClass_Interface();

		/**
		 * The meta object literal for the '<em><b>Anonymous</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GAST_CLASS__ANONYMOUS = eINSTANCE.getGASTClass_Anonymous();

		/**
		 * The meta object literal for the '<em><b>Inner Classes</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GAST_CLASS__INNER_CLASSES = eINSTANCE.getGASTClass_InnerClasses();

		/**
		 * The meta object literal for the '<em><b>Surrounding Class</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GAST_CLASS__SURROUNDING_CLASS = eINSTANCE.getGASTClass_SurroundingClass();

		/**
		 * The meta object literal for the '<em><b>Inheritance Type Accesses</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GAST_CLASS__INHERITANCE_TYPE_ACCESSES = eINSTANCE.getGASTClass_InheritanceTypeAccesses();

		/**
		 * The meta object literal for the '<em><b>Self</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GAST_CLASS__SELF = eINSTANCE.getGASTClass_Self();

		/**
		 * The meta object literal for the '<em><b>Friend Classes</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GAST_CLASS__FRIEND_CLASSES = eINSTANCE.getGASTClass_FriendClasses();

		/**
		 * The meta object literal for the '<em><b>Friend Functions</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GAST_CLASS__FRIEND_FUNCTIONS = eINSTANCE.getGASTClass_FriendFunctions();

		/**
		 * The meta object literal for the '<em><b>Property</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GAST_CLASS__PROPERTY = eINSTANCE.getGASTClass_Property();

		/**
		 * The meta object literal for the '<em><b>All Accesses</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GAST_CLASS__ALL_ACCESSES = eINSTANCE.getGASTClass_AllAccesses();

		/**
		 * The meta object literal for the '<em><b>All Accessed Classes</b></em>' reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GAST_CLASS__ALL_ACCESSED_CLASSES = eINSTANCE.getGASTClass_AllAccessedClasses();

		/**
		 * The meta object literal for the '<em><b>Inner</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute GAST_CLASS__INNER = eINSTANCE.getGASTClass_Inner();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.types.Visibilities <em>Visibilities</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.types.Visibilities
		 * @see de.fzi.gast.types.impl.typesPackageImpl#getVisibilities()
		 * @generated
		 */
		EEnum VISIBILITIES = eINSTANCE.getVisibilities();

	}

} //typesPackage
