/**
 * <copyright>
 * </copyright>
 *
 * $Id: typesFactoryImpl.java,v 1.5 2008/12/05 15:44:34 stammel Exp $
 */
package de.fzi.gast.types.impl;

import de.fzi.gast.types.*;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

import de.fzi.gast.types.GASTArray;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.GenericClass;
import de.fzi.gast.types.Reference;
import de.fzi.gast.types.TypeAlias;
import de.fzi.gast.types.TypeParameterClass;
import de.fzi.gast.types.Visibilities;
import de.fzi.gast.types.typesFactory;
import de.fzi.gast.types.typesPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class typesFactoryImpl extends EFactoryImpl implements typesFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static typesFactory init() {
		try {
			typesFactory thetypesFactory = (typesFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.fzi.de/gast/types"); 
			if (thetypesFactory != null) {
				return thetypesFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new typesFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public typesFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case typesPackage.REFERENCE: return createReference();
			case typesPackage.GAST_ARRAY: return createGASTArray();
			case typesPackage.TYPE_ALIAS: return createTypeAlias();
			case typesPackage.TYPE_PARAMETER_CLASS: return createTypeParameterClass();
			case typesPackage.GENERIC_CLASS: return createGenericClass();
			case typesPackage.GAST_ENUMERATION: return createGASTEnumeration();
			case typesPackage.GAST_STRUCT: return createGASTStruct();
			case typesPackage.GAST_UNION: return createGASTUnion();
			case typesPackage.GAST_CLASS: return createGASTClass();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString(EDataType eDataType, String initialValue) {
		switch (eDataType.getClassifierID()) {
			case typesPackage.VISIBILITIES:
				return createVisibilitiesFromString(eDataType, initialValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString(EDataType eDataType, Object instanceValue) {
		switch (eDataType.getClassifierID()) {
			case typesPackage.VISIBILITIES:
				return convertVisibilitiesToString(eDataType, instanceValue);
			default:
				throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Reference createReference() {
		ReferenceImpl reference = new ReferenceImpl();
		return reference;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTArray createGASTArray() {
		GASTArrayImpl gastArray = new GASTArrayImpl();
		return gastArray;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeAlias createTypeAlias() {
		TypeAliasImpl typeAlias = new TypeAliasImpl();
		return typeAlias;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public TypeParameterClass createTypeParameterClass() {
		TypeParameterClassImpl typeParameterClass = new TypeParameterClassImpl();
		return typeParameterClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GenericClass createGenericClass() {
		GenericClassImpl genericClass = new GenericClassImpl();
		return genericClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTEnumeration createGASTEnumeration() {
		GASTEnumerationImpl gastEnumeration = new GASTEnumerationImpl();
		return gastEnumeration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTStruct createGASTStruct() {
		GASTStructImpl gastStruct = new GASTStructImpl();
		return gastStruct;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTUnion createGASTUnion() {
		GASTUnionImpl gastUnion = new GASTUnionImpl();
		return gastUnion;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTClass createGASTClass() {
		GASTClassImpl gastClass = new GASTClassImpl();
		return gastClass;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Visibilities createVisibilitiesFromString(EDataType eDataType, String initialValue) {
		Visibilities result = Visibilities.get(initialValue);
		if (result == null) throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
		return result;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertVisibilitiesToString(EDataType eDataType, Object instanceValue) {
		return instanceValue == null ? null : instanceValue.toString();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public typesPackage gettypesPackage() {
		return (typesPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static typesPackage getPackage() {
		return typesPackage.eINSTANCE;
	}

} //typesFactoryImpl
