/**
 * <copyright>
 * </copyright>
 *
 * $Id: TypeDecoratorImpl.java,v 1.6 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.types.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import de.fzi.gast.types.GASTType;
import de.fzi.gast.types.TypeDecorator;
import de.fzi.gast.types.typesPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Type Decorator</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.types.impl.TypeDecoratorImpl#getDecoratedType <em>Decorated Type</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.TypeDecoratorImpl#getUndecoratedType <em>Undecorated Type</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class TypeDecoratorImpl extends GASTTypeImpl implements TypeDecorator {
	/**
	 * The cached value of the '{@link #getDecoratedType() <em>Decorated Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDecoratedType()
	 * @generated
	 * @ordered
	 */
	protected GASTType decoratedType;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeDecoratorImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return typesPackage.Literals.TYPE_DECORATOR;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTType getDecoratedType() {
		if (decoratedType != null && decoratedType.eIsProxy()) {
			InternalEObject oldDecoratedType = (InternalEObject)decoratedType;
			decoratedType = (GASTType)eResolveProxy(oldDecoratedType);
			if (decoratedType != oldDecoratedType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, typesPackage.TYPE_DECORATOR__DECORATED_TYPE, oldDecoratedType, decoratedType));
			}
		}
		return decoratedType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTType basicGetDecoratedType() {
		return decoratedType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDecoratedType(GASTType newDecoratedType) {
		GASTType oldDecoratedType = decoratedType;
		decoratedType = newDecoratedType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.TYPE_DECORATOR__DECORATED_TYPE, oldDecoratedType, decoratedType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTType getUndecoratedType() {
		GASTType undecoratedType = basicGetUndecoratedType();
		return undecoratedType != null && undecoratedType.eIsProxy() ? (GASTType)eResolveProxy((InternalEObject)undecoratedType) : undecoratedType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public GASTType basicGetUndecoratedType() {
		GASTType tmp = getDecoratedType();
		while (tmp instanceof TypeDecorator)
			tmp = ((TypeDecorator)tmp).getDecoratedType();
		return tmp;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setUndecoratedType(GASTType newUndecoratedType) {
		// TODO: implement this method to set the 'Undecorated Type' reference
		// Ensure that you remove @generated or mark it @generated NOT
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case typesPackage.TYPE_DECORATOR__DECORATED_TYPE:
				if (resolve) return getDecoratedType();
				return basicGetDecoratedType();
			case typesPackage.TYPE_DECORATOR__UNDECORATED_TYPE:
				if (resolve) return getUndecoratedType();
				return basicGetUndecoratedType();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case typesPackage.TYPE_DECORATOR__DECORATED_TYPE:
				setDecoratedType((GASTType)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case typesPackage.TYPE_DECORATOR__DECORATED_TYPE:
				setDecoratedType((GASTType)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case typesPackage.TYPE_DECORATOR__DECORATED_TYPE:
				return decoratedType != null;
			case typesPackage.TYPE_DECORATOR__UNDECORATED_TYPE:
				return basicGetUndecoratedType() != null;
		}
		return super.eIsSet(featureID);
	}

} //TypeDecoratorImpl
