/**
 * <copyright>
 * </copyright>
 *
 * $Id: TypeAliasImpl.java,v 1.6 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.types.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;

import de.fzi.gast.core.NamedModelElement;
import de.fzi.gast.core.corePackage;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.GASTType;
import de.fzi.gast.types.TypeAlias;
import de.fzi.gast.types.TypeDecorator;
import de.fzi.gast.types.typesPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Type Alias</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.types.impl.TypeAliasImpl#getSimpleName <em>Simple Name</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.TypeAliasImpl#getQualifiedName <em>Qualified Name</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.TypeAliasImpl#isReferenceType <em>Reference Type</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.TypeAliasImpl#getDecoratedType <em>Decorated Type</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.TypeAliasImpl#getUndecoratedType <em>Undecorated Type</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.TypeAliasImpl#getAliasedType <em>Aliased Type</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.TypeAliasImpl#isInnerTypeAlias <em>Inner Type Alias</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.TypeAliasImpl#getSurroundingClass <em>Surrounding Class</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.TypeAliasImpl#getSurroundingPackage <em>Surrounding Package</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TypeAliasImpl extends MemberImpl implements TypeAlias {
	/**
	 * The default value of the '{@link #getSimpleName() <em>Simple Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSimpleName()
	 * @generated
	 * @ordered
	 */
	protected static final String SIMPLE_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSimpleName() <em>Simple Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSimpleName()
	 * @generated
	 * @ordered
	 */
	protected String simpleName = SIMPLE_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getQualifiedName() <em>Qualified Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getQualifiedName()
	 * @generated
	 * @ordered
	 */
	protected static final String QUALIFIED_NAME_EDEFAULT = null;

	/**
	 * The default value of the '{@link #isReferenceType() <em>Reference Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isReferenceType()
	 * @generated
	 * @ordered
	 */
	protected static final boolean REFERENCE_TYPE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isReferenceType() <em>Reference Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isReferenceType()
	 * @generated
	 * @ordered
	 */
	protected boolean referenceType = REFERENCE_TYPE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDecoratedType() <em>Decorated Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDecoratedType()
	 * @generated
	 * @ordered
	 */
	protected GASTType decoratedType;

	/**
	 * The default value of the '{@link #isInnerTypeAlias() <em>Inner Type Alias</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInnerTypeAlias()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INNER_TYPE_ALIAS_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isInnerTypeAlias() <em>Inner Type Alias</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInnerTypeAlias()
	 * @generated
	 * @ordered
	 */
	protected boolean innerTypeAlias = INNER_TYPE_ALIAS_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypeAliasImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return typesPackage.Literals.TYPE_ALIAS;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getSimpleName() {
		return simpleName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSimpleName(String newSimpleName) {
		String oldSimpleName = simpleName;
		simpleName = newSimpleName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.TYPE_ALIAS__SIMPLE_NAME, oldSimpleName, simpleName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public String getQualifiedName() {
		return getSimpleName();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isSetQualifiedName() {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isReferenceType() {
		return referenceType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReferenceType(boolean newReferenceType) {
		boolean oldReferenceType = referenceType;
		referenceType = newReferenceType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.TYPE_ALIAS__REFERENCE_TYPE, oldReferenceType, referenceType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTType getDecoratedType() {
		if (decoratedType != null && decoratedType.eIsProxy()) {
			InternalEObject oldDecoratedType = (InternalEObject)decoratedType;
			decoratedType = (GASTType)eResolveProxy(oldDecoratedType);
			if (decoratedType != oldDecoratedType) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, typesPackage.TYPE_ALIAS__DECORATED_TYPE, oldDecoratedType, decoratedType));
			}
		}
		return decoratedType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTType basicGetDecoratedType() {
		return decoratedType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDecoratedType(GASTType newDecoratedType) {
		GASTType oldDecoratedType = decoratedType;
		decoratedType = newDecoratedType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.TYPE_ALIAS__DECORATED_TYPE, oldDecoratedType, decoratedType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTType getUndecoratedType() {
		GASTType undecoratedType = basicGetUndecoratedType();
		return undecoratedType != null && undecoratedType.eIsProxy() ? (GASTType)eResolveProxy((InternalEObject)undecoratedType) : undecoratedType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public GASTType basicGetUndecoratedType() {
		GASTType tmp = getDecoratedType();
		while (tmp instanceof TypeDecorator)
			tmp = ((TypeDecorator)tmp).getDecoratedType();
		return tmp;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setUndecoratedType(GASTType newUndecoratedType) {
		// TODO: implement this method to set the 'Undecorated Type' reference
		// Ensure that you remove @generated or mark it @generated NOT
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTType getAliasedType() {
		GASTType aliasedType = basicGetAliasedType();
		return aliasedType != null && aliasedType.eIsProxy() ? (GASTType)eResolveProxy((InternalEObject)aliasedType) : aliasedType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public GASTType basicGetAliasedType() {
		return this.getDecoratedType();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setAliasedType(GASTType newAliasedType) {
	    this.setDecoratedType(newAliasedType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isInnerTypeAlias() {
		return innerTypeAlias;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInnerTypeAlias(boolean newInnerTypeAlias) {
		boolean oldInnerTypeAlias = innerTypeAlias;
		innerTypeAlias = newInnerTypeAlias;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.TYPE_ALIAS__INNER_TYPE_ALIAS, oldInnerTypeAlias, innerTypeAlias));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTClass getSurroundingClass() {
		if (eContainerFeatureID() != typesPackage.TYPE_ALIAS__SURROUNDING_CLASS) return null;
		return (GASTClass)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSurroundingClass(GASTClass newSurroundingClass, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newSurroundingClass, typesPackage.TYPE_ALIAS__SURROUNDING_CLASS, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSurroundingClass(GASTClass newSurroundingClass) {
		if (newSurroundingClass != eInternalContainer() || (eContainerFeatureID() != typesPackage.TYPE_ALIAS__SURROUNDING_CLASS && newSurroundingClass != null)) {
			if (EcoreUtil.isAncestor(this, newSurroundingClass))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newSurroundingClass != null)
				msgs = ((InternalEObject)newSurroundingClass).eInverseAdd(this, typesPackage.GAST_CLASS__INNER_TYPE_ALIASES, GASTClass.class, msgs);
			msgs = basicSetSurroundingClass(newSurroundingClass, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.TYPE_ALIAS__SURROUNDING_CLASS, newSurroundingClass, newSurroundingClass));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public de.fzi.gast.core.Package getSurroundingPackage() {
		if (eContainerFeatureID() != typesPackage.TYPE_ALIAS__SURROUNDING_PACKAGE) return null;
		return (de.fzi.gast.core.Package)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSurroundingPackage(de.fzi.gast.core.Package newSurroundingPackage, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newSurroundingPackage, typesPackage.TYPE_ALIAS__SURROUNDING_PACKAGE, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSurroundingPackage(de.fzi.gast.core.Package newSurroundingPackage) {
		if (newSurroundingPackage != eInternalContainer() || (eContainerFeatureID() != typesPackage.TYPE_ALIAS__SURROUNDING_PACKAGE && newSurroundingPackage != null)) {
			if (EcoreUtil.isAncestor(this, newSurroundingPackage))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newSurroundingPackage != null)
				msgs = ((InternalEObject)newSurroundingPackage).eInverseAdd(this, corePackage.PACKAGE__TYPE_ALIASES, de.fzi.gast.core.Package.class, msgs);
			msgs = basicSetSurroundingPackage(newSurroundingPackage, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.TYPE_ALIAS__SURROUNDING_PACKAGE, newSurroundingPackage, newSurroundingPackage));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case typesPackage.TYPE_ALIAS__SURROUNDING_CLASS:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetSurroundingClass((GASTClass)otherEnd, msgs);
			case typesPackage.TYPE_ALIAS__SURROUNDING_PACKAGE:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetSurroundingPackage((de.fzi.gast.core.Package)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case typesPackage.TYPE_ALIAS__SURROUNDING_CLASS:
				return basicSetSurroundingClass(null, msgs);
			case typesPackage.TYPE_ALIAS__SURROUNDING_PACKAGE:
				return basicSetSurroundingPackage(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case typesPackage.TYPE_ALIAS__SURROUNDING_CLASS:
				return eInternalContainer().eInverseRemove(this, typesPackage.GAST_CLASS__INNER_TYPE_ALIASES, GASTClass.class, msgs);
			case typesPackage.TYPE_ALIAS__SURROUNDING_PACKAGE:
				return eInternalContainer().eInverseRemove(this, corePackage.PACKAGE__TYPE_ALIASES, de.fzi.gast.core.Package.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case typesPackage.TYPE_ALIAS__SIMPLE_NAME:
				return getSimpleName();
			case typesPackage.TYPE_ALIAS__QUALIFIED_NAME:
				return getQualifiedName();
			case typesPackage.TYPE_ALIAS__REFERENCE_TYPE:
				return isReferenceType();
			case typesPackage.TYPE_ALIAS__DECORATED_TYPE:
				if (resolve) return getDecoratedType();
				return basicGetDecoratedType();
			case typesPackage.TYPE_ALIAS__UNDECORATED_TYPE:
				if (resolve) return getUndecoratedType();
				return basicGetUndecoratedType();
			case typesPackage.TYPE_ALIAS__ALIASED_TYPE:
				if (resolve) return getAliasedType();
				return basicGetAliasedType();
			case typesPackage.TYPE_ALIAS__INNER_TYPE_ALIAS:
				return isInnerTypeAlias();
			case typesPackage.TYPE_ALIAS__SURROUNDING_CLASS:
				return getSurroundingClass();
			case typesPackage.TYPE_ALIAS__SURROUNDING_PACKAGE:
				return getSurroundingPackage();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case typesPackage.TYPE_ALIAS__SIMPLE_NAME:
				setSimpleName((String)newValue);
				return;
			case typesPackage.TYPE_ALIAS__REFERENCE_TYPE:
				setReferenceType((Boolean)newValue);
				return;
			case typesPackage.TYPE_ALIAS__DECORATED_TYPE:
				setDecoratedType((GASTType)newValue);
				return;
			case typesPackage.TYPE_ALIAS__INNER_TYPE_ALIAS:
				setInnerTypeAlias((Boolean)newValue);
				return;
			case typesPackage.TYPE_ALIAS__SURROUNDING_CLASS:
				setSurroundingClass((GASTClass)newValue);
				return;
			case typesPackage.TYPE_ALIAS__SURROUNDING_PACKAGE:
				setSurroundingPackage((de.fzi.gast.core.Package)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case typesPackage.TYPE_ALIAS__SIMPLE_NAME:
				setSimpleName(SIMPLE_NAME_EDEFAULT);
				return;
			case typesPackage.TYPE_ALIAS__REFERENCE_TYPE:
				setReferenceType(REFERENCE_TYPE_EDEFAULT);
				return;
			case typesPackage.TYPE_ALIAS__DECORATED_TYPE:
				setDecoratedType((GASTType)null);
				return;
			case typesPackage.TYPE_ALIAS__INNER_TYPE_ALIAS:
				setInnerTypeAlias(INNER_TYPE_ALIAS_EDEFAULT);
				return;
			case typesPackage.TYPE_ALIAS__SURROUNDING_CLASS:
				setSurroundingClass((GASTClass)null);
				return;
			case typesPackage.TYPE_ALIAS__SURROUNDING_PACKAGE:
				setSurroundingPackage((de.fzi.gast.core.Package)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case typesPackage.TYPE_ALIAS__SIMPLE_NAME:
				return SIMPLE_NAME_EDEFAULT == null ? simpleName != null : !SIMPLE_NAME_EDEFAULT.equals(simpleName);
			case typesPackage.TYPE_ALIAS__QUALIFIED_NAME:
				return QUALIFIED_NAME_EDEFAULT == null ? getQualifiedName() != null : !QUALIFIED_NAME_EDEFAULT.equals(getQualifiedName());
			case typesPackage.TYPE_ALIAS__REFERENCE_TYPE:
				return referenceType != REFERENCE_TYPE_EDEFAULT;
			case typesPackage.TYPE_ALIAS__DECORATED_TYPE:
				return decoratedType != null;
			case typesPackage.TYPE_ALIAS__UNDECORATED_TYPE:
				return basicGetUndecoratedType() != null;
			case typesPackage.TYPE_ALIAS__ALIASED_TYPE:
				return basicGetAliasedType() != null;
			case typesPackage.TYPE_ALIAS__INNER_TYPE_ALIAS:
				return innerTypeAlias != INNER_TYPE_ALIAS_EDEFAULT;
			case typesPackage.TYPE_ALIAS__SURROUNDING_CLASS:
				return getSurroundingClass() != null;
			case typesPackage.TYPE_ALIAS__SURROUNDING_PACKAGE:
				return getSurroundingPackage() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == NamedModelElement.class) {
			switch (derivedFeatureID) {
				case typesPackage.TYPE_ALIAS__SIMPLE_NAME: return corePackage.NAMED_MODEL_ELEMENT__SIMPLE_NAME;
				default: return -1;
			}
		}
		if (baseClass == GASTType.class) {
			switch (derivedFeatureID) {
				case typesPackage.TYPE_ALIAS__QUALIFIED_NAME: return typesPackage.GAST_TYPE__QUALIFIED_NAME;
				case typesPackage.TYPE_ALIAS__REFERENCE_TYPE: return typesPackage.GAST_TYPE__REFERENCE_TYPE;
				default: return -1;
			}
		}
		if (baseClass == TypeDecorator.class) {
			switch (derivedFeatureID) {
				case typesPackage.TYPE_ALIAS__DECORATED_TYPE: return typesPackage.TYPE_DECORATOR__DECORATED_TYPE;
				case typesPackage.TYPE_ALIAS__UNDECORATED_TYPE: return typesPackage.TYPE_DECORATOR__UNDECORATED_TYPE;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == NamedModelElement.class) {
			switch (baseFeatureID) {
				case corePackage.NAMED_MODEL_ELEMENT__SIMPLE_NAME: return typesPackage.TYPE_ALIAS__SIMPLE_NAME;
				default: return -1;
			}
		}
		if (baseClass == GASTType.class) {
			switch (baseFeatureID) {
				case typesPackage.GAST_TYPE__QUALIFIED_NAME: return typesPackage.TYPE_ALIAS__QUALIFIED_NAME;
				case typesPackage.GAST_TYPE__REFERENCE_TYPE: return typesPackage.TYPE_ALIAS__REFERENCE_TYPE;
				default: return -1;
			}
		}
		if (baseClass == TypeDecorator.class) {
			switch (baseFeatureID) {
				case typesPackage.TYPE_DECORATOR__DECORATED_TYPE: return typesPackage.TYPE_ALIAS__DECORATED_TYPE;
				case typesPackage.TYPE_DECORATOR__UNDECORATED_TYPE: return typesPackage.TYPE_ALIAS__UNDECORATED_TYPE;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (simpleName: ");
		result.append(simpleName);
		result.append(", referenceType: ");
		result.append(referenceType);
		result.append(", innerTypeAlias: ");
		result.append(innerTypeAlias);
		result.append(')');
		return result.toString();
	}

} //TypeAliasImpl
