/**
 * <copyright>
 * </copyright>
 *
 * $Id: MemberImpl.java,v 1.6 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.types.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import de.fzi.gast.core.impl.SourceEntityImpl;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.Member;
import de.fzi.gast.types.TypeParameterClass;
import de.fzi.gast.types.Visibilities;
import de.fzi.gast.types.typesPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Member</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.types.impl.MemberImpl#getVisibility <em>Visibility</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.MemberImpl#getOverriddenMember <em>Overridden Member</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.MemberImpl#isAbstract <em>Abstract</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.MemberImpl#isExtern <em>Extern</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.MemberImpl#isFinal <em>Final</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.MemberImpl#isInternal <em>Internal</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.MemberImpl#isIntrospectable <em>Introspectable</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.MemberImpl#isOverride <em>Override</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.MemberImpl#isStatic <em>Static</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.MemberImpl#isTypeParameterClassMember <em>Type Parameter Class Member</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.MemberImpl#isVirtual <em>Virtual</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class MemberImpl extends SourceEntityImpl implements Member {
	/**
	 * The default value of the '{@link #getVisibility() <em>Visibility</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVisibility()
	 * @generated
	 * @ordered
	 */
	protected static final Visibilities VISIBILITY_EDEFAULT = Visibilities.VISIBILITYSTRICTPROTECTED;

	/**
	 * The cached value of the '{@link #getVisibility() <em>Visibility</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVisibility()
	 * @generated
	 * @ordered
	 */
	protected Visibilities visibility = VISIBILITY_EDEFAULT;

	/**
	 * The cached value of the '{@link #getOverriddenMember() <em>Overridden Member</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getOverriddenMember()
	 * @generated
	 * @ordered
	 */
	protected Member overriddenMember;

	/**
	 * The default value of the '{@link #isAbstract() <em>Abstract</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAbstract()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ABSTRACT_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isAbstract() <em>Abstract</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAbstract()
	 * @generated
	 * @ordered
	 */
	protected boolean abstract_ = ABSTRACT_EDEFAULT;

	/**
	 * The default value of the '{@link #isExtern() <em>Extern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isExtern()
	 * @generated
	 * @ordered
	 */
	protected static final boolean EXTERN_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isExtern() <em>Extern</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isExtern()
	 * @generated
	 * @ordered
	 */
	protected boolean extern = EXTERN_EDEFAULT;

	/**
	 * The default value of the '{@link #isFinal() <em>Final</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isFinal()
	 * @generated
	 * @ordered
	 */
	protected static final boolean FINAL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isFinal() <em>Final</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isFinal()
	 * @generated
	 * @ordered
	 */
	protected boolean final_ = FINAL_EDEFAULT;

	/**
	 * The default value of the '{@link #isInternal() <em>Internal</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInternal()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INTERNAL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isInternal() <em>Internal</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInternal()
	 * @generated
	 * @ordered
	 */
	protected boolean internal = INTERNAL_EDEFAULT;

	/**
	 * The default value of the '{@link #isIntrospectable() <em>Introspectable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIntrospectable()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INTROSPECTABLE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isIntrospectable() <em>Introspectable</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isIntrospectable()
	 * @generated
	 * @ordered
	 */
	protected boolean introspectable = INTROSPECTABLE_EDEFAULT;

	/**
	 * The default value of the '{@link #isOverride() <em>Override</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isOverride()
	 * @generated
	 * @ordered
	 */
	protected static final boolean OVERRIDE_EDEFAULT = false;

	/**
	 * The default value of the '{@link #isStatic() <em>Static</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isStatic()
	 * @generated
	 * @ordered
	 */
	protected static final boolean STATIC_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isStatic() <em>Static</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isStatic()
	 * @generated
	 * @ordered
	 */
	protected boolean static_ = STATIC_EDEFAULT;

	/**
	 * The default value of the '{@link #isTypeParameterClassMember() <em>Type Parameter Class Member</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isTypeParameterClassMember()
	 * @generated
	 * @ordered
	 */
	protected static final boolean TYPE_PARAMETER_CLASS_MEMBER_EDEFAULT = false;

	/**
	 * The default value of the '{@link #isVirtual() <em>Virtual</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isVirtual()
	 * @generated
	 * @ordered
	 */
	protected static final boolean VIRTUAL_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isVirtual() <em>Virtual</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isVirtual()
	 * @generated
	 * @ordered
	 */
	protected boolean virtual = VIRTUAL_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected MemberImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return typesPackage.Literals.MEMBER;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Visibilities getVisibility() {
		return visibility;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVisibility(Visibilities newVisibility) {
		Visibilities oldVisibility = visibility;
		visibility = newVisibility == null ? VISIBILITY_EDEFAULT : newVisibility;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.MEMBER__VISIBILITY, oldVisibility, visibility));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Member getOverriddenMember() {
		if (overriddenMember != null && overriddenMember.eIsProxy()) {
			InternalEObject oldOverriddenMember = (InternalEObject)overriddenMember;
			overriddenMember = (Member)eResolveProxy(oldOverriddenMember);
			if (overriddenMember != oldOverriddenMember) {
				if (eNotificationRequired())
					eNotify(new ENotificationImpl(this, Notification.RESOLVE, typesPackage.MEMBER__OVERRIDDEN_MEMBER, oldOverriddenMember, overriddenMember));
			}
		}
		return overriddenMember;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Member basicGetOverriddenMember() {
		return overriddenMember;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setOverriddenMember(Member newOverriddenMember) {
		Member oldOverriddenMember = overriddenMember;
		overriddenMember = newOverriddenMember;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.MEMBER__OVERRIDDEN_MEMBER, oldOverriddenMember, overriddenMember));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isAbstract() {
		return abstract_;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAbstract(boolean newAbstract) {
		boolean oldAbstract = abstract_;
		abstract_ = newAbstract;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.MEMBER__ABSTRACT, oldAbstract, abstract_));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isExtern() {
		return extern;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setExtern(boolean newExtern) {
		boolean oldExtern = extern;
		extern = newExtern;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.MEMBER__EXTERN, oldExtern, extern));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isFinal() {
		return final_;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFinal(boolean newFinal) {
		boolean oldFinal = final_;
		final_ = newFinal;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.MEMBER__FINAL, oldFinal, final_));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isInternal() {
		return internal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInternal(boolean newInternal) {
		boolean oldInternal = internal;
		internal = newInternal;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.MEMBER__INTERNAL, oldInternal, internal));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isIntrospectable() {
		return introspectable;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIntrospectable(boolean newIntrospectable) {
		boolean oldIntrospectable = introspectable;
		introspectable = newIntrospectable;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.MEMBER__INTROSPECTABLE, oldIntrospectable, introspectable));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isOverride() {
		return getOverriddenMember() != null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isSetOverride() {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isStatic() {
		return static_;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setStatic(boolean newStatic) {
		boolean oldStatic = static_;
		static_ = newStatic;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.MEMBER__STATIC, oldStatic, static_));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isTypeParameterClassMember() {
		if (getSurroundingClass() == null)
			return false;
		
		return (getSurroundingClass() instanceof TypeParameterClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isSetTypeParameterClassMember() {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isVirtual() {
		return virtual;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVirtual(boolean newVirtual) {
		boolean oldVirtual = virtual;
		virtual = newVirtual;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.MEMBER__VIRTUAL, oldVirtual, virtual));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public abstract GASTClass getSurroundingClass();
	
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case typesPackage.MEMBER__VISIBILITY:
				return getVisibility();
			case typesPackage.MEMBER__OVERRIDDEN_MEMBER:
				if (resolve) return getOverriddenMember();
				return basicGetOverriddenMember();
			case typesPackage.MEMBER__ABSTRACT:
				return isAbstract();
			case typesPackage.MEMBER__EXTERN:
				return isExtern();
			case typesPackage.MEMBER__FINAL:
				return isFinal();
			case typesPackage.MEMBER__INTERNAL:
				return isInternal();
			case typesPackage.MEMBER__INTROSPECTABLE:
				return isIntrospectable();
			case typesPackage.MEMBER__OVERRIDE:
				return isOverride();
			case typesPackage.MEMBER__STATIC:
				return isStatic();
			case typesPackage.MEMBER__TYPE_PARAMETER_CLASS_MEMBER:
				return isTypeParameterClassMember();
			case typesPackage.MEMBER__VIRTUAL:
				return isVirtual();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case typesPackage.MEMBER__VISIBILITY:
				setVisibility((Visibilities)newValue);
				return;
			case typesPackage.MEMBER__OVERRIDDEN_MEMBER:
				setOverriddenMember((Member)newValue);
				return;
			case typesPackage.MEMBER__ABSTRACT:
				setAbstract((Boolean)newValue);
				return;
			case typesPackage.MEMBER__EXTERN:
				setExtern((Boolean)newValue);
				return;
			case typesPackage.MEMBER__FINAL:
				setFinal((Boolean)newValue);
				return;
			case typesPackage.MEMBER__INTERNAL:
				setInternal((Boolean)newValue);
				return;
			case typesPackage.MEMBER__INTROSPECTABLE:
				setIntrospectable((Boolean)newValue);
				return;
			case typesPackage.MEMBER__STATIC:
				setStatic((Boolean)newValue);
				return;
			case typesPackage.MEMBER__VIRTUAL:
				setVirtual((Boolean)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case typesPackage.MEMBER__VISIBILITY:
				setVisibility(VISIBILITY_EDEFAULT);
				return;
			case typesPackage.MEMBER__OVERRIDDEN_MEMBER:
				setOverriddenMember((Member)null);
				return;
			case typesPackage.MEMBER__ABSTRACT:
				setAbstract(ABSTRACT_EDEFAULT);
				return;
			case typesPackage.MEMBER__EXTERN:
				setExtern(EXTERN_EDEFAULT);
				return;
			case typesPackage.MEMBER__FINAL:
				setFinal(FINAL_EDEFAULT);
				return;
			case typesPackage.MEMBER__INTERNAL:
				setInternal(INTERNAL_EDEFAULT);
				return;
			case typesPackage.MEMBER__INTROSPECTABLE:
				setIntrospectable(INTROSPECTABLE_EDEFAULT);
				return;
			case typesPackage.MEMBER__STATIC:
				setStatic(STATIC_EDEFAULT);
				return;
			case typesPackage.MEMBER__VIRTUAL:
				setVirtual(VIRTUAL_EDEFAULT);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case typesPackage.MEMBER__VISIBILITY:
				return visibility != VISIBILITY_EDEFAULT;
			case typesPackage.MEMBER__OVERRIDDEN_MEMBER:
				return overriddenMember != null;
			case typesPackage.MEMBER__ABSTRACT:
				return abstract_ != ABSTRACT_EDEFAULT;
			case typesPackage.MEMBER__EXTERN:
				return extern != EXTERN_EDEFAULT;
			case typesPackage.MEMBER__FINAL:
				return final_ != FINAL_EDEFAULT;
			case typesPackage.MEMBER__INTERNAL:
				return internal != INTERNAL_EDEFAULT;
			case typesPackage.MEMBER__INTROSPECTABLE:
				return introspectable != INTROSPECTABLE_EDEFAULT;
			case typesPackage.MEMBER__OVERRIDE:
				return isOverride() != OVERRIDE_EDEFAULT;
			case typesPackage.MEMBER__STATIC:
				return static_ != STATIC_EDEFAULT;
			case typesPackage.MEMBER__TYPE_PARAMETER_CLASS_MEMBER:
				return isTypeParameterClassMember() != TYPE_PARAMETER_CLASS_MEMBER_EDEFAULT;
			case typesPackage.MEMBER__VIRTUAL:
				return virtual != VIRTUAL_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (visibility: ");
		result.append(visibility);
		result.append(", abstract: ");
		result.append(abstract_);
		result.append(", extern: ");
		result.append(extern);
		result.append(", final: ");
		result.append(final_);
		result.append(", internal: ");
		result.append(internal);
		result.append(", introspectable: ");
		result.append(introspectable);
		result.append(", static: ");
		result.append(static_);
		result.append(", virtual: ");
		result.append(virtual);
		result.append(')');
		return result.toString();
	}

} //MemberImpl
