/**
 * <copyright>
 * </copyright>
 *
 * $Id: GASTClassImpl.java,v 1.3 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.types.impl;

import java.util.Collection;
import java.util.Iterator;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.BasicInternalEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import de.fzi.gast.accesses.Access;
import de.fzi.gast.accesses.InheritanceTypeAccess;
import de.fzi.gast.core.NamedModelElement;
import de.fzi.gast.core.corePackage;
import de.fzi.gast.functions.Constructor;
import de.fzi.gast.functions.Delegate;
import de.fzi.gast.functions.Destructor;
import de.fzi.gast.functions.Function;
import de.fzi.gast.functions.Method;
import de.fzi.gast.functions.functionsPackage;
import de.fzi.gast.helpers.DerivationHelper;
import de.fzi.gast.types.GASTClass;
import de.fzi.gast.types.GASTType;
import de.fzi.gast.types.TypeAlias;
import de.fzi.gast.types.typesPackage;
import de.fzi.gast.variables.Field;
import de.fzi.gast.variables.Property;
import de.fzi.gast.variables.variablesPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>GAST Class</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#getSimpleName <em>Simple Name</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#getQualifiedName <em>Qualified Name</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#isReferenceType <em>Reference Type</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#getInnerTypeAliases <em>Inner Type Aliases</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#getInnerDelegates <em>Inner Delegates</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#getConstructors <em>Constructors</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#getDestructors <em>Destructors</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#getFields <em>Fields</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#getMethods <em>Methods</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#getSurroundingFunction <em>Surrounding Function</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#getSurroundingPackage <em>Surrounding Package</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#getSuperTypes <em>Super Types</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#getLinesOfComments <em>Lines Of Comments</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#isLocal <em>Local</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#isPrimitive <em>Primitive</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#isInterface <em>Interface</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#isAnonymous <em>Anonymous</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#getInnerClasses <em>Inner Classes</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#getSurroundingClass <em>Surrounding Class</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#getInheritanceTypeAccesses <em>Inheritance Type Accesses</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#getSelf <em>Self</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#getFriendClasses <em>Friend Classes</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#getFriendFunctions <em>Friend Functions</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#getProperty <em>Property</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#getAllAccesses <em>All Accesses</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#getAllAccessedClasses <em>All Accessed Classes</em>}</li>
 *   <li>{@link de.fzi.gast.types.impl.GASTClassImpl#isInner <em>Inner</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class GASTClassImpl extends MemberImpl implements GASTClass {
	
	/**
	 * caching
	 * @generated NOT
	 */
	private String cachedQualifiedName;
	
	/**
	 * The default value of the '{@link #getSimpleName() <em>Simple Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSimpleName()
	 * @generated
	 * @ordered
	 */
	protected static final String SIMPLE_NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getSimpleName() <em>Simple Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSimpleName()
	 * @generated
	 * @ordered
	 */
	protected String simpleName = SIMPLE_NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getQualifiedName() <em>Qualified Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getQualifiedName()
	 * @generated
	 * @ordered
	 */
	protected static final String QUALIFIED_NAME_EDEFAULT = null;

	/**
	 * The default value of the '{@link #isReferenceType() <em>Reference Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isReferenceType()
	 * @generated
	 * @ordered
	 */
	protected static final boolean REFERENCE_TYPE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isReferenceType() <em>Reference Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isReferenceType()
	 * @generated
	 * @ordered
	 */
	protected boolean referenceType = REFERENCE_TYPE_EDEFAULT;

	/**
	 * The cached value of the '{@link #getInnerTypeAliases() <em>Inner Type Aliases</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInnerTypeAliases()
	 * @generated
	 * @ordered
	 */
	protected EList<TypeAlias> innerTypeAliases;

	/**
	 * The cached value of the '{@link #getInnerDelegates() <em>Inner Delegates</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInnerDelegates()
	 * @generated
	 * @ordered
	 */
	protected EList<Delegate> innerDelegates;

	/**
	 * The cached value of the '{@link #getConstructors() <em>Constructors</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConstructors()
	 * @generated
	 * @ordered
	 */
	protected EList<Constructor> constructors;

	/**
	 * The cached value of the '{@link #getDestructors() <em>Destructors</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDestructors()
	 * @generated
	 * @ordered
	 */
	protected EList<Destructor> destructors;

	/**
	 * The cached value of the '{@link #getFields() <em>Fields</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFields()
	 * @generated
	 * @ordered
	 */
	protected EList<Field> fields;

	/**
	 * The cached value of the '{@link #getMethods() <em>Methods</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMethods()
	 * @generated
	 * @ordered
	 */
	protected EList<Method> methods;

	/**
	 * The default value of the '{@link #getLinesOfComments() <em>Lines Of Comments</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinesOfComments()
	 * @generated
	 * @ordered
	 */
	protected static final int LINES_OF_COMMENTS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLinesOfComments() <em>Lines Of Comments</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinesOfComments()
	 * @generated
	 * @ordered
	 */
	protected int linesOfComments = LINES_OF_COMMENTS_EDEFAULT;

	/**
	 * The default value of the '{@link #isLocal() <em>Local</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isLocal()
	 * @generated
	 * @ordered
	 */
	protected static final boolean LOCAL_EDEFAULT = false;

	/**
	 * The default value of the '{@link #isPrimitive() <em>Primitive</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isPrimitive()
	 * @generated
	 * @ordered
	 */
	protected static final boolean PRIMITIVE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isPrimitive() <em>Primitive</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isPrimitive()
	 * @generated
	 * @ordered
	 */
	protected boolean primitive = PRIMITIVE_EDEFAULT;

	/**
	 * The default value of the '{@link #isInterface() <em>Interface</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInterface()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INTERFACE_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isInterface() <em>Interface</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInterface()
	 * @generated
	 * @ordered
	 */
	protected boolean interface_ = INTERFACE_EDEFAULT;

	/**
	 * The default value of the '{@link #isAnonymous() <em>Anonymous</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAnonymous()
	 * @generated
	 * @ordered
	 */
	protected static final boolean ANONYMOUS_EDEFAULT = false;

	/**
	 * The cached value of the '{@link #isAnonymous() <em>Anonymous</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAnonymous()
	 * @generated
	 * @ordered
	 */
	protected boolean anonymous = ANONYMOUS_EDEFAULT;

	/**
	 * The cached value of the '{@link #getInnerClasses() <em>Inner Classes</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInnerClasses()
	 * @generated
	 * @ordered
	 */
	protected EList<GASTClass> innerClasses;

	/**
	 * The cached value of the '{@link #getInheritanceTypeAccesses() <em>Inheritance Type Accesses</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInheritanceTypeAccesses()
	 * @generated
	 * @ordered
	 */
	protected EList<InheritanceTypeAccess> inheritanceTypeAccesses;

	/**
	 * The cached value of the '{@link #getSelf() <em>Self</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getSelf()
	 * @generated
	 * @ordered
	 */
	protected Field self;

	/**
	 * The cached value of the '{@link #getFriendClasses() <em>Friend Classes</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFriendClasses()
	 * @generated
	 * @ordered
	 */
	protected EList<GASTClass> friendClasses;

	/**
	 * The cached value of the '{@link #getFriendFunctions() <em>Friend Functions</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFriendFunctions()
	 * @generated
	 * @ordered
	 */
	protected EList<Function> friendFunctions;

	/**
	 * The cached value of the '{@link #getProperty() <em>Property</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProperty()
	 * @generated
	 * @ordered
	 */
	protected EList<Property> property;

	/**
	 * The default value of the '{@link #isInner() <em>Inner</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isInner()
	 * @generated
	 * @ordered
	 */
	protected static final boolean INNER_EDEFAULT = false;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected GASTClassImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return typesPackage.Literals.GAST_CLASS;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getSimpleName() {
		return simpleName;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSimpleName(String newSimpleName) {
		String oldSimpleName = simpleName;
		simpleName = newSimpleName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.GAST_CLASS__SIMPLE_NAME, oldSimpleName, simpleName));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public String getQualifiedName() {
		String returnQualifiedName;
		if(cachedQualifiedName == null) {
			String prefix = "";
			String sep = "";
			GASTClass cls = getSurroundingClass();
			Function f = getSurroundingFunction();
			
			if (cls != null) {
				prefix = cls.getQualifiedName();
				sep = "$";
			}
			else if (getSurroundingPackage() != null) {
				prefix = getSurroundingPackage().getQualifiedName();
				sep = ".";
			}
			if (f != null) {
				prefix = prefix + "." + f.getSimpleName();
				sep = "$";
				returnQualifiedName = prefix + sep + f.getLocalClasses().indexOf(this);
			}
			else {				
				returnQualifiedName = prefix + sep + getSimpleName();
			}
			cachedQualifiedName = returnQualifiedName;
			return returnQualifiedName;
		} else {
			return cachedQualifiedName;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isSetQualifiedName() {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isReferenceType() {
		return referenceType;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setReferenceType(boolean newReferenceType) {
		boolean oldReferenceType = referenceType;
		referenceType = newReferenceType;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.GAST_CLASS__REFERENCE_TYPE, oldReferenceType, referenceType));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<TypeAlias> getInnerTypeAliases() {
		if (innerTypeAliases == null) {
			innerTypeAliases = new EObjectContainmentWithInverseEList<TypeAlias>(TypeAlias.class, this, typesPackage.GAST_CLASS__INNER_TYPE_ALIASES, typesPackage.TYPE_ALIAS__SURROUNDING_CLASS);
		}
		return innerTypeAliases;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Field> getFields() {
		if (fields == null) {
			fields = new EObjectContainmentWithInverseEList<Field>(Field.class, this, typesPackage.GAST_CLASS__FIELDS, variablesPackage.FIELD__SURROUNDING_CLASS);
		}
		return fields;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Method> getMethods() {
		if (methods == null) {
			methods = new EObjectContainmentWithInverseEList<Method>(Method.class, this, typesPackage.GAST_CLASS__METHODS, functionsPackage.METHOD__SURROUNDING_CLASS);
		}
		return methods;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Constructor> getConstructors() {
		if (constructors == null) {
			constructors = new EObjectContainmentWithInverseEList<Constructor>(Constructor.class, this, typesPackage.GAST_CLASS__CONSTRUCTORS, functionsPackage.CONSTRUCTOR__SURROUNDING_CLASS);
		}
		return constructors;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Destructor> getDestructors() {
		if (destructors == null) {
			destructors = new EObjectContainmentWithInverseEList<Destructor>(Destructor.class, this, typesPackage.GAST_CLASS__DESTRUCTORS, functionsPackage.DESTRUCTOR__SURROUNDING_CLASS);
		}
		return destructors;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Delegate> getInnerDelegates() {
		if (innerDelegates == null) {
			innerDelegates = new EObjectContainmentWithInverseEList<Delegate>(Delegate.class, this, typesPackage.GAST_CLASS__INNER_DELEGATES, functionsPackage.DELEGATE__SURROUNDING_CLASS);
		}
		return innerDelegates;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public de.fzi.gast.core.Package getSurroundingPackage() {
		/*
		if (eContainerFeatureID != typesPackage.GAST_CLASS__SURROUNDING_PACKAGE) return null;
		return (de.fzi.gast.core.Package)eContainer();
		*/
		return (de.fzi.gast.core.Package) DerivationHelper.calculateNearestParentOfType(this, de.fzi.gast.core.Package.class);

	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSurroundingPackage(de.fzi.gast.core.Package newSurroundingPackage, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newSurroundingPackage, typesPackage.GAST_CLASS__SURROUNDING_PACKAGE, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSurroundingPackage(de.fzi.gast.core.Package newSurroundingPackage) {
		if (newSurroundingPackage != eInternalContainer() || (eContainerFeatureID() != typesPackage.GAST_CLASS__SURROUNDING_PACKAGE && newSurroundingPackage != null)) {
			if (EcoreUtil.isAncestor(this, newSurroundingPackage))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newSurroundingPackage != null)
				msgs = ((InternalEObject)newSurroundingPackage).eInverseAdd(this, corePackage.PACKAGE__CLASSES, de.fzi.gast.core.Package.class, msgs);
			msgs = basicSetSurroundingPackage(newSurroundingPackage, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.GAST_CLASS__SURROUNDING_PACKAGE, newSurroundingPackage, newSurroundingPackage));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<GASTClass> getSuperTypes() {
		BasicInternalEList result = new BasicInternalEList(GASTClass.class);
		Iterator it = this.getInheritanceTypeAccesses().iterator();
		
		while(it.hasNext()) {
			InheritanceTypeAccess ita = (InheritanceTypeAccess) it.next();
			if (!ita.isImplementationInheritance()) { 
				result.addUnique(ita.getAccessedClass());
			}
		}
		
		return result; 
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getLinesOfComments() {
		return linesOfComments;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLinesOfComments(int newLinesOfComments) {
		int oldLinesOfComments = linesOfComments;
		linesOfComments = newLinesOfComments;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.GAST_CLASS__LINES_OF_COMMENTS, oldLinesOfComments, linesOfComments));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isLocal() {
		return DerivationHelper.isLocal(this); 
		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setLocal(boolean newLocal) {

	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void unsetLocal() {
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isPrimitive() {
		return primitive;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setPrimitive(boolean newPrimitive) {
		boolean oldPrimitive = primitive;
		primitive = newPrimitive;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.GAST_CLASS__PRIMITIVE, oldPrimitive, primitive));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Function getSurroundingFunction() {
		/*
		if (eContainerFeatureID != typesPackage.GAST_CLASS__SURROUNDING_FUNCTION) return null;
		return (Function)eContainer();
		*/
		return (Function) DerivationHelper.calculateNearestParentOfType(this, Function.class, GASTClass.class);

	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSurroundingFunction(Function newSurroundingFunction, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newSurroundingFunction, typesPackage.GAST_CLASS__SURROUNDING_FUNCTION, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSurroundingFunction(Function newSurroundingFunction) {
		if (newSurroundingFunction != eInternalContainer() || (eContainerFeatureID() != typesPackage.GAST_CLASS__SURROUNDING_FUNCTION && newSurroundingFunction != null)) {
			if (EcoreUtil.isAncestor(this, newSurroundingFunction))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newSurroundingFunction != null)
				msgs = ((InternalEObject)newSurroundingFunction).eInverseAdd(this, functionsPackage.FUNCTION__LOCAL_CLASSES, Function.class, msgs);
			msgs = basicSetSurroundingFunction(newSurroundingFunction, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.GAST_CLASS__SURROUNDING_FUNCTION, newSurroundingFunction, newSurroundingFunction));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isInterface() {
		return interface_;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInterface(boolean newInterface) {
		boolean oldInterface = interface_;
		interface_ = newInterface;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.GAST_CLASS__INTERFACE, oldInterface, interface_));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean isAnonymous() {
		return anonymous;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setAnonymous(boolean newAnonymous) {
		boolean oldAnonymous = anonymous;
		anonymous = newAnonymous;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.GAST_CLASS__ANONYMOUS, oldAnonymous, anonymous));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<GASTClass> getInnerClasses() {
		if (innerClasses == null) {
			innerClasses = new EObjectContainmentWithInverseEList<GASTClass>(GASTClass.class, this, typesPackage.GAST_CLASS__INNER_CLASSES, typesPackage.GAST_CLASS__SURROUNDING_CLASS);
		}
		return innerClasses;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public GASTClass getSurroundingClass() {
		/*
		if (eContainerFeatureID != typesPackage.GAST_CLASS__SURROUNDING_CLASS) return null;
		return (GASTClass)eContainer();
		*/
		return (GASTClass) DerivationHelper.calculateNearestParentOfType(this, GASTClass.class, Package.class);

	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSurroundingClass(GASTClass newSurroundingClass, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newSurroundingClass, typesPackage.GAST_CLASS__SURROUNDING_CLASS, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSurroundingClass(GASTClass newSurroundingClass) {
		if (newSurroundingClass != eInternalContainer() || (eContainerFeatureID() != typesPackage.GAST_CLASS__SURROUNDING_CLASS && newSurroundingClass != null)) {
			if (EcoreUtil.isAncestor(this, newSurroundingClass))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newSurroundingClass != null)
				msgs = ((InternalEObject)newSurroundingClass).eInverseAdd(this, typesPackage.GAST_CLASS__INNER_CLASSES, GASTClass.class, msgs);
			msgs = basicSetSurroundingClass(newSurroundingClass, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.GAST_CLASS__SURROUNDING_CLASS, newSurroundingClass, newSurroundingClass));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<InheritanceTypeAccess> getInheritanceTypeAccesses() {
		if (inheritanceTypeAccesses == null) {
			inheritanceTypeAccesses = new EObjectContainmentEList<InheritanceTypeAccess>(InheritanceTypeAccess.class, this, typesPackage.GAST_CLASS__INHERITANCE_TYPE_ACCESSES);
		}
		return inheritanceTypeAccesses;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Field getSelf() {
		return self;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetSelf(Field newSelf, NotificationChain msgs) {
		Field oldSelf = self;
		self = newSelf;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, typesPackage.GAST_CLASS__SELF, oldSelf, newSelf);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setSelf(Field newSelf) {
		if (newSelf != self) {
			NotificationChain msgs = null;
			if (self != null)
				msgs = ((InternalEObject)self).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - typesPackage.GAST_CLASS__SELF, null, msgs);
			if (newSelf != null)
				msgs = ((InternalEObject)newSelf).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - typesPackage.GAST_CLASS__SELF, null, msgs);
			msgs = basicSetSelf(newSelf, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, typesPackage.GAST_CLASS__SELF, newSelf, newSelf));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<GASTClass> getFriendClasses() {
		if (friendClasses == null) {
			friendClasses = new EObjectResolvingEList<GASTClass>(GASTClass.class, this, typesPackage.GAST_CLASS__FRIEND_CLASSES);
		}
		return friendClasses;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Function> getFriendFunctions() {
		if (friendFunctions == null) {
			friendFunctions = new EObjectContainmentEList<Function>(Function.class, this, typesPackage.GAST_CLASS__FRIEND_FUNCTIONS);
		}
		return friendFunctions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<Property> getProperty() {
		if (property == null) {
			property = new EObjectContainmentEList<Property>(Property.class, this, typesPackage.GAST_CLASS__PROPERTY);
		}
		return property;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<Access> getAllAccesses() {
		return DerivationHelper.getAllAccesses(this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public EList<GASTClass> getAllAccessedClasses() {
		return DerivationHelper.getAllAccessedClasses(this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isInner() {
		return DerivationHelper.isInner(this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public boolean isSetInner() {
		return true;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case typesPackage.GAST_CLASS__INNER_TYPE_ALIASES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getInnerTypeAliases()).basicAdd(otherEnd, msgs);
			case typesPackage.GAST_CLASS__INNER_DELEGATES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getInnerDelegates()).basicAdd(otherEnd, msgs);
			case typesPackage.GAST_CLASS__CONSTRUCTORS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getConstructors()).basicAdd(otherEnd, msgs);
			case typesPackage.GAST_CLASS__DESTRUCTORS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getDestructors()).basicAdd(otherEnd, msgs);
			case typesPackage.GAST_CLASS__FIELDS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getFields()).basicAdd(otherEnd, msgs);
			case typesPackage.GAST_CLASS__METHODS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getMethods()).basicAdd(otherEnd, msgs);
			case typesPackage.GAST_CLASS__SURROUNDING_FUNCTION:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetSurroundingFunction((Function)otherEnd, msgs);
			case typesPackage.GAST_CLASS__SURROUNDING_PACKAGE:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetSurroundingPackage((de.fzi.gast.core.Package)otherEnd, msgs);
			case typesPackage.GAST_CLASS__INNER_CLASSES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getInnerClasses()).basicAdd(otherEnd, msgs);
			case typesPackage.GAST_CLASS__SURROUNDING_CLASS:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetSurroundingClass((GASTClass)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case typesPackage.GAST_CLASS__INNER_TYPE_ALIASES:
				return ((InternalEList<?>)getInnerTypeAliases()).basicRemove(otherEnd, msgs);
			case typesPackage.GAST_CLASS__INNER_DELEGATES:
				return ((InternalEList<?>)getInnerDelegates()).basicRemove(otherEnd, msgs);
			case typesPackage.GAST_CLASS__CONSTRUCTORS:
				return ((InternalEList<?>)getConstructors()).basicRemove(otherEnd, msgs);
			case typesPackage.GAST_CLASS__DESTRUCTORS:
				return ((InternalEList<?>)getDestructors()).basicRemove(otherEnd, msgs);
			case typesPackage.GAST_CLASS__FIELDS:
				return ((InternalEList<?>)getFields()).basicRemove(otherEnd, msgs);
			case typesPackage.GAST_CLASS__METHODS:
				return ((InternalEList<?>)getMethods()).basicRemove(otherEnd, msgs);
			case typesPackage.GAST_CLASS__SURROUNDING_FUNCTION:
				return basicSetSurroundingFunction(null, msgs);
			case typesPackage.GAST_CLASS__SURROUNDING_PACKAGE:
				return basicSetSurroundingPackage(null, msgs);
			case typesPackage.GAST_CLASS__INNER_CLASSES:
				return ((InternalEList<?>)getInnerClasses()).basicRemove(otherEnd, msgs);
			case typesPackage.GAST_CLASS__SURROUNDING_CLASS:
				return basicSetSurroundingClass(null, msgs);
			case typesPackage.GAST_CLASS__INHERITANCE_TYPE_ACCESSES:
				return ((InternalEList<?>)getInheritanceTypeAccesses()).basicRemove(otherEnd, msgs);
			case typesPackage.GAST_CLASS__SELF:
				return basicSetSelf(null, msgs);
			case typesPackage.GAST_CLASS__FRIEND_FUNCTIONS:
				return ((InternalEList<?>)getFriendFunctions()).basicRemove(otherEnd, msgs);
			case typesPackage.GAST_CLASS__PROPERTY:
				return ((InternalEList<?>)getProperty()).basicRemove(otherEnd, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case typesPackage.GAST_CLASS__SURROUNDING_FUNCTION:
				return eInternalContainer().eInverseRemove(this, functionsPackage.FUNCTION__LOCAL_CLASSES, Function.class, msgs);
			case typesPackage.GAST_CLASS__SURROUNDING_PACKAGE:
				return eInternalContainer().eInverseRemove(this, corePackage.PACKAGE__CLASSES, de.fzi.gast.core.Package.class, msgs);
			case typesPackage.GAST_CLASS__SURROUNDING_CLASS:
				return eInternalContainer().eInverseRemove(this, typesPackage.GAST_CLASS__INNER_CLASSES, GASTClass.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case typesPackage.GAST_CLASS__SIMPLE_NAME:
				return getSimpleName();
			case typesPackage.GAST_CLASS__QUALIFIED_NAME:
				return getQualifiedName();
			case typesPackage.GAST_CLASS__REFERENCE_TYPE:
				return isReferenceType();
			case typesPackage.GAST_CLASS__INNER_TYPE_ALIASES:
				return getInnerTypeAliases();
			case typesPackage.GAST_CLASS__INNER_DELEGATES:
				return getInnerDelegates();
			case typesPackage.GAST_CLASS__CONSTRUCTORS:
				return getConstructors();
			case typesPackage.GAST_CLASS__DESTRUCTORS:
				return getDestructors();
			case typesPackage.GAST_CLASS__FIELDS:
				return getFields();
			case typesPackage.GAST_CLASS__METHODS:
				return getMethods();
			case typesPackage.GAST_CLASS__SURROUNDING_FUNCTION:
				return getSurroundingFunction();
			case typesPackage.GAST_CLASS__SURROUNDING_PACKAGE:
				return getSurroundingPackage();
			case typesPackage.GAST_CLASS__SUPER_TYPES:
				return getSuperTypes();
			case typesPackage.GAST_CLASS__LINES_OF_COMMENTS:
				return getLinesOfComments();
			case typesPackage.GAST_CLASS__LOCAL:
				return isLocal();
			case typesPackage.GAST_CLASS__PRIMITIVE:
				return isPrimitive();
			case typesPackage.GAST_CLASS__INTERFACE:
				return isInterface();
			case typesPackage.GAST_CLASS__ANONYMOUS:
				return isAnonymous();
			case typesPackage.GAST_CLASS__INNER_CLASSES:
				return getInnerClasses();
			case typesPackage.GAST_CLASS__SURROUNDING_CLASS:
				return getSurroundingClass();
			case typesPackage.GAST_CLASS__INHERITANCE_TYPE_ACCESSES:
				return getInheritanceTypeAccesses();
			case typesPackage.GAST_CLASS__SELF:
				return getSelf();
			case typesPackage.GAST_CLASS__FRIEND_CLASSES:
				return getFriendClasses();
			case typesPackage.GAST_CLASS__FRIEND_FUNCTIONS:
				return getFriendFunctions();
			case typesPackage.GAST_CLASS__PROPERTY:
				return getProperty();
			case typesPackage.GAST_CLASS__ALL_ACCESSES:
				return getAllAccesses();
			case typesPackage.GAST_CLASS__ALL_ACCESSED_CLASSES:
				return getAllAccessedClasses();
			case typesPackage.GAST_CLASS__INNER:
				return isInner();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case typesPackage.GAST_CLASS__SIMPLE_NAME:
				setSimpleName((String)newValue);
				return;
			case typesPackage.GAST_CLASS__REFERENCE_TYPE:
				setReferenceType((Boolean)newValue);
				return;
			case typesPackage.GAST_CLASS__INNER_TYPE_ALIASES:
				getInnerTypeAliases().clear();
				getInnerTypeAliases().addAll((Collection<? extends TypeAlias>)newValue);
				return;
			case typesPackage.GAST_CLASS__INNER_DELEGATES:
				getInnerDelegates().clear();
				getInnerDelegates().addAll((Collection<? extends Delegate>)newValue);
				return;
			case typesPackage.GAST_CLASS__CONSTRUCTORS:
				getConstructors().clear();
				getConstructors().addAll((Collection<? extends Constructor>)newValue);
				return;
			case typesPackage.GAST_CLASS__DESTRUCTORS:
				getDestructors().clear();
				getDestructors().addAll((Collection<? extends Destructor>)newValue);
				return;
			case typesPackage.GAST_CLASS__FIELDS:
				getFields().clear();
				getFields().addAll((Collection<? extends Field>)newValue);
				return;
			case typesPackage.GAST_CLASS__METHODS:
				getMethods().clear();
				getMethods().addAll((Collection<? extends Method>)newValue);
				return;
			case typesPackage.GAST_CLASS__SURROUNDING_FUNCTION:
				setSurroundingFunction((Function)newValue);
				return;
			case typesPackage.GAST_CLASS__SURROUNDING_PACKAGE:
				setSurroundingPackage((de.fzi.gast.core.Package)newValue);
				return;
			case typesPackage.GAST_CLASS__LINES_OF_COMMENTS:
				setLinesOfComments((Integer)newValue);
				return;
			case typesPackage.GAST_CLASS__PRIMITIVE:
				setPrimitive((Boolean)newValue);
				return;
			case typesPackage.GAST_CLASS__INTERFACE:
				setInterface((Boolean)newValue);
				return;
			case typesPackage.GAST_CLASS__ANONYMOUS:
				setAnonymous((Boolean)newValue);
				return;
			case typesPackage.GAST_CLASS__INNER_CLASSES:
				getInnerClasses().clear();
				getInnerClasses().addAll((Collection<? extends GASTClass>)newValue);
				return;
			case typesPackage.GAST_CLASS__SURROUNDING_CLASS:
				setSurroundingClass((GASTClass)newValue);
				return;
			case typesPackage.GAST_CLASS__INHERITANCE_TYPE_ACCESSES:
				getInheritanceTypeAccesses().clear();
				getInheritanceTypeAccesses().addAll((Collection<? extends InheritanceTypeAccess>)newValue);
				return;
			case typesPackage.GAST_CLASS__SELF:
				setSelf((Field)newValue);
				return;
			case typesPackage.GAST_CLASS__FRIEND_CLASSES:
				getFriendClasses().clear();
				getFriendClasses().addAll((Collection<? extends GASTClass>)newValue);
				return;
			case typesPackage.GAST_CLASS__FRIEND_FUNCTIONS:
				getFriendFunctions().clear();
				getFriendFunctions().addAll((Collection<? extends Function>)newValue);
				return;
			case typesPackage.GAST_CLASS__PROPERTY:
				getProperty().clear();
				getProperty().addAll((Collection<? extends Property>)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case typesPackage.GAST_CLASS__SIMPLE_NAME:
				setSimpleName(SIMPLE_NAME_EDEFAULT);
				return;
			case typesPackage.GAST_CLASS__REFERENCE_TYPE:
				setReferenceType(REFERENCE_TYPE_EDEFAULT);
				return;
			case typesPackage.GAST_CLASS__INNER_TYPE_ALIASES:
				getInnerTypeAliases().clear();
				return;
			case typesPackage.GAST_CLASS__INNER_DELEGATES:
				getInnerDelegates().clear();
				return;
			case typesPackage.GAST_CLASS__CONSTRUCTORS:
				getConstructors().clear();
				return;
			case typesPackage.GAST_CLASS__DESTRUCTORS:
				getDestructors().clear();
				return;
			case typesPackage.GAST_CLASS__FIELDS:
				getFields().clear();
				return;
			case typesPackage.GAST_CLASS__METHODS:
				getMethods().clear();
				return;
			case typesPackage.GAST_CLASS__SURROUNDING_FUNCTION:
				setSurroundingFunction((Function)null);
				return;
			case typesPackage.GAST_CLASS__SURROUNDING_PACKAGE:
				setSurroundingPackage((de.fzi.gast.core.Package)null);
				return;
			case typesPackage.GAST_CLASS__LINES_OF_COMMENTS:
				setLinesOfComments(LINES_OF_COMMENTS_EDEFAULT);
				return;
			case typesPackage.GAST_CLASS__PRIMITIVE:
				setPrimitive(PRIMITIVE_EDEFAULT);
				return;
			case typesPackage.GAST_CLASS__INTERFACE:
				setInterface(INTERFACE_EDEFAULT);
				return;
			case typesPackage.GAST_CLASS__ANONYMOUS:
				setAnonymous(ANONYMOUS_EDEFAULT);
				return;
			case typesPackage.GAST_CLASS__INNER_CLASSES:
				getInnerClasses().clear();
				return;
			case typesPackage.GAST_CLASS__SURROUNDING_CLASS:
				setSurroundingClass((GASTClass)null);
				return;
			case typesPackage.GAST_CLASS__INHERITANCE_TYPE_ACCESSES:
				getInheritanceTypeAccesses().clear();
				return;
			case typesPackage.GAST_CLASS__SELF:
				setSelf((Field)null);
				return;
			case typesPackage.GAST_CLASS__FRIEND_CLASSES:
				getFriendClasses().clear();
				return;
			case typesPackage.GAST_CLASS__FRIEND_FUNCTIONS:
				getFriendFunctions().clear();
				return;
			case typesPackage.GAST_CLASS__PROPERTY:
				getProperty().clear();
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case typesPackage.GAST_CLASS__SIMPLE_NAME:
				return SIMPLE_NAME_EDEFAULT == null ? simpleName != null : !SIMPLE_NAME_EDEFAULT.equals(simpleName);
			case typesPackage.GAST_CLASS__QUALIFIED_NAME:
				return QUALIFIED_NAME_EDEFAULT == null ? getQualifiedName() != null : !QUALIFIED_NAME_EDEFAULT.equals(getQualifiedName());
			case typesPackage.GAST_CLASS__REFERENCE_TYPE:
				return referenceType != REFERENCE_TYPE_EDEFAULT;
			case typesPackage.GAST_CLASS__INNER_TYPE_ALIASES:
				return innerTypeAliases != null && !innerTypeAliases.isEmpty();
			case typesPackage.GAST_CLASS__INNER_DELEGATES:
				return innerDelegates != null && !innerDelegates.isEmpty();
			case typesPackage.GAST_CLASS__CONSTRUCTORS:
				return constructors != null && !constructors.isEmpty();
			case typesPackage.GAST_CLASS__DESTRUCTORS:
				return destructors != null && !destructors.isEmpty();
			case typesPackage.GAST_CLASS__FIELDS:
				return fields != null && !fields.isEmpty();
			case typesPackage.GAST_CLASS__METHODS:
				return methods != null && !methods.isEmpty();
			case typesPackage.GAST_CLASS__SURROUNDING_FUNCTION:
				return getSurroundingFunction() != null;
			case typesPackage.GAST_CLASS__SURROUNDING_PACKAGE:
				return getSurroundingPackage() != null;
			case typesPackage.GAST_CLASS__SUPER_TYPES:
				return !getSuperTypes().isEmpty();
			case typesPackage.GAST_CLASS__LINES_OF_COMMENTS:
				return linesOfComments != LINES_OF_COMMENTS_EDEFAULT;
			case typesPackage.GAST_CLASS__LOCAL:
				return isLocal() != LOCAL_EDEFAULT;
			case typesPackage.GAST_CLASS__PRIMITIVE:
				return primitive != PRIMITIVE_EDEFAULT;
			case typesPackage.GAST_CLASS__INTERFACE:
				return interface_ != INTERFACE_EDEFAULT;
			case typesPackage.GAST_CLASS__ANONYMOUS:
				return anonymous != ANONYMOUS_EDEFAULT;
			case typesPackage.GAST_CLASS__INNER_CLASSES:
				return innerClasses != null && !innerClasses.isEmpty();
			case typesPackage.GAST_CLASS__SURROUNDING_CLASS:
				return getSurroundingClass() != null;
			case typesPackage.GAST_CLASS__INHERITANCE_TYPE_ACCESSES:
				return inheritanceTypeAccesses != null && !inheritanceTypeAccesses.isEmpty();
			case typesPackage.GAST_CLASS__SELF:
				return self != null;
			case typesPackage.GAST_CLASS__FRIEND_CLASSES:
				return friendClasses != null && !friendClasses.isEmpty();
			case typesPackage.GAST_CLASS__FRIEND_FUNCTIONS:
				return friendFunctions != null && !friendFunctions.isEmpty();
			case typesPackage.GAST_CLASS__PROPERTY:
				return property != null && !property.isEmpty();
			case typesPackage.GAST_CLASS__ALL_ACCESSES:
				return !getAllAccesses().isEmpty();
			case typesPackage.GAST_CLASS__ALL_ACCESSED_CLASSES:
				return !getAllAccessedClasses().isEmpty();
			case typesPackage.GAST_CLASS__INNER:
				return isInner() != INNER_EDEFAULT;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eBaseStructuralFeatureID(int derivedFeatureID, Class<?> baseClass) {
		if (baseClass == NamedModelElement.class) {
			switch (derivedFeatureID) {
				case typesPackage.GAST_CLASS__SIMPLE_NAME: return corePackage.NAMED_MODEL_ELEMENT__SIMPLE_NAME;
				default: return -1;
			}
		}
		if (baseClass == GASTType.class) {
			switch (derivedFeatureID) {
				case typesPackage.GAST_CLASS__QUALIFIED_NAME: return typesPackage.GAST_TYPE__QUALIFIED_NAME;
				case typesPackage.GAST_CLASS__REFERENCE_TYPE: return typesPackage.GAST_TYPE__REFERENCE_TYPE;
				default: return -1;
			}
		}
		return super.eBaseStructuralFeatureID(derivedFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int eDerivedStructuralFeatureID(int baseFeatureID, Class<?> baseClass) {
		if (baseClass == NamedModelElement.class) {
			switch (baseFeatureID) {
				case corePackage.NAMED_MODEL_ELEMENT__SIMPLE_NAME: return typesPackage.GAST_CLASS__SIMPLE_NAME;
				default: return -1;
			}
		}
		if (baseClass == GASTType.class) {
			switch (baseFeatureID) {
				case typesPackage.GAST_TYPE__QUALIFIED_NAME: return typesPackage.GAST_CLASS__QUALIFIED_NAME;
				case typesPackage.GAST_TYPE__REFERENCE_TYPE: return typesPackage.GAST_CLASS__REFERENCE_TYPE;
				default: return -1;
			}
		}
		return super.eDerivedStructuralFeatureID(baseFeatureID, baseClass);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated not
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(/*super.toString()*/);
		result.append("(simpleName: ");
		result.append(simpleName);
//		result.append(", referenceType: ");
//		result.append(referenceType);
//		result.append(", linesOfComments: ");
//		result.append(linesOfComments);
//		result.append(", primitive: ");
//		result.append(primitive);
//		result.append(", interface: ");
//		result.append(interface_);
//		result.append(", anonymous: ");
//		result.append(anonymous);
		result.append(')');
		return result.toString();
	}

} //GASTClassImpl
