/**
 * <copyright>
 * </copyright>
 *
 * $Id: Visibilities.java,v 1.5 2008/12/05 15:44:34 stammel Exp $
 */
package de.fzi.gast.types;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Visibilities</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * This enumeration models possible visibilities of class members. The exact semantics of these visibilities depends on the considered programming language.
 * <!-- end-model-doc -->
 * @see de.fzi.gast.types.typesPackage#getVisibilities()
 * @model
 * @generated
 */
public enum Visibilities implements Enumerator {
	/**
	 * The '<em><b>VISIBILITYSTRICTPROTECTED</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #VISIBILITYSTRICTPROTECTED_VALUE
	 * @generated
	 * @ordered
	 */
	VISIBILITYSTRICTPROTECTED(147, "VISIBILITYSTRICTPROTECTED", "VISIBILITYSTRICTPROTECTED"),

	/**
	 * The '<em><b>VISIBILITYPUBLIC</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #VISIBILITYPUBLIC_VALUE
	 * @generated
	 * @ordered
	 */
	VISIBILITYPUBLIC(145, "VISIBILITYPUBLIC", "VISIBILITYPUBLIC"),

	/**
	 * The '<em><b>VISIBILITYPACKAGE</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #VISIBILITYPACKAGE_VALUE
	 * @generated
	 * @ordered
	 */
	VISIBILITYPACKAGE(148, "VISIBILITYPACKAGE", "VISIBILITYPACKAGE"),

	/**
	 * The '<em><b>VISIBILITYPROTECTED</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #VISIBILITYPROTECTED_VALUE
	 * @generated
	 * @ordered
	 */
	VISIBILITYPROTECTED(146, "VISIBILITYPROTECTED", "VISIBILITYPROTECTED"),

	/**
	 * The '<em><b>VISIBILITYPRIVAT</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #VISIBILITYPRIVAT_VALUE
	 * @generated
	 * @ordered
	 */
	VISIBILITYPRIVAT(149, "VISIBILITYPRIVAT", "VISIBILITYPRIVAT");

	/**
	 * The '<em><b>VISIBILITYSTRICTPROTECTED</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This literal shows that the visibility is strict protected.
	 * <!-- end-model-doc -->
	 * @see #VISIBILITYSTRICTPROTECTED
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int VISIBILITYSTRICTPROTECTED_VALUE = 147;

	/**
	 * The '<em><b>VISIBILITYPUBLIC</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This literal shows that the visibility is public.
	 * <!-- end-model-doc -->
	 * @see #VISIBILITYPUBLIC
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int VISIBILITYPUBLIC_VALUE = 145;

	/**
	 * The '<em><b>VISIBILITYPACKAGE</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This literal shows that the visibility is package scope.
	 * <!-- end-model-doc -->
	 * @see #VISIBILITYPACKAGE
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int VISIBILITYPACKAGE_VALUE = 148;

	/**
	 * The '<em><b>VISIBILITYPROTECTED</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This literal shows that the visibility is protected.
	 * <!-- end-model-doc -->
	 * @see #VISIBILITYPROTECTED
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int VISIBILITYPROTECTED_VALUE = 146;

	/**
	 * The '<em><b>VISIBILITYPRIVAT</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This literal shows that the visibility is privat scope.
	 * <!-- end-model-doc -->
	 * @see #VISIBILITYPRIVAT
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int VISIBILITYPRIVAT_VALUE = 149;

	/**
	 * An array of all the '<em><b>Visibilities</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final Visibilities[] VALUES_ARRAY =
		new Visibilities[] {
			VISIBILITYSTRICTPROTECTED,
			VISIBILITYPUBLIC,
			VISIBILITYPACKAGE,
			VISIBILITYPROTECTED,
			VISIBILITYPRIVAT,
		};

	/**
	 * A public read-only list of all the '<em><b>Visibilities</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<Visibilities> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Visibilities</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static Visibilities get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			Visibilities result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Visibilities</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static Visibilities getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			Visibilities result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Visibilities</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static Visibilities get(int value) {
		switch (value) {
			case VISIBILITYSTRICTPROTECTED_VALUE: return VISIBILITYSTRICTPROTECTED;
			case VISIBILITYPUBLIC_VALUE: return VISIBILITYPUBLIC;
			case VISIBILITYPACKAGE_VALUE: return VISIBILITYPACKAGE;
			case VISIBILITYPROTECTED_VALUE: return VISIBILITYPROTECTED;
			case VISIBILITYPRIVAT_VALUE: return VISIBILITYPRIVAT;
		}
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private Visibilities(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //Visibilities
