/**
 * <copyright>
 * </copyright>
 *
 * $Id: TypeDecorator.java,v 1.6 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.types;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Type Decorator</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This entity is used to model derived types (like arrays) or type proxys.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.types.TypeDecorator#getDecoratedType <em>Decorated Type</em>}</li>
 *   <li>{@link de.fzi.gast.types.TypeDecorator#getUndecoratedType <em>Undecorated Type</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.types.typesPackage#getTypeDecorator()
 * @model abstract="true"
 * @generated
 */
public interface TypeDecorator extends GASTType {
	/**
	 * Returns the value of the '<em><b>Decorated Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the type which is decorated by this type decorator.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Decorated Type</em>' reference.
	 * @see #setDecoratedType(GASTType)
	 * @see de.fzi.gast.types.typesPackage#getTypeDecorator_DecoratedType()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	GASTType getDecoratedType();

	/**
	 * Sets the value of the '{@link de.fzi.gast.types.TypeDecorator#getDecoratedType <em>Decorated Type</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Decorated Type</em>' reference.
	 * @see #getDecoratedType()
	 * @generated
	 */
	void setDecoratedType(GASTType value);

	/**
	 * Returns the value of the '<em><b>Undecorated Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the innermost type which is decorated, which means all type decorators are removed. This property is derived from the chain of type decorators.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Undecorated Type</em>' reference.
	 * @see de.fzi.gast.types.typesPackage#getTypeDecorator_UndecoratedType()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name=''"
	 * @generated
	 */
	GASTType getUndecoratedType();

} // TypeDecorator
