/**
 * <copyright>
 * </copyright>
 *
 * $Id: TypeAlias.java,v 1.5 2008/12/05 15:44:34 stammel Exp $
 */
package de.fzi.gast.types;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Type Alias</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class models a type alias (e. g. typedef-constructs in C++).
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.types.TypeAlias#getAliasedType <em>Aliased Type</em>}</li>
 *   <li>{@link de.fzi.gast.types.TypeAlias#isInnerTypeAlias <em>Inner Type Alias</em>}</li>
 *   <li>{@link de.fzi.gast.types.TypeAlias#getSurroundingClass <em>Surrounding Class</em>}</li>
 *   <li>{@link de.fzi.gast.types.TypeAlias#getSurroundingPackage <em>Surrounding Package</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.types.typesPackage#getTypeAlias()
 * @model
 * @generated
 */
public interface TypeAlias extends Member, TypeDecorator {
	/**
	 * Returns the value of the '<em><b>Aliased Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the aliased type.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Aliased Type</em>' reference.
	 * @see de.fzi.gast.types.typesPackage#getTypeAlias_AliasedType()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name=''"
	 * @generated
	 */
	GASTType getAliasedType();

	/**
	 * Returns the value of the '<em><b>Inner Type Alias</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is true if this type alias is an inner class.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Inner Type Alias</em>' attribute.
	 * @see #setInnerTypeAlias(boolean)
	 * @see de.fzi.gast.types.typesPackage#getTypeAlias_InnerTypeAlias()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	boolean isInnerTypeAlias();

	/**
	 * Sets the value of the '{@link de.fzi.gast.types.TypeAlias#isInnerTypeAlias <em>Inner Type Alias</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Inner Type Alias</em>' attribute.
	 * @see #isInnerTypeAlias()
	 * @generated
	 */
	void setInnerTypeAlias(boolean value);

	/**
	 * Returns the value of the '<em><b>Surrounding Class</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.types.GASTClass#getInnerTypeAliases <em>Inner Type Aliases</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the class which contains this type alias.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Class</em>' container reference.
	 * @see #setSurroundingClass(GASTClass)
	 * @see de.fzi.gast.types.typesPackage#getTypeAlias_SurroundingClass()
	 * @see de.fzi.gast.types.GASTClass#getInnerTypeAliases
	 * @model opposite="innerTypeAliases" required="true" transient="false" ordered="false"
	 * @generated
	 */
	GASTClass getSurroundingClass();

	/**
	 * Sets the value of the '{@link de.fzi.gast.types.TypeAlias#getSurroundingClass <em>Surrounding Class</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Surrounding Class</em>' container reference.
	 * @see #getSurroundingClass()
	 * @generated
	 */
	void setSurroundingClass(GASTClass value);

	/**
	 * Returns the value of the '<em><b>Surrounding Package</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.core.Package#getTypeAliases <em>Type Aliases</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the package which contains this type alias.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Package</em>' container reference.
	 * @see #setSurroundingPackage(de.fzi.gast.core.Package)
	 * @see de.fzi.gast.types.typesPackage#getTypeAlias_SurroundingPackage()
	 * @see de.fzi.gast.core.Package#getTypeAliases
	 * @model opposite="typeAliases" required="true" transient="false" ordered="false"
	 * @generated
	 */
	de.fzi.gast.core.Package getSurroundingPackage();

	/**
	 * Sets the value of the '{@link de.fzi.gast.types.TypeAlias#getSurroundingPackage <em>Surrounding Package</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Surrounding Package</em>' container reference.
	 * @see #getSurroundingPackage()
	 * @generated
	 */
	void setSurroundingPackage(de.fzi.gast.core.Package value);

} // TypeAlias
