/**
 * <copyright>
 * </copyright>
 *
 * $Id: Reference.java,v 1.5 2008/12/05 15:44:34 stammel Exp $
 */
package de.fzi.gast.types;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Reference</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class models a pointer (like in C++) or a reference. 
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.types.Reference#getReferencedType <em>Referenced Type</em>}</li>
 *   <li>{@link de.fzi.gast.types.Reference#isExplicit <em>Explicit</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.types.typesPackage#getReference()
 * @model
 * @generated
 */
public interface Reference extends TypeDecorator {
	/**
	 * Returns the value of the '<em><b>Referenced Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the referenced type.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Referenced Type</em>' reference.
	 * @see de.fzi.gast.types.typesPackage#getReference_ReferencedType()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name=''"
	 * @generated
	 */
	GASTType getReferencedType();

	/**
	 * Returns the value of the '<em><b>Explicit</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is true if it is a pointer and false if it is a reference.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Explicit</em>' attribute.
	 * @see #setExplicit(boolean)
	 * @see de.fzi.gast.types.typesPackage#getReference_Explicit()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	boolean isExplicit();

	/**
	 * Sets the value of the '{@link de.fzi.gast.types.Reference#isExplicit <em>Explicit</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Explicit</em>' attribute.
	 * @see #isExplicit()
	 * @generated
	 */
	void setExplicit(boolean value);

} // Reference
