/**
 * <copyright>
 * </copyright>
 *
 * $Id: GASTType.java,v 1.5 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.types;

import de.fzi.gast.core.NamedModelElement;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>GAST Type</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This entity models the root of the type hierarchy. The type hierarchy represents the type system.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.types.GASTType#getQualifiedName <em>Qualified Name</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTType#isReferenceType <em>Reference Type</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.types.typesPackage#getGASTType()
 * @model abstract="true"
 * @generated
 */
public interface GASTType extends NamedModelElement {
	/**
	 * Returns the value of the '<em><b>Qualified Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the fully qualified name of this type.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Qualified Name</em>' attribute.
	 * @see de.fzi.gast.types.typesPackage#getGASTType_QualifiedName()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	String getQualifiedName();

	/**
	 * Returns the value of the '<em><b>Reference Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is true if this type is a reference type. It is false if this type is value type.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Reference Type</em>' attribute.
	 * @see #setReferenceType(boolean)
	 * @see de.fzi.gast.types.typesPackage#getGASTType_ReferenceType()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	boolean isReferenceType();

	/**
	 * Sets the value of the '{@link de.fzi.gast.types.GASTType#isReferenceType <em>Reference Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Reference Type</em>' attribute.
	 * @see #isReferenceType()
	 * @generated
	 */
	void setReferenceType(boolean value);

} // GASTType
