/**
 * <copyright>
 * </copyright>
 *
 * $Id: GASTClass.java,v 1.3 2009/01/20 10:51:20 stammel Exp $
 */
package de.fzi.gast.types;

import org.eclipse.emf.common.util.EList;

import de.fzi.gast.accesses.Access;
import de.fzi.gast.accesses.InheritanceTypeAccess;
import de.fzi.gast.functions.Constructor;
import de.fzi.gast.functions.Delegate;
import de.fzi.gast.functions.Destructor;
import de.fzi.gast.functions.Function;
import de.fzi.gast.functions.Method;
import de.fzi.gast.variables.Field;
import de.fzi.gast.variables.Property;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>GAST Class</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents the class elements like they are known in the UML. It models classes, primitive types as well as interfaces.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.types.GASTClass#getInnerTypeAliases <em>Inner Type Aliases</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#getInnerDelegates <em>Inner Delegates</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#getConstructors <em>Constructors</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#getDestructors <em>Destructors</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#getFields <em>Fields</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#getMethods <em>Methods</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#getSurroundingFunction <em>Surrounding Function</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#getSurroundingPackage <em>Surrounding Package</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#getSuperTypes <em>Super Types</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#getLinesOfComments <em>Lines Of Comments</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#isLocal <em>Local</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#isPrimitive <em>Primitive</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#isInterface <em>Interface</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#isAnonymous <em>Anonymous</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#getInnerClasses <em>Inner Classes</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#getSurroundingClass <em>Surrounding Class</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#getInheritanceTypeAccesses <em>Inheritance Type Accesses</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#getSelf <em>Self</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#getFriendClasses <em>Friend Classes</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#getFriendFunctions <em>Friend Functions</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#getProperty <em>Property</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#getAllAccesses <em>All Accesses</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#getAllAccessedClasses <em>All Accessed Classes</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTClass#isInner <em>Inner</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.types.typesPackage#getGASTClass()
 * @model
 * @generated
 */
public interface GASTClass extends Member, GASTType {
	/**
	 * Returns the value of the '<em><b>Inner Type Aliases</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.types.TypeAlias}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.types.TypeAlias#getSurroundingClass <em>Surrounding Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all type aliases declared in this class.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Inner Type Aliases</em>' containment reference list.
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_InnerTypeAliases()
	 * @see de.fzi.gast.types.TypeAlias#getSurroundingClass
	 * @model opposite="surroundingClass" containment="true" ordered="false"
	 * @generated
	 */
	EList<TypeAlias> getInnerTypeAliases();

	/**
	 * Returns the value of the '<em><b>Fields</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.variables.Field}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.variables.Field#getSurroundingClass <em>Surrounding Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all fields of this class.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Fields</em>' containment reference list.
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_Fields()
	 * @see de.fzi.gast.variables.Field#getSurroundingClass
	 * @model opposite="surroundingClass" containment="true" ordered="false"
	 * @generated
	 */
	EList<Field> getFields();

	/**
	 * Returns the value of the '<em><b>Methods</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.functions.Method}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.functions.Method#getSurroundingClass <em>Surrounding Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all methods of this class.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Methods</em>' containment reference list.
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_Methods()
	 * @see de.fzi.gast.functions.Method#getSurroundingClass
	 * @model opposite="surroundingClass" containment="true" ordered="false"
	 * @generated
	 */
	EList<Method> getMethods();

	/**
	 * Returns the value of the '<em><b>Constructors</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.functions.Constructor}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.functions.Constructor#getSurroundingClass <em>Surrounding Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all constructors of this class.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Constructors</em>' containment reference list.
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_Constructors()
	 * @see de.fzi.gast.functions.Constructor#getSurroundingClass
	 * @model opposite="surroundingClass" containment="true" ordered="false"
	 * @generated
	 */
	EList<Constructor> getConstructors();

	/**
	 * Returns the value of the '<em><b>Destructors</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.functions.Destructor}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.functions.Destructor#getSurroundingClass <em>Surrounding Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all destructors of this class.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Destructors</em>' containment reference list.
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_Destructors()
	 * @see de.fzi.gast.functions.Destructor#getSurroundingClass
	 * @model opposite="surroundingClass" containment="true" ordered="false"
	 * @generated
	 */
	EList<Destructor> getDestructors();

	/**
	 * Returns the value of the '<em><b>Inner Delegates</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.functions.Delegate}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.functions.Delegate#getSurroundingClass <em>Surrounding Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all delegates declared in this class.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Inner Delegates</em>' containment reference list.
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_InnerDelegates()
	 * @see de.fzi.gast.functions.Delegate#getSurroundingClass
	 * @model opposite="surroundingClass" containment="true" ordered="false"
	 * @generated
	 */
	EList<Delegate> getInnerDelegates();

	/**
	 * Returns the value of the '<em><b>Surrounding Package</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.core.Package#getClasses <em>Classes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the package, in which this class is contained.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Package</em>' container reference.
	 * @see #setSurroundingPackage(de.fzi.gast.core.Package)
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_SurroundingPackage()
	 * @see de.fzi.gast.core.Package#getClasses
	 * @model opposite="classes" transient="false" ordered="false"
	 * @generated
	 */
	de.fzi.gast.core.Package getSurroundingPackage();

	/**
	 * Sets the value of the '{@link de.fzi.gast.types.GASTClass#getSurroundingPackage <em>Surrounding Package</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Surrounding Package</em>' container reference.
	 * @see #getSurroundingPackage()
	 * @generated
	 */
	void setSurroundingPackage(de.fzi.gast.core.Package value);

	/**
	 * Returns the value of the '<em><b>Super Types</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.types.GASTClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents all direct super types of this class. It is derived from the inheritance hierarchy which is represented by inheritance type accesses.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Super Types</em>' reference list.
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_SuperTypes()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	EList<GASTClass> getSuperTypes();

	/**
	 * Returns the value of the '<em><b>Lines Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the number of comments within this class.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Lines Of Comments</em>' attribute.
	 * @see #setLinesOfComments(int)
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_LinesOfComments()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getLinesOfComments();

	/**
	 * Sets the value of the '{@link de.fzi.gast.types.GASTClass#getLinesOfComments <em>Lines Of Comments</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Lines Of Comments</em>' attribute.
	 * @see #getLinesOfComments()
	 * @generated
	 */
	void setLinesOfComments(int value);

	/**
	 * Returns the value of the '<em><b>Local</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is true if this class is a local class, which means that it is declared within a function body.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Local</em>' attribute.
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_Local()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	boolean isLocal();

	/**
	 * Returns the value of the '<em><b>Primitive</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is true if this class object represents a primitive type (e. g. int).
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Primitive</em>' attribute.
	 * @see #setPrimitive(boolean)
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_Primitive()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	boolean isPrimitive();

	/**
	 * Sets the value of the '{@link de.fzi.gast.types.GASTClass#isPrimitive <em>Primitive</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Primitive</em>' attribute.
	 * @see #isPrimitive()
	 * @generated
	 */
	void setPrimitive(boolean value);

	/**
	 * Returns the value of the '<em><b>Surrounding Function</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.functions.Function#getLocalClasses <em>Local Classes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Surrounding Function</em>' container reference.
	 * @see #setSurroundingFunction(Function)
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_SurroundingFunction()
	 * @see de.fzi.gast.functions.Function#getLocalClasses
	 * @model opposite="localClasses" transient="false" ordered="false"
	 * @generated
	 */
	Function getSurroundingFunction();

	/**
	 * Sets the value of the '{@link de.fzi.gast.types.GASTClass#getSurroundingFunction <em>Surrounding Function</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Surrounding Function</em>' container reference.
	 * @see #getSurroundingFunction()
	 * @generated
	 */
	void setSurroundingFunction(Function value);

	/**
	 * Returns the value of the '<em><b>Interface</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is true if this class object represents an interface.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Interface</em>' attribute.
	 * @see #setInterface(boolean)
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_Interface()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	boolean isInterface();

	/**
	 * Sets the value of the '{@link de.fzi.gast.types.GASTClass#isInterface <em>Interface</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Interface</em>' attribute.
	 * @see #isInterface()
	 * @generated
	 */
	void setInterface(boolean value);

	/**
	 * Returns the value of the '<em><b>Anonymous</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is true if this class is an anonymous class, which is declared without an explicit name.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Anonymous</em>' attribute.
	 * @see #setAnonymous(boolean)
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_Anonymous()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	boolean isAnonymous();

	/**
	 * Sets the value of the '{@link de.fzi.gast.types.GASTClass#isAnonymous <em>Anonymous</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Anonymous</em>' attribute.
	 * @see #isAnonymous()
	 * @generated
	 */
	void setAnonymous(boolean value);

	/**
	 * Returns the value of the '<em><b>Inner Classes</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.types.GASTClass}.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.types.GASTClass#getSurroundingClass <em>Surrounding Class</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all inner classes of this class.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Inner Classes</em>' containment reference list.
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_InnerClasses()
	 * @see de.fzi.gast.types.GASTClass#getSurroundingClass
	 * @model opposite="surroundingClass" containment="true" ordered="false"
	 * @generated
	 */
	EList<GASTClass> getInnerClasses();

	/**
	 * Returns the value of the '<em><b>Surrounding Class</b></em>' container reference.
	 * It is bidirectional and its opposite is '{@link de.fzi.gast.types.GASTClass#getInnerClasses <em>Inner Classes</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a reference to the class in which this class is contained, only in the case of inner and local classes. Otherwise this property is "null".
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Surrounding Class</em>' container reference.
	 * @see #setSurroundingClass(GASTClass)
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_SurroundingClass()
	 * @see de.fzi.gast.types.GASTClass#getInnerClasses
	 * @model opposite="innerClasses" transient="false" ordered="false"
	 * @generated
	 */
	GASTClass getSurroundingClass();

	/**
	 * Sets the value of the '{@link de.fzi.gast.types.GASTClass#getSurroundingClass <em>Surrounding Class</em>}' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Surrounding Class</em>' container reference.
	 * @see #getSurroundingClass()
	 * @generated
	 */
	void setSurroundingClass(GASTClass value);

	/**
	 * Returns the value of the '<em><b>Inheritance Type Accesses</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.accesses.InheritanceTypeAccess}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all direct inheritance relationships of this class.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Inheritance Type Accesses</em>' containment reference list.
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_InheritanceTypeAccesses()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<InheritanceTypeAccess> getInheritanceTypeAccesses();

	/**
	 * Returns the value of the '<em><b>Self</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property is a helping construct, which is used as a target for all explicit and implicit "this" and "super" accesses.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Self</em>' containment reference.
	 * @see #setSelf(Field)
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_Self()
	 * @model containment="true" required="true" ordered="false"
	 * @generated
	 */
	Field getSelf();

	/**
	 * Sets the value of the '{@link de.fzi.gast.types.GASTClass#getSelf <em>Self</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Self</em>' containment reference.
	 * @see #getSelf()
	 * @generated
	 */
	void setSelf(Field value);

	/**
	 * Returns the value of the '<em><b>Friend Classes</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.types.GASTClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all friend classes of this class.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Friend Classes</em>' reference list.
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_FriendClasses()
	 * @model ordered="false"
	 * @generated
	 */
	EList<GASTClass> getFriendClasses();

	/**
	 * Returns the value of the '<em><b>Friend Functions</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.functions.Function}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all friend functions of this class.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Friend Functions</em>' containment reference list.
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_FriendFunctions()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<Function> getFriendFunctions();

	/**
	 * Returns the value of the '<em><b>Property</b></em>' containment reference list.
	 * The list contents are of type {@link de.fzi.gast.variables.Property}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents a list of all properties of this class.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Property</em>' containment reference list.
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_Property()
	 * @model containment="true" ordered="false"
	 * @generated
	 */
	EList<Property> getProperty();

	/**
	 * Returns the value of the '<em><b>All Accesses</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.accesses.Access}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>All Accesses</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>All Accesses</em>' reference list.
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_AllAccesses()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	EList<Access> getAllAccesses();

	/**
	 * Returns the value of the '<em><b>All Accessed Classes</b></em>' reference list.
	 * The list contents are of type {@link de.fzi.gast.types.GASTClass}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>All Accessed Classes</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>All Accessed Classes</em>' reference list.
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_AllAccessedClasses()
	 * @model transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	EList<GASTClass> getAllAccessedClasses();

	/**
	 * Returns the value of the '<em><b>Inner</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Inner</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Inner</em>' attribute.
	 * @see de.fzi.gast.types.typesPackage#getGASTClass_Inner()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 * @generated
	 */
	boolean isInner();

} // GASTClass
