/**
 * <copyright>
 * </copyright>
 *
 * $Id: GASTArray.java,v 1.2 2008/12/05 15:44:34 stammel Exp $
 */
package de.fzi.gast.types;


/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>GAST Array</b></em>'.
 * <!-- end-user-doc -->
 *
 * <!-- begin-model-doc -->
 * This class represents an array. It implements the interface TypeDecorator.
 * <!-- end-model-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link de.fzi.gast.types.GASTArray#getBaseType <em>Base Type</em>}</li>
 *   <li>{@link de.fzi.gast.types.GASTArray#getDimensions <em>Dimensions</em>}</li>
 * </ul>
 * </p>
 *
 * @see de.fzi.gast.types.typesPackage#getGASTArray()
 * @model
 * @generated
 */
public interface GASTArray extends TypeDecorator {
	/**
	 * Returns the value of the '<em><b>Base Type</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the base type of this array.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Base Type</em>' reference.
	 * @see de.fzi.gast.types.typesPackage#getGASTArray_BaseType()
	 * @model required="true" transient="true" changeable="false" volatile="true" derived="true" ordered="false"
	 *        extendedMetaData="name=''"
	 * @generated
	 */
	GASTType getBaseType();

	/**
	 * Returns the value of the '<em><b>Dimensions</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * <!-- begin-model-doc -->
	 * This property represents the number of dimensions of this array.
	 * <!-- end-model-doc -->
	 * @return the value of the '<em>Dimensions</em>' attribute.
	 * @see #setDimensions(int)
	 * @see de.fzi.gast.types.typesPackage#getGASTArray_Dimensions()
	 * @model required="true" ordered="false"
	 * @generated
	 */
	int getDimensions();

	/**
	 * Sets the value of the '{@link de.fzi.gast.types.GASTArray#getDimensions <em>Dimensions</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Dimensions</em>' attribute.
	 * @see #getDimensions()
	 * @generated
	 */
	void setDimensions(int value);

} // GASTArray
