/**
 * <copyright>
 * </copyright>
 *
 * $Id: statementsPackage.java,v 1.6 2009/01/20 10:51:21 stammel Exp $
 */
package de.fzi.gast.statements;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

import de.fzi.gast.core.corePackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * <!-- begin-model-doc -->
 * This package contains all classes and interfaces which belong to the statement hierarchy or are otherwise related to it. Statements describe the control flow within a function body.
 * <!-- end-model-doc -->
 * @see de.fzi.gast.statements.statementsFactory
 * @model kind="package"
 * @generated
 */
public interface statementsPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "statements";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http://www.fzi.de/gast/statements";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "statements";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	statementsPackage eINSTANCE = de.fzi.gast.statements.impl.statementsPackageImpl.init();

	/**
	 * The meta object id for the '{@link de.fzi.gast.statements.impl.StatementImpl <em>Statement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.statements.impl.StatementImpl
	 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getStatement()
	 * @generated
	 */
	int STATEMENT = 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__ID = corePackage.SOURCE_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__ANNOTATIONS = corePackage.SOURCE_ENTITY__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__STATUS = corePackage.SOURCE_ENTITY__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__SISSY_ID = corePackage.SOURCE_ENTITY__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__POSITION = corePackage.SOURCE_ENTITY__POSITION;

	/**
	 * The feature id for the '<em><b>Accesses</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__ACCESSES = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Blockstatement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__BLOCKSTATEMENT = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__SURROUNDING_STATEMENT = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Number Of Statements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__NUMBER_OF_STATEMENTS = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Maximum Nesting Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__MAXIMUM_NESTING_LEVEL = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 4;

	/**
	 * The feature id for the '<em><b>Number Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__NUMBER_OF_COMMENTS = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__LINES_OF_CODE = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 6;

	/**
	 * The feature id for the '<em><b>Number Of Edges In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__NUMBER_OF_EDGES_IN_CFG = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 7;

	/**
	 * The feature id for the '<em><b>Number Of Nodes In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__NUMBER_OF_NODES_IN_CFG = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 8;

	/**
	 * The feature id for the '<em><b>Branch</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__BRANCH = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 9;

	/**
	 * The feature id for the '<em><b>Loopstatement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT__LOOPSTATEMENT = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 10;

	/**
	 * The number of structural features of the '<em>Statement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int STATEMENT_FEATURE_COUNT = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 11;

	/**
	 * The meta object id for the '{@link de.fzi.gast.statements.impl.ExceptionHandlerImpl <em>Exception Handler</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.statements.impl.ExceptionHandlerImpl
	 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getExceptionHandler()
	 * @generated
	 */
	int EXCEPTION_HANDLER = 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__ID = STATEMENT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__ANNOTATIONS = STATEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__STATUS = STATEMENT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__SISSY_ID = STATEMENT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__POSITION = STATEMENT__POSITION;

	/**
	 * The feature id for the '<em><b>Accesses</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__ACCESSES = STATEMENT__ACCESSES;

	/**
	 * The feature id for the '<em><b>Blockstatement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__BLOCKSTATEMENT = STATEMENT__BLOCKSTATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__SURROUNDING_STATEMENT = STATEMENT__SURROUNDING_STATEMENT;

	/**
	 * The feature id for the '<em><b>Number Of Statements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__NUMBER_OF_STATEMENTS = STATEMENT__NUMBER_OF_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Maximum Nesting Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__MAXIMUM_NESTING_LEVEL = STATEMENT__MAXIMUM_NESTING_LEVEL;

	/**
	 * The feature id for the '<em><b>Number Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__NUMBER_OF_COMMENTS = STATEMENT__NUMBER_OF_COMMENTS;

	/**
	 * The feature id for the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__LINES_OF_CODE = STATEMENT__LINES_OF_CODE;

	/**
	 * The feature id for the '<em><b>Number Of Edges In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__NUMBER_OF_EDGES_IN_CFG = STATEMENT__NUMBER_OF_EDGES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Number Of Nodes In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__NUMBER_OF_NODES_IN_CFG = STATEMENT__NUMBER_OF_NODES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Branch</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__BRANCH = STATEMENT__BRANCH;

	/**
	 * The feature id for the '<em><b>Loopstatement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__LOOPSTATEMENT = STATEMENT__LOOPSTATEMENT;

	/**
	 * The feature id for the '<em><b>Catch Blocks</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__CATCH_BLOCKS = STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Finally Block</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__FINALLY_BLOCK = STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Guarded Block</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER__GUARDED_BLOCK = STATEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Exception Handler</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int EXCEPTION_HANDLER_FEATURE_COUNT = STATEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link de.fzi.gast.statements.impl.BlockStatementImpl <em>Block Statement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.statements.impl.BlockStatementImpl
	 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getBlockStatement()
	 * @generated
	 */
	int BLOCK_STATEMENT = 2;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK_STATEMENT__ID = STATEMENT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK_STATEMENT__ANNOTATIONS = STATEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK_STATEMENT__STATUS = STATEMENT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK_STATEMENT__SISSY_ID = STATEMENT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK_STATEMENT__POSITION = STATEMENT__POSITION;

	/**
	 * The feature id for the '<em><b>Accesses</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK_STATEMENT__ACCESSES = STATEMENT__ACCESSES;

	/**
	 * The feature id for the '<em><b>Blockstatement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK_STATEMENT__BLOCKSTATEMENT = STATEMENT__BLOCKSTATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK_STATEMENT__SURROUNDING_STATEMENT = STATEMENT__SURROUNDING_STATEMENT;

	/**
	 * The feature id for the '<em><b>Number Of Statements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK_STATEMENT__NUMBER_OF_STATEMENTS = STATEMENT__NUMBER_OF_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Maximum Nesting Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK_STATEMENT__MAXIMUM_NESTING_LEVEL = STATEMENT__MAXIMUM_NESTING_LEVEL;

	/**
	 * The feature id for the '<em><b>Number Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK_STATEMENT__NUMBER_OF_COMMENTS = STATEMENT__NUMBER_OF_COMMENTS;

	/**
	 * The feature id for the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK_STATEMENT__LINES_OF_CODE = STATEMENT__LINES_OF_CODE;

	/**
	 * The feature id for the '<em><b>Number Of Edges In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK_STATEMENT__NUMBER_OF_EDGES_IN_CFG = STATEMENT__NUMBER_OF_EDGES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Number Of Nodes In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK_STATEMENT__NUMBER_OF_NODES_IN_CFG = STATEMENT__NUMBER_OF_NODES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Branch</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK_STATEMENT__BRANCH = STATEMENT__BRANCH;

	/**
	 * The feature id for the '<em><b>Loopstatement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK_STATEMENT__LOOPSTATEMENT = STATEMENT__LOOPSTATEMENT;

	/**
	 * The feature id for the '<em><b>Synchronized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK_STATEMENT__SYNCHRONIZED = STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Statements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK_STATEMENT__STATEMENTS = STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK_STATEMENT__SURROUNDING_FUNCTION = STATEMENT_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Block Statement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BLOCK_STATEMENT_FEATURE_COUNT = STATEMENT_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link de.fzi.gast.statements.impl.CatchBlockImpl <em>Catch Block</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.statements.impl.CatchBlockImpl
	 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getCatchBlock()
	 * @generated
	 */
	int CATCH_BLOCK = 7;

	/**
	 * The meta object id for the '{@link de.fzi.gast.statements.impl.BranchStatementImpl <em>Branch Statement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.statements.impl.BranchStatementImpl
	 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getBranchStatement()
	 * @generated
	 */
	int BRANCH_STATEMENT = 5;

	/**
	 * The meta object id for the '{@link de.fzi.gast.statements.impl.BranchImpl <em>Branch</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.statements.impl.BranchImpl
	 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getBranch()
	 * @generated
	 */
	int BRANCH = 3;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH__ID = corePackage.SOURCE_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH__ANNOTATIONS = corePackage.SOURCE_ENTITY__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH__STATUS = corePackage.SOURCE_ENTITY__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH__SISSY_ID = corePackage.SOURCE_ENTITY__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH__POSITION = corePackage.SOURCE_ENTITY__POSITION;

	/**
	 * The feature id for the '<em><b>Condition Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH__CONDITION_EXPRESSION = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Branchstatement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH__BRANCHSTATEMENT = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Statement</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH__STATEMENT = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 2;

	/**
	 * The number of structural features of the '<em>Branch</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_FEATURE_COUNT = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 3;

	/**
	 * The meta object id for the '{@link de.fzi.gast.statements.impl.GASTExpressionImpl <em>GAST Expression</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.statements.impl.GASTExpressionImpl
	 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getGASTExpression()
	 * @generated
	 */
	int GAST_EXPRESSION = 4;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_EXPRESSION__ID = corePackage.SOURCE_ENTITY__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_EXPRESSION__ANNOTATIONS = corePackage.SOURCE_ENTITY__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_EXPRESSION__STATUS = corePackage.SOURCE_ENTITY__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_EXPRESSION__SISSY_ID = corePackage.SOURCE_ENTITY__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_EXPRESSION__POSITION = corePackage.SOURCE_ENTITY__POSITION;

	/**
	 * The number of structural features of the '<em>GAST Expression</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_EXPRESSION_FEATURE_COUNT = corePackage.SOURCE_ENTITY_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_STATEMENT__ID = STATEMENT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_STATEMENT__ANNOTATIONS = STATEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_STATEMENT__STATUS = STATEMENT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_STATEMENT__SISSY_ID = STATEMENT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_STATEMENT__POSITION = STATEMENT__POSITION;

	/**
	 * The feature id for the '<em><b>Accesses</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_STATEMENT__ACCESSES = STATEMENT__ACCESSES;

	/**
	 * The feature id for the '<em><b>Blockstatement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_STATEMENT__BLOCKSTATEMENT = STATEMENT__BLOCKSTATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_STATEMENT__SURROUNDING_STATEMENT = STATEMENT__SURROUNDING_STATEMENT;

	/**
	 * The feature id for the '<em><b>Number Of Statements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_STATEMENT__NUMBER_OF_STATEMENTS = STATEMENT__NUMBER_OF_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Maximum Nesting Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_STATEMENT__MAXIMUM_NESTING_LEVEL = STATEMENT__MAXIMUM_NESTING_LEVEL;

	/**
	 * The feature id for the '<em><b>Number Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_STATEMENT__NUMBER_OF_COMMENTS = STATEMENT__NUMBER_OF_COMMENTS;

	/**
	 * The feature id for the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_STATEMENT__LINES_OF_CODE = STATEMENT__LINES_OF_CODE;

	/**
	 * The feature id for the '<em><b>Number Of Edges In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_STATEMENT__NUMBER_OF_EDGES_IN_CFG = STATEMENT__NUMBER_OF_EDGES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Number Of Nodes In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_STATEMENT__NUMBER_OF_NODES_IN_CFG = STATEMENT__NUMBER_OF_NODES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Branch</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_STATEMENT__BRANCH = STATEMENT__BRANCH;

	/**
	 * The feature id for the '<em><b>Loopstatement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_STATEMENT__LOOPSTATEMENT = STATEMENT__LOOPSTATEMENT;

	/**
	 * The feature id for the '<em><b>Branches</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_STATEMENT__BRANCHES = STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Branch Statement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int BRANCH_STATEMENT_FEATURE_COUNT = STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.statements.impl.JumpStatementImpl <em>Jump Statement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.statements.impl.JumpStatementImpl
	 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getJumpStatement()
	 * @generated
	 */
	int JUMP_STATEMENT = 8;

	/**
	 * The meta object id for the '{@link de.fzi.gast.statements.impl.LoopStatementImpl <em>Loop Statement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.statements.impl.LoopStatementImpl
	 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getLoopStatement()
	 * @generated
	 */
	int LOOP_STATEMENT = 6;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_STATEMENT__ID = STATEMENT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_STATEMENT__ANNOTATIONS = STATEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_STATEMENT__STATUS = STATEMENT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_STATEMENT__SISSY_ID = STATEMENT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_STATEMENT__POSITION = STATEMENT__POSITION;

	/**
	 * The feature id for the '<em><b>Accesses</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_STATEMENT__ACCESSES = STATEMENT__ACCESSES;

	/**
	 * The feature id for the '<em><b>Blockstatement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_STATEMENT__BLOCKSTATEMENT = STATEMENT__BLOCKSTATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_STATEMENT__SURROUNDING_STATEMENT = STATEMENT__SURROUNDING_STATEMENT;

	/**
	 * The feature id for the '<em><b>Number Of Statements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_STATEMENT__NUMBER_OF_STATEMENTS = STATEMENT__NUMBER_OF_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Maximum Nesting Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_STATEMENT__MAXIMUM_NESTING_LEVEL = STATEMENT__MAXIMUM_NESTING_LEVEL;

	/**
	 * The feature id for the '<em><b>Number Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_STATEMENT__NUMBER_OF_COMMENTS = STATEMENT__NUMBER_OF_COMMENTS;

	/**
	 * The feature id for the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_STATEMENT__LINES_OF_CODE = STATEMENT__LINES_OF_CODE;

	/**
	 * The feature id for the '<em><b>Number Of Edges In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_STATEMENT__NUMBER_OF_EDGES_IN_CFG = STATEMENT__NUMBER_OF_EDGES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Number Of Nodes In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_STATEMENT__NUMBER_OF_NODES_IN_CFG = STATEMENT__NUMBER_OF_NODES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Branch</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_STATEMENT__BRANCH = STATEMENT__BRANCH;

	/**
	 * The feature id for the '<em><b>Loopstatement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_STATEMENT__LOOPSTATEMENT = STATEMENT__LOOPSTATEMENT;

	/**
	 * The feature id for the '<em><b>Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_STATEMENT__KIND = STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Break Condition Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION = STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Init Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_STATEMENT__INIT_EXPRESSION = STATEMENT_FEATURE_COUNT + 2;

	/**
	 * The feature id for the '<em><b>Increment Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_STATEMENT__INCREMENT_EXPRESSION = STATEMENT_FEATURE_COUNT + 3;

	/**
	 * The feature id for the '<em><b>Body</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_STATEMENT__BODY = STATEMENT_FEATURE_COUNT + 4;

	/**
	 * The number of structural features of the '<em>Loop Statement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int LOOP_STATEMENT_FEATURE_COUNT = STATEMENT_FEATURE_COUNT + 5;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_BLOCK__ID = BLOCK_STATEMENT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_BLOCK__ANNOTATIONS = BLOCK_STATEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_BLOCK__STATUS = BLOCK_STATEMENT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_BLOCK__SISSY_ID = BLOCK_STATEMENT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_BLOCK__POSITION = BLOCK_STATEMENT__POSITION;

	/**
	 * The feature id for the '<em><b>Accesses</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_BLOCK__ACCESSES = BLOCK_STATEMENT__ACCESSES;

	/**
	 * The feature id for the '<em><b>Blockstatement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_BLOCK__BLOCKSTATEMENT = BLOCK_STATEMENT__BLOCKSTATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_BLOCK__SURROUNDING_STATEMENT = BLOCK_STATEMENT__SURROUNDING_STATEMENT;

	/**
	 * The feature id for the '<em><b>Number Of Statements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_BLOCK__NUMBER_OF_STATEMENTS = BLOCK_STATEMENT__NUMBER_OF_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Maximum Nesting Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_BLOCK__MAXIMUM_NESTING_LEVEL = BLOCK_STATEMENT__MAXIMUM_NESTING_LEVEL;

	/**
	 * The feature id for the '<em><b>Number Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_BLOCK__NUMBER_OF_COMMENTS = BLOCK_STATEMENT__NUMBER_OF_COMMENTS;

	/**
	 * The feature id for the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_BLOCK__LINES_OF_CODE = BLOCK_STATEMENT__LINES_OF_CODE;

	/**
	 * The feature id for the '<em><b>Number Of Edges In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_BLOCK__NUMBER_OF_EDGES_IN_CFG = BLOCK_STATEMENT__NUMBER_OF_EDGES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Number Of Nodes In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_BLOCK__NUMBER_OF_NODES_IN_CFG = BLOCK_STATEMENT__NUMBER_OF_NODES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Branch</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_BLOCK__BRANCH = BLOCK_STATEMENT__BRANCH;

	/**
	 * The feature id for the '<em><b>Loopstatement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_BLOCK__LOOPSTATEMENT = BLOCK_STATEMENT__LOOPSTATEMENT;

	/**
	 * The feature id for the '<em><b>Synchronized</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_BLOCK__SYNCHRONIZED = BLOCK_STATEMENT__SYNCHRONIZED;

	/**
	 * The feature id for the '<em><b>Statements</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_BLOCK__STATEMENTS = BLOCK_STATEMENT__STATEMENTS;

	/**
	 * The feature id for the '<em><b>Surrounding Function</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_BLOCK__SURROUNDING_FUNCTION = BLOCK_STATEMENT__SURROUNDING_FUNCTION;

	/**
	 * The feature id for the '<em><b>Catch Parameter</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_BLOCK__CATCH_PARAMETER = BLOCK_STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Catch Block</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int CATCH_BLOCK_FEATURE_COUNT = BLOCK_STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JUMP_STATEMENT__ID = STATEMENT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JUMP_STATEMENT__ANNOTATIONS = STATEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JUMP_STATEMENT__STATUS = STATEMENT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JUMP_STATEMENT__SISSY_ID = STATEMENT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JUMP_STATEMENT__POSITION = STATEMENT__POSITION;

	/**
	 * The feature id for the '<em><b>Accesses</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JUMP_STATEMENT__ACCESSES = STATEMENT__ACCESSES;

	/**
	 * The feature id for the '<em><b>Blockstatement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JUMP_STATEMENT__BLOCKSTATEMENT = STATEMENT__BLOCKSTATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JUMP_STATEMENT__SURROUNDING_STATEMENT = STATEMENT__SURROUNDING_STATEMENT;

	/**
	 * The feature id for the '<em><b>Number Of Statements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JUMP_STATEMENT__NUMBER_OF_STATEMENTS = STATEMENT__NUMBER_OF_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Maximum Nesting Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JUMP_STATEMENT__MAXIMUM_NESTING_LEVEL = STATEMENT__MAXIMUM_NESTING_LEVEL;

	/**
	 * The feature id for the '<em><b>Number Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JUMP_STATEMENT__NUMBER_OF_COMMENTS = STATEMENT__NUMBER_OF_COMMENTS;

	/**
	 * The feature id for the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JUMP_STATEMENT__LINES_OF_CODE = STATEMENT__LINES_OF_CODE;

	/**
	 * The feature id for the '<em><b>Number Of Edges In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JUMP_STATEMENT__NUMBER_OF_EDGES_IN_CFG = STATEMENT__NUMBER_OF_EDGES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Number Of Nodes In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JUMP_STATEMENT__NUMBER_OF_NODES_IN_CFG = STATEMENT__NUMBER_OF_NODES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Branch</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JUMP_STATEMENT__BRANCH = STATEMENT__BRANCH;

	/**
	 * The feature id for the '<em><b>Loopstatement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JUMP_STATEMENT__LOOPSTATEMENT = STATEMENT__LOOPSTATEMENT;

	/**
	 * The feature id for the '<em><b>Kind</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JUMP_STATEMENT__KIND = STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JUMP_STATEMENT__EXPRESSION = STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The number of structural features of the '<em>Jump Statement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int JUMP_STATEMENT_FEATURE_COUNT = STATEMENT_FEATURE_COUNT + 2;

	/**
	 * The meta object id for the '{@link de.fzi.gast.statements.impl.SimpleStatementImpl <em>Simple Statement</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.statements.impl.SimpleStatementImpl
	 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getSimpleStatement()
	 * @generated
	 */
	int SIMPLE_STATEMENT = 9;

	/**
	 * The feature id for the '<em><b>Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_STATEMENT__ID = STATEMENT__ID;

	/**
	 * The feature id for the '<em><b>Annotations</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_STATEMENT__ANNOTATIONS = STATEMENT__ANNOTATIONS;

	/**
	 * The feature id for the '<em><b>Status</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_STATEMENT__STATUS = STATEMENT__STATUS;

	/**
	 * The feature id for the '<em><b>Sissy Id</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_STATEMENT__SISSY_ID = STATEMENT__SISSY_ID;

	/**
	 * The feature id for the '<em><b>Position</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_STATEMENT__POSITION = STATEMENT__POSITION;

	/**
	 * The feature id for the '<em><b>Accesses</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_STATEMENT__ACCESSES = STATEMENT__ACCESSES;

	/**
	 * The feature id for the '<em><b>Blockstatement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_STATEMENT__BLOCKSTATEMENT = STATEMENT__BLOCKSTATEMENT;

	/**
	 * The feature id for the '<em><b>Surrounding Statement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_STATEMENT__SURROUNDING_STATEMENT = STATEMENT__SURROUNDING_STATEMENT;

	/**
	 * The feature id for the '<em><b>Number Of Statements</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_STATEMENT__NUMBER_OF_STATEMENTS = STATEMENT__NUMBER_OF_STATEMENTS;

	/**
	 * The feature id for the '<em><b>Maximum Nesting Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_STATEMENT__MAXIMUM_NESTING_LEVEL = STATEMENT__MAXIMUM_NESTING_LEVEL;

	/**
	 * The feature id for the '<em><b>Number Of Comments</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_STATEMENT__NUMBER_OF_COMMENTS = STATEMENT__NUMBER_OF_COMMENTS;

	/**
	 * The feature id for the '<em><b>Lines Of Code</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_STATEMENT__LINES_OF_CODE = STATEMENT__LINES_OF_CODE;

	/**
	 * The feature id for the '<em><b>Number Of Edges In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_STATEMENT__NUMBER_OF_EDGES_IN_CFG = STATEMENT__NUMBER_OF_EDGES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Number Of Nodes In CFG</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_STATEMENT__NUMBER_OF_NODES_IN_CFG = STATEMENT__NUMBER_OF_NODES_IN_CFG;

	/**
	 * The feature id for the '<em><b>Branch</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_STATEMENT__BRANCH = STATEMENT__BRANCH;

	/**
	 * The feature id for the '<em><b>Loopstatement</b></em>' container reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_STATEMENT__LOOPSTATEMENT = STATEMENT__LOOPSTATEMENT;

	/**
	 * The feature id for the '<em><b>Expression</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_STATEMENT__EXPRESSION = STATEMENT_FEATURE_COUNT + 0;

	/**
	 * The number of structural features of the '<em>Simple Statement</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIMPLE_STATEMENT_FEATURE_COUNT = STATEMENT_FEATURE_COUNT + 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.statements.impl.GASTBehaviourImpl <em>GAST Behaviour</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.statements.impl.GASTBehaviourImpl
	 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getGASTBehaviour()
	 * @generated
	 */
	int GAST_BEHAVIOUR = 10;

	/**
	 * The feature id for the '<em><b>Blockstatement</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_BEHAVIOUR__BLOCKSTATEMENT = 0;

	/**
	 * The number of structural features of the '<em>GAST Behaviour</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int GAST_BEHAVIOUR_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link de.fzi.gast.statements.JumpStatementKind <em>Jump Statement Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.statements.JumpStatementKind
	 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getJumpStatementKind()
	 * @generated
	 */
	int JUMP_STATEMENT_KIND = 12;

	/**
	 * The meta object id for the '{@link de.fzi.gast.statements.LoopStatementKind <em>Loop Statement Kind</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see de.fzi.gast.statements.LoopStatementKind
	 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getLoopStatementKind()
	 * @generated
	 */
	int LOOP_STATEMENT_KIND = 11;


	/**
	 * Returns the meta object for class '{@link de.fzi.gast.statements.ExceptionHandler <em>Exception Handler</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Exception Handler</em>'.
	 * @see de.fzi.gast.statements.ExceptionHandler
	 * @generated
	 */
	EClass getExceptionHandler();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.statements.ExceptionHandler#getCatchBlocks <em>Catch Blocks</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Catch Blocks</em>'.
	 * @see de.fzi.gast.statements.ExceptionHandler#getCatchBlocks()
	 * @see #getExceptionHandler()
	 * @generated
	 */
	EReference getExceptionHandler_CatchBlocks();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.statements.ExceptionHandler#getFinallyBlock <em>Finally Block</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Finally Block</em>'.
	 * @see de.fzi.gast.statements.ExceptionHandler#getFinallyBlock()
	 * @see #getExceptionHandler()
	 * @generated
	 */
	EReference getExceptionHandler_FinallyBlock();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.statements.ExceptionHandler#getGuardedBlock <em>Guarded Block</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Guarded Block</em>'.
	 * @see de.fzi.gast.statements.ExceptionHandler#getGuardedBlock()
	 * @see #getExceptionHandler()
	 * @generated
	 */
	EReference getExceptionHandler_GuardedBlock();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.statements.Statement <em>Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Statement</em>'.
	 * @see de.fzi.gast.statements.Statement
	 * @generated
	 */
	EClass getStatement();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.statements.Statement#getBlockstatement <em>Blockstatement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Blockstatement</em>'.
	 * @see de.fzi.gast.statements.Statement#getBlockstatement()
	 * @see #getStatement()
	 * @generated
	 */
	EReference getStatement_Blockstatement();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.statements.Statement#getAccesses <em>Accesses</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Accesses</em>'.
	 * @see de.fzi.gast.statements.Statement#getAccesses()
	 * @see #getStatement()
	 * @generated
	 */
	EReference getStatement_Accesses();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.statements.Statement#getSurroundingStatement <em>Surrounding Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Surrounding Statement</em>'.
	 * @see de.fzi.gast.statements.Statement#getSurroundingStatement()
	 * @see #getStatement()
	 * @generated
	 */
	EReference getStatement_SurroundingStatement();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.statements.Statement#getNumberOfStatements <em>Number Of Statements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Number Of Statements</em>'.
	 * @see de.fzi.gast.statements.Statement#getNumberOfStatements()
	 * @see #getStatement()
	 * @generated
	 */
	EAttribute getStatement_NumberOfStatements();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.statements.Statement#getMaximumNestingLevel <em>Maximum Nesting Level</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Maximum Nesting Level</em>'.
	 * @see de.fzi.gast.statements.Statement#getMaximumNestingLevel()
	 * @see #getStatement()
	 * @generated
	 */
	EAttribute getStatement_MaximumNestingLevel();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.statements.Statement#getNumberOfComments <em>Number Of Comments</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Number Of Comments</em>'.
	 * @see de.fzi.gast.statements.Statement#getNumberOfComments()
	 * @see #getStatement()
	 * @generated
	 */
	EAttribute getStatement_NumberOfComments();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.statements.Statement#getLinesOfCode <em>Lines Of Code</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Lines Of Code</em>'.
	 * @see de.fzi.gast.statements.Statement#getLinesOfCode()
	 * @see #getStatement()
	 * @generated
	 */
	EAttribute getStatement_LinesOfCode();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.statements.Statement#getNumberOfEdgesInCFG <em>Number Of Edges In CFG</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Number Of Edges In CFG</em>'.
	 * @see de.fzi.gast.statements.Statement#getNumberOfEdgesInCFG()
	 * @see #getStatement()
	 * @generated
	 */
	EAttribute getStatement_NumberOfEdgesInCFG();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.statements.Statement#getNumberOfNodesInCFG <em>Number Of Nodes In CFG</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Number Of Nodes In CFG</em>'.
	 * @see de.fzi.gast.statements.Statement#getNumberOfNodesInCFG()
	 * @see #getStatement()
	 * @generated
	 */
	EAttribute getStatement_NumberOfNodesInCFG();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.statements.Statement#getBranch <em>Branch</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Branch</em>'.
	 * @see de.fzi.gast.statements.Statement#getBranch()
	 * @see #getStatement()
	 * @generated
	 */
	EReference getStatement_Branch();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.statements.Statement#getLoopstatement <em>Loopstatement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Loopstatement</em>'.
	 * @see de.fzi.gast.statements.Statement#getLoopstatement()
	 * @see #getStatement()
	 * @generated
	 */
	EReference getStatement_Loopstatement();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.statements.BlockStatement <em>Block Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Block Statement</em>'.
	 * @see de.fzi.gast.statements.BlockStatement
	 * @generated
	 */
	EClass getBlockStatement();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.statements.BlockStatement#isSynchronized <em>Synchronized</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Synchronized</em>'.
	 * @see de.fzi.gast.statements.BlockStatement#isSynchronized()
	 * @see #getBlockStatement()
	 * @generated
	 */
	EAttribute getBlockStatement_Synchronized();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.statements.BlockStatement#getStatements <em>Statements</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Statements</em>'.
	 * @see de.fzi.gast.statements.BlockStatement#getStatements()
	 * @see #getBlockStatement()
	 * @generated
	 */
	EReference getBlockStatement_Statements();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.statements.BlockStatement#getSurroundingFunction <em>Surrounding Function</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Surrounding Function</em>'.
	 * @see de.fzi.gast.statements.BlockStatement#getSurroundingFunction()
	 * @see #getBlockStatement()
	 * @generated
	 */
	EReference getBlockStatement_SurroundingFunction();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.statements.CatchBlock <em>Catch Block</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Catch Block</em>'.
	 * @see de.fzi.gast.statements.CatchBlock
	 * @generated
	 */
	EClass getCatchBlock();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.statements.CatchBlock#getCatchParameter <em>Catch Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Catch Parameter</em>'.
	 * @see de.fzi.gast.statements.CatchBlock#getCatchParameter()
	 * @see #getCatchBlock()
	 * @generated
	 */
	EReference getCatchBlock_CatchParameter();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.statements.BranchStatement <em>Branch Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Branch Statement</em>'.
	 * @see de.fzi.gast.statements.BranchStatement
	 * @generated
	 */
	EClass getBranchStatement();

	/**
	 * Returns the meta object for the containment reference list '{@link de.fzi.gast.statements.BranchStatement#getBranches <em>Branches</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Branches</em>'.
	 * @see de.fzi.gast.statements.BranchStatement#getBranches()
	 * @see #getBranchStatement()
	 * @generated
	 */
	EReference getBranchStatement_Branches();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.statements.Branch <em>Branch</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Branch</em>'.
	 * @see de.fzi.gast.statements.Branch
	 * @generated
	 */
	EClass getBranch();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.statements.Branch#getConditionExpression <em>Condition Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Condition Expression</em>'.
	 * @see de.fzi.gast.statements.Branch#getConditionExpression()
	 * @see #getBranch()
	 * @generated
	 */
	EReference getBranch_ConditionExpression();

	/**
	 * Returns the meta object for the container reference '{@link de.fzi.gast.statements.Branch#getBranchstatement <em>Branchstatement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the container reference '<em>Branchstatement</em>'.
	 * @see de.fzi.gast.statements.Branch#getBranchstatement()
	 * @see #getBranch()
	 * @generated
	 */
	EReference getBranch_Branchstatement();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.statements.Branch#getStatement <em>Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Statement</em>'.
	 * @see de.fzi.gast.statements.Branch#getStatement()
	 * @see #getBranch()
	 * @generated
	 */
	EReference getBranch_Statement();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.statements.GASTExpression <em>GAST Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>GAST Expression</em>'.
	 * @see de.fzi.gast.statements.GASTExpression
	 * @generated
	 */
	EClass getGASTExpression();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.statements.JumpStatement <em>Jump Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Jump Statement</em>'.
	 * @see de.fzi.gast.statements.JumpStatement
	 * @generated
	 */
	EClass getJumpStatement();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.statements.JumpStatement#getKind <em>Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Kind</em>'.
	 * @see de.fzi.gast.statements.JumpStatement#getKind()
	 * @see #getJumpStatement()
	 * @generated
	 */
	EAttribute getJumpStatement_Kind();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.statements.JumpStatement#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see de.fzi.gast.statements.JumpStatement#getExpression()
	 * @see #getJumpStatement()
	 * @generated
	 */
	EReference getJumpStatement_Expression();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.statements.LoopStatement <em>Loop Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Loop Statement</em>'.
	 * @see de.fzi.gast.statements.LoopStatement
	 * @generated
	 */
	EClass getLoopStatement();

	/**
	 * Returns the meta object for the attribute '{@link de.fzi.gast.statements.LoopStatement#getKind <em>Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Kind</em>'.
	 * @see de.fzi.gast.statements.LoopStatement#getKind()
	 * @see #getLoopStatement()
	 * @generated
	 */
	EAttribute getLoopStatement_Kind();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.statements.LoopStatement#getBody <em>Body</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Body</em>'.
	 * @see de.fzi.gast.statements.LoopStatement#getBody()
	 * @see #getLoopStatement()
	 * @generated
	 */
	EReference getLoopStatement_Body();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.statements.LoopStatement#getBreakConditionExpression <em>Break Condition Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Break Condition Expression</em>'.
	 * @see de.fzi.gast.statements.LoopStatement#getBreakConditionExpression()
	 * @see #getLoopStatement()
	 * @generated
	 */
	EReference getLoopStatement_BreakConditionExpression();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.statements.LoopStatement#getInitExpression <em>Init Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Init Expression</em>'.
	 * @see de.fzi.gast.statements.LoopStatement#getInitExpression()
	 * @see #getLoopStatement()
	 * @generated
	 */
	EReference getLoopStatement_InitExpression();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.statements.LoopStatement#getIncrementExpression <em>Increment Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Increment Expression</em>'.
	 * @see de.fzi.gast.statements.LoopStatement#getIncrementExpression()
	 * @see #getLoopStatement()
	 * @generated
	 */
	EReference getLoopStatement_IncrementExpression();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.statements.SimpleStatement <em>Simple Statement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Simple Statement</em>'.
	 * @see de.fzi.gast.statements.SimpleStatement
	 * @generated
	 */
	EClass getSimpleStatement();

	/**
	 * Returns the meta object for the containment reference '{@link de.fzi.gast.statements.SimpleStatement#getExpression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Expression</em>'.
	 * @see de.fzi.gast.statements.SimpleStatement#getExpression()
	 * @see #getSimpleStatement()
	 * @generated
	 */
	EReference getSimpleStatement_Expression();

	/**
	 * Returns the meta object for class '{@link de.fzi.gast.statements.GASTBehaviour <em>GAST Behaviour</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>GAST Behaviour</em>'.
	 * @see de.fzi.gast.statements.GASTBehaviour
	 * @generated
	 */
	EClass getGASTBehaviour();

	/**
	 * Returns the meta object for the reference '{@link de.fzi.gast.statements.GASTBehaviour#getBlockstatement <em>Blockstatement</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Blockstatement</em>'.
	 * @see de.fzi.gast.statements.GASTBehaviour#getBlockstatement()
	 * @see #getGASTBehaviour()
	 * @generated
	 */
	EReference getGASTBehaviour_Blockstatement();

	/**
	 * Returns the meta object for enum '{@link de.fzi.gast.statements.JumpStatementKind <em>Jump Statement Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Jump Statement Kind</em>'.
	 * @see de.fzi.gast.statements.JumpStatementKind
	 * @generated
	 */
	EEnum getJumpStatementKind();

	/**
	 * Returns the meta object for enum '{@link de.fzi.gast.statements.LoopStatementKind <em>Loop Statement Kind</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Loop Statement Kind</em>'.
	 * @see de.fzi.gast.statements.LoopStatementKind
	 * @generated
	 */
	EEnum getLoopStatementKind();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	statementsFactory getstatementsFactory();

	/**
	 * <!-- begin-user-doc -->
	 * Defines literals for the meta objects that represent
	 * <ul>
	 *   <li>each class,</li>
	 *   <li>each feature of each class,</li>
	 *   <li>each enum,</li>
	 *   <li>and each data type</li>
	 * </ul>
	 * <!-- end-user-doc -->
	 * @generated
	 */
	interface Literals {
		/**
		 * The meta object literal for the '{@link de.fzi.gast.statements.impl.ExceptionHandlerImpl <em>Exception Handler</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.statements.impl.ExceptionHandlerImpl
		 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getExceptionHandler()
		 * @generated
		 */
		EClass EXCEPTION_HANDLER = eINSTANCE.getExceptionHandler();

		/**
		 * The meta object literal for the '<em><b>Catch Blocks</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EXCEPTION_HANDLER__CATCH_BLOCKS = eINSTANCE.getExceptionHandler_CatchBlocks();

		/**
		 * The meta object literal for the '<em><b>Finally Block</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EXCEPTION_HANDLER__FINALLY_BLOCK = eINSTANCE.getExceptionHandler_FinallyBlock();

		/**
		 * The meta object literal for the '<em><b>Guarded Block</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference EXCEPTION_HANDLER__GUARDED_BLOCK = eINSTANCE.getExceptionHandler_GuardedBlock();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.statements.impl.StatementImpl <em>Statement</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.statements.impl.StatementImpl
		 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getStatement()
		 * @generated
		 */
		EClass STATEMENT = eINSTANCE.getStatement();

		/**
		 * The meta object literal for the '<em><b>Blockstatement</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STATEMENT__BLOCKSTATEMENT = eINSTANCE.getStatement_Blockstatement();

		/**
		 * The meta object literal for the '<em><b>Accesses</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STATEMENT__ACCESSES = eINSTANCE.getStatement_Accesses();

		/**
		 * The meta object literal for the '<em><b>Surrounding Statement</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STATEMENT__SURROUNDING_STATEMENT = eINSTANCE.getStatement_SurroundingStatement();

		/**
		 * The meta object literal for the '<em><b>Number Of Statements</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATEMENT__NUMBER_OF_STATEMENTS = eINSTANCE.getStatement_NumberOfStatements();

		/**
		 * The meta object literal for the '<em><b>Maximum Nesting Level</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATEMENT__MAXIMUM_NESTING_LEVEL = eINSTANCE.getStatement_MaximumNestingLevel();

		/**
		 * The meta object literal for the '<em><b>Number Of Comments</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATEMENT__NUMBER_OF_COMMENTS = eINSTANCE.getStatement_NumberOfComments();

		/**
		 * The meta object literal for the '<em><b>Lines Of Code</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATEMENT__LINES_OF_CODE = eINSTANCE.getStatement_LinesOfCode();

		/**
		 * The meta object literal for the '<em><b>Number Of Edges In CFG</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATEMENT__NUMBER_OF_EDGES_IN_CFG = eINSTANCE.getStatement_NumberOfEdgesInCFG();

		/**
		 * The meta object literal for the '<em><b>Number Of Nodes In CFG</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute STATEMENT__NUMBER_OF_NODES_IN_CFG = eINSTANCE.getStatement_NumberOfNodesInCFG();

		/**
		 * The meta object literal for the '<em><b>Branch</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STATEMENT__BRANCH = eINSTANCE.getStatement_Branch();

		/**
		 * The meta object literal for the '<em><b>Loopstatement</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference STATEMENT__LOOPSTATEMENT = eINSTANCE.getStatement_Loopstatement();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.statements.impl.BlockStatementImpl <em>Block Statement</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.statements.impl.BlockStatementImpl
		 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getBlockStatement()
		 * @generated
		 */
		EClass BLOCK_STATEMENT = eINSTANCE.getBlockStatement();

		/**
		 * The meta object literal for the '<em><b>Synchronized</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute BLOCK_STATEMENT__SYNCHRONIZED = eINSTANCE.getBlockStatement_Synchronized();

		/**
		 * The meta object literal for the '<em><b>Statements</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BLOCK_STATEMENT__STATEMENTS = eINSTANCE.getBlockStatement_Statements();

		/**
		 * The meta object literal for the '<em><b>Surrounding Function</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BLOCK_STATEMENT__SURROUNDING_FUNCTION = eINSTANCE.getBlockStatement_SurroundingFunction();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.statements.impl.CatchBlockImpl <em>Catch Block</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.statements.impl.CatchBlockImpl
		 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getCatchBlock()
		 * @generated
		 */
		EClass CATCH_BLOCK = eINSTANCE.getCatchBlock();

		/**
		 * The meta object literal for the '<em><b>Catch Parameter</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference CATCH_BLOCK__CATCH_PARAMETER = eINSTANCE.getCatchBlock_CatchParameter();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.statements.impl.BranchStatementImpl <em>Branch Statement</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.statements.impl.BranchStatementImpl
		 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getBranchStatement()
		 * @generated
		 */
		EClass BRANCH_STATEMENT = eINSTANCE.getBranchStatement();

		/**
		 * The meta object literal for the '<em><b>Branches</b></em>' containment reference list feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BRANCH_STATEMENT__BRANCHES = eINSTANCE.getBranchStatement_Branches();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.statements.impl.BranchImpl <em>Branch</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.statements.impl.BranchImpl
		 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getBranch()
		 * @generated
		 */
		EClass BRANCH = eINSTANCE.getBranch();

		/**
		 * The meta object literal for the '<em><b>Condition Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BRANCH__CONDITION_EXPRESSION = eINSTANCE.getBranch_ConditionExpression();

		/**
		 * The meta object literal for the '<em><b>Branchstatement</b></em>' container reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BRANCH__BRANCHSTATEMENT = eINSTANCE.getBranch_Branchstatement();

		/**
		 * The meta object literal for the '<em><b>Statement</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference BRANCH__STATEMENT = eINSTANCE.getBranch_Statement();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.statements.impl.GASTExpressionImpl <em>GAST Expression</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.statements.impl.GASTExpressionImpl
		 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getGASTExpression()
		 * @generated
		 */
		EClass GAST_EXPRESSION = eINSTANCE.getGASTExpression();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.statements.impl.JumpStatementImpl <em>Jump Statement</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.statements.impl.JumpStatementImpl
		 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getJumpStatement()
		 * @generated
		 */
		EClass JUMP_STATEMENT = eINSTANCE.getJumpStatement();

		/**
		 * The meta object literal for the '<em><b>Kind</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute JUMP_STATEMENT__KIND = eINSTANCE.getJumpStatement_Kind();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference JUMP_STATEMENT__EXPRESSION = eINSTANCE.getJumpStatement_Expression();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.statements.impl.LoopStatementImpl <em>Loop Statement</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.statements.impl.LoopStatementImpl
		 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getLoopStatement()
		 * @generated
		 */
		EClass LOOP_STATEMENT = eINSTANCE.getLoopStatement();

		/**
		 * The meta object literal for the '<em><b>Kind</b></em>' attribute feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EAttribute LOOP_STATEMENT__KIND = eINSTANCE.getLoopStatement_Kind();

		/**
		 * The meta object literal for the '<em><b>Body</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LOOP_STATEMENT__BODY = eINSTANCE.getLoopStatement_Body();

		/**
		 * The meta object literal for the '<em><b>Break Condition Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION = eINSTANCE.getLoopStatement_BreakConditionExpression();

		/**
		 * The meta object literal for the '<em><b>Init Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LOOP_STATEMENT__INIT_EXPRESSION = eINSTANCE.getLoopStatement_InitExpression();

		/**
		 * The meta object literal for the '<em><b>Increment Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference LOOP_STATEMENT__INCREMENT_EXPRESSION = eINSTANCE.getLoopStatement_IncrementExpression();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.statements.impl.SimpleStatementImpl <em>Simple Statement</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.statements.impl.SimpleStatementImpl
		 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getSimpleStatement()
		 * @generated
		 */
		EClass SIMPLE_STATEMENT = eINSTANCE.getSimpleStatement();

		/**
		 * The meta object literal for the '<em><b>Expression</b></em>' containment reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference SIMPLE_STATEMENT__EXPRESSION = eINSTANCE.getSimpleStatement_Expression();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.statements.impl.GASTBehaviourImpl <em>GAST Behaviour</em>}' class.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.statements.impl.GASTBehaviourImpl
		 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getGASTBehaviour()
		 * @generated
		 */
		EClass GAST_BEHAVIOUR = eINSTANCE.getGASTBehaviour();

		/**
		 * The meta object literal for the '<em><b>Blockstatement</b></em>' reference feature.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @generated
		 */
		EReference GAST_BEHAVIOUR__BLOCKSTATEMENT = eINSTANCE.getGASTBehaviour_Blockstatement();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.statements.JumpStatementKind <em>Jump Statement Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.statements.JumpStatementKind
		 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getJumpStatementKind()
		 * @generated
		 */
		EEnum JUMP_STATEMENT_KIND = eINSTANCE.getJumpStatementKind();

		/**
		 * The meta object literal for the '{@link de.fzi.gast.statements.LoopStatementKind <em>Loop Statement Kind</em>}' enum.
		 * <!-- begin-user-doc -->
		 * <!-- end-user-doc -->
		 * @see de.fzi.gast.statements.LoopStatementKind
		 * @see de.fzi.gast.statements.impl.statementsPackageImpl#getLoopStatementKind()
		 * @generated
		 */
		EEnum LOOP_STATEMENT_KIND = eINSTANCE.getLoopStatementKind();

	}

} //statementsPackage
