/**
 * <copyright>
 * </copyright>
 *
 * $Id: StatementImpl.java,v 1.5 2008/12/05 15:44:33 stammel Exp $
 */
package de.fzi.gast.statements.impl;

import de.fzi.gast.accesses.BaseAccess;
import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

import de.fzi.gast.accesses.Access;
import de.fzi.gast.accesses.accessesPackage;
import de.fzi.gast.core.impl.SourceEntityImpl;
import de.fzi.gast.helpers.DerivationHelper;
import de.fzi.gast.statements.BlockStatement;
import de.fzi.gast.statements.Branch;
import de.fzi.gast.statements.LoopStatement;
import de.fzi.gast.statements.Statement;
import de.fzi.gast.statements.statementsPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Statement</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.statements.impl.StatementImpl#getAccesses <em>Accesses</em>}</li>
 *   <li>{@link de.fzi.gast.statements.impl.StatementImpl#getBlockstatement <em>Blockstatement</em>}</li>
 *   <li>{@link de.fzi.gast.statements.impl.StatementImpl#getSurroundingStatement <em>Surrounding Statement</em>}</li>
 *   <li>{@link de.fzi.gast.statements.impl.StatementImpl#getNumberOfStatements <em>Number Of Statements</em>}</li>
 *   <li>{@link de.fzi.gast.statements.impl.StatementImpl#getMaximumNestingLevel <em>Maximum Nesting Level</em>}</li>
 *   <li>{@link de.fzi.gast.statements.impl.StatementImpl#getNumberOfComments <em>Number Of Comments</em>}</li>
 *   <li>{@link de.fzi.gast.statements.impl.StatementImpl#getLinesOfCode <em>Lines Of Code</em>}</li>
 *   <li>{@link de.fzi.gast.statements.impl.StatementImpl#getNumberOfEdgesInCFG <em>Number Of Edges In CFG</em>}</li>
 *   <li>{@link de.fzi.gast.statements.impl.StatementImpl#getNumberOfNodesInCFG <em>Number Of Nodes In CFG</em>}</li>
 *   <li>{@link de.fzi.gast.statements.impl.StatementImpl#getBranch <em>Branch</em>}</li>
 *   <li>{@link de.fzi.gast.statements.impl.StatementImpl#getLoopstatement <em>Loopstatement</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class StatementImpl extends SourceEntityImpl implements Statement {
	/**
	 * The cached value of the '{@link #getAccesses() <em>Accesses</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getAccesses()
	 * @generated
	 * @ordered
	 */
	protected EList<BaseAccess> accesses;

	/**
	 * The default value of the '{@link #getNumberOfStatements() <em>Number Of Statements</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNumberOfStatements()
	 * @generated
	 * @ordered
	 */
	protected static final int NUMBER_OF_STATEMENTS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getNumberOfStatements() <em>Number Of Statements</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNumberOfStatements()
	 * @generated
	 * @ordered
	 */
	protected int numberOfStatements = NUMBER_OF_STATEMENTS_EDEFAULT;

	/**
	 * The default value of the '{@link #getMaximumNestingLevel() <em>Maximum Nesting Level</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaximumNestingLevel()
	 * @generated
	 * @ordered
	 */
	protected static final int MAXIMUM_NESTING_LEVEL_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getMaximumNestingLevel() <em>Maximum Nesting Level</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getMaximumNestingLevel()
	 * @generated
	 * @ordered
	 */
	protected int maximumNestingLevel = MAXIMUM_NESTING_LEVEL_EDEFAULT;

	/**
	 * The default value of the '{@link #getNumberOfComments() <em>Number Of Comments</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNumberOfComments()
	 * @generated
	 * @ordered
	 */
	protected static final int NUMBER_OF_COMMENTS_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getNumberOfComments() <em>Number Of Comments</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNumberOfComments()
	 * @generated
	 * @ordered
	 */
	protected int numberOfComments = NUMBER_OF_COMMENTS_EDEFAULT;

	/**
	 * The default value of the '{@link #getLinesOfCode() <em>Lines Of Code</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinesOfCode()
	 * @generated
	 * @ordered
	 */
	protected static final int LINES_OF_CODE_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getLinesOfCode() <em>Lines Of Code</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getLinesOfCode()
	 * @generated
	 * @ordered
	 */
	protected int linesOfCode = LINES_OF_CODE_EDEFAULT;

	/**
	 * The default value of the '{@link #getNumberOfEdgesInCFG() <em>Number Of Edges In CFG</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNumberOfEdgesInCFG()
	 * @generated
	 * @ordered
	 */
	protected static final int NUMBER_OF_EDGES_IN_CFG_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getNumberOfEdgesInCFG() <em>Number Of Edges In CFG</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNumberOfEdgesInCFG()
	 * @generated
	 * @ordered
	 */
	protected int numberOfEdgesInCFG = NUMBER_OF_EDGES_IN_CFG_EDEFAULT;

	/**
	 * The default value of the '{@link #getNumberOfNodesInCFG() <em>Number Of Nodes In CFG</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNumberOfNodesInCFG()
	 * @generated
	 * @ordered
	 */
	protected static final int NUMBER_OF_NODES_IN_CFG_EDEFAULT = 0;

	/**
	 * The cached value of the '{@link #getNumberOfNodesInCFG() <em>Number Of Nodes In CFG</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getNumberOfNodesInCFG()
	 * @generated
	 * @ordered
	 */
	protected int numberOfNodesInCFG = NUMBER_OF_NODES_IN_CFG_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StatementImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return statementsPackage.Literals.STATEMENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BlockStatement getBlockstatement() {
		if (eContainerFeatureID() != statementsPackage.STATEMENT__BLOCKSTATEMENT) return null;
		return (BlockStatement)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetBlockstatement(BlockStatement newBlockstatement, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newBlockstatement, statementsPackage.STATEMENT__BLOCKSTATEMENT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBlockstatement(BlockStatement newBlockstatement) {
		if (newBlockstatement != eInternalContainer() || (eContainerFeatureID() != statementsPackage.STATEMENT__BLOCKSTATEMENT && newBlockstatement != null)) {
			if (EcoreUtil.isAncestor(this, newBlockstatement))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newBlockstatement != null)
				msgs = ((InternalEObject)newBlockstatement).eInverseAdd(this, statementsPackage.BLOCK_STATEMENT__STATEMENTS, BlockStatement.class, msgs);
			msgs = basicSetBlockstatement(newBlockstatement, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, statementsPackage.STATEMENT__BLOCKSTATEMENT, newBlockstatement, newBlockstatement));
	}

	/**
	 * <!-- begin-user-doc -->
	 * This method returns the predecessor of the given statement in the list of
	 * its surrounding statement in case the surrounding statement is a block statement.
	 * <!-- end-user-doc -->
	 * @return the predecessor statement within the statement list of parent block statement, null in other cases.
	 * @generated NOT
	 */
	public Statement basicGetPredecessorStatement() {
		if (this.getSurroundingStatement() instanceof BlockStatement) {
			BlockStatement parentBlock = (BlockStatement) this.getSurroundingStatement();
			
			int index = parentBlock.getStatements().indexOf(this);
			
			int indexOfPredecessor = index - 1;
			if (indexOfPredecessor > 0 && indexOfPredecessor < parentBlock.getStatements().size()) {
				return parentBlock.getStatements().get(indexOfPredecessor);
			}
		}
		
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<BaseAccess> getAccesses() {
		if (accesses == null) {
			accesses = new EObjectContainmentWithInverseEList<BaseAccess>(BaseAccess.class, this, statementsPackage.STATEMENT__ACCESSES, accessesPackage.BASE_ACCESS__PARENT_STATEMENT);
		}
		return accesses;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Statement getSurroundingStatement() {
		Statement surroundingStatement = basicGetSurroundingStatement();
		return surroundingStatement != null && surroundingStatement.eIsProxy() ? (Statement)eResolveProxy((InternalEObject)surroundingStatement) : surroundingStatement;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public Statement basicGetSurroundingStatement() {
		// -> do not perform proxy resolution
		return DerivationHelper.basicGetSurroundingStatement(this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated NOT
	 */
	public void setSurroundingStatement(Statement newSurroundingStatement) {
		
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getNumberOfStatements() {
		return numberOfStatements;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNumberOfStatements(int newNumberOfStatements) {
		int oldNumberOfStatements = numberOfStatements;
		numberOfStatements = newNumberOfStatements;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, statementsPackage.STATEMENT__NUMBER_OF_STATEMENTS, oldNumberOfStatements, numberOfStatements));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getMaximumNestingLevel() {
		return maximumNestingLevel;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setMaximumNestingLevel(int newMaximumNestingLevel) {
		int oldMaximumNestingLevel = maximumNestingLevel;
		maximumNestingLevel = newMaximumNestingLevel;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, statementsPackage.STATEMENT__MAXIMUM_NESTING_LEVEL, oldMaximumNestingLevel, maximumNestingLevel));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getNumberOfComments() {
		return numberOfComments;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNumberOfComments(int newNumberOfComments) {
		int oldNumberOfComments = numberOfComments;
		numberOfComments = newNumberOfComments;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, statementsPackage.STATEMENT__NUMBER_OF_COMMENTS, oldNumberOfComments, numberOfComments));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getLinesOfCode() {
		return linesOfCode;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLinesOfCode(int newLinesOfCode) {
		int oldLinesOfCode = linesOfCode;
		linesOfCode = newLinesOfCode;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, statementsPackage.STATEMENT__LINES_OF_CODE, oldLinesOfCode, linesOfCode));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getNumberOfEdgesInCFG() {
		return numberOfEdgesInCFG;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNumberOfEdgesInCFG(int newNumberOfEdgesInCFG) {
		int oldNumberOfEdgesInCFG = numberOfEdgesInCFG;
		numberOfEdgesInCFG = newNumberOfEdgesInCFG;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, statementsPackage.STATEMENT__NUMBER_OF_EDGES_IN_CFG, oldNumberOfEdgesInCFG, numberOfEdgesInCFG));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public int getNumberOfNodesInCFG() {
		return numberOfNodesInCFG;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setNumberOfNodesInCFG(int newNumberOfNodesInCFG) {
		int oldNumberOfNodesInCFG = numberOfNodesInCFG;
		numberOfNodesInCFG = newNumberOfNodesInCFG;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, statementsPackage.STATEMENT__NUMBER_OF_NODES_IN_CFG, oldNumberOfNodesInCFG, numberOfNodesInCFG));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Branch getBranch() {
		if (eContainerFeatureID() != statementsPackage.STATEMENT__BRANCH) return null;
		return (Branch)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetBranch(Branch newBranch, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newBranch, statementsPackage.STATEMENT__BRANCH, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBranch(Branch newBranch) {
		if (newBranch != eInternalContainer() || (eContainerFeatureID() != statementsPackage.STATEMENT__BRANCH && newBranch != null)) {
			if (EcoreUtil.isAncestor(this, newBranch))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newBranch != null)
				msgs = ((InternalEObject)newBranch).eInverseAdd(this, statementsPackage.BRANCH__STATEMENT, Branch.class, msgs);
			msgs = basicSetBranch(newBranch, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, statementsPackage.STATEMENT__BRANCH, newBranch, newBranch));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LoopStatement getLoopstatement() {
		if (eContainerFeatureID() != statementsPackage.STATEMENT__LOOPSTATEMENT) return null;
		return (LoopStatement)eContainer();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetLoopstatement(LoopStatement newLoopstatement, NotificationChain msgs) {
		msgs = eBasicSetContainer((InternalEObject)newLoopstatement, statementsPackage.STATEMENT__LOOPSTATEMENT, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setLoopstatement(LoopStatement newLoopstatement) {
		if (newLoopstatement != eInternalContainer() || (eContainerFeatureID() != statementsPackage.STATEMENT__LOOPSTATEMENT && newLoopstatement != null)) {
			if (EcoreUtil.isAncestor(this, newLoopstatement))
				throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
			NotificationChain msgs = null;
			if (eInternalContainer() != null)
				msgs = eBasicRemoveFromContainer(msgs);
			if (newLoopstatement != null)
				msgs = ((InternalEObject)newLoopstatement).eInverseAdd(this, statementsPackage.LOOP_STATEMENT__BODY, LoopStatement.class, msgs);
			msgs = basicSetLoopstatement(newLoopstatement, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, statementsPackage.STATEMENT__LOOPSTATEMENT, newLoopstatement, newLoopstatement));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case statementsPackage.STATEMENT__ACCESSES:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getAccesses()).basicAdd(otherEnd, msgs);
			case statementsPackage.STATEMENT__BLOCKSTATEMENT:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetBlockstatement((BlockStatement)otherEnd, msgs);
			case statementsPackage.STATEMENT__BRANCH:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetBranch((Branch)otherEnd, msgs);
			case statementsPackage.STATEMENT__LOOPSTATEMENT:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetLoopstatement((LoopStatement)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * This method returns the successor of the given statement in the list of
	 * its surrounding statement in case the surrounding statement is a block statement.
	 * <!-- end-user-doc -->
	 * @generated NOT
	 * @return the successor statement within the statement list of parent block statement, null in other cases.
	 */
	public Statement basicGetSuccessorStatement() {
		if (this.getSurroundingStatement() instanceof BlockStatement) {
			BlockStatement parentBlock = (BlockStatement) this.getSurroundingStatement();
			
			int index = parentBlock.getStatements().indexOf(this);
			
			int indexOfSuccessor = index + 1;
			if (indexOfSuccessor > 0 && indexOfSuccessor < parentBlock.getStatements().size()) {
				return parentBlock.getStatements().get(indexOfSuccessor);
			}
		}
		
		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case statementsPackage.STATEMENT__ACCESSES:
				return ((InternalEList<?>)getAccesses()).basicRemove(otherEnd, msgs);
			case statementsPackage.STATEMENT__BLOCKSTATEMENT:
				return basicSetBlockstatement(null, msgs);
			case statementsPackage.STATEMENT__BRANCH:
				return basicSetBranch(null, msgs);
			case statementsPackage.STATEMENT__LOOPSTATEMENT:
				return basicSetLoopstatement(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
		switch (eContainerFeatureID()) {
			case statementsPackage.STATEMENT__BLOCKSTATEMENT:
				return eInternalContainer().eInverseRemove(this, statementsPackage.BLOCK_STATEMENT__STATEMENTS, BlockStatement.class, msgs);
			case statementsPackage.STATEMENT__BRANCH:
				return eInternalContainer().eInverseRemove(this, statementsPackage.BRANCH__STATEMENT, Branch.class, msgs);
			case statementsPackage.STATEMENT__LOOPSTATEMENT:
				return eInternalContainer().eInverseRemove(this, statementsPackage.LOOP_STATEMENT__BODY, LoopStatement.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case statementsPackage.STATEMENT__ACCESSES:
				return getAccesses();
			case statementsPackage.STATEMENT__BLOCKSTATEMENT:
				return getBlockstatement();
			case statementsPackage.STATEMENT__SURROUNDING_STATEMENT:
				if (resolve) return getSurroundingStatement();
				return basicGetSurroundingStatement();
			case statementsPackage.STATEMENT__NUMBER_OF_STATEMENTS:
				return getNumberOfStatements();
			case statementsPackage.STATEMENT__MAXIMUM_NESTING_LEVEL:
				return getMaximumNestingLevel();
			case statementsPackage.STATEMENT__NUMBER_OF_COMMENTS:
				return getNumberOfComments();
			case statementsPackage.STATEMENT__LINES_OF_CODE:
				return getLinesOfCode();
			case statementsPackage.STATEMENT__NUMBER_OF_EDGES_IN_CFG:
				return getNumberOfEdgesInCFG();
			case statementsPackage.STATEMENT__NUMBER_OF_NODES_IN_CFG:
				return getNumberOfNodesInCFG();
			case statementsPackage.STATEMENT__BRANCH:
				return getBranch();
			case statementsPackage.STATEMENT__LOOPSTATEMENT:
				return getLoopstatement();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case statementsPackage.STATEMENT__ACCESSES:
				getAccesses().clear();
				getAccesses().addAll((Collection<? extends BaseAccess>)newValue);
				return;
			case statementsPackage.STATEMENT__BLOCKSTATEMENT:
				setBlockstatement((BlockStatement)newValue);
				return;
			case statementsPackage.STATEMENT__NUMBER_OF_STATEMENTS:
				setNumberOfStatements((Integer)newValue);
				return;
			case statementsPackage.STATEMENT__MAXIMUM_NESTING_LEVEL:
				setMaximumNestingLevel((Integer)newValue);
				return;
			case statementsPackage.STATEMENT__NUMBER_OF_COMMENTS:
				setNumberOfComments((Integer)newValue);
				return;
			case statementsPackage.STATEMENT__LINES_OF_CODE:
				setLinesOfCode((Integer)newValue);
				return;
			case statementsPackage.STATEMENT__NUMBER_OF_EDGES_IN_CFG:
				setNumberOfEdgesInCFG((Integer)newValue);
				return;
			case statementsPackage.STATEMENT__NUMBER_OF_NODES_IN_CFG:
				setNumberOfNodesInCFG((Integer)newValue);
				return;
			case statementsPackage.STATEMENT__BRANCH:
				setBranch((Branch)newValue);
				return;
			case statementsPackage.STATEMENT__LOOPSTATEMENT:
				setLoopstatement((LoopStatement)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case statementsPackage.STATEMENT__ACCESSES:
				getAccesses().clear();
				return;
			case statementsPackage.STATEMENT__BLOCKSTATEMENT:
				setBlockstatement((BlockStatement)null);
				return;
			case statementsPackage.STATEMENT__NUMBER_OF_STATEMENTS:
				setNumberOfStatements(NUMBER_OF_STATEMENTS_EDEFAULT);
				return;
			case statementsPackage.STATEMENT__MAXIMUM_NESTING_LEVEL:
				setMaximumNestingLevel(MAXIMUM_NESTING_LEVEL_EDEFAULT);
				return;
			case statementsPackage.STATEMENT__NUMBER_OF_COMMENTS:
				setNumberOfComments(NUMBER_OF_COMMENTS_EDEFAULT);
				return;
			case statementsPackage.STATEMENT__LINES_OF_CODE:
				setLinesOfCode(LINES_OF_CODE_EDEFAULT);
				return;
			case statementsPackage.STATEMENT__NUMBER_OF_EDGES_IN_CFG:
				setNumberOfEdgesInCFG(NUMBER_OF_EDGES_IN_CFG_EDEFAULT);
				return;
			case statementsPackage.STATEMENT__NUMBER_OF_NODES_IN_CFG:
				setNumberOfNodesInCFG(NUMBER_OF_NODES_IN_CFG_EDEFAULT);
				return;
			case statementsPackage.STATEMENT__BRANCH:
				setBranch((Branch)null);
				return;
			case statementsPackage.STATEMENT__LOOPSTATEMENT:
				setLoopstatement((LoopStatement)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case statementsPackage.STATEMENT__ACCESSES:
				return accesses != null && !accesses.isEmpty();
			case statementsPackage.STATEMENT__BLOCKSTATEMENT:
				return getBlockstatement() != null;
			case statementsPackage.STATEMENT__SURROUNDING_STATEMENT:
				return basicGetSurroundingStatement() != null;
			case statementsPackage.STATEMENT__NUMBER_OF_STATEMENTS:
				return numberOfStatements != NUMBER_OF_STATEMENTS_EDEFAULT;
			case statementsPackage.STATEMENT__MAXIMUM_NESTING_LEVEL:
				return maximumNestingLevel != MAXIMUM_NESTING_LEVEL_EDEFAULT;
			case statementsPackage.STATEMENT__NUMBER_OF_COMMENTS:
				return numberOfComments != NUMBER_OF_COMMENTS_EDEFAULT;
			case statementsPackage.STATEMENT__LINES_OF_CODE:
				return linesOfCode != LINES_OF_CODE_EDEFAULT;
			case statementsPackage.STATEMENT__NUMBER_OF_EDGES_IN_CFG:
				return numberOfEdgesInCFG != NUMBER_OF_EDGES_IN_CFG_EDEFAULT;
			case statementsPackage.STATEMENT__NUMBER_OF_NODES_IN_CFG:
				return numberOfNodesInCFG != NUMBER_OF_NODES_IN_CFG_EDEFAULT;
			case statementsPackage.STATEMENT__BRANCH:
				return getBranch() != null;
			case statementsPackage.STATEMENT__LOOPSTATEMENT:
				return getLoopstatement() != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (numberOfStatements: ");
		result.append(numberOfStatements);
		result.append(", maximumNestingLevel: ");
		result.append(maximumNestingLevel);
		result.append(", numberOfComments: ");
		result.append(numberOfComments);
		result.append(", linesOfCode: ");
		result.append(linesOfCode);
		result.append(", numberOfEdgesInCFG: ");
		result.append(numberOfEdgesInCFG);
		result.append(", numberOfNodesInCFG: ");
		result.append(numberOfNodesInCFG);
		result.append(')');
		return result.toString();
	}

} //StatementImpl
