/**
 * <copyright>
 * </copyright>
 *
 * $Id: LoopStatementImpl.java,v 1.5 2008/12/05 15:44:33 stammel Exp $
 */
package de.fzi.gast.statements.impl;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

import de.fzi.gast.statements.GASTExpression;
import de.fzi.gast.statements.LoopStatement;
import de.fzi.gast.statements.LoopStatementKind;
import de.fzi.gast.statements.Statement;
import de.fzi.gast.statements.statementsPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Loop Statement</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.statements.impl.LoopStatementImpl#getKind <em>Kind</em>}</li>
 *   <li>{@link de.fzi.gast.statements.impl.LoopStatementImpl#getBreakConditionExpression <em>Break Condition Expression</em>}</li>
 *   <li>{@link de.fzi.gast.statements.impl.LoopStatementImpl#getInitExpression <em>Init Expression</em>}</li>
 *   <li>{@link de.fzi.gast.statements.impl.LoopStatementImpl#getIncrementExpression <em>Increment Expression</em>}</li>
 *   <li>{@link de.fzi.gast.statements.impl.LoopStatementImpl#getBody <em>Body</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class LoopStatementImpl extends StatementImpl implements LoopStatement {
	/**
	 * The default value of the '{@link #getKind() <em>Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKind()
	 * @generated
	 * @ordered
	 */
	protected static final LoopStatementKind KIND_EDEFAULT = LoopStatementKind.FOREACH;

	/**
	 * The cached value of the '{@link #getKind() <em>Kind</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getKind()
	 * @generated
	 * @ordered
	 */
	protected LoopStatementKind kind = KIND_EDEFAULT;

	/**
	 * The cached value of the '{@link #getBreakConditionExpression() <em>Break Condition Expression</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBreakConditionExpression()
	 * @generated
	 * @ordered
	 */
	protected GASTExpression breakConditionExpression;

	/**
	 * The cached value of the '{@link #getInitExpression() <em>Init Expression</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getInitExpression()
	 * @generated
	 * @ordered
	 */
	protected GASTExpression initExpression;

	/**
	 * The cached value of the '{@link #getIncrementExpression() <em>Increment Expression</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIncrementExpression()
	 * @generated
	 * @ordered
	 */
	protected GASTExpression incrementExpression;

	/**
	 * The cached value of the '{@link #getBody() <em>Body</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getBody()
	 * @generated
	 * @ordered
	 */
	protected Statement body;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected LoopStatementImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return statementsPackage.Literals.LOOP_STATEMENT;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public LoopStatementKind getKind() {
		return kind;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setKind(LoopStatementKind newKind) {
		LoopStatementKind oldKind = kind;
		kind = newKind == null ? KIND_EDEFAULT : newKind;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, statementsPackage.LOOP_STATEMENT__KIND, oldKind, kind));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Statement getBody() {
		return body;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetBody(Statement newBody, NotificationChain msgs) {
		Statement oldBody = body;
		body = newBody;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, statementsPackage.LOOP_STATEMENT__BODY, oldBody, newBody);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBody(Statement newBody) {
		if (newBody != body) {
			NotificationChain msgs = null;
			if (body != null)
				msgs = ((InternalEObject)body).eInverseRemove(this, statementsPackage.STATEMENT__LOOPSTATEMENT, Statement.class, msgs);
			if (newBody != null)
				msgs = ((InternalEObject)newBody).eInverseAdd(this, statementsPackage.STATEMENT__LOOPSTATEMENT, Statement.class, msgs);
			msgs = basicSetBody(newBody, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, statementsPackage.LOOP_STATEMENT__BODY, newBody, newBody));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case statementsPackage.LOOP_STATEMENT__BODY:
				if (body != null)
					msgs = ((InternalEObject)body).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - statementsPackage.LOOP_STATEMENT__BODY, null, msgs);
				return basicSetBody((Statement)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTExpression getBreakConditionExpression() {
		return breakConditionExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetBreakConditionExpression(GASTExpression newBreakConditionExpression, NotificationChain msgs) {
		GASTExpression oldBreakConditionExpression = breakConditionExpression;
		breakConditionExpression = newBreakConditionExpression;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, statementsPackage.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION, oldBreakConditionExpression, newBreakConditionExpression);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setBreakConditionExpression(GASTExpression newBreakConditionExpression) {
		if (newBreakConditionExpression != breakConditionExpression) {
			NotificationChain msgs = null;
			if (breakConditionExpression != null)
				msgs = ((InternalEObject)breakConditionExpression).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - statementsPackage.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION, null, msgs);
			if (newBreakConditionExpression != null)
				msgs = ((InternalEObject)newBreakConditionExpression).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - statementsPackage.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION, null, msgs);
			msgs = basicSetBreakConditionExpression(newBreakConditionExpression, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, statementsPackage.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION, newBreakConditionExpression, newBreakConditionExpression));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTExpression getInitExpression() {
		return initExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetInitExpression(GASTExpression newInitExpression, NotificationChain msgs) {
		GASTExpression oldInitExpression = initExpression;
		initExpression = newInitExpression;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, statementsPackage.LOOP_STATEMENT__INIT_EXPRESSION, oldInitExpression, newInitExpression);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setInitExpression(GASTExpression newInitExpression) {
		if (newInitExpression != initExpression) {
			NotificationChain msgs = null;
			if (initExpression != null)
				msgs = ((InternalEObject)initExpression).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - statementsPackage.LOOP_STATEMENT__INIT_EXPRESSION, null, msgs);
			if (newInitExpression != null)
				msgs = ((InternalEObject)newInitExpression).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - statementsPackage.LOOP_STATEMENT__INIT_EXPRESSION, null, msgs);
			msgs = basicSetInitExpression(newInitExpression, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, statementsPackage.LOOP_STATEMENT__INIT_EXPRESSION, newInitExpression, newInitExpression));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public GASTExpression getIncrementExpression() {
		return incrementExpression;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetIncrementExpression(GASTExpression newIncrementExpression, NotificationChain msgs) {
		GASTExpression oldIncrementExpression = incrementExpression;
		incrementExpression = newIncrementExpression;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, statementsPackage.LOOP_STATEMENT__INCREMENT_EXPRESSION, oldIncrementExpression, newIncrementExpression);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIncrementExpression(GASTExpression newIncrementExpression) {
		if (newIncrementExpression != incrementExpression) {
			NotificationChain msgs = null;
			if (incrementExpression != null)
				msgs = ((InternalEObject)incrementExpression).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - statementsPackage.LOOP_STATEMENT__INCREMENT_EXPRESSION, null, msgs);
			if (newIncrementExpression != null)
				msgs = ((InternalEObject)newIncrementExpression).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - statementsPackage.LOOP_STATEMENT__INCREMENT_EXPRESSION, null, msgs);
			msgs = basicSetIncrementExpression(newIncrementExpression, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, statementsPackage.LOOP_STATEMENT__INCREMENT_EXPRESSION, newIncrementExpression, newIncrementExpression));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case statementsPackage.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION:
				return basicSetBreakConditionExpression(null, msgs);
			case statementsPackage.LOOP_STATEMENT__INIT_EXPRESSION:
				return basicSetInitExpression(null, msgs);
			case statementsPackage.LOOP_STATEMENT__INCREMENT_EXPRESSION:
				return basicSetIncrementExpression(null, msgs);
			case statementsPackage.LOOP_STATEMENT__BODY:
				return basicSetBody(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case statementsPackage.LOOP_STATEMENT__KIND:
				return getKind();
			case statementsPackage.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION:
				return getBreakConditionExpression();
			case statementsPackage.LOOP_STATEMENT__INIT_EXPRESSION:
				return getInitExpression();
			case statementsPackage.LOOP_STATEMENT__INCREMENT_EXPRESSION:
				return getIncrementExpression();
			case statementsPackage.LOOP_STATEMENT__BODY:
				return getBody();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case statementsPackage.LOOP_STATEMENT__KIND:
				setKind((LoopStatementKind)newValue);
				return;
			case statementsPackage.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION:
				setBreakConditionExpression((GASTExpression)newValue);
				return;
			case statementsPackage.LOOP_STATEMENT__INIT_EXPRESSION:
				setInitExpression((GASTExpression)newValue);
				return;
			case statementsPackage.LOOP_STATEMENT__INCREMENT_EXPRESSION:
				setIncrementExpression((GASTExpression)newValue);
				return;
			case statementsPackage.LOOP_STATEMENT__BODY:
				setBody((Statement)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case statementsPackage.LOOP_STATEMENT__KIND:
				setKind(KIND_EDEFAULT);
				return;
			case statementsPackage.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION:
				setBreakConditionExpression((GASTExpression)null);
				return;
			case statementsPackage.LOOP_STATEMENT__INIT_EXPRESSION:
				setInitExpression((GASTExpression)null);
				return;
			case statementsPackage.LOOP_STATEMENT__INCREMENT_EXPRESSION:
				setIncrementExpression((GASTExpression)null);
				return;
			case statementsPackage.LOOP_STATEMENT__BODY:
				setBody((Statement)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case statementsPackage.LOOP_STATEMENT__KIND:
				return kind != KIND_EDEFAULT;
			case statementsPackage.LOOP_STATEMENT__BREAK_CONDITION_EXPRESSION:
				return breakConditionExpression != null;
			case statementsPackage.LOOP_STATEMENT__INIT_EXPRESSION:
				return initExpression != null;
			case statementsPackage.LOOP_STATEMENT__INCREMENT_EXPRESSION:
				return incrementExpression != null;
			case statementsPackage.LOOP_STATEMENT__BODY:
				return body != null;
		}
		return super.eIsSet(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (kind: ");
		result.append(kind);
		result.append(')');
		return result.toString();
	}

} //LoopStatementImpl
