/**
 * <copyright>
 * </copyright>
 *
 * $Id: ExceptionHandlerImpl.java,v 1.5 2008/12/05 15:44:33 stammel Exp $
 */
package de.fzi.gast.statements.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

import de.fzi.gast.statements.BlockStatement;
import de.fzi.gast.statements.CatchBlock;
import de.fzi.gast.statements.ExceptionHandler;
import de.fzi.gast.statements.statementsPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Exception Handler</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link de.fzi.gast.statements.impl.ExceptionHandlerImpl#getCatchBlocks <em>Catch Blocks</em>}</li>
 *   <li>{@link de.fzi.gast.statements.impl.ExceptionHandlerImpl#getFinallyBlock <em>Finally Block</em>}</li>
 *   <li>{@link de.fzi.gast.statements.impl.ExceptionHandlerImpl#getGuardedBlock <em>Guarded Block</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class ExceptionHandlerImpl extends StatementImpl implements ExceptionHandler {
	/**
	 * The cached value of the '{@link #getCatchBlocks() <em>Catch Blocks</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCatchBlocks()
	 * @generated
	 * @ordered
	 */
	protected EList<CatchBlock> catchBlocks;

	/**
	 * The cached value of the '{@link #getFinallyBlock() <em>Finally Block</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getFinallyBlock()
	 * @generated
	 * @ordered
	 */
	protected BlockStatement finallyBlock;

	/**
	 * The cached value of the '{@link #getGuardedBlock() <em>Guarded Block</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getGuardedBlock()
	 * @generated
	 * @ordered
	 */
	protected BlockStatement guardedBlock;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ExceptionHandlerImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass() {
		return statementsPackage.Literals.EXCEPTION_HANDLER;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList<CatchBlock> getCatchBlocks() {
		if (catchBlocks == null) {
			catchBlocks = new EObjectContainmentEList<CatchBlock>(CatchBlock.class, this, statementsPackage.EXCEPTION_HANDLER__CATCH_BLOCKS);
		}
		return catchBlocks;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BlockStatement getFinallyBlock() {
		return finallyBlock;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetFinallyBlock(BlockStatement newFinallyBlock, NotificationChain msgs) {
		BlockStatement oldFinallyBlock = finallyBlock;
		finallyBlock = newFinallyBlock;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, statementsPackage.EXCEPTION_HANDLER__FINALLY_BLOCK, oldFinallyBlock, newFinallyBlock);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setFinallyBlock(BlockStatement newFinallyBlock) {
		if (newFinallyBlock != finallyBlock) {
			NotificationChain msgs = null;
			if (finallyBlock != null)
				msgs = ((InternalEObject)finallyBlock).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - statementsPackage.EXCEPTION_HANDLER__FINALLY_BLOCK, null, msgs);
			if (newFinallyBlock != null)
				msgs = ((InternalEObject)newFinallyBlock).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - statementsPackage.EXCEPTION_HANDLER__FINALLY_BLOCK, null, msgs);
			msgs = basicSetFinallyBlock(newFinallyBlock, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, statementsPackage.EXCEPTION_HANDLER__FINALLY_BLOCK, newFinallyBlock, newFinallyBlock));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BlockStatement getGuardedBlock() {
		return guardedBlock;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetGuardedBlock(BlockStatement newGuardedBlock, NotificationChain msgs) {
		BlockStatement oldGuardedBlock = guardedBlock;
		guardedBlock = newGuardedBlock;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, statementsPackage.EXCEPTION_HANDLER__GUARDED_BLOCK, oldGuardedBlock, newGuardedBlock);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setGuardedBlock(BlockStatement newGuardedBlock) {
		if (newGuardedBlock != guardedBlock) {
			NotificationChain msgs = null;
			if (guardedBlock != null)
				msgs = ((InternalEObject)guardedBlock).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - statementsPackage.EXCEPTION_HANDLER__GUARDED_BLOCK, null, msgs);
			if (newGuardedBlock != null)
				msgs = ((InternalEObject)newGuardedBlock).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - statementsPackage.EXCEPTION_HANDLER__GUARDED_BLOCK, null, msgs);
			msgs = basicSetGuardedBlock(newGuardedBlock, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, statementsPackage.EXCEPTION_HANDLER__GUARDED_BLOCK, newGuardedBlock, newGuardedBlock));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
		switch (featureID) {
			case statementsPackage.EXCEPTION_HANDLER__CATCH_BLOCKS:
				return ((InternalEList<?>)getCatchBlocks()).basicRemove(otherEnd, msgs);
			case statementsPackage.EXCEPTION_HANDLER__FINALLY_BLOCK:
				return basicSetFinallyBlock(null, msgs);
			case statementsPackage.EXCEPTION_HANDLER__GUARDED_BLOCK:
				return basicSetGuardedBlock(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType) {
		switch (featureID) {
			case statementsPackage.EXCEPTION_HANDLER__CATCH_BLOCKS:
				return getCatchBlocks();
			case statementsPackage.EXCEPTION_HANDLER__FINALLY_BLOCK:
				return getFinallyBlock();
			case statementsPackage.EXCEPTION_HANDLER__GUARDED_BLOCK:
				return getGuardedBlock();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue) {
		switch (featureID) {
			case statementsPackage.EXCEPTION_HANDLER__CATCH_BLOCKS:
				getCatchBlocks().clear();
				getCatchBlocks().addAll((Collection<? extends CatchBlock>)newValue);
				return;
			case statementsPackage.EXCEPTION_HANDLER__FINALLY_BLOCK:
				setFinallyBlock((BlockStatement)newValue);
				return;
			case statementsPackage.EXCEPTION_HANDLER__GUARDED_BLOCK:
				setGuardedBlock((BlockStatement)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID) {
		switch (featureID) {
			case statementsPackage.EXCEPTION_HANDLER__CATCH_BLOCKS:
				getCatchBlocks().clear();
				return;
			case statementsPackage.EXCEPTION_HANDLER__FINALLY_BLOCK:
				setFinallyBlock((BlockStatement)null);
				return;
			case statementsPackage.EXCEPTION_HANDLER__GUARDED_BLOCK:
				setGuardedBlock((BlockStatement)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID) {
		switch (featureID) {
			case statementsPackage.EXCEPTION_HANDLER__CATCH_BLOCKS:
				return catchBlocks != null && !catchBlocks.isEmpty();
			case statementsPackage.EXCEPTION_HANDLER__FINALLY_BLOCK:
				return finallyBlock != null;
			case statementsPackage.EXCEPTION_HANDLER__GUARDED_BLOCK:
				return guardedBlock != null;
		}
		return super.eIsSet(featureID);
	}

} //ExceptionHandlerImpl
